/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core;

import com.plotsquared.core.PlotPlatform;
import com.plotsquared.core.PlotVersion;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.MemorySection;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.Storage;
import com.plotsquared.core.configuration.caption.CaptionMap;
import com.plotsquared.core.configuration.caption.DummyCaptionMap;
import com.plotsquared.core.configuration.caption.load.CaptionLoader;
import com.plotsquared.core.configuration.caption.load.DefaultCaptionProvider;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.configuration.serialization.ConfigurationSerialization;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.database.Database;
import com.plotsquared.core.database.MySQL;
import com.plotsquared.core.database.SQLManager;
import com.plotsquared.core.database.SQLite;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.factory.HybridPlotWorldFactory;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.expiration.ExpireManager;
import com.plotsquared.core.plot.expiration.ExpiryTask;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.LegacyConverter;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.ReflectionUtils;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.uuid.UUIDPipeline;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.util.eventbus.EventHandler;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlotSquared {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotSquared.class.getSimpleName()));
    private static @MonotonicNonNull PlotSquared instance;
    private final PlotPlatform<?> platform;
    private final Thread thread;
    private final UUIDPipeline impromptuUUIDPipeline = new UUIDPipeline(Executors.newCachedThreadPool());
    private final UUIDPipeline backgroundUUIDPipeline = new UUIDPipeline(Executors.newSingleThreadExecutor());
    private final Map<String, CaptionMap> captionMaps = new HashMap<String, CaptionMap>();
    public HashMap<String, HashMap<PlotId, Plot>> plots_tmp;
    private CaptionLoader captionLoader;
    private WorldEdit worldedit;
    private File configFile;
    private File worldsFile;
    private YamlConfiguration worldConfiguration;
    private HashMap<String, Set<PlotCluster>> clustersTmp;
    private YamlConfiguration config;
    private PlotVersion version;
    private File jarFile = null;
    private File storageFile;
    private EventDispatcher eventDispatcher;
    private PlotListener plotListener;
    private boolean weInitialised;

    public PlotSquared(@NonNull PlotPlatform<?> iPlotMain, @NonNull String platform) {
        if (instance != null) {
            throw new IllegalStateException("Cannot re-initialize the PlotSquared singleton");
        }
        instance = this;
        this.thread = Thread.currentThread();
        this.platform = iPlotMain;
        Settings.PLATFORM = platform;
        PlayerMetaDataKeys.load();
        ConfigurationSerialization.registerClass(BlockBucket.class, "BlockBucket");
        if (!this.setupConfigs()) {
            return;
        }
        this.captionLoader = CaptionLoader.of(Locale.ENGLISH, CaptionLoader.patternExtractor(Pattern.compile("messages_(.*)\\.json")), DefaultCaptionProvider.forClassLoaderFormatString(this.getClass().getClassLoader(), "lang/messages_%s.json"), "plotsquared");
        try {
            this.loadCaptionMap();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load caption map", (Throwable)e);
            LOGGER.error("Shutting down server to prevent further issues");
            this.platform.shutdownServer();
            throw new RuntimeException("Abort loading PlotSquared");
        }
        GlobalFlagContainer.setup();
        try {
            block8: {
                new ReflectionUtils(this.platform.serverNativePackage());
                try {
                    URL logurl = PlotSquared.class.getProtectionDomain().getCodeSource().getLocation();
                    this.jarFile = new File(new URL(logurl.toURI().toString().split("\\!")[0].replaceAll("jar:file", "file")).toURI().getPath());
                }
                catch (SecurityException | MalformedURLException | URISyntaxException e) {
                    e.printStackTrace();
                    this.jarFile = new File(this.platform.getDirectory().getParentFile(), "PlotSquared.jar");
                    if (this.jarFile.exists()) break block8;
                    this.jarFile = new File(this.platform.getDirectory().getParentFile(), "PlotSquared-" + platform + ".jar");
                }
            }
            this.worldedit = WorldEdit.getInstance();
            WorldEdit.getInstance().getEventBus().register((Object)new WEPlatformReadyListener());
            this.eventDispatcher = new EventDispatcher(this.worldedit);
            this.plotListener = new PlotListener(this.eventDispatcher);
            this.copyFile("town.template", Settings.Paths.TEMPLATES);
            this.copyFile("bridge.template", Settings.Paths.TEMPLATES);
            this.copyFile("skyblock.template", Settings.Paths.TEMPLATES);
            this.showDebug();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static @NonNull PlotSquared get() {
        return instance;
    }

    public static @NonNull PlotPlatform<?> platform() {
        if (instance != null && PlotSquared.instance.platform != null) {
            return PlotSquared.instance.platform;
        }
        throw new IllegalStateException("Plot platform implementation is missing");
    }

    public void loadCaptionMap() throws Exception {
        CaptionMap captionMap;
        this.platform.copyCaptionMaps();
        if (Settings.Enabled_Components.PER_USER_LOCALE) {
            captionMap = this.captionLoader.loadAll(this.platform.getDirectory().toPath().resolve("lang"));
        } else {
            String fileName = "messages_" + Settings.Enabled_Components.DEFAULT_LOCALE + ".json";
            captionMap = this.captionLoader.loadOrCreateSingle(this.platform.getDirectory().toPath().resolve("lang").resolve(fileName));
        }
        this.captionMaps.put("plotsquared", captionMap);
        LOGGER.info("Loaded caption map for namespace 'plotsquared': {}", (Object)this.captionMaps.get("plotsquared").getClass().getCanonicalName());
    }

    public @NonNull PlotAreaManager getPlotAreaManager() {
        return this.platform.plotAreaManager();
    }

    public void startExpiryTasks() {
        if (Settings.Enabled_Components.PLOT_EXPIRY) {
            ExpireManager expireManager = PlotSquared.platform().expireManager();
            expireManager.runAutomatedTask();
            for (Settings.Auto_Clear settings : Settings.AUTO_CLEAR.getInstances()) {
                ExpiryTask task = new ExpiryTask(settings, this.getPlotAreaManager());
                expireManager.addTask(task);
            }
        }
    }

    public boolean isMainThread(@NonNull Thread thread) {
        return this.thread == thread;
    }

    public boolean checkVersion(int[] version, int ... version2) {
        return version[0] > version2[0] || version[0] == version2[0] && version[1] > version2[1] || version[0] == version2[0] && version[1] == version2[1] && version[2] >= version2[2];
    }

    public @NonNull PlotVersion getVersion() {
        return this.version;
    }

    public @NonNull String getPlatform() {
        return Settings.PLATFORM;
    }

    public void addPlotArea(@NonNull PlotArea plotArea) {
        Set<PlotCluster> clusters;
        HashMap<PlotId, Plot> plots;
        if (this.plots_tmp == null || (plots = this.plots_tmp.remove(plotArea.toString())) == null) {
            if (plotArea.getType() == PlotAreaType.PARTIAL) {
                HashMap<PlotId, Plot> hashMap = plots = this.plots_tmp != null ? this.plots_tmp.get(plotArea.getWorldName()) : null;
                if (plots != null) {
                    Iterator<Object> iterator = plots.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry next = (Map.Entry)iterator.next();
                        PlotId id = (PlotId)next.getKey();
                        if (!plotArea.contains(id)) continue;
                        ((Plot)next.getValue()).setArea(plotArea);
                        iterator.remove();
                    }
                }
            }
        } else {
            for (Plot entry : plots.values()) {
                entry.setArea(plotArea);
            }
        }
        if (this.clustersTmp == null || (clusters = this.clustersTmp.remove(plotArea.toString())) == null) {
            if (plotArea.getType() == PlotAreaType.PARTIAL) {
                Set<PlotCluster> set = clusters = this.clustersTmp != null ? this.clustersTmp.get(plotArea.getWorldName()) : null;
                if (clusters != null) {
                    Iterator<PlotCluster> iterator = clusters.iterator();
                    while (iterator.hasNext()) {
                        PlotCluster next = iterator.next();
                        if (!next.intersects(plotArea.getMin(), plotArea.getMax())) continue;
                        next.setArea(plotArea);
                        iterator.remove();
                    }
                }
            }
        } else {
            for (PlotCluster cluster : clusters) {
                cluster.setArea(plotArea);
            }
        }
        this.getPlotAreaManager().addPlotArea(plotArea);
        plotArea.setupBorder();
        if (!Settings.Enabled_Components.PERSISTENT_ROAD_REGEN) {
            return;
        }
        File file = new File(this.platform.getDirectory() + File.separator + "persistent_regen_data_" + plotArea.getId() + "_" + plotArea.getWorldName());
        if (!file.exists()) {
            return;
        }
        TaskManager.runTaskAsync(() -> {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                List list = (List)ois.readObject();
                ArrayList regionInts = (ArrayList)list.get(0);
                ArrayList chunkInts = (ArrayList)list.get(1);
                HashSet<BlockVector2> regions = new HashSet<BlockVector2>();
                HashSet<BlockVector2> chunks = new HashSet<BlockVector2>();
                regionInts.forEach(l -> regions.add(BlockVector2.at((int)l[0], (int)l[1])));
                chunkInts.forEach(l -> chunks.add(BlockVector2.at((int)l[0], (int)l[1])));
                int height = (Integer)list.get(2);
                LOGGER.info("Incomplete road regeneration found. Restarting in world {} with height {}", (Object)plotArea.getWorldName(), (Object)height);
                LOGGER.info("- Regions: {}", (Object)regions.size());
                LOGGER.info("- Chunks: {}", (Object)chunks.size());
                HybridUtils.UPDATE = true;
                PlotSquared.platform().hybridUtils().scheduleRoadUpdate(plotArea, regions, height, chunks);
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error("Error restarting road regeneration", (Throwable)e);
            }
            finally {
                if (!file.delete()) {
                    LOGGER.error("Error deleting persistent_regen_data_{}. Please delete this file manually", (Object)plotArea.getId());
                }
            }
        });
    }

    public void removePlotArea(@NonNull PlotArea area) {
        this.getPlotAreaManager().removePlotArea(area);
        this.setPlotsTmp(area);
    }

    public void removePlotAreas(@NonNull String world) {
        for (PlotArea area : this.getPlotAreaManager().getPlotAreasSet(world)) {
            if (!area.getWorldName().equals(world)) continue;
            this.removePlotArea(area);
        }
    }

    private void setPlotsTmp(@NonNull PlotArea area) {
        if (this.plots_tmp == null) {
            this.plots_tmp = new HashMap();
        }
        HashMap map = this.plots_tmp.computeIfAbsent(area.toString(), k -> new HashMap());
        for (Plot plot : area.getPlots()) {
            map.put(plot.getId(), plot);
        }
        if (this.clustersTmp == null) {
            this.clustersTmp = new HashMap();
        }
        this.clustersTmp.put(area.toString(), area.getClusters());
    }

    public Set<PlotCluster> getClusters(@NonNull String world) {
        HashSet<PlotCluster> set = new HashSet<PlotCluster>();
        for (PlotArea area : this.getPlotAreaManager().getPlotAreasSet(world)) {
            set.addAll(area.getClusters());
        }
        return Collections.unmodifiableSet(set);
    }

    public List<Plot> sortPlotsByTemp(Collection<Plot> plots) {
        int max = 0;
        int overflowCount = 0;
        for (Plot plot : plots) {
            if (plot.temp > 0) {
                if (plot.temp <= max) continue;
                max = plot.temp;
                continue;
            }
            ++overflowCount;
        }
        Plot[] array = new Plot[max + 1];
        ArrayList<Plot> overflow = new ArrayList<Plot>(overflowCount);
        for (Plot plot : plots) {
            if (plot.temp <= 0) {
                overflow.add(plot);
                continue;
            }
            array[plot.temp] = plot;
        }
        ArrayList<Plot> result = new ArrayList<Plot>(plots.size());
        for (Plot plot : array) {
            if (plot == null) continue;
            result.add(plot);
        }
        overflow.sort(Comparator.comparingInt(Plot::hashCode));
        result.addAll(overflow);
        return result;
    }

    private ArrayList<Plot> sortPlotsByHash(Collection<Plot> plots) {
        int hardmax = 256000;
        int max = 0;
        int overflowSize = 0;
        for (Plot plot : plots) {
            int hash = MathMan.getPositiveId(plot.hashCode());
            if (hash <= max) continue;
            if (hash >= hardmax) {
                ++overflowSize;
                continue;
            }
            max = hash;
        }
        hardmax = Math.min(hardmax, max);
        Plot[] cache = new Plot[hardmax + 1];
        ArrayList<Plot> overflow = new ArrayList<Plot>(overflowSize);
        ArrayList<Plot> extra = new ArrayList<Plot>();
        for (Plot plot : plots) {
            int hash = MathMan.getPositiveId(plot.hashCode());
            if (hash < hardmax) {
                if (hash >= 0) {
                    cache[hash] = plot;
                    continue;
                }
                extra.add(plot);
                continue;
            }
            if (Math.abs(plot.getId().getX()) > 15446 || Math.abs(plot.getId().getY()) > 15446) {
                extra.add(plot);
                continue;
            }
            overflow.add(plot);
        }
        Plot[] overflowArray = overflow.toArray(new Plot[0]);
        this.sortPlotsByHash(overflowArray);
        ArrayList<Plot> result = new ArrayList<Plot>(cache.length + overflowArray.length);
        for (Plot plot : cache) {
            if (plot == null) continue;
            result.add(plot);
        }
        Collections.addAll(result, overflowArray);
        result.addAll(extra);
        return result;
    }

    private void sortPlotsByHash(@NonNull Plot @NonNull [] input) {
        Object[] bucket = new ArrayList[32];
        Arrays.fill(bucket, new ArrayList());
        boolean maxLength = false;
        int placement = 1;
        while (!maxLength) {
            maxLength = true;
            for (Plot plot : input) {
                int tmp = MathMan.getPositiveId(plot.hashCode()) / placement;
                bucket[tmp & 0x1F].add(plot);
                if (!maxLength || tmp <= 0) continue;
                maxLength = false;
            }
            int a = 0;
            for (int i = 0; i < 32; ++i) {
                Iterator iterator = bucket[i].iterator();
                while (iterator.hasNext()) {
                    Plot plot;
                    plot = (Plot)iterator.next();
                    input[a++] = plot;
                }
                bucket[i].clear();
            }
            placement *= 32;
        }
    }

    private @NonNull List<Plot> sortPlotsByTimestamp(@NonNull Collection<Plot> plots) {
        int hardMax = 256000;
        int max = 0;
        int overflowSize = 0;
        for (Plot plot : plots) {
            int hash = MathMan.getPositiveId(plot.hashCode());
            if (hash <= max) continue;
            if (hash >= hardMax) {
                ++overflowSize;
                continue;
            }
            max = hash;
        }
        hardMax = Math.min(hardMax, max);
        Plot[] cache = new Plot[hardMax + 1];
        ArrayList<Plot> overflow = new ArrayList<Plot>(overflowSize);
        ArrayList<Plot> extra = new ArrayList<Plot>();
        for (Plot plot : plots) {
            int hash = MathMan.getPositiveId(plot.hashCode());
            if (hash < hardMax) {
                if (hash >= 0) {
                    cache[hash] = plot;
                    continue;
                }
                extra.add(plot);
                continue;
            }
            if (Math.abs(plot.getId().getX()) > 15446 || Math.abs(plot.getId().getY()) > 15446) {
                extra.add(plot);
                continue;
            }
            overflow.add(plot);
        }
        Plot[] overflowArray = overflow.toArray(new Plot[0]);
        this.sortPlotsByHash(overflowArray);
        ArrayList<Plot> result = new ArrayList<Plot>(cache.length + overflowArray.length);
        for (Plot plot : cache) {
            if (plot == null) continue;
            result.add(plot);
        }
        Collections.addAll(result, overflowArray);
        result.addAll(extra);
        return result;
    }

    private @NonNull List<Plot> sortPlotsByModified(@NonNull Collection<Plot> input) {
        ArrayList<Plot> list = input instanceof List ? (ArrayList<Plot>)input : new ArrayList<Plot>(input);
        ExpireManager expireManager = PlotSquared.platform().expireManager();
        list.sort(Comparator.comparingLong(a -> expireManager.getTimestamp(a.getOwnerAbs())));
        return list;
    }

    public @NonNull List<Plot> sortPlots(@NonNull Collection<Plot> plots, @NonNull SortType type, @Nullable PlotArea priorityArea) {
        HashMap<PlotArea, Collection<Plot>> map = new HashMap<PlotArea, Collection<Plot>>();
        int totalSize = Arrays.stream(this.getPlotAreaManager().getAllPlotAreas()).mapToInt(PlotArea::getPlotCount).sum();
        if (plots.size() == totalSize) {
            for (PlotArea area : this.getPlotAreaManager().getAllPlotAreas()) {
                map.put(area, area.getPlots());
            }
        } else {
            for (PlotArea area : this.getPlotAreaManager().getAllPlotAreas()) {
                map.put(area, new ArrayList(0));
            }
            Collection lastList = null;
            PlotArea lastWorld = null;
            for (Plot plot : plots) {
                if (lastWorld == plot.getArea()) {
                    lastList.add(plot);
                    continue;
                }
                lastWorld = plot.getArea();
                lastList = (Collection)map.get(lastWorld);
                lastList.add(plot);
            }
        }
        List<PlotArea> areas = Arrays.asList(this.getPlotAreaManager().getAllPlotAreas());
        areas.sort((a, b) -> {
            if (priorityArea != null) {
                if (a.equals(priorityArea)) {
                    return -1;
                }
                if (b.equals(priorityArea)) {
                    return 1;
                }
            }
            return a.hashCode() - b.hashCode();
        });
        ArrayList<Plot> toReturn = new ArrayList<Plot>(plots.size());
        for (PlotArea area : areas) {
            switch (type) {
                case CREATION_DATE: {
                    toReturn.addAll(this.sortPlotsByTemp((Collection)map.get(area)));
                    break;
                }
                case CREATION_DATE_TIMESTAMP: {
                    toReturn.addAll(this.sortPlotsByTimestamp((Collection)map.get(area)));
                    break;
                }
                case DISTANCE_FROM_ORIGIN: {
                    toReturn.addAll(this.sortPlotsByHash((Collection)map.get(area)));
                    break;
                }
                case LAST_MODIFIED: {
                    toReturn.addAll(this.sortPlotsByModified((Collection)map.get(area)));
                    break;
                }
            }
        }
        return toReturn;
    }

    public void setPlots(@NonNull Map<String, HashMap<PlotId, Plot>> plots) {
        if (this.plots_tmp == null) {
            this.plots_tmp = new HashMap();
        }
        for (Map.Entry<String, HashMap<PlotId, Plot>> entry : plots.entrySet()) {
            String world = entry.getKey();
            PlotArea plotArea = this.getPlotAreaManager().getPlotArea(world, null);
            if (plotArea == null) {
                Map map = this.plots_tmp.computeIfAbsent(world, k -> new HashMap());
                map.putAll((Map)entry.getValue());
                continue;
            }
            for (Plot plot : entry.getValue().values()) {
                plot.setArea(plotArea);
                plotArea.addPlot(plot);
            }
        }
    }

    public boolean removePlot(@NonNull Plot plot, boolean callEvent) {
        if (plot == null) {
            return false;
        }
        if (callEvent) {
            this.eventDispatcher.callDelete(plot);
        }
        if (plot.getArea().removePlot(plot.getId())) {
            PlotId last = (PlotId)plot.getArea().getMeta("lastPlot");
            int last_max = Math.max(Math.abs(last.getX()), Math.abs(last.getY()));
            int this_max = Math.max(Math.abs(plot.getId().getX()), Math.abs(plot.getId().getY()));
            if (this_max < last_max) {
                plot.getArea().setMeta("lastPlot", plot.getId());
            }
            if (callEvent) {
                this.eventDispatcher.callPostDelete(plot);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadWorld(@NonNull String world, @Nullable GeneratorWrapper<?> baseGenerator) {
        if (world.equals("CheckingPlotSquaredGenerator")) {
            return;
        }
        this.getPlotAreaManager().addWorld(world);
        Set<Object> worlds = this.worldConfiguration.contains("worlds") ? this.worldConfiguration.getConfigurationSection("worlds").getKeys(false) : new HashSet();
        String path = "worlds." + world;
        ConfigurationSection worldSection = this.worldConfiguration.getConfigurationSection(path);
        PlotAreaType type = worldSection != null ? ConfigurationUtil.getType(worldSection) : PlotAreaType.NORMAL;
        if (type == PlotAreaType.NORMAL) {
            IndependentPlotGenerator plotGenerator;
            if (this.getPlotAreaManager().getPlotAreas(world, null).length != 0) {
                return;
            }
            if (baseGenerator != null && baseGenerator.isFull()) {
                plotGenerator = baseGenerator.getPlotGenerator();
            } else {
                if (worldSection == null) return;
                String secondaryGeneratorName = worldSection.getString("generator.plugin");
                GeneratorWrapper<?> secondaryGenerator = this.platform.getGenerator(world, secondaryGeneratorName);
                if (secondaryGenerator != null && secondaryGenerator.isFull()) {
                    plotGenerator = secondaryGenerator.getPlotGenerator();
                } else {
                    String primaryGeneratorName = worldSection.getString("generator.init");
                    GeneratorWrapper<?> primaryGenerator = this.platform.getGenerator(world, primaryGeneratorName);
                    if (primaryGenerator == null || !primaryGenerator.isFull()) return;
                    plotGenerator = primaryGenerator.getPlotGenerator();
                }
            }
            PlotArea plotArea = plotGenerator.getNewPlotArea(world, null, null, null);
            PlotManager plotManager = plotArea.getPlotManager();
            LOGGER.info("Detected world load for '{}'", (Object)world);
            LOGGER.info("- generator: {}>{}", baseGenerator, (Object)plotGenerator);
            LOGGER.info("- plot world: {}", (Object)plotArea.getClass().getCanonicalName());
            LOGGER.info("- plot area manager: {}", (Object)plotManager.getClass().getCanonicalName());
            if (!this.worldConfiguration.contains(path)) {
                this.worldConfiguration.createSection(path);
                worldSection = this.worldConfiguration.getConfigurationSection(path);
            }
            plotArea.saveConfiguration(worldSection);
            plotArea.loadDefaultConfiguration(worldSection);
            try {
                this.worldConfiguration.save(this.worldsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.addPlotArea(plotArea);
            plotGenerator.initialize(plotArea);
            return;
        }
        if (!worlds.contains(world)) {
            return;
        }
        ConfigurationSection areasSection = worldSection.getConfigurationSection("areas");
        if (areasSection == null) {
            if (this.getPlotAreaManager().getPlotAreas(world, null).length != 0) {
                return;
            }
            LOGGER.info("Detected world load for '{}'", (Object)world);
            String gen_string = worldSection.getString("generator.plugin", this.platform.pluginName());
            if (type == PlotAreaType.PARTIAL) {
                HashSet clusters;
                Set<Object> set = clusters = this.clustersTmp != null ? this.clustersTmp.get(world) : new HashSet();
                if (clusters == null) {
                    throw new IllegalArgumentException("No cluster exists for world: " + world);
                }
                ArrayDeque<PlotArea> toLoad = new ArrayDeque<PlotArea>();
                for (PlotCluster cluster : clusters) {
                    PlotId pos1 = cluster.getP1();
                    PlotId pos2 = cluster.getP2();
                    String name = cluster.getName();
                    String fullId = name + "-" + pos1 + "-" + pos2;
                    worldSection.createSection("areas." + fullId);
                    DBFunc.replaceWorld(world, world + ";" + name, pos1, pos2);
                    LOGGER.info("- {}-{}-{}", (Object)name, (Object)pos1, (Object)pos2);
                    GeneratorWrapper<?> areaGen = this.platform.getGenerator(world, gen_string);
                    if (areaGen == null) {
                        throw new IllegalArgumentException("Invalid Generator: " + gen_string);
                    }
                    PlotArea pa = areaGen.getPlotGenerator().getNewPlotArea(world, name, pos1, pos2);
                    pa.saveConfiguration(worldSection);
                    pa.loadDefaultConfiguration(worldSection);
                    try {
                        this.worldConfiguration.save(this.worldsFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    LOGGER.info("| generator: {}>{}", baseGenerator, areaGen);
                    LOGGER.info("| plot world: {}", (Object)pa.getClass().getCanonicalName());
                    LOGGER.info("| manager: {}", (Object)pa.getPlotManager().getClass().getCanonicalName());
                    LOGGER.info("Note: Area created for cluster '{}' (invalid or old configuration?)", (Object)name);
                    areaGen.getPlotGenerator().initialize(pa);
                    areaGen.augment(pa);
                    toLoad.add(pa);
                }
                for (PlotArea area : toLoad) {
                    this.addPlotArea(area);
                }
                return;
            }
            GeneratorWrapper<?> areaGen = this.platform.getGenerator(world, gen_string);
            if (areaGen == null) {
                throw new IllegalArgumentException("Invalid Generator: " + gen_string);
            }
            PlotArea pa = areaGen.getPlotGenerator().getNewPlotArea(world, null, null, null);
            LOGGER.info("- generator: {}>{}", baseGenerator, areaGen);
            LOGGER.info("- plot world: {}", (Object)pa.getClass().getCanonicalName());
            LOGGER.info("- plot area manager: {}", (Object)pa.getPlotManager().getClass().getCanonicalName());
            if (!this.worldConfiguration.contains(path)) {
                this.worldConfiguration.createSection(path);
                worldSection = this.worldConfiguration.getConfigurationSection(path);
            }
            pa.saveConfiguration(worldSection);
            pa.loadDefaultConfiguration(worldSection);
            try {
                this.worldConfiguration.save(this.worldsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            areaGen.getPlotGenerator().initialize(pa);
            areaGen.augment(pa);
            this.addPlotArea(pa);
            return;
        }
        if (type == PlotAreaType.AUGMENTED) {
            throw new IllegalArgumentException("Invalid type for multi-area world. Expected `PARTIAL`, got `" + PlotAreaType.AUGMENTED + "`");
        }
        for (String areaId : areasSection.getKeys(false)) {
            LOGGER.info("- {}", (Object)areaId);
            String[] split = areaId.split("(?<=[^;-])-");
            if (split.length != 3) {
                throw new IllegalArgumentException("Invalid Area identifier: " + areaId + ". Expected form `<name>-<pos1>-<pos2>`");
            }
            String name = split[0];
            PlotId pos1 = PlotId.fromString(split[1]);
            PlotId pos2 = PlotId.fromString(split[2]);
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Invalid Area identifier: " + areaId + ". Expected form `<name>-<x1;z1>-<x2;z2>`");
            }
            PlotArea existing = this.getPlotAreaManager().getPlotArea(world, name);
            if (existing != null && name.equals(existing.getId())) continue;
            ConfigurationSection section = areasSection.getConfigurationSection(areaId);
            YamlConfiguration clone = new YamlConfiguration();
            for (String key : section.getKeys(true)) {
                if (section.get(key) instanceof MemorySection || clone.contains(key)) continue;
                clone.set(key, section.get(key));
            }
            for (String key : worldSection.getKeys(true)) {
                if (worldSection.get(key) instanceof MemorySection || key.startsWith("areas") || clone.contains(key)) continue;
                clone.set(key, worldSection.get(key));
            }
            String gen_string = clone.getString("generator.plugin", this.platform.pluginName());
            GeneratorWrapper<?> areaGen = this.platform.getGenerator(world, gen_string);
            if (areaGen == null) {
                throw new IllegalArgumentException("Invalid Generator: " + gen_string);
            }
            PlotArea pa = areaGen.getPlotGenerator().getNewPlotArea(world, name, pos1, pos2);
            pa.saveConfiguration(clone);
            for (String key : clone.getKeys(true)) {
                if (clone.get(key) instanceof MemorySection) continue;
                if (!worldSection.contains(key)) {
                    worldSection.set(key, clone.get(key));
                    continue;
                }
                Object value = worldSection.get(key);
                if (Objects.equals(value, clone.get(key))) continue;
                section.set(key, clone.get(key));
            }
            pa.loadDefaultConfiguration(clone);
            try {
                this.worldConfiguration.save(this.worldsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            LOGGER.info("Detected area load for '{}'", (Object)world);
            LOGGER.info("| generator: {}>{}", baseGenerator, areaGen);
            LOGGER.info("| plot world: {}", (Object)pa);
            LOGGER.info("| manager: {}", (Object)pa.getPlotManager());
            areaGen.getPlotGenerator().initialize(pa);
            areaGen.augment(pa);
            this.addPlotArea(pa);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean setupPlotWorld(@NonNull String world, @Nullable String args, @NonNull IndependentPlotGenerator generator) {
        if (args != null && !args.isEmpty()) {
            List<String> validArguments = Arrays.asList("s=", "size=", "g=", "gap=", "h=", "height=", "minh=", "minheight=", "maxh=", "maxheight=", "f=", "floor=", "m=", "main=", "w=", "wall=", "b=", "border=");
            int expected = (int)validArguments.stream().filter(validArgument -> args.toLowerCase(Locale.ENGLISH).contains((CharSequence)validArgument)).count();
            String[] split = args.toLowerCase(Locale.ENGLISH).split(",(?![^\\(\\[]*[\\]\\)])");
            if (split.length > expected) {
                void var9_11;
                String[] combinedArgs = new String[expected];
                int index = 0;
                StringBuilder stringBuilder = new StringBuilder();
                String[] stringArray = split;
                int n = stringArray.length;
                block35: for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    for (String validArgument2 : validArguments) {
                        if (!string.contains(validArgument2)) continue;
                        if (!var9_11.toString().isEmpty()) {
                            combinedArgs[index++] = var9_11.toString();
                            StringBuilder stringBuilder2 = new StringBuilder();
                        }
                        var9_11.append(string);
                        continue block35;
                    }
                    if (var9_11.toString().charAt(var9_11.length() - 1) != '=') {
                        var9_11.append(",");
                    }
                    var9_11.append(string);
                }
                if (!var9_11.toString().isEmpty()) {
                    combinedArgs[index] = var9_11.toString();
                }
                split = combinedArgs;
            }
            HybridPlotWorldFactory hybridPlotWorldFactory = (HybridPlotWorldFactory)this.platform.injector().getInstance(HybridPlotWorldFactory.class);
            HybridPlotWorld plotWorld = hybridPlotWorldFactory.create(world, null, generator, null, null);
            for (String element : split) {
                String[] pair = element.split("=");
                if (pair.length != 2) {
                    LOGGER.error("No value provided for '{}'", (Object)element);
                    return false;
                }
                String key = pair[0].toLowerCase();
                String value = pair[1];
                try {
                    String base = "worlds." + world + ".";
                    switch (key) {
                        case "s": 
                        case "size": {
                            this.worldConfiguration.set(base + "plot.size", ConfigurationUtil.INTEGER.parseString(value).shortValue());
                            break;
                        }
                        case "g": 
                        case "gap": {
                            this.worldConfiguration.set(base + "road.width", ConfigurationUtil.INTEGER.parseString(value).shortValue());
                            break;
                        }
                        case "h": 
                        case "height": {
                            this.worldConfiguration.set(base + "road.height", ConfigurationUtil.INTEGER.parseString(value).shortValue());
                            this.worldConfiguration.set(base + "plot.height", ConfigurationUtil.INTEGER.parseString(value).shortValue());
                            this.worldConfiguration.set(base + "wall.height", ConfigurationUtil.INTEGER.parseString(value).shortValue());
                            break;
                        }
                        case "minh": 
                        case "minheight": {
                            this.worldConfiguration.set(base + "world.min_gen_height", ConfigurationUtil.INTEGER.parseString(value).shortValue());
                            break;
                        }
                        case "maxh": 
                        case "maxheight": {
                            this.worldConfiguration.set(base + "world.max_gen_height", ConfigurationUtil.INTEGER.parseString(value).shortValue());
                            break;
                        }
                        case "f": 
                        case "floor": {
                            this.worldConfiguration.set(base + "plot.floor", ConfigurationUtil.BLOCK_BUCKET.parseString(value).toString());
                            break;
                        }
                        case "m": 
                        case "main": {
                            this.worldConfiguration.set(base + "plot.filling", ConfigurationUtil.BLOCK_BUCKET.parseString(value).toString());
                            break;
                        }
                        case "w": 
                        case "wall": {
                            this.worldConfiguration.set(base + "wall.filling", ConfigurationUtil.BLOCK_BUCKET.parseString(value).toString());
                            break;
                        }
                        case "b": 
                        case "border": {
                            this.worldConfiguration.set(base + "wall.block", ConfigurationUtil.BLOCK_BUCKET.parseString(value).toString());
                            break;
                        }
                        default: {
                            LOGGER.error("Key not found: {}", (Object)element);
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Invalid value '{}' for arg '{}'", (Object)value, (Object)element);
                    e.printStackTrace();
                    return false;
                }
            }
            try {
                ConfigurationSection configurationSection = this.worldConfiguration.getConfigurationSection("worlds." + world);
                plotWorld.saveConfiguration(configurationSection);
                plotWorld.loadDefaultConfiguration(configurationSection);
                this.worldConfiguration.save(this.worldsFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return true;
    }

    public void copyFile(@NonNull String file, @NonNull String folder) {
        try {
            File newFile;
            File output = this.platform.getDirectory();
            if (!output.exists()) {
                output.mkdirs();
            }
            if ((newFile = FileUtils.getFile(output, folder + File.separator + file)).exists()) {
                return;
            }
            try (InputStream stream = this.platform.getClass().getResourceAsStream(file);){
                byte[] buffer = new byte[2048];
                if (stream == null) {
                    try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.jarFile));){
                        ZipEntry ze = zis.getNextEntry();
                        while (ze != null) {
                            String name = ze.getName();
                            if (name.equals(file)) {
                                new File(newFile.getParent()).mkdirs();
                                try (FileOutputStream fos = new FileOutputStream(newFile);){
                                    int len;
                                    while ((len = zis.read(buffer)) > 0) {
                                        fos.write(buffer, 0, len);
                                    }
                                }
                                ze = null;
                                continue;
                            }
                            ze = zis.getNextEntry();
                        }
                        zis.closeEntry();
                    }
                    return;
                }
                newFile.createNewFile();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = stream.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not save {}", (Object)file);
            e.printStackTrace();
        }
    }

    public void disable() {
        try {
            this.eventDispatcher.unregisterAll();
            this.checkRoadRegenPersistence();
            HashSet<Plot> plots = new HashSet<Plot>();
            try {
                this.forEachPlotRaw(plots::add);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DBFunc.validatePlots(plots);
            DBFunc.close();
        }
        catch (NullPointerException throwable) {
            LOGGER.error("Could not close database connection", (Throwable)throwable);
            throwable.printStackTrace();
        }
    }

    private void checkRoadRegenPersistence() {
        if (!HybridUtils.UPDATE || !Settings.Enabled_Components.PERSISTENT_ROAD_REGEN || HybridUtils.regions.isEmpty() && HybridUtils.chunks.isEmpty()) {
            return;
        }
        LOGGER.info("Road regeneration incomplete. Saving incomplete regions to disk");
        LOGGER.info("- regions: {}", (Object)HybridUtils.regions.size());
        LOGGER.info("- chunks: {}", (Object)HybridUtils.chunks.size());
        ArrayList<int[]> regions = new ArrayList<int[]>();
        ArrayList<int[]> chunks = new ArrayList<int[]>();
        for (BlockVector2 r : HybridUtils.regions) {
            regions.add(new int[]{r.getBlockX(), r.getBlockZ()});
        }
        for (BlockVector2 c : HybridUtils.chunks) {
            chunks.add(new int[]{c.getBlockX(), c.getBlockZ()});
        }
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        list.add(regions);
        list.add(chunks);
        list.add(Integer.valueOf(HybridUtils.height));
        File file = new File(this.platform.getDirectory() + File.separator + "persistent_regen_data_" + HybridUtils.area.getId() + "_" + HybridUtils.area.getWorldName());
        if (file.exists() && !file.delete()) {
            LOGGER.error("persistent_regene_data file already exists and could not be deleted");
            return;
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE_NEW));){
            oos.writeObject(list);
        }
        catch (IOException e) {
            LOGGER.error("Error creating persistent_region_data file", (Throwable)e);
        }
    }

    public void setupDatabase() {
        try {
            Database database;
            if (DBFunc.dbManager != null) {
                DBFunc.dbManager.close();
            }
            if (Storage.MySQL.USE) {
                database = new MySQL(Storage.MySQL.HOST, Storage.MySQL.PORT, Storage.MySQL.DATABASE, Storage.MySQL.USER, Storage.MySQL.PASSWORD);
            } else if (Storage.SQLite.USE) {
                File file = FileUtils.getFile(this.platform.getDirectory(), Storage.SQLite.DB + ".db");
                database = new SQLite(file);
            } else {
                LOGGER.error("No storage type is set. Disabling PlotSquared");
                this.platform.shutdown();
                return;
            }
            DBFunc.dbManager = new SQLManager(database, Storage.PREFIX, this.eventDispatcher, this.plotListener, this.worldConfiguration);
            this.plots_tmp = DBFunc.getPlots();
            if (this.getPlotAreaManager() instanceof SinglePlotAreaManager) {
                SinglePlotArea area = ((SinglePlotAreaManager)this.getPlotAreaManager()).getArea();
                this.addPlotArea(area);
                ConfigurationSection section = this.worldConfiguration.getConfigurationSection("worlds.*");
                if (section == null) {
                    section = this.worldConfiguration.createSection("worlds.*");
                }
                area.saveConfiguration(section);
                area.loadDefaultConfiguration(section);
            }
            this.clustersTmp = DBFunc.getClusters();
            LOGGER.info("Connection to database established. Type: {}", (Object)(Storage.MySQL.USE ? "MySQL" : "SQLite"));
        }
        catch (ClassNotFoundException | SQLException e) {
            LOGGER.error("Failed to open database connection ({}). Disabling PlotSquared", (Object)(Storage.MySQL.USE ? "MySQL" : "SQLite"));
            LOGGER.error("==== Here is an ugly stacktrace, if you are interested in those things ===");
            e.printStackTrace();
            LOGGER.error("==== End of stacktrace ====");
            LOGGER.error("Please go to the {} 'storage.yml' and configure the database correctly", (Object)this.platform.pluginName());
            this.platform.shutdown();
        }
    }

    public void setupConfig() {
        String lastVersionString = this.getConfig().getString("version");
        if (lastVersionString != null) {
            String[] split = lastVersionString.split("\\.");
            int[] lastVersion = new int[]{Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2])};
            if (this.checkVersion(new int[]{3, 4, 0}, lastVersion)) {
                Settings.convertLegacy(this.configFile);
                if (this.getConfig().contains("worlds")) {
                    ConfigurationSection worldSection = this.getConfig().getConfigurationSection("worlds");
                    this.worldConfiguration.set("worlds", worldSection);
                    try {
                        this.worldConfiguration.save(this.worldsFile);
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to save worlds.yml", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                Settings.save(this.configFile);
            }
        }
        Settings.load(this.configFile);
        try (InputStream stream = this.getClass().getResourceAsStream("/plugin.properties");
             BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            String versionString = br.readLine();
            String commitString = br.readLine();
            String dateString = br.readLine();
            this.version = PlotVersion.tryParse(versionString, commitString, dateString);
        }
        catch (IOException throwable) {
            throwable.printStackTrace();
        }
        Settings.save(this.configFile);
        this.config = YamlConfiguration.loadConfiguration(this.configFile);
    }

    public boolean setupConfigs() {
        File folder;
        block13: {
            folder = new File(this.platform.getDirectory(), "config");
            if (!folder.exists() && !folder.mkdirs()) {
                LOGGER.error("Failed to create the {} config folder. Please create it manually", (Object)this.platform.getDirectory());
            }
            try {
                this.worldsFile = new File(folder, "worlds.yml");
                if (!this.worldsFile.exists() && !this.worldsFile.createNewFile()) {
                    LOGGER.error("Could not create the worlds file. Please create 'worlds.yml' manually");
                }
                this.worldConfiguration = YamlConfiguration.loadConfiguration(this.worldsFile);
                if (this.worldConfiguration.contains("worlds")) {
                    if (this.worldConfiguration.contains("configuration_version") && (this.worldConfiguration.getString("configuration_version").equalsIgnoreCase("post_flattening") || this.worldConfiguration.getString("configuration_version").equalsIgnoreCase("v5"))) break block13;
                    LOGGER.info("A legacy configuration file was detected. Conversion will be attempted.");
                    try {
                        com.google.common.io.Files.copy((File)this.worldsFile, (File)new File(folder, "worlds.yml.old"));
                        LOGGER.info("A copy of worlds.yml has been saved in the file worlds.yml.old");
                        ConfigurationSection worlds = this.worldConfiguration.getConfigurationSection("worlds");
                        LegacyConverter converter = new LegacyConverter(worlds);
                        converter.convert();
                        this.worldConfiguration.set("worlds", worlds);
                        this.setConfigurationVersion("post_flattening");
                        LOGGER.info("The conversion has finished. PlotSquared will now be disabled and the new configuration file will be used at next startup. Please review the new worlds.yml file. Please note that schematics will not be converted, as we are now using WorldEdit to handle schematics. You need to re-generate the schematics.");
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to convert the legacy configuration file. See stack trace for information.", (Throwable)e);
                    }
                    this.platform.shutdown();
                    return false;
                }
                this.worldConfiguration.set("configuration_version", "post_flattening");
            }
            catch (IOException ignored) {
                LOGGER.error("Failed to save worlds.yml");
            }
        }
        try {
            this.configFile = new File(folder, "settings.yml");
            if (!this.configFile.exists() && !this.configFile.createNewFile()) {
                LOGGER.error("Could not create the settings file. Please create 'settings.yml' manually");
            }
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            this.setupConfig();
        }
        catch (IOException ignored) {
            LOGGER.error("Failed to save settings.yml");
        }
        try {
            this.storageFile = new File(folder, "storage.yml");
            if (!this.storageFile.exists() && !this.storageFile.createNewFile()) {
                LOGGER.error("Could not create the storage settings file. Please create 'storage.yml' manually");
            }
            YamlConfiguration.loadConfiguration(this.storageFile);
            this.setupStorage();
        }
        catch (IOException ignored) {
            LOGGER.error("Failed to save storage.yml");
        }
        return true;
    }

    public @NonNull String getConfigurationVersion() {
        return this.worldConfiguration.get("configuration_version", "post_flattening").toString();
    }

    public void setConfigurationVersion(@NonNull String newVersion) throws IOException {
        this.worldConfiguration.set("configuration_version", newVersion);
        this.worldConfiguration.save(this.worldsFile);
    }

    private void setupStorage() {
        Storage.load(this.storageFile);
        Storage.save(this.storageFile);
        YamlConfiguration.loadConfiguration(this.storageFile);
    }

    private void showDebug() {
        if (Settings.DEBUG) {
            Map<String, Object> components = Settings.getFields(Settings.Enabled_Components.class);
            for (Map.Entry<String, Object> component : components.entrySet()) {
                LOGGER.info("Key: {} | Value: {}", (Object)component.getKey(), component.getValue());
            }
        }
    }

    public void forEachPlotRaw(@NonNull Consumer<Plot> consumer) {
        for (PlotArea area : this.getPlotAreaManager().getAllPlotAreas()) {
            area.getPlots().forEach(consumer);
        }
        if (this.plots_tmp != null) {
            for (HashMap hashMap : this.plots_tmp.values()) {
                hashMap.values().forEach(consumer);
            }
        }
    }

    public boolean isNonStandardGeneration(@NonNull String world, @NonNull BlockVector2 chunkCoordinates) {
        Location location = Location.at(world, chunkCoordinates.getBlockX() << 4, 64, chunkCoordinates.getBlockZ() << 4);
        PlotArea area = this.getPlotAreaManager().getApplicablePlotArea(location);
        if (area == null) {
            return true;
        }
        return area.getTerrain() != PlotAreaTerrainType.NONE;
    }

    public @NonNull YamlConfiguration getConfig() {
        return this.config;
    }

    public @NonNull UUIDPipeline getImpromptuUUIDPipeline() {
        return this.impromptuUUIDPipeline;
    }

    public @NonNull UUIDPipeline getBackgroundUUIDPipeline() {
        return this.backgroundUUIDPipeline;
    }

    public @NonNull WorldEdit getWorldEdit() {
        return this.worldedit;
    }

    public @NonNull File getConfigFile() {
        return this.configFile;
    }

    public @NonNull File getWorldsFile() {
        return this.worldsFile;
    }

    public @NonNull YamlConfiguration getWorldConfiguration() {
        return this.worldConfiguration;
    }

    public @NonNull CaptionMap getCaptionMap(@NonNull String namespace) {
        return this.captionMaps.computeIfAbsent(namespace.toLowerCase(Locale.ENGLISH), missingNamespace -> new DummyCaptionMap());
    }

    public void registerCaptionMap(@NonNull String namespace, @NonNull CaptionMap captionMap) {
        if (namespace.equalsIgnoreCase("plotsquared")) {
            throw new IllegalArgumentException("Cannot replace default caption map");
        }
        this.captionMaps.put(namespace.toLowerCase(Locale.ENGLISH), captionMap);
    }

    public @NonNull EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public @NonNull PlotListener getPlotListener() {
        return this.plotListener;
    }

    public boolean isWeInitialised() {
        return this.weInitialised;
    }

    private final class WEPlatformReadyListener {
        private WEPlatformReadyListener() {
        }

        @Subscribe(priority=EventHandler.Priority.VERY_EARLY)
        public void onPlatformReady(PlatformReadyEvent event) {
            PlotSquared.this.weInitialised = true;
            WorldEdit.getInstance().getEventBus().unregister((Object)this);
        }
    }

    public static enum SortType {
        CREATION_DATE,
        CREATION_DATE_TIMESTAMP,
        LAST_MODIFIED,
        DISTANCE_FROM_ORIGIN;

    }
}

