/*
 * PlotSquared, a land and world management plugin for Minecraft.
 * Copyright (C) IntellectualSites <https://intellectualsites.com>
 * Copyright (C) IntellectualSites team and contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.plotsquared.core.util;

public class MathMan {

    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = ATAN2_BITS << 1;
    private static final int ATAN2_MASK = ~(-1 << ATAN2_BITS2);
    private static final int ATAN2_COUNT = ATAN2_MASK + 1;
    private static final int ATAN2_DIM = (int) Math.sqrt(ATAN2_COUNT);
    private static final float INV_ATAN2_DIM_MINUS_1 = 1.0f / (ATAN2_DIM - 1);
    private static final float[] atan2 = new float[ATAN2_COUNT];
    private static final int[] table =
            {0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61, 64, 65, 67, 69, 71, 73, 75,
                    76, 78, 80, 81, 83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97, 98, 99, 101, 102, 103, 104,
                    106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
                    124, 125, 126, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140,
                    141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155,
                    155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 163, 164, 165, 166, 167, 167, 168,
                    169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181,
                    181, 182, 183, 183, 184, 185, 185, 186, 187, 187, 188, 189, 189, 190, 191, 192, 192,
                    193, 193, 194, 195, 195, 196, 197, 197, 198, 199, 199, 200, 201, 201, 202, 203, 203,
                    204, 204, 205, 206, 206, 207, 208, 208, 209, 209, 210, 211, 211, 212, 212, 213, 214,
                    214, 215, 215, 216, 217, 217, 218, 218, 219, 219, 220, 221, 221, 222, 222, 223, 224,
                    224, 225, 225, 226, 226, 227, 227, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233,
                    234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242,
                    243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251,
                    251, 252, 252, 253, 253, 254, 254, 255};

    static {
        for (int i = 0; i < ATAN2_DIM; i++) {
            for (int j = 0; j < ATAN2_DIM; j++) {
                float x0 = (float) i / ATAN2_DIM;
                float y0 = (float) j / ATAN2_DIM;

                atan2[(j * ATAN2_DIM) + i] = (float) Math.atan2(y0, x0);
            }
        }
    }

    public static final int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return gcd(b, a % b);
    }

    public static final int gcd(int[] a) {
        int result = a[0];
        for (int i = 1; i < a.length; i++) {
            result = gcd(result, a[i]);
        }
        return result;
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static long pairInt(int x, int y) {
        return (((long) x) << 32) | (y & 0xffffffffL);
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static int unpairIntX(long pair) {
        return (int) (pair >> 32);
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static int unpairIntY(long pair) {
        return (int) pair;
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static byte pair16(byte x, byte y) {
        return (byte) (x + (y << 4));
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static byte unpair16x(byte value) {
        return (byte) (value & 0xF);
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static byte unpair16y(byte value) {
        return (byte) ((value >> 4) & 0xF);
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static long inverseRound(double val) {
        long round = Math.round(val);
        return (long) (round + Math.signum(val - round));
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static int sqrt(int x) {
        int xn;

        if (x >= 0x10000) {
            if (x >= 0x1000000) {
                if (x >= 0x10000000) {
                    if (x >= 0x40000000) {
                        xn = table[x >> 24] << 8;
                    } else {
                        xn = table[x >> 22] << 7;
                    }
                } else {
                    if (x >= 0x4000000) {
                        xn = table[x >> 20] << 6;
                    } else {
                        xn = table[x >> 18] << 5;
                    }
                }

                xn = (xn + 1 + (x / xn)) >> 1;
                xn = (xn + 1 + (x / xn)) >> 1;
                return ((xn * xn) > x) ? --xn : xn;
            } else {
                if (x >= 0x100000) {
                    if (x >= 0x400000) {
                        xn = table[x >> 16] << 4;
                    } else {
                        xn = table[x >> 14] << 3;
                    }
                } else {
                    if (x >= 0x40000) {
                        xn = table[x >> 12] << 2;
                    } else {
                        xn = table[x >> 10] << 1;
                    }
                }

                xn = (xn + 1 + (x / xn)) >> 1;

                return ((xn * xn) > x) ? --xn : xn;
            }
        } else {
            if (x >= 0x100) {
                if (x >= 0x1000) {
                    if (x >= 0x4000) {
                        xn = (table[x >> 8]) + 1;
                    } else {
                        xn = (table[x >> 6] >> 1) + 1;
                    }
                } else {
                    if (x >= 0x400) {
                        xn = (table[x >> 4] >> 2) + 1;
                    } else {
                        xn = (table[x >> 2] >> 3) + 1;
                    }
                }

                return ((xn * xn) > x) ? --xn : xn;
            } else {
                if (x >= 0) {
                    return table[x] >> 4;
                }
            }
        }
        throw new IllegalArgumentException("Invalid number:" + x);
    }


    public static double getMean(int[] array) {
        double count = 0;
        for (int i : array) {
            count += i;
        }
        return count / array.length;
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static double getMean(double[] array) {
        double count = 0;
        for (double i : array) {
            count += i;
        }
        return count / array.length;
    }

    public static int pair(short x, short y) {
        return (x << 16) | (y & 0xFFFF);
    }

    public static final int average(int a, int b) {
        return (a & b) + (a ^ b) / 2;
    }


    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static short unpairX(int hash) {
        return (short) (hash >> 16);
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static short unpairY(int hash) {
        return (short) (hash & 0xFFFF);
    }

    /**
     * get the x,y,z unit vector from pitch and yaw specified
     *
     * @param yaw   yaw
     * @param pitch pitch
     * @return x, y, z unit vector
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static float[] getDirection(float yaw, float pitch) {
        double pitch_sin = Math.sin(pitch);
        return new float[]{(float) (pitch_sin * Math.cos(yaw)),
                (float) (pitch_sin * Math.sin(yaw)), (float) Math.cos(pitch)};
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static int floorMod(int x, int y) {
        int i = x % y;
        if (i < 0) {
            i += y;
        }
        return i;
    }

    public static int roundInt(double value) {
        return (int) (value < 0 ? (value == (int) value) ? value : value - 1 : value);
    }

    /**
     * Returns [ pitch, yaw ]
     *
     * @param x x
     * @param y y
     * @param z z
     * @return pitch and yaw of x,y,z from 0,0,0
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static float[] getPitchAndYaw(float x, float y, float z) {
        float distance = sqrtApprox((z * z) + (x * x));
        return new float[]{atan2(y, distance), atan2(x, z)};
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static final float atan2(float y, float x) {
        float add;
        float mul;

        if (x < 0.0f) {
            if (y < 0.0f) {
                x = -x;
                y = -y;

                mul = 1.0f;
            } else {
                x = -x;
                mul = -1.0f;
            }

            add = -3.141592653f;
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }

            add = 0.0f;
        }

        float invDiv = 1.0f / (((x < y) ? y : x) * INV_ATAN2_DIM_MINUS_1);

        int xi = (int) (x * invDiv);
        int yi = (int) (y * invDiv);

        return (atan2[(yi * ATAN2_DIM) + xi] + add) * mul;
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static float sqrtApprox(float f) {
        return f * Float.intBitsToFloat(0x5f375a86 - (Float.floatToIntBits(f) >> 1));
    }


    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static double sqrtApprox(double d) {
        return Double
                .longBitsToDouble(((Double.doubleToLongBits(d) - (1L << 52)) >> 1) + (1L << 61));
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static float invSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 0x5f3759df - (i >> 1);
        x = Float.intBitsToFloat(i);
        x = x * (1.5f - (xhalf * x * x));
        return x;
    }

    public static int getPositiveId(int i) {
        if (i < 0) {
            return (-i * 2) - 1;
        }
        return i * 2;
    }

    public static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        for (; i < length; i++) {
            char c = str.charAt(i);
            if ((c <= '/') || (c >= ':')) {
                return false;
            }
        }
        return true;
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static double getSD(double[] array, double av) {
        double sd = 0;
        for (double element : array) {
            sd += Math.pow(Math.abs(element - av), 2);
        }
        return Math.sqrt(sd / array.length);
    }

    public static double getSD(int[] array, double av) {
        double sd = 0;
        for (int element : array) {
            sd += Math.pow(Math.abs(element - av), 2);
        }
        return Math.sqrt(sd / array.length);
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static int mod(int x, int y) {
        if (isPowerOfTwo(y)) {
            return x & (y - 1);
        }
        return x % y;
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static int unsignedmod(int x, int y) {
        if (isPowerOfTwo(y)) {
            return x & (y - 1);
        }
        return x % y;
    }

    /**
     * @deprecated Unused internally. Scheduled for removal in next major release.
     */
    @Deprecated(forRemoval = true, since = "6.11.1")
    public static boolean isPowerOfTwo(int number) {
        return (number & (number - 1)) == 0;
    }

}
