/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.PlotTitle;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.StringMan;
import java.util.List;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlotTitleFlag
extends PlotFlag<PlotTitle, PlotTitleFlag> {
    public static final PlotTitleFlag TITLE_FLAG_DEFAULT = new PlotTitleFlag(PlotTitle.CONFIGURED);

    protected PlotTitleFlag(PlotTitle value) {
        super(value, TranslatableCaption.of("flags.flag_category_string"), TranslatableCaption.of("flags.flag_description_title"));
    }

    @Override
    public PlotTitleFlag parse(@NonNull String input) throws FlagParseException {
        if (input.equals("CONFIGURED")) {
            return TITLE_FLAG_DEFAULT;
        }
        if (!input.contains("\"")) {
            return new PlotTitleFlag(new PlotTitle(input, ""));
        }
        List<String> split = StringMan.splitMessage(input);
        if (split.isEmpty() || split.size() > 2) {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_title"), new Template[0]);
        }
        PlotTitle value = split.size() == 1 ? new PlotTitle(split.get(0), "") : new PlotTitle(split.get(0), split.get(1));
        return new PlotTitleFlag(value);
    }

    @Override
    public PlotTitleFlag merge(@NonNull PlotTitle newValue) {
        if (((PlotTitle)this.getValue()).title().isEmpty() && ((PlotTitle)this.getValue()).subtitle().isEmpty()) {
            return new PlotTitleFlag(newValue);
        }
        if (((PlotTitle)this.getValue()).subtitle().isEmpty()) {
            return new PlotTitleFlag(new PlotTitle(((PlotTitle)this.getValue()).title(), newValue.subtitle()));
        }
        if (((PlotTitle)this.getValue()).title().isEmpty()) {
            return new PlotTitleFlag(new PlotTitle(newValue.title(), ((PlotTitle)this.getValue()).subtitle()));
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.getValue() == PlotTitle.CONFIGURED) {
            return "CONFIGURED";
        }
        return "\"" + ((PlotTitle)this.getValue()).title() + "\" \"" + ((PlotTitle)this.getValue()).subtitle() + "\"";
    }

    @Override
    public boolean isValuedPermission() {
        return false;
    }

    @Override
    public String getExample() {
        return "\"A Title\" \"The subtitle\"";
    }

    @Override
    protected PlotTitleFlag flagOf(@NonNull PlotTitle value) {
        return new PlotTitleFlag(value);
    }
}

