/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.database;

import com.plotsquared.core.database.AbstractDB;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.task.RunnableVal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class DBFunc {
    public static final UUID EVERYONE = UUID.fromString("1-1-3-3-7");
    public static final UUID SERVER = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static AbstractDB dbManager;

    public static void updateTables(int[] oldVersion) {
        if (dbManager != null) {
            dbManager.updateTables(oldVersion);
        }
    }

    public static void addPersistentMeta(UUID uuid, String key, byte[] meta, boolean delete) {
        if (dbManager != null) {
            dbManager.addPersistentMeta(uuid, key, meta, delete);
        }
    }

    public static void getPersistentMeta(UUID uuid, RunnableVal<Map<String, byte[]>> result) {
        if (dbManager != null) {
            dbManager.getPersistentMeta(uuid, result);
        }
    }

    public static void removePersistentMeta(UUID uuid, String key) {
        if (dbManager != null) {
            dbManager.removePersistentMeta(uuid, key);
        }
    }

    public static CompletableFuture<Boolean> swapPlots(Plot plot1, Plot plot2) {
        if (dbManager != null) {
            return dbManager.swapPlots(plot1, plot2);
        }
        return CompletableFuture.completedFuture(false);
    }

    public static boolean deleteTables() {
        return dbManager != null && dbManager.deleteTables();
    }

    public static void movePlot(Plot originalPlot, Plot newPlot) {
        if (originalPlot.temp == -1 || newPlot.temp == -1) {
            return;
        }
        dbManager.movePlot(originalPlot, newPlot);
    }

    public static void validatePlots(Set<Plot> plots) {
        if (dbManager == null) {
            return;
        }
        dbManager.validateAllPlots(plots);
    }

    @Deprecated
    public static boolean hasColumn(ResultSet resultSet, String name) {
        try {
            ResultSetMetaData meta = resultSet.getMetaData();
            int count = meta.getColumnCount();
            for (int x = 1; x <= count; ++x) {
                if (!name.equals(meta.getColumnName(x))) continue;
                return true;
            }
            return false;
        }
        catch (SQLException ignored) {
            return false;
        }
    }

    public static void setOwner(Plot plot, UUID uuid) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setOwner(plot, uuid);
    }

    public static void createPlotsAndData(List<Plot> plots, Runnable whenDone) {
        if (dbManager == null) {
            return;
        }
        dbManager.createPlotsAndData(plots, whenDone);
    }

    public static void createPlotSafe(Plot plot, Runnable success, Runnable failure) {
        if (dbManager == null) {
            return;
        }
        dbManager.createPlotSafe(plot, success, failure);
    }

    public static void createPlotAndSettings(Plot plot, Runnable whenDone) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.createPlotAndSettings(plot, whenDone);
    }

    public static void createTables() throws Exception {
        if (dbManager == null) {
            return;
        }
        dbManager.createTables();
    }

    public static void delete(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.delete(plot);
        plot.temp = -1;
    }

    public static void deleteRatings(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteRatings(plot);
    }

    public static void deleteTrusted(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteHelpers(plot);
    }

    public static void deleteMembers(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteTrusted(plot);
    }

    public static void deleteDenied(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteDenied(plot);
    }

    public static void deleteComments(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteComments(plot);
    }

    public static void deleteSettings(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.deleteSettings(plot);
    }

    public static void delete(PlotCluster toDelete) {
        if (dbManager == null) {
            return;
        }
        dbManager.delete(toDelete);
    }

    public static void createPlotSettings(int id, Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.createPlotSettings(id, plot);
    }

    public static int getId(Plot plot) {
        if (dbManager == null) {
            return 0;
        }
        return dbManager.getId(plot);
    }

    public static HashMap<String, HashMap<PlotId, Plot>> getPlots() {
        if (dbManager == null) {
            return new HashMap<String, HashMap<PlotId, Plot>>();
        }
        return dbManager.getPlots();
    }

    public static void setMerged(Plot plot, boolean[] merged) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setMerged(plot, merged);
    }

    public static void setFlag(Plot plot, PlotFlag<?, ?> flag) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setFlag(plot, flag);
    }

    public static void removeFlag(Plot plot, PlotFlag<?, ?> flag) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeFlag(plot, flag);
    }

    public static void setAlias(Plot plot, String alias) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setAlias(plot, alias);
    }

    public static void purgeIds(Set<Integer> uniqueIds) {
        if (dbManager == null) {
            return;
        }
        dbManager.purgeIds(uniqueIds);
    }

    public static void purge(PlotArea area, Set<PlotId> plotIds) {
        if (dbManager == null) {
            return;
        }
        dbManager.purge(area, plotIds);
    }

    public static void setPosition(Plot plot, String position) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setPosition(plot, position);
    }

    public static void removeComment(Plot plot, PlotComment comment) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeComment(plot, comment);
    }

    public static void clearInbox(Plot plot, String inbox) {
        if (plot != null && plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.clearInbox(plot, inbox);
    }

    public static void setComment(Plot plot, PlotComment comment) {
        if (plot != null && plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setComment(plot, comment);
    }

    public static void getComments(Plot plot, String inbox, RunnableVal<List<PlotComment>> whenDone) {
        if (plot != null && plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.getComments(plot, inbox, whenDone);
    }

    public static void removeTrusted(Plot plot, UUID uuid) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeTrusted(plot, uuid);
    }

    public static void removeHelper(PlotCluster cluster, UUID uuid) {
        if (dbManager == null) {
            return;
        }
        dbManager.removeHelper(cluster, uuid);
    }

    public static void createCluster(PlotCluster cluster) {
        if (dbManager == null) {
            return;
        }
        dbManager.createCluster(cluster);
    }

    public static void resizeCluster(PlotCluster current, PlotId min, PlotId max) {
        if (dbManager == null) {
            return;
        }
        dbManager.resizeCluster(current, min, max);
    }

    public static void removeMember(Plot plot, UUID uuid) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeMember(plot, uuid);
    }

    public static void removeInvited(PlotCluster cluster, UUID uuid) {
        if (dbManager == null) {
            return;
        }
        dbManager.removeInvited(cluster, uuid);
    }

    public static void setTrusted(Plot plot, UUID uuid) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setTrusted(plot, uuid);
    }

    public static void setHelper(PlotCluster cluster, UUID uuid) {
        if (dbManager == null) {
            return;
        }
        dbManager.setHelper(cluster, uuid);
    }

    public static void setMember(Plot plot, UUID uuid) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setMember(plot, uuid);
    }

    public static void setInvited(PlotCluster cluster, UUID uuid) {
        if (dbManager == null) {
            return;
        }
        dbManager.setInvited(cluster, uuid);
    }

    public static void removeDenied(Plot plot, UUID uuid) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.removeDenied(plot, uuid);
    }

    public static void setDenied(Plot plot, UUID uuid) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setDenied(plot, uuid);
    }

    public static HashMap<UUID, Integer> getRatings(Plot plot) {
        if (plot.temp == -1 || dbManager == null) {
            return new HashMap<UUID, Integer>(0);
        }
        return dbManager.getRatings(plot);
    }

    public static void setRating(Plot plot, UUID rater, int value) {
        if (plot.temp == -1 || dbManager == null) {
            return;
        }
        dbManager.setRating(plot, rater, value);
    }

    public static HashMap<String, Set<PlotCluster>> getClusters() {
        if (dbManager == null) {
            return new HashMap<String, Set<PlotCluster>>();
        }
        return dbManager.getClusters();
    }

    public static void setPosition(PlotCluster cluster, String position) {
        if (dbManager == null) {
            return;
        }
        dbManager.setPosition(cluster, position);
    }

    public static void replaceWorld(String oldWorld, String newWorld, PlotId min, PlotId max) {
        if (dbManager == null) {
            return;
        }
        dbManager.replaceWorld(oldWorld, newWorld, min, max);
    }

    public static void replaceUUID(UUID old, UUID now) {
        if (dbManager == null) {
            return;
        }
        dbManager.replaceUUID(old, now);
    }

    public static void close() {
        if (dbManager != null) {
            dbManager.close();
        }
    }
}

