/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.AnalysisFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.core.util.task.TaskManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="clear", requiredType=RequiredType.NONE, permission="plots.clear", category=CommandCategory.APPEARANCE, usage="/plot clear", aliases={"reset"}, confirmation=true)
public class Clear
extends Command {
    private final EventDispatcher eventDispatcher;
    private final GlobalBlockQueue blockQueue;

    @Inject
    public Clear(@NonNull EventDispatcher eventDispatcher, @NonNull GlobalBlockQueue blockQueue) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
        this.blockQueue = blockQueue;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        if (args.length != 0) {
            this.sendUsage(player);
            return CompletableFuture.completedFuture(false);
        }
        Plot plot = this.check(player.getCurrentPlot(), TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
        Result eventResult = this.eventDispatcher.callClear(plot).getEventResult();
        if (eventResult == Result.DENY) {
            player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.of((String)"value", (String)"Clear"));
            return CompletableFuture.completedFuture(true);
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
            return CompletableFuture.completedFuture(true);
        }
        boolean force = eventResult == Result.FORCE;
        this.checkTrue(force || plot.isOwner(player.getUUID()) || player.hasPermission("plots.admin.command.clear"), TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
        this.checkTrue(plot.getRunning() == 0, TranslatableCaption.of("errors.wait_for_timer"), new Template[0]);
        this.checkTrue(force || !Settings.Done.RESTRICT_BUILDING || !DoneFlag.isDone(plot) || player.hasPermission("plots.continue"), TranslatableCaption.of("done.done_already_done"), new Template[0]);
        confirm.run(this, () -> {
            if (Settings.Teleport.ON_CLEAR) {
                plot.getPlayersInPlot().forEach(playerInPlot -> plot.teleportPlayer((PlotPlayer<?>)playerInPlot, TeleportCause.COMMAND_CLEAR, result -> {}));
            }
            BackupManager.backup(player, plot, () -> {
                long start = System.currentTimeMillis();
                boolean result = plot.getPlotModificationManager().clear(true, false, player, () -> {
                    plot.getPlotModificationManager().unlink();
                    TaskManager.runTask(() -> {
                        PlotFlag plotFlag;
                        PlotFlagRemoveEvent event;
                        plot.removeRunning();
                        if (DoneFlag.isDone(plot) && (event = this.eventDispatcher.callFlagRemove(plotFlag = plot.getFlagContainer().getFlag(DoneFlag.class), plot)).getEventResult() != Result.DENY) {
                            plot.removeFlag(event.getFlag());
                        }
                        if (!((List)plot.getFlag(AnalysisFlag.class)).isEmpty() && (event = this.eventDispatcher.callFlagRemove(plotFlag = plot.getFlagContainer().getFlag(AnalysisFlag.class), plot)).getEventResult() != Result.DENY) {
                            plot.removeFlag(event.getFlag());
                        }
                        player.sendMessage(TranslatableCaption.of("working.clearing_done"), Template.of((String)"amount", (String)String.valueOf(System.currentTimeMillis() - start)), Template.of((String)"plot", (String)plot.getId().toString()));
                    });
                });
                if (!result) {
                    player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new Template[0]);
                } else {
                    plot.addRunning();
                }
            });
        }, null);
        return CompletableFuture.completedFuture(true);
    }
}

