/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.google.common.base.Preconditions;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PatternUtil {
    public static BaseBlock apply(@NonNull Pattern pattern, int x, int y, int z) {
        Preconditions.checkNotNull((Object)pattern, (Object)"Pattern may not be null");
        if (pattern instanceof BlockPattern || pattern instanceof BlockState || pattern instanceof BlockType || pattern instanceof BaseBlock) {
            return pattern.applyBlock(BlockVector3.ZERO);
        }
        return pattern.applyBlock(BlockVector3.at((int)x, (int)y, (int)z));
    }

    public static Pattern parse(PlotPlayer<?> plotPlayer, String input) {
        return PatternUtil.parse(plotPlayer, input, true);
    }

    public static List<String> getSuggestions(String input) {
        try {
            return WorldEdit.getInstance().getPatternFactory().getSuggestions(input);
        }
        catch (Exception exception) {
            return new ArrayList<String>();
        }
    }

    public static Pattern parse(PlotPlayer<?> plotPlayer, String input, boolean allowLegacy) {
        ParserContext context = new ParserContext();
        if (plotPlayer != null) {
            Actor actor = plotPlayer.toActor();
            context.setActor(actor);
            if (actor instanceof Player) {
                context.setWorld(((Player)actor).getWorld());
            }
            context.setSession(WorldEdit.getInstance().getSessionManager().get((SessionOwner)actor));
            context.setRestricted(true);
        } else {
            context.setRestricted(false);
        }
        context.setPreferringWildcard(false);
        context.setTryLegacy(allowLegacy);
        try {
            return (Pattern)WorldEdit.getInstance().getPatternFactory().parseFromInput(input, context);
        }
        catch (InputParseException e) {
            throw new Command.CommandException(TranslatableCaption.of("invalid.not_valid_block"), Template.of((String)"value", (String)e.getMessage()));
        }
    }

    public static boolean isAir(Pattern pattern) {
        if (pattern instanceof BlockPattern) {
            return ((BlockPattern)pattern).getBlock().getBlockType().getMaterial().isAir();
        }
        if (pattern instanceof BlockState) {
            return ((BlockState)pattern).getBlockType().getMaterial().isAir();
        }
        if (pattern instanceof BlockType) {
            return ((BlockType)pattern).getMaterial().isAir();
        }
        if (pattern instanceof BaseBlock) {
            return ((BaseBlock)pattern).getBlockType().getMaterial().isAir();
        }
        return false;
    }
}

