/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.plotsquared.core.collection.ArrayUtil;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.SingleWorldGenerator;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.DefaultPlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.SetupUtils;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class SinglePlotAreaManager
extends DefaultPlotAreaManager {
    private final SinglePlotArea[] array;
    private SinglePlotArea area;
    private PlotArea[] all;

    @Inject
    public SinglePlotAreaManager(@NonNull EventDispatcher eventDispatcher, @NonNull PlotListener plotListener, @WorldConfig @NonNull YamlConfiguration worldConfiguration, @NonNull GlobalBlockQueue blockQueue) {
        this.area = new SinglePlotArea(this, eventDispatcher, plotListener, worldConfiguration, blockQueue);
        this.array = new SinglePlotArea[]{this.area};
        this.all = new PlotArea[]{this.area};
        SetupUtils.generators.put("PlotSquared:single", new SingleWorldGenerator(this).specify("CheckingPlotSquaredGenerator"));
    }

    public SinglePlotArea getArea() {
        return this.area;
    }

    public void setArea(@NonNull SinglePlotArea area) {
        this.area = area;
        this.array[0] = area;
        this.all = ArrayUtil.concatAll(super.getAllPlotAreas(), new PlotArea[][]{this.array});
    }

    public boolean isWorld(@NonNull String id) {
        char[] chars = id.toCharArray();
        if (chars.length == 1 && chars[0] == '*') {
            return true;
        }
        int mode = 0;
        block6: for (char c : chars) {
            switch (mode) {
                case 0: {
                    mode = 1;
                    if (c == '-') continue block6;
                }
                case 1: {
                    if (c > '/' && c < ':') continue block6;
                    if (c == '_') {
                        mode = 2;
                        continue block6;
                    }
                    return false;
                }
                case 2: {
                    mode = 3;
                    if (c == '-') continue block6;
                }
                case 3: {
                    if (c > '/' && c < ':') continue block6;
                    return false;
                }
            }
        }
        return mode == 3;
    }

    @Override
    public @Nullable PlotArea getApplicablePlotArea(@Nullable Location location) {
        if (location == null) {
            return null;
        }
        String world = location.getWorldName();
        return this.isWorld(world) || world.equals("*") || super.getAllPlotAreas().length == 0 ? this.area : super.getApplicablePlotArea(location);
    }

    @Override
    public @Nullable PlotArea getPlotArea(@NonNull String world, @NonNull String id) {
        PlotArea found = super.getPlotArea(world, id);
        if (found != null) {
            return found;
        }
        return this.isWorld(world) || world.equals("*") ? this.area : super.getPlotArea(world, id);
    }

    @Override
    public @Nullable PlotArea getPlotArea(@NonNull Location location) {
        PlotArea found = super.getPlotArea(location);
        if (found != null) {
            return found;
        }
        return this.isWorld(location.getWorldName()) || location.getWorldName().equals("*") ? this.area : null;
    }

    @Override
    public @NonNull PlotArea[] getPlotAreas(@NonNull String world, @NonNull CuboidRegion region) {
        PlotArea[] found = super.getPlotAreas(world, region);
        if (found != null && found.length != 0) {
            return found;
        }
        return this.isWorld(world) || world.equals("*") ? this.array : (this.all.length == 0 ? this.noPlotAreas : found);
    }

    @Override
    public @NonNull PlotArea[] getAllPlotAreas() {
        return this.all;
    }

    @Override
    public @NonNull String[] getAllWorlds() {
        return super.getAllWorlds();
    }

    @Override
    public void addPlotArea(@NonNull PlotArea area) {
        if (area == this.area) {
            return;
        }
        super.addPlotArea(area);
        this.all = ArrayUtil.concatAll(super.getAllPlotAreas(), new PlotArea[][]{this.array});
    }

    @Override
    public void removePlotArea(@NonNull PlotArea area) {
        if (area == this.area) {
            throw new UnsupportedOperationException("Cannot remove base area!");
        }
        super.removePlotArea(area);
    }

    @Override
    public void addWorld(@NonNull String worldName) {
        super.addWorld(worldName);
    }

    @Override
    public void removeWorld(@NonNull String worldName) {
        super.removeWorld(worldName);
    }
}

