/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="leave", permission="plots.leave", usage="/plot leave", category=CommandCategory.CLAIMING, requiredType=RequiredType.PLAYER)
public class Leave
extends Command {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Leave(@NonNull EventDispatcher eventDispatcher) {
        super(MainCommand.getInstance(), true);
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        Plot plot = this.check(player.getCurrentPlot(), TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
        this.checkTrue(plot.hasOwner(), TranslatableCaption.of("info.plot_unowned"), new Template[0]);
        if (plot.isOwner(player.getUUID())) {
            player.sendMessage(TranslatableCaption.of("member.plot_cant_leave_owner"), new Template[0]);
        } else {
            UUID uuid = player.getUUID();
            if (plot.isAdded(uuid)) {
                if (plot.removeTrusted(uuid)) {
                    this.eventDispatcher.callTrusted(player, plot, uuid, false);
                }
                if (plot.removeMember(uuid)) {
                    this.eventDispatcher.callMember(player, plot, uuid, false);
                }
                player.sendMessage(TranslatableCaption.of("member.plot_left"), Template.of((String)"player", (String)player.getName()));
            } else {
                player.sendMessage(TranslatableCaption.of("members.not_added_trusted"), new Template[0]);
            }
        }
        return CompletableFuture.completedFuture(true);
    }
}

