/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core;

import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlotVersion {
    public final int year;
    public final int month;
    public final int day;
    public final int hash;
    public final String versionString;
    public final int[] version;
    public final String suffix;

    public PlotVersion(int year, int month, int day, int hash, String rawVersion) {
        String versionString = rawVersion;
        this.year = year;
        this.month = month;
        this.day = day;
        this.hash = hash;
        int dash = versionString.indexOf(45);
        if (dash != -1) {
            this.suffix = versionString.substring(dash);
            versionString = versionString.substring(0, dash);
        } else {
            this.suffix = "";
        }
        this.versionString = versionString.substring(versionString.indexOf(61) + 1);
        this.version = new int[3];
        String[] verArray = versionString.substring(versionString.indexOf(61) + 1).split("\\.");
        this.version[0] = verArray.length > 0 ? Integer.parseInt(verArray[0]) : 0;
        this.version[1] = verArray.length > 1 ? Integer.parseInt(verArray[1]) : 0;
        this.version[2] = verArray.length > 2 ? Integer.parseInt(verArray[2]) : 0;
    }

    public PlotVersion(String rawVersion, String commit, String date) {
        String versionString = rawVersion;
        int dash = versionString.indexOf(45);
        if (dash != -1) {
            this.suffix = versionString.substring(dash);
            versionString = versionString.substring(0, dash);
        } else {
            this.suffix = "";
        }
        this.versionString = versionString.substring(versionString.indexOf(61) + 1);
        this.version = new int[3];
        String[] verArray = this.versionString.split("\\.");
        this.version[0] = verArray.length > 0 ? Integer.parseInt(verArray[0]) : 0;
        this.version[1] = verArray.length > 1 ? Integer.parseInt(verArray[1]) : 0;
        this.version[2] = verArray.length > 2 ? Integer.parseInt(verArray[2]) : 0;
        this.hash = Integer.parseInt(commit.substring(commit.indexOf(61) + 1), 16);
        String[] split1 = date.substring(date.indexOf(61) + 1).split("\\.");
        this.year = Integer.parseInt(split1[0]);
        this.month = Integer.parseInt(split1[1]);
        this.day = Integer.parseInt(split1[2]);
    }

    public static @NonNull PlotVersion tryParse(@NonNull String versionString, @NonNull String commit, @NonNull String date) {
        try {
            return new PlotVersion(versionString, commit, date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PlotVersion(0, 0, 0, 0, "0");
        }
    }

    public @NonNull String versionString() {
        if (this.hash == 0 && this.versionString == null) {
            return "NoVer-SNAPSHOT";
        }
        return this.versionString + this.suffix;
    }

    public String toString() {
        if (this.hash == 0 && this.versionString == null) {
            return "PlotSquared-NoVer-SNAPSHOT";
        }
        return "PlotSquared-" + this.versionString + this.suffix;
    }

    public boolean isLaterVersion(@NonNull String versionString) {
        int dash = versionString.indexOf(45);
        String[] verArray = versionString.substring(0, dash == -1 ? versionString.length() : dash).split("\\.");
        int one = Integer.parseInt(verArray[0]);
        int two = Integer.parseInt(verArray[1]);
        int three = Integer.parseInt(verArray[2]);
        if (one > this.version[0]) {
            return true;
        }
        if (one == this.version[0] && two > this.version[1]) {
            return true;
        }
        return one == this.version[0] && two == this.version[1] && three > this.version[2];
    }

    public boolean isLaterVersion(int[] verArray) {
        if (verArray[0] > this.version[0]) {
            return true;
        }
        if (verArray[0] == this.version[0] && verArray[1] > this.version[1]) {
            return true;
        }
        return verArray[0] == this.version[0] && verArray[1] == this.version[1] && verArray[2] > this.version[2];
    }
}

