/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.util.ChunkManager;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlotAPI {
    public @NonNull Set<@NonNull Plot> getAllPlots() {
        return PlotQuery.newQuery().allPlots().asSet();
    }

    public @NonNull Set<@NonNull Plot> getPlayerPlots(@NonNull PlotPlayer<?> player) {
        return PlotQuery.newQuery().ownedBy(player).asSet();
    }

    public void addPlotArea(@NonNull PlotArea plotArea) {
        PlotSquared.get().addPlotArea(plotArea);
    }

    public @NonNull ChunkManager getChunkManager() {
        return (ChunkManager)PlotSquared.platform().injector().getInstance(ChunkManager.class);
    }

    public @NonNull GlobalBlockQueue getBlockQueue() {
        return PlotSquared.platform().globalBlockQueue();
    }

    public @NonNull SchematicHandler getSchematicHandler() {
        return (SchematicHandler)PlotSquared.platform().injector().getInstance(SchematicHandler.class);
    }

    public @NonNull Set<@NonNull PlotArea> getPlotAreas(@Nullable String world) {
        if (world == null) {
            return Collections.emptySet();
        }
        return PlotSquared.get().getPlotAreaManager().getPlotAreasSet(world);
    }

    public void sendConsoleMessage(@NonNull String message, Template ... replacements) {
        ConsolePlayer.getConsole().sendMessage(StaticCaption.of(message), replacements);
    }

    public void sendConsoleMessage(@NonNull Caption caption, Template ... replacements) {
        ConsolePlayer.getConsole().sendMessage(caption, replacements);
    }

    public @NonNull PlotSquared getPlotSquared() {
        return PlotSquared.get();
    }

    public @Nullable PlotPlayer<?> wrapPlayer(@NonNull UUID uuid) {
        return PlotSquared.platform().playerManager().getPlayerIfExists(uuid);
    }

    public @Nullable PlotPlayer<?> wrapPlayer(@NonNull String player) {
        return PlotSquared.platform().playerManager().getPlayerIfExists(player);
    }

    public void registerListener(@NonNull Object listener) {
        PlotSquared.get().getEventDispatcher().registerListener(listener);
    }
}

