/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.intellectualsites.annotations.DoNotUse;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.generator.SquarePlotWorld;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.SchematicHandler;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.CompoundTagBuilder;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.transform.BlockTransformExtent;
import com.sk89q.worldedit.internal.helper.MCDirections;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HybridPlotWorld
extends ClassicPlotWorld {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + HybridPlotWorld.class.getSimpleName()));
    private static final AffineTransform transform = new AffineTransform().rotateY(90.0);
    public boolean ROAD_SCHEMATIC_ENABLED;
    public boolean PLOT_SCHEMATIC = false;
    @Deprecated(forRemoval=true, since="6.9.0")
    public int PLOT_SCHEMATIC_HEIGHT = -1;
    public short PATH_WIDTH_LOWER;
    public short PATH_WIDTH_UPPER;
    public HashMap<Integer, BaseBlock[]> G_SCH;
    public HashMap<Integer, BiomeType> G_SCH_B;
    public int SCHEM_Y;
    private Location SIGN_LOCATION;
    private File root = null;
    private int lastOverlayHeightError = Integer.MIN_VALUE;
    private List<Entity> schem3Entities = null;
    private BlockVector3 schem3MinPoint = null;
    private boolean schem1PopulationNeeded = false;
    private boolean schem2PopulationNeeded = false;
    private boolean schem3PopulationNeeded = false;
    @Inject
    private SchematicHandler schematicHandler;

    @Inject
    public HybridPlotWorld(@Assisted(value="world") String worldName, @Assisted(value="id") @Nullable String id, @Assisted @NonNull IndependentPlotGenerator generator, @Assisted(value="min") @Nullable PlotId min, @Assisted(value="max") @Nullable PlotId max, @WorldConfig @NonNull YamlConfiguration worldConfiguration, @NonNull GlobalBlockQueue blockQueue) {
        super(worldName, id, generator, min, max, worldConfiguration, blockQueue);
        PlotSquared.platform().injector().injectMembers((Object)this);
    }

    @Deprecated(forRemoval=true, since="6.9.0")
    public static byte wrap(byte data, int start) {
        if (data >= start && data < start + 4) {
            data = (byte)((data - start + 2 & 3) + start);
        }
        return data;
    }

    @Deprecated(forRemoval=true, since="6.9.0")
    public static byte wrap2(byte data, int start) {
        if (data >= start && data < start + 2) {
            data = (byte)((data - start + 1 & 1) + start);
        }
        return data;
    }

    public static BaseBlock rotate(BaseBlock id) {
        Vector3 vector;
        Direction newDirection;
        int rot;
        Direction direction;
        CompoundTag tag = id.getNbtData();
        if (tag != null && tag.containsKey("Rot") && (direction = MCDirections.fromRotation((int)(rot = tag.asInt("Rot")))) != null && (newDirection = Direction.findClosest((Vector3)(vector = transform.apply(direction.toVector()).subtract(transform.apply(Vector3.ZERO)).normalize()), (int)(Direction.Flag.CARDINAL | Direction.Flag.ORDINAL | Direction.Flag.SECONDARY_ORDINAL))) != null) {
            CompoundTagBuilder builder = tag.createBuilder();
            builder.putByte("Rot", (byte)MCDirections.toRotation((Direction)newDirection));
            id.setNbtData(builder.build());
        }
        return (BaseBlock)BlockTransformExtent.transform((BlockStateHolder)id, (Transform)transform);
    }

    @Override
    protected @NonNull PlotManager createManager() {
        return new HybridPlotManager(this, PlotSquared.platform().regionManager(), (ProgressSubscriberFactory)PlotSquared.platform().injector().getInstance(ProgressSubscriberFactory.class));
    }

    public Location getSignLocation(@NonNull Plot plot) {
        plot = plot.getBasePlot(false);
        Location bot = plot.getBottomAbs();
        if (this.SIGN_LOCATION == null) {
            return bot.withY(this.ROAD_HEIGHT + 1).add(-1, 0, -2);
        }
        return bot.withY(0).add(this.SIGN_LOCATION.getX(), this.SIGN_LOCATION.getY(), this.SIGN_LOCATION.getZ());
    }

    @Override
    public void loadConfiguration(ConfigurationSection config) {
        super.loadConfiguration(config);
        this.PATH_WIDTH_LOWER = (this.ROAD_WIDTH & 1) == 0 ? (short)(Math.floor((float)this.ROAD_WIDTH / 2.0f) - 1.0) : (short)Math.floor((float)this.ROAD_WIDTH / 2.0f);
        this.PATH_WIDTH_UPPER = this.ROAD_WIDTH == 0 ? (short)(this.SIZE + 1) : (short)(this.PATH_WIDTH_LOWER + this.PLOT_WIDTH + 1);
        try {
            this.setupSchematics();
        }
        catch (Exception event) {
            event.printStackTrace();
        }
        if (Settings.DEBUG) {
            Field[] fields;
            LOGGER.info("- Dumping settings for ClassicPlotWorld with name {}", (Object)this.getWorldName());
            for (Field field : fields = this.getClass().getFields()) {
                Object value;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                if (name.contains("g_sch")) continue;
                try {
                    boolean accessible = field.isAccessible();
                    field.setAccessible(true);
                    value = field.get(this);
                    field.setAccessible(accessible);
                }
                catch (IllegalAccessException e) {
                    value = String.format("Failed to parse: %s", e.getMessage());
                }
                LOGGER.info("-- {} = {}", (Object)name, value);
            }
        }
    }

    @Override
    public boolean isCompatible(@NonNull PlotArea plotArea) {
        if (!(plotArea instanceof SquarePlotWorld)) {
            return false;
        }
        return ((SquarePlotWorld)plotArea).PLOT_WIDTH == this.PLOT_WIDTH;
    }

    public void setupSchematics() throws SchematicHandler.UnsupportedFormatException {
        File schematic3File;
        File schematic2File;
        File schematic1File;
        this.G_SCH = new HashMap();
        this.G_SCH_B = new HashMap();
        this.root = FileUtils.getFile(PlotSquared.platform().getDirectory(), "schematics/GEN_ROAD_SCHEMATIC/" + this.getWorldName() + "/" + this.getId());
        if (!this.root.exists()) {
            this.root = FileUtils.getFile(PlotSquared.platform().getDirectory(), "schematics/GEN_ROAD_SCHEMATIC/" + this.getWorldName());
        }
        if (!(schematic1File = new File(this.root, "sideroad.schem")).exists()) {
            schematic1File = new File(this.root, "sideroad.schematic");
        }
        if (!(schematic2File = new File(this.root, "intersection.schem")).exists()) {
            schematic2File = new File(this.root, "intersection.schematic");
        }
        if (!(schematic3File = new File(this.root, "plot.schem")).exists()) {
            schematic3File = new File(this.root, "plot.schematic");
        }
        Schematic schematic1 = this.schematicHandler.getSchematic(schematic1File);
        Schematic schematic2 = this.schematicHandler.getSchematic(schematic2File);
        Schematic schematic3 = this.schematicHandler.getSchematic(schematic3File);
        if (schematic3 != null && !schematic3.getClipboard().getEntities().isEmpty()) {
            this.schem3Entities = new ArrayList<Entity>(schematic3.getClipboard().getEntities());
            this.schem3MinPoint = schematic3.getClipboard().getMinimumPoint();
            this.schem3PopulationNeeded = true;
        }
        int shift = this.ROAD_WIDTH / 2;
        int oddshift = this.ROAD_WIDTH & 1;
        this.SCHEM_Y = this.schematicStartHeight();
        int plotY = this.PLOT_HEIGHT - this.SCHEM_Y;
        int minRoadWall = Settings.Schematics.USE_WALL_IN_ROAD_SCHEM_HEIGHT ? Math.min(this.ROAD_HEIGHT, this.WALL_HEIGHT) : this.ROAD_HEIGHT;
        int roadY = minRoadWall - this.SCHEM_Y;
        int worldHeight = this.getMaxGenHeight() - this.getMinGenHeight() + 1;
        if (schematic3 != null) {
            if (schematic3.getClipboard().getDimensions().getY() == worldHeight) {
                plotY = 0;
                this.SCHEM_Y = 0;
            } else if (!Settings.Schematics.PASTE_ON_TOP) {
                this.SCHEM_Y = plotY = this.getMinBuildHeight() - this.getMinGenHeight();
            }
        }
        if (schematic1 != null) {
            if (schematic1.getClipboard().getDimensions().getY() == worldHeight) {
                this.SCHEM_Y = roadY = this.getMinGenHeight();
                if (schematic3 != null && schematic3.getClipboard().getDimensions().getY() != worldHeight && !Settings.Schematics.PASTE_ON_TOP) {
                    plotY = this.PLOT_HEIGHT;
                }
            } else if (!Settings.Schematics.PASTE_ROAD_ON_TOP) {
                this.SCHEM_Y = roadY = this.getMinBuildHeight();
                if (schematic3 != null && schematic3.getClipboard().getDimensions().getY() != worldHeight && !Settings.Schematics.PASTE_ON_TOP) {
                    plotY = this.PLOT_HEIGHT;
                }
            }
        }
        if (schematic3 != null) {
            this.PLOT_SCHEMATIC = true;
            Clipboard blockArrayClipboard3 = schematic3.getClipboard();
            BlockVector3 d3 = blockArrayClipboard3.getDimensions();
            short w3 = (short)d3.getX();
            short l3 = (short)d3.getZ();
            short h3 = (short)d3.getY();
            if (w3 > this.PLOT_WIDTH || h3 > this.PLOT_WIDTH) {
                this.ROAD_SCHEMATIC_ENABLED = true;
            }
            int centerShiftZ = l3 < this.PLOT_WIDTH ? (this.PLOT_WIDTH - l3) / 2 : (this.PLOT_WIDTH - l3) / 2;
            int centerShiftX = w3 < this.PLOT_WIDTH ? (this.PLOT_WIDTH - w3) / 2 : (this.PLOT_WIDTH - w3) / 2;
            BlockVector3 min = blockArrayClipboard3.getMinimumPoint();
            for (short x = 0; x < w3; x = (short)(x + 1)) {
                for (short z = 0; z < l3; z = (short)(z + 1)) {
                    for (short y = 0; y < h3; y = (short)(y + 1)) {
                        BaseBlock id = blockArrayClipboard3.getFullBlock(BlockVector3.at((int)(x + min.getBlockX()), (int)(y + min.getBlockY()), (int)(z + min.getBlockZ())));
                        if (id.getBlockType().getMaterial().isAir()) continue;
                        this.schem3PopulationNeeded |= id.hasNbtData();
                        this.addOverlayBlock((short)(x + shift + oddshift + centerShiftX), (short)(y + plotY), (short)(z + shift + oddshift + centerShiftZ), id, false, h3);
                    }
                    if (!blockArrayClipboard3.hasBiomes()) continue;
                    BiomeType biome = blockArrayClipboard3.getBiome(BlockVector2.at((int)(x + min.getBlockX()), (int)(z + min.getBlockZ())));
                    this.addOverlayBiome((short)(x + shift + oddshift + centerShiftX), (short)(z + shift + oddshift + centerShiftZ), biome);
                }
            }
            if (Settings.DEBUG) {
                LOGGER.info("- plot schematic: {}", (Object)schematic3File.getPath());
            }
        }
        if (schematic1 == null && schematic2 == null || this.ROAD_WIDTH == 0) {
            if (Settings.DEBUG) {
                LOGGER.info("- schematic: false");
            }
            return;
        }
        this.ROAD_SCHEMATIC_ENABLED = true;
        Clipboard blockArrayClipboard1 = schematic1.getClipboard();
        BlockVector3 d1 = blockArrayClipboard1.getDimensions();
        short w1 = (short)d1.getX();
        short l1 = (short)d1.getZ();
        short h1 = (short)d1.getY();
        if (!Settings.Schematics.USE_WALL_IN_ROAD_SCHEM_HEIGHT) {
            h1 = (short)(h1 + Math.max(this.ROAD_HEIGHT - this.WALL_HEIGHT, 0));
        }
        BlockVector3 min = blockArrayClipboard1.getMinimumPoint();
        for (short x = 0; x < w1; x = (short)(x + 1)) {
            for (short z = 0; z < l1; z = (short)(z + 1)) {
                for (short y = 0; y < h1; y = (short)(y + 1)) {
                    BaseBlock id = blockArrayClipboard1.getFullBlock(BlockVector3.at((int)(x + min.getBlockX()), (int)(y + min.getBlockY()), (int)(z + min.getBlockZ())));
                    if (id.getBlockType().getMaterial().isAir()) continue;
                    this.schem1PopulationNeeded |= id.hasNbtData();
                    this.addOverlayBlock((short)(x - shift), (short)(y + roadY), (short)(z + shift + oddshift), id, false, h1);
                    this.addOverlayBlock((short)(z + shift + oddshift), (short)(y + roadY), (short)(shift - x + (oddshift - 1)), id, true, h1);
                }
                if (!blockArrayClipboard1.hasBiomes()) continue;
                BiomeType biome = blockArrayClipboard1.getBiome(BlockVector2.at((int)(x + min.getBlockX()), (int)(z + min.getBlockZ())));
                this.addOverlayBiome((short)(x - shift), (short)(z + shift + oddshift), biome);
                this.addOverlayBiome((short)(z + shift + oddshift), (short)(shift - x + (oddshift - 1)), biome);
            }
        }
        Clipboard blockArrayClipboard2 = schematic2.getClipboard();
        BlockVector3 d2 = blockArrayClipboard2.getDimensions();
        short w2 = (short)d2.getX();
        short l2 = (short)d2.getZ();
        short h2 = (short)d2.getY();
        if (!Settings.Schematics.USE_WALL_IN_ROAD_SCHEM_HEIGHT) {
            h2 = (short)(h2 + Math.max(this.ROAD_HEIGHT - this.WALL_HEIGHT, 0));
        }
        min = blockArrayClipboard2.getMinimumPoint();
        for (short x = 0; x < w2; x = (short)(x + 1)) {
            for (short z = 0; z < l2; z = (short)(z + 1)) {
                for (short y = 0; y < h2; y = (short)(y + 1)) {
                    BaseBlock id = blockArrayClipboard2.getFullBlock(BlockVector3.at((int)(x + min.getBlockX()), (int)(y + min.getBlockY()), (int)(z + min.getBlockZ())));
                    if (id.getBlockType().getMaterial().isAir()) continue;
                    this.schem2PopulationNeeded |= id.hasNbtData();
                    this.addOverlayBlock((short)(x - shift), (short)(y + roadY), (short)(z - shift), id, false, h2);
                }
                if (!blockArrayClipboard2.hasBiomes()) continue;
                BiomeType biome = blockArrayClipboard2.getBiome(BlockVector2.at((int)(x + min.getBlockX()), (int)(z + min.getBlockZ())));
                this.addOverlayBiome((short)(x - shift), (short)(z - shift), biome);
            }
        }
    }

    public void addOverlayBlock(short x, short y, short z, BaseBlock id, boolean rotate, int height) {
        if (z < 0) {
            z = (short)(z + this.SIZE);
        } else if (z >= this.SIZE) {
            z = (short)(z - this.SIZE);
        }
        if (x < 0) {
            x = (short)(x + this.SIZE);
        } else if (x >= this.SIZE) {
            x = (short)(x - this.SIZE);
        }
        if (rotate) {
            id = HybridPlotWorld.rotate(id);
        }
        int pair = MathMan.pair(x, z);
        BaseBlock[] existing = this.G_SCH.computeIfAbsent(pair, k -> new BaseBlock[height]);
        if (y >= height) {
            if (y > this.lastOverlayHeightError) {
                this.lastOverlayHeightError = y;
                LOGGER.error(String.format("Error adding overlay block. `y > height`. y=%s, height=%s", y, height));
            }
            return;
        }
        existing[y] = id;
    }

    public void addOverlayBiome(short x, short z, BiomeType id) {
        if (z < 0) {
            z = (short)(z + this.SIZE);
        } else if (z >= this.SIZE) {
            z = (short)(z - this.SIZE);
        }
        if (x < 0) {
            x = (short)(x + this.SIZE);
        } else if (x >= this.SIZE) {
            x = (short)(x - this.SIZE);
        }
        int pair = MathMan.pair(x, z);
        this.G_SCH_B.put(pair, id);
    }

    @DoNotUse
    public @Nullable List<Entity> getPlotSchematicEntities() {
        return this.schem3Entities;
    }

    @DoNotUse
    public @Nullable BlockVector3 getPlotSchematicMinPoint() {
        return this.schem3MinPoint;
    }

    @DoNotUse
    public boolean populationNeeded() {
        return this.schem1PopulationNeeded || this.schem2PopulationNeeded || this.schem3PopulationNeeded;
    }

    @Deprecated(forRemoval=true, since="6.9.0")
    public File getRoot() {
        return this.root;
    }

    public @Nullable File getSchematicRoot() {
        return this.root;
    }
}

