/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.google.common.collect.Sets;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Template;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.ClassicPlotManager;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.FileBytes;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.WorldUtil;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HybridPlotManager
extends ClassicPlotManager {
    public static boolean REGENERATIVE_CLEAR = true;
    private final HybridPlotWorld hybridPlotWorld;
    private final RegionManager regionManager;
    private final ProgressSubscriberFactory subscriberFactory;

    public HybridPlotManager(@NonNull HybridPlotWorld hybridPlotWorld, @NonNull RegionManager regionManager, @NonNull ProgressSubscriberFactory subscriberFactory) {
        super(hybridPlotWorld, regionManager);
        this.hybridPlotWorld = hybridPlotWorld;
        this.regionManager = regionManager;
        this.subscriberFactory = subscriberFactory;
    }

    @Override
    public void exportTemplate() throws IOException {
        HashSet files = Sets.newHashSet((Object[])new FileBytes[]{new FileBytes(Settings.Paths.TEMPLATES + "/tmp-data.yml", Template.getBytes(this.hybridPlotWorld))});
        String dir = Settings.Paths.SCHEMATICS + File.separator + "GEN_ROAD_SCHEMATIC" + File.separator + this.hybridPlotWorld.getWorldName() + File.separator;
        try {
            File plot;
            File intersection;
            File sideRoad = FileUtils.getFile(PlotSquared.platform().getDirectory(), dir + "sideroad.schem");
            String newDir = Settings.Paths.SCHEMATICS + File.separator + "GEN_ROAD_SCHEMATIC" + File.separator + "__TEMP_DIR__" + File.separator;
            if (sideRoad.exists()) {
                files.add(new FileBytes(newDir + "sideroad.schem", Files.readAllBytes(sideRoad.toPath())));
            }
            if ((intersection = FileUtils.getFile(PlotSquared.platform().getDirectory(), dir + "intersection.schem")).exists()) {
                files.add(new FileBytes(newDir + "intersection.schem", Files.readAllBytes(intersection.toPath())));
            }
            if ((plot = FileUtils.getFile(PlotSquared.platform().getDirectory(), dir + "plot.schem")).exists()) {
                files.add(new FileBytes(newDir + "plot.schem", Files.readAllBytes(plot.toPath())));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Template.zipAll(this.hybridPlotWorld.getWorldName(), files);
    }

    @Override
    public boolean createRoadEast(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        boolean enqueue = false;
        if (queue == null) {
            queue = this.hybridPlotWorld.getQueue();
            enqueue = true;
        }
        super.createRoadEast(plot, queue);
        PlotId id = plot.getId();
        PlotId id2 = PlotId.of(id.getX() + 1, id.getY());
        Location bot = this.getPlotBottomLocAbs(id2);
        Location top = this.getPlotTopLocAbs(id);
        Location pos1 = Location.at(this.hybridPlotWorld.getWorldName(), top.getX() + 1, this.hybridPlotWorld.getMinGenHeight(), bot.getZ() - 1);
        Location pos2 = Location.at(this.hybridPlotWorld.getWorldName(), bot.getX(), this.hybridPlotWorld.getMaxGenHeight(), top.getZ() + 1);
        this.resetBiome(this.hybridPlotWorld, pos1, pos2);
        if (!this.hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
            return true;
        }
        this.createSchemAbs(queue, pos1, pos2, true);
        return !enqueue || queue.enqueue();
    }

    private void resetBiome(@NonNull HybridPlotWorld hybridPlotWorld, @NonNull Location pos1, @NonNull Location pos2) {
        BiomeType biome = hybridPlotWorld.getPlotBiome();
        if (!Objects.equals(PlotSquared.platform().worldUtil().getBiomeSynchronous(hybridPlotWorld.getWorldName(), (pos1.getX() + pos2.getX()) / 2, (pos1.getZ() + pos2.getZ()) / 2), biome)) {
            WorldUtil.setBiome(hybridPlotWorld.getWorldName(), new CuboidRegion(pos1.getBlockVector3(), pos2.getBlockVector3()), biome);
        }
    }

    private void createSchemAbs(@NonNull QueueCoordinator queue, @NonNull Location pos1, @NonNull Location pos2, boolean isRoad) {
        short size = this.hybridPlotWorld.SIZE;
        int minY = isRoad && Settings.Schematics.PASTE_ROAD_ON_TOP || !isRoad && Settings.Schematics.PASTE_ON_TOP ? this.hybridPlotWorld.SCHEM_Y : this.hybridPlotWorld.getMinBuildHeight();
        BaseBlock airBlock = BlockTypes.AIR.getDefaultState().toBaseBlock();
        for (int x = pos1.getX(); x <= pos2.getX(); ++x) {
            short absX = (short)((x - this.hybridPlotWorld.ROAD_OFFSET_X) % size);
            if (absX < 0) {
                absX = (short)(absX + size);
            }
            for (int z = pos1.getZ(); z <= pos2.getZ(); ++z) {
                BiomeType biome;
                BaseBlock[] blocks;
                short absZ = (short)((z - this.hybridPlotWorld.ROAD_OFFSET_Z) % size);
                if (absZ < 0) {
                    absZ = (short)(absZ + size);
                }
                if ((blocks = this.hybridPlotWorld.G_SCH.get(MathMan.pair(absX, absZ))) != null) {
                    for (int y = 0; y < blocks.length; ++y) {
                        if (blocks[y] != null) {
                            queue.setBlock(x, minY + y, z, blocks[y]);
                            continue;
                        }
                        queue.setBlock(x, minY + y, z, airBlock);
                    }
                }
                if ((biome = this.hybridPlotWorld.G_SCH_B.get(MathMan.pair(absX, absZ))) != null) {
                    queue.setBiome(x, z, biome);
                    continue;
                }
                queue.setBiome(x, z, this.hybridPlotWorld.getPlotBiome());
            }
        }
    }

    @Override
    public boolean createRoadSouth(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        boolean enqueue = false;
        if (queue == null) {
            enqueue = true;
            queue = this.hybridPlotWorld.getQueue();
        }
        super.createRoadSouth(plot, queue);
        PlotId id = plot.getId();
        PlotId id2 = PlotId.of(id.getX(), id.getY() + 1);
        Location bot = this.getPlotBottomLocAbs(id2);
        Location top = this.getPlotTopLocAbs(id);
        Location pos1 = Location.at(this.hybridPlotWorld.getWorldName(), bot.getX() - 1, this.hybridPlotWorld.getMinGenHeight(), top.getZ() + 1);
        Location pos2 = Location.at(this.hybridPlotWorld.getWorldName(), top.getX() + 1, this.hybridPlotWorld.getMaxGenHeight(), bot.getZ());
        this.resetBiome(this.hybridPlotWorld, pos1, pos2);
        if (!this.hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
            return true;
        }
        this.createSchemAbs(queue, pos1, pos2, true);
        return !enqueue || queue.enqueue();
    }

    @Override
    public boolean createRoadSouthEast(@NonNull Plot plot, @Nullable QueueCoordinator queue) {
        boolean enqueue = false;
        if (queue == null) {
            enqueue = true;
            queue = this.hybridPlotWorld.getQueue();
        }
        super.createRoadSouthEast(plot, queue);
        PlotId id = plot.getId();
        PlotId id2 = PlotId.of(id.getX() + 1, id.getY() + 1);
        Location pos1 = this.getPlotTopLocAbs(id).add(1, 0, 1);
        Location pos2 = this.getPlotBottomLocAbs(id2);
        this.createSchemAbs(queue, pos1, pos2, true);
        if (this.hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
            this.createSchemAbs(queue, pos1, pos2, true);
        }
        return !enqueue || queue.enqueue();
    }

    @Override
    public boolean clearPlot(@NonNull Plot plot, @Nullable Runnable whenDone, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        if (this.regionManager.notifyClear(this) && this.regionManager.handleClear(plot, whenDone, this, actor)) {
            return true;
        }
        Location pos1 = plot.getBottomAbs();
        Location pos2 = plot.getExtendedTopAbs();
        boolean canRegen = this.hybridPlotWorld.getType() == PlotAreaType.AUGMENTED && this.hybridPlotWorld.getTerrain() != PlotAreaTerrainType.NONE && REGENERATIVE_CLEAR;
        Pattern plotfloor = this.hybridPlotWorld.TOP_BLOCK.toPattern();
        Pattern filling = this.hybridPlotWorld.MAIN_BLOCK.toPattern();
        Object bedrock = this.hybridPlotWorld.PLOT_BEDROCK ? BlockTypes.BEDROCK.getDefaultState() : this.hybridPlotWorld.MAIN_BLOCK.toPattern();
        BiomeType biome = this.hybridPlotWorld.getPlotBiome();
        boolean enqueue = false;
        if (queue == null) {
            enqueue = true;
            queue = this.hybridPlotWorld.getQueue();
        }
        if (actor != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            queue.addProgressSubscriber(this.subscriberFactory.createWithActor(actor));
        }
        if (whenDone != null) {
            queue.setCompleteTask(whenDone);
        }
        if (!canRegen) {
            queue.setCuboid(pos1.withY(this.hybridPlotWorld.getMinGenHeight()), pos2.withY(this.hybridPlotWorld.getMinGenHeight()), (Pattern)(this.hybridPlotWorld.PLOT_BEDROCK ? bedrock : filling));
            queue.setCuboid(pos1.withY(this.hybridPlotWorld.getMinGenHeight() + 1), pos2.withY(this.hybridPlotWorld.PLOT_HEIGHT - 1), filling);
            queue.setCuboid(pos1.withY(this.hybridPlotWorld.PLOT_HEIGHT), pos2.withY(this.hybridPlotWorld.PLOT_HEIGHT), plotfloor);
            queue.setCuboid(pos1.withY(this.hybridPlotWorld.PLOT_HEIGHT + 1), pos2.withY(this.hybridPlotWorld.getMaxGenHeight()), BlockTypes.AIR.getDefaultState());
            queue.setBiomeCuboid(pos1, pos2, biome);
        } else {
            queue.setRegenRegion(new CuboidRegion(pos1.getBlockVector3(), pos2.getBlockVector3()));
        }
        this.pastePlotSchematic(queue, pos1, pos2);
        return !enqueue || queue.enqueue();
    }

    public void pastePlotSchematic(@NonNull QueueCoordinator queue, @NonNull Location bottom, @NonNull Location top) {
        if (!this.hybridPlotWorld.PLOT_SCHEMATIC) {
            return;
        }
        this.createSchemAbs(queue, bottom, top, false);
    }

    @Override
    public Location getSignLoc(@NonNull Plot plot) {
        return this.hybridPlotWorld.getSignLocation(plot);
    }

    public HybridPlotWorld getHybridPlotWorld() {
        return this.hybridPlotWorld;
    }
}

