/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="createroadschematic", aliases={"crs"}, category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.PLAYER, permission="plots.createroadschematic", usage="/plot createroadschematic")
public class CreateRoadSchematic
extends SubCommand {
    private final HybridUtils hybridUtils;

    @Inject
    public CreateRoadSchematic(@NonNull HybridUtils hybridUtils) {
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
            return false;
        }
        if (!(location.getPlotArea() instanceof HybridPlotWorld)) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot_world"), new Template[0]);
        }
        this.hybridUtils.setupRoadSchematic(plot);
        player.sendMessage(TranslatableCaption.of("schematics.schematic_road_created"), Template.of((String)"command", (String)"/plot debugroadregen"));
        return true;
    }
}

