/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core;

import cloud.commandframework.services.ServicePipeline;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.intellectualsites.annotations.DoNotUse;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.annotations.DefaultGenerator;
import com.plotsquared.core.location.World;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.util.ChunkManager;
import com.plotsquared.core.util.EconHandler;
import com.plotsquared.core.util.PlatformWorldManager;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.placeholders.PlaceholderRegistry;
import java.io.File;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface PlotPlatform<P>
extends LocaleHolder {
    public @NonNull File getDirectory();

    public @NonNull File worldContainer();

    public void shutdown();

    public void shutdownServer();

    default public @NonNull String pluginName() {
        return "PlotSquared";
    }

    public int[] serverVersion();

    public int versionMinHeight();

    public int versionMaxHeight();

    public @NonNull String serverImplementation();

    public @NonNull String serverNativePackage();

    public void startMetrics();

    public void setGenerator(@NonNull String var1);

    public void unregister(@NonNull PlotPlayer<?> var1);

    public @Nullable GeneratorWrapper<?> getGenerator(@NonNull String var1, @Nullable String var2);

    public @NonNull GeneratorWrapper<?> wrapPlotGenerator(@NonNull String var1, @NonNull IndependentPlotGenerator var2);

    default public @NonNull IndependentPlotGenerator defaultGenerator() {
        return (IndependentPlotGenerator)this.injector().getInstance(Key.get(IndependentPlotGenerator.class, DefaultGenerator.class));
    }

    default public @NonNull BackupManager backupManager() {
        return (BackupManager)this.injector().getInstance(BackupManager.class);
    }

    default public @NonNull PlatformWorldManager<?> worldManager() {
        return (PlatformWorldManager)this.injector().getInstance(PlatformWorldManager.class);
    }

    default public @NonNull PlayerManager<? extends PlotPlayer<P>, ? extends P> playerManager() {
        return (PlayerManager)this.injector().getInstance(Key.get((TypeLiteral)new TypeLiteral<PlayerManager<? extends PlotPlayer<P>, ? extends P>>(){}));
    }

    public @Nullable World<?> getPlatformWorld(@NonNull String var1);

    public @NonNull Injector injector();

    default public @NonNull WorldUtil worldUtil() {
        return (WorldUtil)this.injector().getInstance(WorldUtil.class);
    }

    default public @NonNull GlobalBlockQueue globalBlockQueue() {
        return (GlobalBlockQueue)this.injector().getInstance(GlobalBlockQueue.class);
    }

    default public @NonNull HybridUtils hybridUtils() {
        return (HybridUtils)this.injector().getInstance(HybridUtils.class);
    }

    default public @NonNull SetupUtils setupUtils() {
        return (SetupUtils)this.injector().getInstance(SetupUtils.class);
    }

    default public @NonNull EconHandler econHandler() {
        return (EconHandler)this.injector().getInstance(EconHandler.class);
    }

    default public @NonNull RegionManager regionManager() {
        return (RegionManager)this.injector().getInstance(RegionManager.class);
    }

    default public @NonNull ChunkManager chunkManager() {
        return (ChunkManager)this.injector().getInstance(ChunkManager.class);
    }

    public @NonNull PlotAreaManager plotAreaManager();

    public @NonNull Audience consoleAudience();

    public @NonNull String pluginsFormatted();

    @DoNotUse
    public @NonNull String worldEditImplementations();

    public void copyCaptionMaps();

    default public @NonNull PermissionHandler permissionHandler() {
        return (PermissionHandler)this.injector().getInstance(PermissionHandler.class);
    }

    default public @NonNull ServicePipeline servicePipeline() {
        return (ServicePipeline)this.injector().getInstance(ServicePipeline.class);
    }

    default public @NonNull PlaceholderRegistry placeholderRegistry() {
        return (PlaceholderRegistry)this.injector().getInstance(PlaceholderRegistry.class);
    }

    public @NonNull String toLegacyPlatformString(@NonNull Component var1);

    default public boolean isFaweHooking() {
        return false;
    }
}

