/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.player;

import com.google.common.base.Charsets;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotWeather;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.MathMan;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import io.papermc.lib.PaperLib;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Sound;
import org.bukkit.WeatherType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.RegisteredListener;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitPlayer
extends PlotPlayer<Player> {
    private static boolean CHECK_EFFECTIVE = true;
    public final Player player;
    private String name;

    public BukkitPlayer(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull Player player, @NonNull PermissionHandler permissionHandler) {
        this(plotAreaManager, eventDispatcher, player, false, permissionHandler);
    }

    public BukkitPlayer(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull Player player, boolean realPlayer, @NonNull PermissionHandler permissionHandler) {
        super(plotAreaManager, eventDispatcher, permissionHandler);
        this.player = player;
        this.setupPermissionProfile();
        if (realPlayer) {
            super.populatePersistentMetaMap();
        }
    }

    public Actor toActor() {
        return BukkitAdapter.adapt((Player)this.player);
    }

    public Player getPlatformPlayer() {
        return this.player;
    }

    public @NonNull UUID getUUID() {
        if (Settings.UUID.OFFLINE) {
            if (Settings.UUID.FORCE_LOWERCASE) {
                return UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName().toLowerCase()).getBytes(Charsets.UTF_8));
            }
            return UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName()).getBytes(Charsets.UTF_8));
        }
        return this.player.getUniqueId();
    }

    public @NonNegative long getLastPlayed() {
        return this.player.getLastSeen();
    }

    public boolean canTeleport(@NonNull Location location) {
        org.bukkit.Location to = BukkitUtil.adapt(location);
        org.bukkit.Location from = this.player.getLocation();
        PlayerTeleportEvent event = new PlayerTeleportEvent(this.player, from, to);
        this.callEvent((Event)event);
        if (event.isCancelled() || !event.getTo().equals((Object)to)) {
            return false;
        }
        event = new PlayerTeleportEvent(this.player, to, from);
        this.callEvent((Event)event);
        return true;
    }

    private void callEvent(@NonNull Event event) {
        RegisteredListener[] listeners;
        for (RegisteredListener listener : listeners = event.getHandlers().getRegisteredListeners()) {
            if (listener.getPlugin().getName().equals(PlotSquared.platform().pluginName())) continue;
            try {
                listener.callEvent(event);
            }
            catch (EventException e) {
                e.printStackTrace();
            }
        }
    }

    public @NonNegative int hasPermissionRange(@NonNull String stub, @NonNegative int range) {
        if (this.hasPermission(Permission.PERMISSION_ADMIN.toString())) {
            return Integer.MAX_VALUE;
        }
        String[] nodes = stub.split("\\.");
        StringBuilder n = new StringBuilder();
        for (int i = 0; i < nodes.length - 1; ++i) {
            n.append(nodes[i]).append(".");
            if (stub.equals(n + Permission.PERMISSION_STAR.toString()) || !this.hasPermission(n + Permission.PERMISSION_STAR.toString())) continue;
            return Integer.MAX_VALUE;
        }
        if (this.hasPermission(stub + ".*")) {
            return Integer.MAX_VALUE;
        }
        int max = 0;
        if (CHECK_EFFECTIVE) {
            boolean hasAny = false;
            String stubPlus = stub + ".";
            Set effective = this.player.getEffectivePermissions();
            if (!effective.isEmpty()) {
                String permStr;
                for (PermissionAttachmentInfo attach : effective) {
                    permStr = attach.getPermission();
                    if (!permStr.startsWith(stubPlus)) continue;
                    hasAny = true;
                    String end = permStr.substring(stubPlus.length());
                    if (!MathMan.isInteger((String)end)) continue;
                    int val = Integer.parseInt(end);
                    if (val > range) {
                        return val;
                    }
                    if (val <= max) continue;
                    max = val;
                }
                if (hasAny) {
                    return max;
                }
                for (PermissionAttachmentInfo attach : effective) {
                    permStr = attach.getPermission();
                    if (!permStr.startsWith("plots.") || permStr.equals("plots.use")) continue;
                    return max;
                }
                CHECK_EFFECTIVE = false;
            }
        }
        for (int i = range; i > 0; --i) {
            if (!this.hasPermission(stub + "." + i)) continue;
            return i;
        }
        return max;
    }

    public void teleport(@NonNull Location location, @NonNull TeleportCause cause) {
        if (Math.abs(location.getX()) >= 30000000 || Math.abs(location.getZ()) >= 30000000) {
            return;
        }
        org.bukkit.Location bukkitLocation = new org.bukkit.Location(BukkitUtil.getWorld(location.getWorldName()), (double)location.getX() + 0.5, (double)location.getY(), (double)location.getZ() + 0.5, location.getYaw(), location.getPitch());
        PaperLib.teleportAsync((Entity)this.player, (org.bukkit.Location)bukkitLocation, (PlayerTeleportEvent.TeleportCause)this.getTeleportCause(cause));
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.player.getName();
        }
        return this.name;
    }

    public void setCompassTarget(Location location) {
        this.player.setCompassTarget(new org.bukkit.Location(BukkitUtil.getWorld(location.getWorldName()), (double)location.getX(), (double)location.getY(), (double)location.getZ()));
    }

    public Location getLocationFull() {
        return BukkitUtil.adaptComplete(this.player.getLocation());
    }

    public void setWeather(@NonNull PlotWeather weather) {
        switch (weather) {
            case CLEAR: {
                this.player.setPlayerWeather(WeatherType.CLEAR);
                break;
            }
            case RAIN: {
                this.player.setPlayerWeather(WeatherType.DOWNFALL);
                break;
            }
            case WORLD: {
                this.player.resetPlayerWeather();
                break;
            }
        }
    }

    public GameMode getGameMode() {
        return switch (this.player.getGameMode()) {
            case org.bukkit.GameMode.ADVENTURE -> GameModes.ADVENTURE;
            case org.bukkit.GameMode.CREATIVE -> GameModes.CREATIVE;
            case org.bukkit.GameMode.SPECTATOR -> GameModes.SPECTATOR;
            default -> GameModes.SURVIVAL;
        };
    }

    public void setGameMode(GameMode gameMode) {
        if (GameModes.ADVENTURE.equals((Object)gameMode)) {
            this.player.setGameMode(org.bukkit.GameMode.ADVENTURE);
        } else if (GameModes.CREATIVE.equals((Object)gameMode)) {
            this.player.setGameMode(org.bukkit.GameMode.CREATIVE);
        } else if (GameModes.SPECTATOR.equals((Object)gameMode)) {
            this.player.setGameMode(org.bukkit.GameMode.SPECTATOR);
        } else {
            this.player.setGameMode(org.bukkit.GameMode.SURVIVAL);
        }
    }

    public void setTime(long time) {
        if (time != Long.MAX_VALUE) {
            this.player.setPlayerTime(time, false);
        } else {
            this.player.resetPlayerTime();
        }
    }

    public boolean getFlight() {
        return this.player.getAllowFlight();
    }

    public void setFlight(boolean fly) {
        this.player.setAllowFlight(fly);
    }

    public void playMusic(@NonNull Location location, @NonNull ItemType id) {
        if (id == ItemTypes.AIR) {
            for (Sound sound2 : Arrays.stream(Sound.values()).filter(sound -> sound.name().contains("DISC")).toList()) {
                this.player.stopSound(sound2);
            }
        } else {
            this.player.playSound(BukkitUtil.adapt(location), Sound.valueOf((String)BukkitAdapter.adapt((ItemType)id).name()), Float.MAX_VALUE, 1.0f);
        }
    }

    public void kick(String message) {
        this.player.kickPlayer(message);
    }

    public void stopSpectating() {
        if (this.getGameMode() == GameModes.SPECTATOR) {
            this.player.setSpectatorTarget(null);
        }
    }

    public boolean isBanned() {
        return this.player.isBanned();
    }

    public @NonNull Audience getAudience() {
        return BukkitUtil.BUKKIT_AUDIENCES.player(this.player);
    }

    public boolean canSee(PlotPlayer<?> other) {
        if (other instanceof ConsolePlayer) {
            return true;
        }
        return this.player.canSee(((BukkitPlayer)other).getPlatformPlayer());
    }

    public PlayerTeleportEvent.TeleportCause getTeleportCause(@NonNull TeleportCause cause) {
        if (TeleportCause.CauseSets.COMMAND.contains(cause)) {
            return PlayerTeleportEvent.TeleportCause.COMMAND;
        }
        if (cause == TeleportCause.UNKNOWN) {
            return PlayerTeleportEvent.TeleportCause.UNKNOWN;
        }
        return PlayerTeleportEvent.TeleportCause.PLUGIN;
    }
}

