/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.permissions;

import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.core.permissions.ConsolePermissionProfile;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.permissions.PermissionProfile;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BukkitPermissionHandler
implements PermissionHandler {
    public void initialize() {
    }

    public @NonNull Optional<PermissionProfile> getPermissionProfile(@NonNull PlotPlayer<?> playerPlotPlayer) {
        if (playerPlotPlayer instanceof BukkitPlayer) {
            BukkitPlayer bukkitPlayer = (BukkitPlayer)playerPlotPlayer;
            return Optional.of(new BukkitPermissionProfile(bukkitPlayer.getPlatformPlayer()));
        }
        if (playerPlotPlayer instanceof ConsolePlayer) {
            return Optional.of(ConsolePermissionProfile.INSTANCE);
        }
        return Optional.empty();
    }

    public @NonNull Optional<PermissionProfile> getPermissionProfile(@NonNull OfflinePlotPlayer offlinePlotPlayer) {
        return Optional.empty();
    }

    public @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    PermissionHandler.PermissionHandlerCapability> getCapabilities() {
        return EnumSet.of(PermissionHandler.PermissionHandlerCapability.ONLINE_PERMISSIONS);
    }

    private static final class BukkitPermissionProfile
    implements PermissionProfile {
        private final WeakReference<Player> playerReference;

        private BukkitPermissionProfile(@NonNull Player player) {
            this.playerReference = new WeakReference<Player>(player);
        }

        public boolean hasPermission(@Nullable String world, @NonNull String permission) {
            Player player = (Player)this.playerReference.get();
            return player != null && player.hasPermission(permission);
        }

        public boolean hasKeyedPermission(@Nullable String world, @NonNull String stub, @NonNull String key) {
            Player player = (Player)this.playerReference.get();
            return player != null && (player.hasPermission(stub + "." + key) || player.hasPermission(stub + ".*"));
        }
    }
}

