/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.destroystokyo.paper.MaterialTags;
import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.plotsquared.bukkit.listener.EntitySpawnListener;
import com.plotsquared.bukkit.listener.ForceFieldListener;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitEntityUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.bukkit.util.UpdateUtility;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.listener.PlayerBlockEventType;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotInventory;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.flag.implementations.AnimalInteractFlag;
import com.plotsquared.core.plot.flag.implementations.BlockedCmdsFlag;
import com.plotsquared.core.plot.flag.implementations.ChatFlag;
import com.plotsquared.core.plot.flag.implementations.DenyPortalTravelFlag;
import com.plotsquared.core.plot.flag.implementations.DenyPortalsFlag;
import com.plotsquared.core.plot.flag.implementations.DenyTeleportFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.DropProtectionFlag;
import com.plotsquared.core.plot.flag.implementations.HangingBreakFlag;
import com.plotsquared.core.plot.flag.implementations.HangingPlaceFlag;
import com.plotsquared.core.plot.flag.implementations.HostileInteractFlag;
import com.plotsquared.core.plot.flag.implementations.ItemDropFlag;
import com.plotsquared.core.plot.flag.implementations.KeepInventoryFlag;
import com.plotsquared.core.plot.flag.implementations.LecternReadBookFlag;
import com.plotsquared.core.plot.flag.implementations.MiscInteractFlag;
import com.plotsquared.core.plot.flag.implementations.PlayerInteractFlag;
import com.plotsquared.core.plot.flag.implementations.PreventCreativeCopyFlag;
import com.plotsquared.core.plot.flag.implementations.TamedInteractFlag;
import com.plotsquared.core.plot.flag.implementations.UntrustedVisitFlag;
import com.plotsquared.core.plot.flag.implementations.VehicleBreakFlag;
import com.plotsquared.core.plot.flag.implementations.VehicleUseFlag;
import com.plotsquared.core.plot.flag.implementations.VillagerInteractFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PremiumVerification;
import com.plotsquared.core.util.entity.EntityCategories;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.block.BlockType;
import io.papermc.lib.PaperLib;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.Template;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlayerEventListener
extends PlotListener
implements Listener {
    private final EventDispatcher eventDispatcher;
    private final WorldEdit worldEdit;
    private final PlotAreaManager plotAreaManager;
    private boolean tmpTeleport = true;
    private Field fieldPlayer;
    private PlayerMoveEvent moveTmp;
    private String internalVersion;

    @Inject
    public PlayerEventListener(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull WorldEdit worldEdit) {
        super(eventDispatcher);
        try {
            this.fieldPlayer = PlayerEvent.class.getDeclaredField("player");
            this.fieldPlayer.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        this.eventDispatcher = eventDispatcher;
        this.worldEdit = worldEdit;
        this.plotAreaManager = plotAreaManager;
    }

    @EventHandler
    public void onVehicleEntityCollision(VehicleEntityCollisionEvent e) {
        Location location;
        if (e.getVehicle().getType() == EntityType.BOAT && (location = BukkitUtil.adapt(e.getEntity().getLocation())).isPlotArea()) {
            if (e.getEntity() instanceof Player) {
                BukkitPlayer player = BukkitUtil.adapt((Player)e.getEntity());
                Plot plot = player.getCurrentPlot();
                if (plot != null) {
                    if (!plot.isAdded(player.getUUID())) {
                        e.setCancelled(true);
                    }
                } else {
                    e.setCancelled(true);
                }
            } else {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void playerCommand(PlayerCommandPreprocessEvent event) {
        List blockedCommands;
        String msg = event.getMessage().replace("/", "").toLowerCase(Locale.ROOT).trim();
        if (msg.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
        Location location = plotPlayer.getLocation();
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        String[] parts = msg.split(" ");
        Plot plot = plotPlayer.getCurrentPlot();
        switch (parts[0]) {
            case "up": 
            case "worldedit:up": {
                if (plot != null && (plot.isAdded(plotPlayer.getUUID()) || Permissions.hasPermission((PlotPlayer)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER, (boolean)true))) break;
                event.setCancelled(true);
                return;
            }
        }
        if (plot == null && !area.isRoadFlags()) {
            return;
        }
        List list = blockedCommands = plot != null ? (List)plot.getFlag(BlockedCmdsFlag.class) : (List)area.getFlag(BlockedCmdsFlag.class);
        if (blockedCommands.isEmpty()) {
            return;
        }
        if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_INTERACT_BLOCKED_CMDS)) {
            return;
        }
        String part = parts[0];
        if (part.contains(":")) {
            String[] namespaced = part.split(":");
            part = namespaced[1];
            msg = msg.substring(namespaced[0].length() + 1);
        }
        msg = this.replaceAliases(msg, part);
        for (String blocked : blockedCommands) {
            if (!blocked.equalsIgnoreCase(msg)) continue;
            String perm = plot != null && plot.isAdded(plotPlayer.getUUID()) ? "plots.admin.command.blocked-cmds.shared" : "plots.admin.command.blocked-cmds.road";
            if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (String)perm)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"blockedcmds.command_blocked"), new Template[0]);
                event.setCancelled(true);
            }
            return;
        }
    }

    private String replaceAliases(String msg, String part) {
        HelpTopic cmdLabel;
        String s1 = part;
        HashSet<String> aliases = new HashSet<String>();
        Iterator iterator = Bukkit.getServer().getHelpMap().getHelpTopics().iterator();
        block0: while (iterator.hasNext() && !part.equals((cmdLabel = (HelpTopic)iterator.next()).getName())) {
            PluginCommand p;
            String label = cmdLabel.getName().replaceFirst("/", "");
            if (aliases.contains(label) || (p = Bukkit.getPluginCommand((String)label)) == null) continue;
            for (String a : p.getAliases()) {
                if (aliases.contains(a)) continue;
                aliases.add(a);
                if ((a = a.replaceFirst("/", "")).equals(label) || !a.equals(part)) continue;
                part = label;
                continue block0;
            }
        }
        if (!s1.equals(part)) {
            msg = msg.replace(s1, part);
        }
        return msg;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPreLogin(AsyncPlayerPreLoginEvent event) {
        UUID uuid = Settings.UUID.OFFLINE ? (Settings.UUID.FORCE_LOWERCASE ? UUID.nameUUIDFromBytes(("OfflinePlayer:" + event.getName().toLowerCase()).getBytes(Charsets.UTF_8)) : UUID.nameUUIDFromBytes(("OfflinePlayer:" + event.getName()).getBytes(Charsets.UTF_8))) : event.getUniqueId();
        PlotSquared.get().getImpromptuUUIDPipeline().storeImmediately(event.getName(), uuid);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onConnect(PlayerJoinEvent event) {
        Plot plot;
        Player player = event.getPlayer();
        PlotSquared.platform().playerManager().removePlayer(player.getUniqueId());
        BukkitPlayer pp = BukkitUtil.adapt(player);
        pp.setLocale(Locale.forLanguageTag(player.getLocale().substring(0, 2)));
        Location location = pp.getLocation();
        PlotArea area = location.getPlotArea();
        if (area != null && (plot = area.getPlot(location)) != null) {
            this.plotEntry(pp, plot);
        }
        TaskManager.runTaskLaterAsync(() -> {
            if (!player.hasPlayedBefore() && player.isOnline()) {
                player.saveData();
            }
            this.eventDispatcher.doJoinTask(pp);
        }, (TaskTime)TaskTime.seconds((long)1L));
        if (pp.hasPermission(Permission.PERMISSION_ADMIN_UPDATE_NOTIFICATION.toString()) && Settings.Enabled_Components.UPDATE_NOTIFICATIONS && PremiumVerification.isPremium().booleanValue() && UpdateUtility.hasUpdate) {
            TranslatableCaption boundary = TranslatableCaption.of((String)"update.update_boundary");
            TranslatableCaption updateNotification = TranslatableCaption.of((String)"update.update_notification");
            Template internalVersion = Template.of((String)"p2version", (String)UpdateUtility.internalVersion.versionString());
            Template spigotVersion = Template.of((String)"spigotversion", (String)UpdateUtility.spigotVersion);
            Template downloadUrl = Template.of((String)"downloadurl", (String)"https://www.spigotmc.org/resources/77506/updates");
            pp.sendMessage((Caption)boundary, new Template[0]);
            pp.sendMessage((Caption)updateNotification, new Template[]{internalVersion, spigotVersion, downloadUrl});
            pp.sendMessage((Caption)boundary, new Template[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        BukkitPlayer pp = BukkitUtil.adapt(player);
        this.eventDispatcher.doRespawnTask((PlotPlayer)pp);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent event) {
        block17: {
            Player player = event.getPlayer();
            if (!player.isOnline()) {
                return;
            }
            BukkitPlayer pp = BukkitUtil.adapt(player);
            try (MetaDataAccess lastPlotAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                boolean result;
                Plot lastPlot = lastPlotAccess.get().orElse(null);
                org.bukkit.Location to = event.getTo();
                if (to == null) break block17;
                Location location = BukkitUtil.adapt(to);
                PlotArea area = location.getPlotArea();
                if (area == null) {
                    if (lastPlot != null) {
                        this.plotExit(pp, lastPlot);
                        lastPlotAccess.remove();
                    }
                    try (MetaDataAccess lastLocationAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);){
                        lastLocationAccess.remove();
                    }
                    return;
                }
                Plot plot = area.getPlot(location);
                if (!(plot == null || (result = DenyTeleportFlag.allowsTeleport((PlotPlayer)pp, (Plot)plot)) || ((Boolean)plot.getFlag(UntrustedVisitFlag.class)).booleanValue() && plot.getHomeSynchronous().equals((Object)BukkitUtil.adaptComplete(to)))) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"deny.no_enter"), new Template[]{Template.of((String)"plot", (String)plot.toString())});
                    event.setCancelled(true);
                }
            }
        }
        this.playerMove((PlayerMoveEvent)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void vehicleMove(VehicleMoveEvent event) throws IllegalAccessException {
        Vehicle vehicle;
        int toZ;
        org.bukkit.Location from = event.getFrom();
        org.bukkit.Location to = event.getTo();
        int toX = MathMan.roundInt((double)to.getX());
        if (toX != MathMan.roundInt((double)from.getX()) | (toZ = MathMan.roundInt((double)to.getZ())) != MathMan.roundInt((double)from.getZ()) && !(vehicle = event.getVehicle()).getPassengers().isEmpty()) {
            com.sk89q.worldedit.world.entity.EntityType entityType;
            Entity passenger = (Entity)vehicle.getPassengers().get(0);
            if (passenger instanceof Player) {
                Player player = (Player)passenger;
                if (this.moveTmp == null) {
                    this.moveTmp = new PlayerMoveEvent(null, from, to);
                }
                this.moveTmp.setFrom(from);
                this.moveTmp.setTo(to);
                this.moveTmp.setCancelled(false);
                this.fieldPlayer.set(this.moveTmp, player);
                List passengers = vehicle.getPassengers();
                this.playerMove(this.moveTmp);
                Object dest = this.moveTmp.isCancelled() ? from : (MathMan.roundInt((double)this.moveTmp.getTo().getX()) != toX || MathMan.roundInt((double)this.moveTmp.getTo().getZ()) != toZ ? to : null);
                if (dest != null) {
                    vehicle.eject();
                    vehicle.setVelocity(new Vector(0.0, 0.0, 0.0));
                    PaperLib.teleportAsync((Entity)vehicle, (org.bukkit.Location)dest);
                    passengers.forEach(arg_0 -> ((Vehicle)vehicle).addPassenger(arg_0));
                    return;
                }
            }
            if (Settings.Enabled_Components.KILL_ROAD_VEHICLES && EntityCategories.VEHICLE.contains((Keyed)(entityType = BukkitAdapter.adapt((EntityType)vehicle.getType()))) && !EntityCategories.ANIMAL.contains((Keyed)entityType)) {
                List meta = vehicle.getMetadata("plot");
                Plot toPlot = BukkitUtil.adapt(to).getPlot();
                if (!meta.isEmpty()) {
                    Plot origin = (Plot)((MetadataValue)meta.get(0)).value();
                    if (origin != null && !origin.getBasePlot(false).equals((Object)toPlot)) {
                        vehicle.remove();
                    }
                } else if (toPlot != null) {
                    vehicle.setMetadata("plot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)toPlot));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerMove(PlayerMoveEvent event) {
        org.bukkit.Location from = event.getFrom();
        org.bukkit.Location to = event.getTo();
        int x2 = MathMan.roundInt((double)to.getX());
        if (MathMan.roundInt((double)from.getX()) != x2) {
            PlotArea area;
            BukkitPlayer pp;
            Player player;
            block93: {
                Plot lastPlot;
                player = event.getPlayer();
                pp = BukkitUtil.adapt(player);
                if (TaskManager.removeFromTeleportQueue((String)pp.getName())) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"teleport.teleport_failed"), new Template[0]);
                }
                Location location = BukkitUtil.adapt(to);
                try (MetaDataAccess lastLocationAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);){
                    lastLocationAccess.remove();
                }
                area = location.getPlotArea();
                if (area == null) {
                    try (MetaDataAccess lastPlotAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                        lastPlotAccess.remove();
                    }
                    return;
                }
                Plot now = area.getPlot(location);
                try (MetaDataAccess lastPlotAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                    lastPlot = lastPlotAccess.get().orElse(null);
                }
                if (now == null) {
                    try (MetaDataAccess kickAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_KICK);){
                        if (lastPlot != null && !this.plotExit(pp, lastPlot) && this.tmpTeleport && !kickAccess.get().orElse(false).booleanValue()) {
                            pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_EXIT_DENIED))});
                            this.tmpTeleport = false;
                            if (lastPlot.equals((Object)BukkitUtil.adapt(from).getPlot())) {
                                player.teleport(from);
                            } else {
                                player.teleport(player.getWorld().getSpawnLocation());
                            }
                            this.tmpTeleport = true;
                            event.setCancelled(true);
                            return;
                        }
                        break block93;
                    }
                }
                if (now.equals((Object)lastPlot)) {
                    ForceFieldListener.handleForcefield(player, pp, now);
                } else if (!this.plotEntry(pp, now) && this.tmpTeleport) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"deny.no_enter"), new Template[]{Template.of((String)"plot", (String)now.toString())});
                    this.tmpTeleport = false;
                    to.setX((double)from.getBlockX());
                    to.setY((double)from.getBlockY());
                    to.setZ((double)from.getBlockZ());
                    player.teleport(event.getTo());
                    this.tmpTeleport = true;
                    return;
                }
            }
            int border = area.getBorder();
            if (x2 > border && this.tmpTeleport) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    to.setX((double)(border - 1));
                    this.tmpTeleport = false;
                    player.teleport(event.getTo());
                    this.tmpTeleport = true;
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.denied"), new Template[0]);
                } else if (MathMan.roundInt((double)from.getX()) <= border) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.bypass.exited"), new Template[0]);
                }
            } else if (x2 < -border && this.tmpTeleport) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    to.setX((double)(-border + 1));
                    this.tmpTeleport = false;
                    player.teleport(event.getTo());
                    this.tmpTeleport = true;
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.denied"), new Template[0]);
                } else if (MathMan.roundInt((double)from.getX()) >= -border) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.bypass.exited"), new Template[0]);
                }
            } else {
                int x1 = MathMan.roundInt((double)from.getX());
                if ((x1 >= border && x2 <= border || x1 <= -border && x2 >= -border) && Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.bypass.entered"), new Template[0]);
                }
            }
        }
        int z2 = MathMan.roundInt((double)to.getZ());
        if (MathMan.roundInt((double)from.getZ()) != z2) {
            PlotArea area;
            BukkitPlayer pp;
            Player player;
            block97: {
                Plot lastPlot;
                player = event.getPlayer();
                pp = BukkitUtil.adapt(player);
                if (TaskManager.removeFromTeleportQueue((String)pp.getName())) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"teleport.teleport_failed"), new Template[0]);
                }
                Location location = BukkitUtil.adapt(to);
                try (MetaDataAccess lastLocationAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);){
                    lastLocationAccess.set((Object)location);
                }
                area = location.getPlotArea();
                if (area == null) {
                    try (MetaDataAccess lastPlotAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                        lastPlotAccess.remove();
                    }
                    return;
                }
                Plot plot = area.getPlot(location);
                try (MetaDataAccess lastPlotAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
                    lastPlot = lastPlotAccess.get().orElse(null);
                }
                if (plot == null) {
                    try (MetaDataAccess kickAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_KICK);){
                        if (lastPlot != null && !this.plotExit(pp, lastPlot) && this.tmpTeleport && !kickAccess.get().orElse(false).booleanValue()) {
                            pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_EXIT_DENIED))});
                            this.tmpTeleport = false;
                            if (lastPlot.equals((Object)BukkitUtil.adapt(from).getPlot())) {
                                player.teleport(from);
                            } else {
                                player.teleport(player.getWorld().getSpawnLocation());
                            }
                            this.tmpTeleport = true;
                            event.setCancelled(true);
                            return;
                        }
                        break block97;
                    }
                }
                if (plot.equals((Object)lastPlot)) {
                    ForceFieldListener.handleForcefield(player, pp, plot);
                } else if (!this.plotEntry(pp, plot) && this.tmpTeleport) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"deny.no_enter"), new Template[]{Template.of((String)"plot", (String)plot.toString())});
                    this.tmpTeleport = false;
                    player.teleport(from);
                    to.setX((double)from.getBlockX());
                    to.setY((double)from.getBlockY());
                    to.setZ((double)from.getBlockZ());
                    player.teleport(event.getTo());
                    this.tmpTeleport = true;
                    return;
                }
            }
            int border = area.getBorder();
            if (z2 > border && this.tmpTeleport) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    to.setZ((double)(border - 1));
                    this.tmpTeleport = false;
                    player.teleport(event.getTo());
                    this.tmpTeleport = true;
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.denied"), new Template[0]);
                } else if (MathMan.roundInt((double)from.getZ()) <= border) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.bypass.exited"), new Template[0]);
                }
            } else if (z2 < -border && this.tmpTeleport) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    to.setZ((double)(-border + 1));
                    this.tmpTeleport = false;
                    player.teleport(event.getTo());
                    this.tmpTeleport = true;
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.denied"), new Template[0]);
                } else if (MathMan.roundInt((double)from.getZ()) >= -border) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.bypass.exited"), new Template[0]);
                }
            } else {
                int z1 = MathMan.roundInt((double)from.getZ());
                if ((z1 >= border && z2 <= border || z1 <= -border && z2 >= -border) && Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BYPASS_BORDER)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"border.bypass.entered"), new Template[0]);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onChat(AsyncPlayerChatEvent event) {
        Template spymessageTemplate;
        Template spysenderTemplate;
        Template plotidTemplate;
        TranslatableCaption spymsg;
        if (event.isCancelled()) {
            return;
        }
        BukkitPlayer plotPlayer = BukkitUtil.adapt(event.getPlayer());
        Location location = plotPlayer.getLocation();
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getPlot(location);
        if (plot == null) {
            return;
        }
        if (!(((Boolean)plot.getFlag(ChatFlag.class)).booleanValue() && area.isPlotChat() && plotPlayer.getAttribute("chat") || area.isForcingPlotChat())) {
            return;
        }
        if (plot.isDenied(plotPlayer.getUUID()) && !Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_CHAT_BYPASS)) {
            return;
        }
        event.setCancelled(true);
        Set recipients = event.getRecipients();
        recipients.clear();
        HashSet<PlotPlayer> spies = new HashSet<PlotPlayer>();
        HashSet<PlotPlayer> plotRecipients = new HashSet<PlotPlayer>();
        for (PlotPlayer pp : PlotSquared.platform().playerManager().getPlayers()) {
            if (pp.getAttribute("chatspy")) {
                spies.add(pp);
                continue;
            }
            Plot current = pp.getCurrentPlot();
            if (current == null || !current.getBasePlot(false).equals((Object)plot)) continue;
            plotRecipients.add(pp);
        }
        String message = event.getMessage();
        String sender = event.getPlayer().getDisplayName();
        PlotId id = plot.getId();
        String worldName = plot.getWorldName();
        TranslatableCaption msg = TranslatableCaption.of((String)"chat.plot_chat_format");
        Template worldNameTemplate = Template.of((String)"world", (String)worldName);
        Template plotTemplate = Template.of((String)"plot_id", (String)id.toString());
        Template senderTemplate = Template.of((String)"sender", (String)sender);
        Template msgTemplate = plotPlayer.hasPermission("plots.chat.color") ? Template.of((String)"msg", (Component)BukkitUtil.LEGACY_COMPONENT_SERIALIZER.deserialize(ChatColor.translateAlternateColorCodes((char)'&', (String)message))) : Template.of((String)"msg", (Component)BukkitUtil.MINI_MESSAGE.deserialize((Object)ChatColor.stripColor((String)BukkitUtil.LEGACY_COMPONENT_SERIALIZER.serialize((Component)Component.text((String)message)))));
        for (PlotPlayer receiver : plotRecipients) {
            receiver.sendMessage((Caption)msg, new Template[]{worldNameTemplate, msgTemplate, plotTemplate, senderTemplate});
        }
        if (!spies.isEmpty()) {
            spymsg = TranslatableCaption.of((String)"chat.plot_chat_spy_format");
            plotidTemplate = Template.of((String)"plot_id", (String)(id.getX() + ";" + id.getY()));
            spysenderTemplate = Template.of((String)"sender", (String)sender);
            spymessageTemplate = Template.of((String)"msg", (Component)Component.text((String)message));
            for (PlotPlayer player : spies) {
                player.sendMessage((Caption)spymsg, new Template[]{worldNameTemplate, plotidTemplate, spysenderTemplate, spymessageTemplate});
            }
        }
        if (Settings.Chat.LOG_PLOTCHAT_TO_CONSOLE) {
            spymsg = TranslatableCaption.of((String)"chat.plot_chat_spy_format");
            plotidTemplate = Template.of((String)"plot_id", (String)(id.getX() + ";" + id.getY()));
            spysenderTemplate = Template.of((String)"sender", (String)sender);
            spymessageTemplate = Template.of((String)"msg", (Component)Component.text((String)message));
            ConsolePlayer.getConsole().sendMessage((Caption)spymsg, new Template[]{worldNameTemplate, plotidTemplate, spysenderTemplate, spymessageTemplate});
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onWorldChanged(PlayerChangedWorldEvent event) {
        Plot plot;
        Player player = event.getPlayer();
        BukkitPlayer pp = BukkitUtil.adapt(player);
        try (MetaDataAccess lastPlotAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
            plot = (Plot)lastPlotAccess.remove();
        }
        try (MetaDataAccess lastLocationAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);){
            lastLocationAccess.remove();
        }
        if (plot != null) {
            this.plotExit(pp, plot);
        }
        if (this.worldEdit != null && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_WORLDEDIT_BYPASS) && pp.getAttribute("worldedit")) {
            pp.removeAttribute("worldedit");
        }
        Location location = pp.getLocation();
        PlotArea area = location.getPlotArea();
        if (location.isPlotArea() && (plot = location.getPlot()) != null) {
            this.plotEntry(pp, plot);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Location location;
        PlotArea area;
        Material itemType;
        Block block;
        BlockState state;
        Material stateType;
        List lore;
        List lore2;
        PlayerInventory inv;
        int slot;
        HumanEntity entity = event.getWhoClicked();
        if (!(entity instanceof Player) || !this.plotAreaManager.hasPlotArea(entity.getWorld().getName())) {
            return;
        }
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Player player = (Player)clicker;
        BukkitPlayer pp = BukkitUtil.adapt(player);
        PlotInventory inventory = PlotInventory.getOpenPlotInventory((PlotPlayer)pp);
        if (inventory != null && event.getRawSlot() == event.getSlot() && !inventory.onClick(event.getSlot())) {
            event.setResult(Event.Result.DENY);
            event.setCancelled(true);
            inventory.close();
        }
        if ((slot = (inv = player.getInventory()).getHeldItemSlot()) > 8 || !event.getEventName().equals("InventoryCreativeEvent")) {
            return;
        }
        ItemStack current = inv.getItemInHand();
        ItemStack newItem = event.getCursor();
        ItemMeta newMeta = newItem.getItemMeta();
        ItemMeta oldMeta = newItem.getItemMeta();
        if (event.getClick() == ClickType.CREATIVE) {
            Plot plot = pp.getCurrentPlot();
            if (plot != null) {
                if (((Boolean)plot.getFlag(PreventCreativeCopyFlag.class)).booleanValue() && !plot.isAdded(player.getUniqueId()) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                    ItemStack newStack = new ItemStack(newItem.getType(), newItem.getAmount());
                    event.setCursor(newStack);
                    plot.debug(player.getName() + " could not creative-copy an item because prevent-creative-copy = true");
                }
            } else {
                PlotArea area2 = pp.getPlotAreaAbs();
                if (area2 != null && area2.isRoadFlags() && ((Boolean)area2.getRoadFlag(PreventCreativeCopyFlag.class)).booleanValue()) {
                    ItemStack newStack = new ItemStack(newItem.getType(), newItem.getAmount());
                    event.setCursor(newStack);
                }
            }
            return;
        }
        String newLore = "";
        if (newMeta != null && (lore2 = newMeta.getLore()) != null) {
            newLore = lore2.toString();
        }
        String oldLore = "";
        if (oldMeta != null && (lore = oldMeta.getLore()) != null) {
            oldLore = lore.toString();
        }
        if (!"[(+NBT)]".equals(newLore) || current.equals((Object)newItem) && newLore.equals(oldLore)) {
            switch (newItem.getType()) {
                case LEGACY_BANNER: 
                case PLAYER_HEAD: {
                    if (newMeta != null) break;
                }
                default: {
                    return;
                }
            }
        }
        if ((stateType = (state = (block = player.getTargetBlock(null, 7)).getState()).getType()) != (itemType = newItem.getType())) {
            switch (stateType) {
                case LEGACY_STANDING_BANNER: 
                case LEGACY_WALL_BANNER: {
                    if (itemType == Material.LEGACY_BANNER) break;
                }
                case LEGACY_SKULL: {
                    if (itemType == Material.LEGACY_SKULL_ITEM) break;
                }
                default: {
                    return;
                }
            }
        }
        if ((area = (location = BukkitUtil.adapt(state.getLocation())).getPlotArea()) == null) {
            return;
        }
        Plot plot = area.getPlotAbs(location);
        boolean cancelled = false;
        if (plot == null) {
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_INTERACT_ROAD)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_INTERACT_ROAD))});
                cancelled = true;
            }
        } else if (!plot.hasOwner()) {
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED))});
                cancelled = true;
            }
        } else {
            UUID uuid = pp.getUUID();
            if (!plot.isAdded(uuid) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_INTERACT_OTHER))});
                cancelled = true;
            }
        }
        if (cancelled) {
            if (current.getType() == newItem.getType() && current.getDurability() == newItem.getDurability()) {
                event.setCursor(new ItemStack(newItem.getType(), newItem.getAmount(), newItem.getDurability()));
                event.setCancelled(true);
                return;
            }
            event.setCursor(new ItemStack(newItem.getType(), newItem.getAmount(), newItem.getDurability()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInteract(PlayerInteractAtEntityEvent e) {
        Entity entity = e.getRightClicked();
        if (!(entity instanceof ArmorStand) && !(entity instanceof ItemFrame)) {
            return;
        }
        Location location = BukkitUtil.adapt(e.getRightClicked().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        EntitySpawnListener.testNether(entity);
        Plot plot = location.getPlotAbs();
        BukkitPlayer pp = BukkitUtil.adapt(e.getPlayer());
        if (plot == null) {
            if (!(area.isRoadFlags() || ((Boolean)area.getRoadFlag(MiscInteractFlag.class)).booleanValue() || Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_INTERACT_ROAD))) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_INTERACT_ROAD))});
                e.setCancelled(true);
            }
        } else {
            if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"done.building_restricted"), new Template[0]);
                e.setCancelled(true);
                return;
            }
            if (!plot.hasOwner()) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (String)"plots.admin.interact.unowned")) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED))});
                    e.setCancelled(true);
                }
            } else {
                UUID uuid = pp.getUUID();
                if (plot.isAdded(uuid)) {
                    return;
                }
                if (((Boolean)plot.getFlag(MiscInteractFlag.class)).booleanValue()) {
                    return;
                }
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_INTERACT_OTHER))});
                    e.setCancelled(true);
                    plot.debug(pp.getName() + " could not interact with " + entity.getType() + " because misc-interact = false");
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onCancelledInteract(PlayerInteractEvent event) {
        if (event.isCancelled() && event.getAction() == Action.RIGHT_CLICK_AIR) {
            Location location;
            Block block;
            Material item;
            Player player = event.getPlayer();
            BukkitPlayer pp = BukkitUtil.adapt(player);
            PlotArea area = pp.getPlotAreaAbs();
            if (area == null) {
                return;
            }
            if (event.getAction() == Action.RIGHT_CLICK_AIR && (item = event.getMaterial()).toString().toLowerCase().endsWith("_egg")) {
                event.setCancelled(true);
                event.setUseItemInHand(Event.Result.DENY);
            }
            ItemStack hand = player.getInventory().getItemInMainHand();
            ItemStack offHand = player.getInventory().getItemInOffHand();
            Material type = hand.getType();
            Material offType = offHand.getType();
            if (type == Material.AIR) {
                type = offType;
            }
            if (type.toString().toLowerCase().endsWith("_egg") && (block = player.getTargetBlockExact(5, FluidCollisionMode.SOURCE_ONLY)) != null && block.getType() != Material.AIR && !this.eventDispatcher.checkPlayerBlockEvent((PlotPlayer)pp, PlayerBlockEventType.SPAWN_MOB, location = BukkitUtil.adapt(block.getLocation()), null, true)) {
                event.setCancelled(true);
                event.setUseItemInHand(Event.Result.DENY);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        BlockType blocktype1;
        PlayerBlockEventType eventType;
        Player player = event.getPlayer();
        BukkitPlayer pp = BukkitUtil.adapt(player);
        PlotArea area = pp.getPlotAreaAbs();
        if (area == null) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Location location = BukkitUtil.adapt(block.getLocation());
        Action action = event.getAction();
        switch (action) {
            case PHYSICAL: {
                eventType = PlayerBlockEventType.TRIGGER_PHYSICAL;
                blocktype1 = BukkitAdapter.asBlockType((Material)block.getType());
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                Material blockType = block.getType();
                eventType = PlayerBlockEventType.INTERACT_BLOCK;
                blocktype1 = BukkitAdapter.asBlockType((Material)block.getType());
                if (blockType.isInteractable()) {
                    if (!player.isSneaking()) break;
                    ItemStack hand = player.getInventory().getItemInMainHand();
                    ItemStack offHand = player.getInventory().getItemInOffHand();
                    if (hand.getType() == Material.AIR && offHand.getType() == Material.AIR) break;
                }
                Material type = event.getMaterial();
                switch (type.toString()) {
                    case "REDSTONE": 
                    case "STRING": 
                    case "PUMPKIN_SEEDS": 
                    case "MELON_SEEDS": 
                    case "COCOA_BEANS": 
                    case "WHEAT_SEEDS": 
                    case "BEETROOT_SEEDS": 
                    case "SWEET_BERRIES": 
                    case "GLOW_BERRIES": {
                        return;
                    }
                }
                if (type.isBlock()) {
                    return;
                }
                if (PaperLib.isPaper()) {
                    if (MaterialTags.SPAWN_EGGS.isTagged(type) || Material.EGG.equals((Object)type)) {
                        eventType = PlayerBlockEventType.SPAWN_MOB;
                        break;
                    }
                } else if (type.toString().toLowerCase().endsWith("egg")) {
                    eventType = PlayerBlockEventType.SPAWN_MOB;
                    break;
                }
                if (type.isEdible()) {
                    return;
                }
                switch (type) {
                    case ACACIA_BOAT: 
                    case BIRCH_BOAT: 
                    case CHEST_MINECART: 
                    case COMMAND_BLOCK_MINECART: 
                    case DARK_OAK_BOAT: 
                    case FURNACE_MINECART: 
                    case HOPPER_MINECART: 
                    case JUNGLE_BOAT: 
                    case MINECART: 
                    case OAK_BOAT: 
                    case SPRUCE_BOAT: 
                    case TNT_MINECART: {
                        eventType = PlayerBlockEventType.PLACE_VEHICLE;
                        break;
                    }
                    case FIREWORK_ROCKET: 
                    case FIREWORK_STAR: {
                        eventType = PlayerBlockEventType.SPAWN_MOB;
                        break;
                    }
                    case BOOK: 
                    case KNOWLEDGE_BOOK: 
                    case WRITABLE_BOOK: 
                    case WRITTEN_BOOK: {
                        eventType = PlayerBlockEventType.READ;
                        break;
                    }
                    case ARMOR_STAND: {
                        location = BukkitUtil.adapt(block.getRelative(event.getBlockFace()).getLocation());
                        eventType = PlayerBlockEventType.PLACE_MISC;
                    }
                }
                break;
            }
            case LEFT_CLICK_BLOCK: {
                Material blockType = block.getType();
                if (blockType != Material.DRAGON_EGG) {
                    return;
                }
                eventType = PlayerBlockEventType.INTERACT_BLOCK;
                blocktype1 = BukkitAdapter.asBlockType((Material)block.getType());
                break;
            }
            default: {
                return;
            }
        }
        if (this.worldEdit != null && pp.getAttribute("worldedit") && event.getMaterial() == Material.getMaterial((String)this.worldEdit.getConfiguration().wandItem)) {
            return;
        }
        if (!this.eventDispatcher.checkPlayerBlockEvent((PlotPlayer)pp, eventType, location, blocktype1, true)) {
            event.setCancelled(true);
            event.setUseInteractedBlock(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBoatPlace(EntityPlaceEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        Entity placed = event.getEntity();
        if (!(placed instanceof Boat)) {
            return;
        }
        BukkitPlayer pp = BukkitUtil.adapt(event.getPlayer());
        PlotArea area = pp.getPlotAreaAbs();
        if (area == null) {
            return;
        }
        PlayerBlockEventType eventType = PlayerBlockEventType.PLACE_VEHICLE;
        Block block = event.getBlock();
        BlockType blockType = BukkitAdapter.asBlockType((Material)block.getType());
        Location location = BukkitUtil.adapt(block.getLocation());
        if (!PlotSquared.get().getEventDispatcher().checkPlayerBlockEvent((PlotPlayer)pp, eventType, location, blockType, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Waterlogged waterlogged;
        BlockFace bf = event.getBlockFace();
        BlockData blockData = event.getBlockClicked().getBlockData();
        Block block = blockData instanceof Waterlogged && !(waterlogged = (Waterlogged)blockData).isWaterlogged() && event.getBucket() != Material.LAVA_BUCKET ? event.getBlockClicked() : event.getBlockClicked().getLocation().add((double)bf.getModX(), (double)bf.getModY(), (double)bf.getModZ()).getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        BukkitPlayer pp = BukkitUtil.adapt(event.getPlayer());
        Plot plot = area.getPlot(location);
        if (plot == null) {
            if (Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
                return;
            }
            pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_ROAD))});
            event.setCancelled(true);
        } else if (!plot.hasOwner()) {
            if (Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                return;
            }
            pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_UNOWNED))});
            event.setCancelled(true);
        } else if (!plot.isAdded(pp.getUUID())) {
            if (Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                return;
            }
            pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_OTHER))});
            event.setCancelled(true);
        } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
            pp.sendMessage((Caption)TranslatableCaption.of((String)"done.building_restricted"), new Template[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity closer = event.getPlayer();
        if (!(closer instanceof Player)) {
            return;
        }
        Player player = (Player)closer;
        PlotInventory.removePlotInventoryOpen((PlotPlayer)BukkitUtil.adapt(player));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLeave(PlayerQuitEvent event) {
        TaskManager.removeFromTeleportQueue((String)event.getPlayer().getName());
        BukkitPlayer pp = BukkitUtil.adapt(event.getPlayer());
        pp.unregister();
        this.logout(pp.getUUID());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBucketFill(PlayerBucketFillEvent event) {
        Block blockClicked = event.getBlockClicked();
        Location location = BukkitUtil.adapt(blockClicked.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Player player = event.getPlayer();
        BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
        Plot plot = area.getPlot(location);
        if (plot == null) {
            if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
                return;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_ROAD))});
            event.setCancelled(true);
        } else if (!plot.hasOwner()) {
            if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                return;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_UNOWNED))});
            event.setCancelled(true);
        } else if (!plot.isAdded(plotPlayer.getUUID())) {
            if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                return;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_OTHER))});
            event.setCancelled(true);
        } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot) && !Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"done.building_restricted"), new Template[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        Block block = event.getBlock().getRelative(event.getBlockFace());
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Player p = event.getPlayer();
        if (p == null) {
            event.setCancelled(true);
            return;
        }
        BukkitPlayer pp = BukkitUtil.adapt(p);
        Plot plot = area.getPlot(location);
        if (plot == null) {
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_ROAD))});
                event.setCancelled(true);
            }
        } else {
            if (!plot.hasOwner()) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_UNOWNED))});
                    event.setCancelled(true);
                }
                return;
            }
            if (!plot.isAdded(pp.getUUID()) && !((Boolean)plot.getFlag(HangingPlaceFlag.class)).booleanValue()) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_OTHER))});
                    event.setCancelled(true);
                }
                return;
            }
            if (BukkitEntityUtil.checkEntity((Entity)event.getEntity(), plot)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        Entity remover = event.getRemover();
        if (remover instanceof Player) {
            Player p = (Player)remover;
            Location location = BukkitUtil.adapt(event.getEntity().getLocation());
            PlotArea area = location.getPlotArea();
            if (area == null) {
                return;
            }
            BukkitPlayer pp = BukkitUtil.adapt(p);
            Plot plot = area.getPlot(location);
            if (plot == null) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_DESTROY_ROAD)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_ROAD))});
                    event.setCancelled(true);
                }
            } else if (!plot.hasOwner()) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_DESTROY_UNOWNED)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_UNOWNED))});
                    event.setCancelled(true);
                }
            } else if (!plot.isAdded(pp.getUUID())) {
                if (((Boolean)plot.getFlag(HangingBreakFlag.class)).booleanValue()) {
                    return;
                }
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_DESTROY_OTHER)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_OTHER))});
                    event.setCancelled(true);
                    plot.debug(p.getName() + " could not break hanging entity because hanging-break = false");
                }
            }
        } else if (remover instanceof Projectile) {
            Projectile p = (Projectile)remover;
            ProjectileSource area = p.getShooter();
            if (area instanceof Player) {
                Player shooter = (Player)area;
                Location location = BukkitUtil.adapt(event.getEntity().getLocation());
                PlotArea area2 = location.getPlotArea();
                if (area2 == null) {
                    return;
                }
                BukkitPlayer player = BukkitUtil.adapt(shooter);
                Plot plot = area2.getPlot(BukkitUtil.adapt(event.getEntity().getLocation()));
                if (plot != null) {
                    if (!plot.hasOwner()) {
                        if (!Permissions.hasPermission((PermissionHolder)player, (Permission)Permission.PERMISSION_ADMIN_DESTROY_UNOWNED)) {
                            player.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_UNOWNED))});
                            event.setCancelled(true);
                        }
                    } else if (!(plot.isAdded(player.getUUID()) || ((Boolean)plot.getFlag(HangingBreakFlag.class)).booleanValue() || Permissions.hasPermission((PermissionHolder)player, (Permission)Permission.PERMISSION_ADMIN_DESTROY_OTHER))) {
                        player.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_OTHER))});
                        event.setCancelled(true);
                        plot.debug(player.getName() + " could not break hanging entity because hanging-break = false");
                    }
                }
            }
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getRightClicked().getType() == EntityType.UNKNOWN) {
            return;
        }
        Location location = BukkitUtil.adapt(event.getRightClicked().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Player p = event.getPlayer();
        BukkitPlayer pp = BukkitUtil.adapt(p);
        Plot plot = area.getPlot(location);
        if (plot == null && !area.isRoadFlags()) {
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_INTERACT_ROAD)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_INTERACT_ROAD))});
                event.setCancelled(true);
            }
        } else if (plot != null && !plot.hasOwner()) {
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED))});
                event.setCancelled(true);
            }
        } else if (plot != null && !plot.isAdded(pp.getUUID()) || plot == null && area.isRoadFlags()) {
            Entity entity = event.getRightClicked();
            com.sk89q.worldedit.world.entity.EntityType entityType = BukkitAdapter.adapt((EntityType)entity.getType());
            FlagContainer flagContainer = plot == null ? area.getRoadFlagContainer() : plot.getFlagContainer();
            if (EntityCategories.HOSTILE.contains((Keyed)entityType) && ((Boolean)((HostileInteractFlag)flagContainer.getFlag(HostileInteractFlag.class)).getValue()).booleanValue()) {
                return;
            }
            if (EntityCategories.ANIMAL.contains((Keyed)entityType) && ((Boolean)((AnimalInteractFlag)flagContainer.getFlag(AnimalInteractFlag.class)).getValue()).booleanValue()) {
                return;
            }
            if (entity instanceof Tameable && ((Tameable)entity).isTamed() && ((Boolean)((TamedInteractFlag)flagContainer.getFlag(TamedInteractFlag.class)).getValue()).booleanValue()) {
                return;
            }
            if (EntityCategories.VEHICLE.contains((Keyed)entityType) && ((Boolean)((VehicleUseFlag)flagContainer.getFlag(VehicleUseFlag.class)).getValue()).booleanValue()) {
                return;
            }
            if (EntityCategories.PLAYER.contains((Keyed)entityType) && ((Boolean)((PlayerInteractFlag)flagContainer.getFlag(PlayerInteractFlag.class)).getValue()).booleanValue()) {
                return;
            }
            if (EntityCategories.VILLAGER.contains((Keyed)entityType) && ((Boolean)((VillagerInteractFlag)flagContainer.getFlag(VillagerInteractFlag.class)).getValue()).booleanValue()) {
                return;
            }
            if ((EntityCategories.HANGING.contains((Keyed)entityType) || EntityCategories.OTHER.contains((Keyed)entityType)) && ((Boolean)((MiscInteractFlag)flagContainer.getFlag(MiscInteractFlag.class)).getValue()).booleanValue()) {
                return;
            }
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_INTERACT_OTHER))});
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        Location location = BukkitUtil.adapt(event.getVehicle().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Entity attacker = event.getAttacker();
        if (attacker instanceof Player) {
            Player p = (Player)attacker;
            BukkitPlayer pp = BukkitUtil.adapt(p);
            Plot plot = area.getPlot(location);
            if (plot == null) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_ROAD)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_ROAD))});
                    event.setCancelled(true);
                }
            } else {
                if (!plot.hasOwner()) {
                    if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_UNOWNED)) {
                        pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_UNOWNED))});
                        event.setCancelled(true);
                        return;
                    }
                    return;
                }
                if (!plot.isAdded(pp.getUUID())) {
                    if (((Boolean)plot.getFlag(VehicleBreakFlag.class)).booleanValue()) {
                        return;
                    }
                    if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_OTHER)) {
                        pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_VEHICLE_OTHER))});
                        event.setCancelled(true);
                        plot.debug(pp.getName() + " could not break vehicle because vehicle-break = false");
                    }
                }
            }
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        BukkitPlayer pp = BukkitUtil.adapt(player);
        Location location = pp.getLocation();
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (area.isRoadFlags() && !((Boolean)area.getRoadFlag(ItemDropFlag.class)).booleanValue()) {
                event.setCancelled(true);
            }
            return;
        }
        UUID uuid = pp.getUUID();
        if (!plot.isAdded(uuid) && !((Boolean)plot.getFlag(ItemDropFlag.class)).booleanValue()) {
            plot.debug(player.getName() + " could not drop item because of item-drop = false");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        LivingEntity ent = event.getEntity();
        if (ent instanceof Player) {
            Player player = (Player)ent;
            BukkitPlayer pp = BukkitUtil.adapt(player);
            Location location = pp.getLocation();
            PlotArea area = location.getPlotArea();
            if (area == null) {
                return;
            }
            Plot plot = location.getOwnedPlot();
            if (plot == null) {
                if (area.isRoadFlags() && ((Boolean)area.getRoadFlag(DropProtectionFlag.class)).booleanValue()) {
                    event.setCancelled(true);
                }
                return;
            }
            UUID uuid = pp.getUUID();
            if (!plot.isAdded(uuid) && ((Boolean)plot.getFlag(DropProtectionFlag.class)).booleanValue()) {
                plot.debug(player.getName() + " could not pick up item because of drop-protection = true");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Location location = BukkitUtil.adapt(event.getEntity().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (area.isRoadFlags() && ((Boolean)area.getRoadFlag(KeepInventoryFlag.class)).booleanValue()) {
                event.setCancelled(true);
            }
            return;
        }
        if (((Boolean)plot.getFlag(KeepInventoryFlag.class)).booleanValue() && ((Boolean)plot.getFlag(KeepInventoryFlag.class)).booleanValue()) {
            plot.debug(event.getEntity().getName() + " kept their inventory because of keep-inventory = true");
            event.getDrops().clear();
            event.setKeepInventory(true);
        }
    }

    @EventHandler
    public void onLocaleChange(PlayerLocaleChangeEvent event) {
        if (!event.getPlayer().isOnline()) {
            return;
        }
        BukkitPlayer player = BukkitUtil.adapt(event.getPlayer());
        player.setLocale(Locale.forLanguageTag(event.getLocale().substring(0, 2)));
    }

    @EventHandler
    public void onPortalEnter(PlayerPortalEvent event) {
        Location location = BukkitUtil.adapt(event.getPlayer().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (area.isRoadFlags() && ((Boolean)area.getRoadFlag(DenyPortalTravelFlag.class)).booleanValue()) {
                event.setCancelled(true);
            }
            return;
        }
        if (((Boolean)plot.getFlag(DenyPortalTravelFlag.class)).booleanValue() && ((Boolean)plot.getFlag(DenyPortalTravelFlag.class)).booleanValue()) {
            plot.debug(event.getPlayer().getName() + " did not travel thru a portal because of deny-portal-travel = true");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPortalCreation(PortalCreateEvent event) {
        String world = event.getWorld().getName();
        if (PlotSquared.get().getPlotAreaManager().getPlotAreasSet(world).size() == 0) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockState state : event.getBlocks()) {
            minX = Math.min(state.getX(), minX);
            maxX = Math.max(state.getX(), maxX);
            minZ = Math.min(state.getZ(), minZ);
            maxZ = Math.max(state.getZ(), maxZ);
        }
        int y = ((BlockState)event.getBlocks().get(0)).getY();
        for (Location location : Set.of(Location.at((String)world, (int)minX, (int)y, (int)maxX), Location.at((String)world, (int)minZ, (int)y, (int)maxZ), Location.at((String)world, (int)minX, (int)y, (int)maxZ), Location.at((String)world, (int)minZ, (int)y, (int)maxX))) {
            PlotArea area = location.getPlotArea();
            if (area == null) continue;
            Plot plot = location.getOwnedPlot();
            if (plot == null) {
                if (!area.isRoadFlags() || !((Boolean)area.getRoadFlag(DenyPortalsFlag.class)).booleanValue()) continue;
                event.setCancelled(true);
                return;
            }
            if (!((Boolean)plot.getFlag(DenyPortalsFlag.class)).booleanValue()) continue;
            StringBuilder builder = new StringBuilder();
            if (event.getEntity() != null) {
                builder.append(event.getEntity().getName()).append(" did not create a portal");
            } else {
                builder.append("Portal creation cancelled");
            }
            plot.debug(builder.append(" because of deny-portals = true").toString());
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerTakeLecternBook(PlayerTakeLecternBookEvent event) {
        Location location = BukkitUtil.adapt(event.getPlayer().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (area.isRoadFlags() && ((Boolean)area.getRoadFlag(LecternReadBookFlag.class)).booleanValue()) {
                event.setCancelled(true);
            }
            return;
        }
        if (((Boolean)plot.getFlag(LecternReadBookFlag.class)).booleanValue() && ((Boolean)plot.getFlag(LecternReadBookFlag.class)).booleanValue()) {
            plot.debug(event.getPlayer().getName() + " could not take the book because of lectern-read-book = true");
            event.setCancelled(true);
        }
    }
}

