/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.util.BukkitEntityUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import io.papermc.lib.PaperLib;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class EntitySpawnListener
implements Listener {
    private static final String KEY = "P2";
    private static boolean ignoreTP = false;
    private static boolean hasPlotArea = false;
    private static String areaName = null;

    public static void testNether(Entity entity) {
        @NonNull World world = entity.getWorld();
        if (world.getEnvironment() != World.Environment.NETHER && world.getEnvironment() != World.Environment.THE_END) {
            return;
        }
        EntitySpawnListener.test(entity);
    }

    public static void testCreate(Entity entity) {
        @NonNull World world = entity.getWorld();
        if (!world.getName().equals(areaName)) {
            areaName = world.getName();
            hasPlotArea = PlotSquared.get().getPlotAreaManager().hasPlotArea(areaName);
        }
        if (!hasPlotArea) {
            return;
        }
        EntitySpawnListener.test(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(Entity entity) {
        @NonNull World world = entity.getWorld();
        List meta = entity.getMetadata(KEY);
        if (meta.isEmpty()) {
            if (PlotSquared.get().getPlotAreaManager().hasPlotArea(world.getName())) {
                entity.setMetadata(KEY, (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)entity.getLocation()));
            }
        } else {
            org.bukkit.Location origin = (org.bukkit.Location)((MetadataValue)meta.get(0)).value();
            World originWorld = origin.getWorld();
            if (!originWorld.equals(world)) {
                if (!ignoreTP) {
                    if (!world.getName().equalsIgnoreCase(originWorld + "_the_end")) {
                        if (entity.getType() == EntityType.PLAYER) {
                            return;
                        }
                        try {
                            ignoreTP = true;
                            PaperLib.teleportAsync((Entity)entity, (org.bukkit.Location)origin);
                        }
                        finally {
                            ignoreTP = false;
                        }
                        if (entity.getLocation().getWorld().equals(world)) {
                            entity.remove();
                        }
                    }
                } else {
                    if (entity.getType() == EntityType.PLAYER) {
                        return;
                    }
                    entity.remove();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void creatureSpawnEvent(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        Location location = BukkitUtil.adapt(entity.getLocation());
        PlotArea area = location.getPlotArea();
        if (!location.isPlotArea()) {
            return;
        }
        Plot plot = location.getOwnedPlotAbs();
        if (plot == null) {
            EntityType type = entity.getType();
            if (!area.isMobSpawning()) {
                switch (type) {
                    case DROPPED_ITEM: {
                        if (Settings.Enabled_Components.KILL_ROAD_ITEMS) {
                            event.setCancelled(true);
                            return;
                        }
                    }
                    case PLAYER: {
                        return;
                    }
                }
                if (type.isAlive()) {
                    event.setCancelled(true);
                }
            }
            if (!area.isMiscSpawnUnowned() && !type.isAlive()) {
                event.setCancelled(true);
            }
            return;
        }
        if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot)) {
            event.setCancelled(true);
        }
        switch (entity.getType()) {
            case ENDER_CRYSTAL: {
                if (BukkitEntityUtil.checkEntity(entity, plot)) {
                    event.setCancelled(true);
                }
            }
            case SHULKER: {
                if (entity.hasMetadata("shulkerPlot")) break;
                entity.setMetadata("shulkerPlot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)plot.getId()));
            }
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        @NonNull Chunk chunk = event.getChunk();
        for (Entity entity : chunk.getEntities()) {
            EntitySpawnListener.testCreate(entity);
        }
    }

    @EventHandler
    public void onVehicle(VehicleUpdateEvent event) {
        EntitySpawnListener.testNether((Entity)event.getVehicle());
    }

    @EventHandler
    public void onVehicle(VehicleCreateEvent event) {
        EntitySpawnListener.testCreate((Entity)event.getVehicle());
    }

    @EventHandler
    public void onVehicle(VehicleBlockCollisionEvent event) {
        EntitySpawnListener.testNether((Entity)event.getVehicle());
    }

    @EventHandler
    public void onTeleport(EntityTeleportEvent event) {
        Plot fromPlot;
        Entity entity = event.getEntity();
        Entity fromLocation = event.getEntity();
        Block toLocation = event.getTo().getBlock();
        Location fromLocLocation = BukkitUtil.adapt(fromLocation.getLocation());
        PlotArea fromArea = fromLocLocation.getPlotArea();
        Location toLocLocation = BukkitUtil.adapt(toLocation.getLocation());
        PlotArea toArea = toLocLocation.getPlotArea();
        if (toArea == null) {
            if (fromLocation.getType() == EntityType.SHULKER && fromArea != null) {
                event.setCancelled(true);
            }
            return;
        }
        Plot toPlot = toArea.getOwnedPlot(toLocLocation);
        if (!(fromLocation.getType() != EntityType.SHULKER || fromArea == null || (fromPlot = fromArea.getOwnedPlot(fromLocLocation)) == null && toPlot == null || fromPlot != null && fromPlot.equals((Object)toPlot) || toPlot != null && toPlot.equals((Object)fromPlot))) {
            event.setCancelled(true);
            return;
        }
        if (entity instanceof Vehicle || entity instanceof ArmorStand) {
            EntitySpawnListener.testNether(event.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void vehicleMove(VehicleMoveEvent event) {
        EntitySpawnListener.testNether((Entity)event.getVehicle());
    }

    @EventHandler
    public void spawn(CreatureSpawnEvent event) {
        if (event.getEntityType() == EntityType.ARMOR_STAND) {
            EntitySpawnListener.testCreate((Entity)event.getEntity());
        }
    }
}

