/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.AnimalAttackFlag;
import com.plotsquared.core.plot.flag.implementations.AnimalCapFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.EntityCapFlag;
import com.plotsquared.core.plot.flag.implementations.HangingBreakFlag;
import com.plotsquared.core.plot.flag.implementations.HostileAttackFlag;
import com.plotsquared.core.plot.flag.implementations.HostileCapFlag;
import com.plotsquared.core.plot.flag.implementations.MiscBreakFlag;
import com.plotsquared.core.plot.flag.implementations.MiscCapFlag;
import com.plotsquared.core.plot.flag.implementations.MobCapFlag;
import com.plotsquared.core.plot.flag.implementations.PveFlag;
import com.plotsquared.core.plot.flag.implementations.PvpFlag;
import com.plotsquared.core.plot.flag.implementations.TamedAttackFlag;
import com.plotsquared.core.plot.flag.implementations.VehicleCapFlag;
import com.plotsquared.core.util.EntityUtil;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.entity.EntityCategories;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.registry.Keyed;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.Template;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitEntityUtil {
    public static final com.sk89q.worldedit.world.entity.EntityType FAKE_ENTITY_TYPE = new com.sk89q.worldedit.world.entity.EntityType("plotsquared:fake");

    public static boolean entityDamage(Entity damager, Entity victim) {
        return BukkitEntityUtil.entityDamage(damager, victim, null);
    }

    public static boolean entityDamage(Entity damager, Entity victim, EntityDamageEvent.DamageCause cause) {
        Player player;
        PlotArea area;
        String stub;
        Plot plot;
        Location dloc = BukkitUtil.adapt(damager.getLocation());
        Location vloc = BukkitUtil.adapt(victim.getLocation());
        PlotArea dArea = dloc.getPlotArea();
        PlotArea vArea = dArea != null && dArea.contains(vloc.getX(), vloc.getZ()) ? dArea : vloc.getPlotArea();
        if (dArea == null && vArea == null) {
            return true;
        }
        Plot dplot = dArea != null ? dArea.getPlot(dloc) : null;
        Plot vplot = vArea != null ? vArea.getPlot(vloc) : null;
        boolean isPlot = true;
        if (dplot == null && vplot == null) {
            if (dArea == null) {
                return true;
            }
            plot = null;
            stub = "road";
            isPlot = false;
        } else {
            plot = victim.getTicksLived() > damager.getTicksLived() ? (dplot == null || !(victim instanceof Player) ? (vplot == null ? dplot : vplot) : dplot) : (dplot == null || !(victim instanceof Player) ? (vplot == null ? dplot : vplot) : (vplot == null ? dplot : vplot));
            stub = plot.hasOwner() ? "other" : "unowned";
        }
        boolean roadFlags = vArea != null ? vArea.isRoadFlags() : dArea.isRoadFlags();
        PlotArea plotArea = area = vArea != null ? vArea : dArea;
        if (damager instanceof Player) {
            player = (Player)damager;
        } else if (damager instanceof Projectile) {
            Projectile projectile = (Projectile)damager;
            ProjectileSource shooter = projectile.getShooter();
            if (shooter instanceof Player) {
                player = (Player)shooter;
            } else {
                if (shooter instanceof BlockProjectileSource) {
                    Location sLoc = BukkitUtil.adapt(((BlockProjectileSource)shooter).getBlock().getLocation());
                    dplot = dArea.getPlot(sLoc);
                }
                player = null;
            }
        } else {
            player = null;
        }
        if (player != null) {
            BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
            com.sk89q.worldedit.world.entity.EntityType entityType = victim.getType().getName() == null ? FAKE_ENTITY_TYPE : BukkitAdapter.adapt((EntityType)victim.getType());
            if (EntityCategories.HANGING.contains((Keyed)entityType)) {
                if (plot != null && (((Boolean)plot.getFlag(HangingBreakFlag.class)).booleanValue() || plot.isAdded(plotPlayer.getUUID()))) {
                    if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot) && !Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"done.building_restricted"), new Template[0]);
                        return false;
                    }
                    return true;
                }
                if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (String)(Permission.PERMISSION_ADMIN_DESTROY + "." + stub))) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)(Permission.PERMISSION_ADMIN_DESTROY + "." + stub))});
                    return false;
                }
            } else if (victim.getType() == EntityType.ARMOR_STAND) {
                if (plot != null && (((Boolean)plot.getFlag(MiscBreakFlag.class)).booleanValue() || plot.isAdded(plotPlayer.getUUID()))) {
                    return true;
                }
                if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (String)(Permission.PERMISSION_ADMIN_DESTROY + "." + stub))) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)(Permission.PERMISSION_ADMIN_DESTROY + "." + stub))});
                    if (plot != null) {
                        plot.debug(player.getName() + " could not break armor stand because misc-break = false");
                    }
                    return false;
                }
            } else if (EntityCategories.HOSTILE.contains((Keyed)entityType)) {
                if (isPlot ? (Boolean)plot.getFlag(HostileAttackFlag.class) != false || (Boolean)plot.getFlag(PveFlag.class) != false || plot.isAdded(plotPlayer.getUUID()) : roadFlags && ((Boolean)area.getRoadFlag(HostileAttackFlag.class) != false || (Boolean)area.getFlag(PveFlag.class) != false)) {
                    return true;
                }
                if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (String)(Permission.PERMISSION_ADMIN_PVE + "." + stub))) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)(Permission.PERMISSION_ADMIN_PVE + "." + stub))});
                    if (plot != null) {
                        plot.debug(player.getName() + " could not attack " + entityType + " because pve = false OR hostile-attack = false");
                    }
                    return false;
                }
            } else if (EntityCategories.TAMEABLE.contains((Keyed)entityType)) {
                if (isPlot ? (Boolean)plot.getFlag(TamedAttackFlag.class) != false || (Boolean)plot.getFlag(PveFlag.class) != false || plot.isAdded(plotPlayer.getUUID()) : roadFlags && ((Boolean)area.getRoadFlag(TamedAttackFlag.class) != false || (Boolean)area.getFlag(PveFlag.class) != false)) {
                    return true;
                }
                if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (String)(Permission.PERMISSION_ADMIN_PVE + "." + stub))) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)(Permission.PERMISSION_ADMIN_PVE + "." + stub))});
                    if (plot != null) {
                        plot.debug(player.getName() + " could not attack " + entityType + " because pve = false OR tamed-attack = false");
                    }
                    return false;
                }
            } else if (EntityCategories.PLAYER.contains((Keyed)entityType)) {
                if (isPlot) {
                    if (!((Boolean)plot.getFlag(PvpFlag.class)).booleanValue() && !Permissions.hasPermission((PermissionHolder)plotPlayer, (String)(Permission.PERMISSION_ADMIN_PVP + "." + stub))) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)(Permission.PERMISSION_ADMIN_PVP + "." + stub))});
                        plot.debug(player.getName() + " could not attack " + entityType + " because pve = false");
                        return false;
                    }
                    return true;
                }
                if (roadFlags && ((Boolean)area.getRoadFlag(PvpFlag.class)).booleanValue()) {
                    return true;
                }
                if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (String)(Permission.PERMISSION_ADMIN_PVP + "." + stub))) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)(Permission.PERMISSION_ADMIN_PVP + "." + stub))});
                    return false;
                }
            } else if (EntityCategories.ANIMAL.contains((Keyed)entityType)) {
                if (isPlot ? (Boolean)plot.getFlag(AnimalAttackFlag.class) != false || (Boolean)plot.getFlag(PveFlag.class) != false || plot.isAdded(plotPlayer.getUUID()) : roadFlags && ((Boolean)area.getRoadFlag(AnimalAttackFlag.class) != false || (Boolean)area.getFlag(PveFlag.class) != false)) {
                    return true;
                }
                if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (String)(Permission.PERMISSION_ADMIN_PVE + "." + stub))) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)(Permission.PERMISSION_ADMIN_PVE + "." + stub))});
                    if (plot != null) {
                        plot.debug(player.getName() + " could not attack " + entityType + " because pve = false OR animal-attack = false");
                    }
                    return false;
                }
            } else {
                if (EntityCategories.VEHICLE.contains((Keyed)entityType)) {
                    return true;
                }
                if (isPlot ? (Boolean)plot.getFlag(PveFlag.class) != false || plot.isAdded(plotPlayer.getUUID()) : roadFlags && (Boolean)area.getRoadFlag(PveFlag.class) != false) {
                    return true;
                }
                if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (String)(Permission.PERMISSION_ADMIN_PVE + "." + stub))) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)(Permission.PERMISSION_ADMIN_PVE + "." + stub))});
                    if (plot != null) {
                        plot.debug(player.getName() + " could not attack " + entityType + " because pve = false");
                    }
                    return false;
                }
            }
            return true;
        }
        if (dplot != null && (!dplot.equals((Object)vplot) || Objects.equals(dplot.getOwnerAbs(), vplot.getOwnerAbs()))) {
            return vplot != null && (Boolean)vplot.getFlag(PveFlag.class) != false;
        }
        if (vplot != null && EntityDamageEvent.DamageCause.ENTITY_EXPLOSION == cause && damager.getType() == EntityType.FIREWORK) {
            return false;
        }
        if (vplot == null && roadFlags && ((Boolean)area.getRoadFlag(PveFlag.class)).booleanValue()) {
            return true;
        }
        return vplot != null && (Boolean)vplot.getFlag(PveFlag.class) != false || !(damager instanceof Arrow) || victim instanceof Creature;
    }

    public static boolean checkEntity(Entity entity, Plot plot) {
        if (plot == null || !plot.hasOwner() || plot.getFlags().isEmpty() && plot.getArea().getFlagContainer().getFlagMap().isEmpty()) {
            return false;
        }
        com.sk89q.worldedit.world.entity.EntityType entityType = BukkitAdapter.adapt((EntityType)entity.getType());
        if (EntityCategories.PLAYER.contains((Keyed)entityType)) {
            return false;
        }
        if (EntityCategories.PROJECTILE.contains((Keyed)entityType) || EntityCategories.OTHER.contains((Keyed)entityType) || EntityCategories.HANGING.contains((Keyed)entityType)) {
            return EntityUtil.checkEntity((Plot)plot, (PlotFlag[])new PlotFlag[]{EntityCapFlag.ENTITY_CAP_UNLIMITED, MiscCapFlag.MISC_CAP_UNLIMITED});
        }
        if (EntityCategories.ANIMAL.contains((Keyed)entityType) || EntityCategories.VILLAGER.contains((Keyed)entityType) || EntityCategories.TAMEABLE.contains((Keyed)entityType)) {
            return EntityUtil.checkEntity((Plot)plot, (PlotFlag[])new PlotFlag[]{EntityCapFlag.ENTITY_CAP_UNLIMITED, MobCapFlag.MOB_CAP_UNLIMITED, AnimalCapFlag.ANIMAL_CAP_UNLIMITED});
        }
        if (EntityCategories.HOSTILE.contains((Keyed)entityType)) {
            return EntityUtil.checkEntity((Plot)plot, (PlotFlag[])new PlotFlag[]{EntityCapFlag.ENTITY_CAP_UNLIMITED, MobCapFlag.MOB_CAP_UNLIMITED, HostileCapFlag.HOSTILE_CAP_UNLIMITED});
        }
        if (EntityCategories.VEHICLE.contains((Keyed)entityType)) {
            return EntityUtil.checkEntity((Plot)plot, (PlotFlag[])new PlotFlag[]{EntityCapFlag.ENTITY_CAP_UNLIMITED, VehicleCapFlag.VEHICLE_CAP_UNLIMITED});
        }
        return EntityUtil.checkEntity((Plot)plot, (PlotFlag[])new PlotFlag[]{EntityCapFlag.ENTITY_CAP_UNLIMITED});
    }
}

