/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.ChunkWrapper;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.ScopedQueueCoordinator;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.world.World;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.generator.BlockPopulator;
import org.checkerframework.checker.nullness.qual.NonNull;

final class BlockStatePopulator
extends BlockPopulator {
    private final IndependentPlotGenerator plotGenerator;
    private final PlotAreaManager plotAreaManager;
    private QueueCoordinator queue;

    public BlockStatePopulator(@NonNull IndependentPlotGenerator plotGenerator, @NonNull PlotAreaManager plotAreaManager) {
        this.plotGenerator = plotGenerator;
        this.plotAreaManager = plotAreaManager;
    }

    public void populate(@NonNull org.bukkit.World world, @NonNull Random random, @NonNull Chunk source) {
        PlotArea area;
        if (this.queue == null) {
            this.queue = PlotSquared.platform().globalBlockQueue().getNewQueue((World)new BukkitWorld(world));
        }
        if ((area = this.plotAreaManager.getPlotArea(world.getName(), null)) == null) {
            return;
        }
        ChunkWrapper wrap = new ChunkWrapper(area.getWorldName(), source.getX(), source.getZ());
        ScopedQueueCoordinator chunk = this.queue.getForChunk(wrap.x, wrap.z, com.plotsquared.bukkit.util.BukkitWorld.getMinWorldHeight(world), com.plotsquared.bukkit.util.BukkitWorld.getMaxWorldHeight(world) - 1);
        if (this.plotGenerator.populateChunk(chunk, area)) {
            this.queue.enqueue();
        }
    }
}

