/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.google.inject.Singleton;
import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.player.BukkitPlayerManager;
import com.plotsquared.bukkit.util.BukkitWorld;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.World;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.BlockUtil;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.StringComparison;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.papermc.lib.PaperLib;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.Template;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Boss;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Monster;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WaterMob;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitUtil
extends WorldUtil {
    public static final BukkitAudiences BUKKIT_AUDIENCES = BukkitAudiences.create((Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class));
    public static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.legacySection();
    public static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + BukkitUtil.class.getSimpleName()));
    private final Collection<BlockType> tileEntityTypes = new HashSet<BlockType>();

    public static @NonNull BukkitPlayer adapt(@NonNull Player player) {
        PlayerManager playerManager = PlotSquared.platform().playerManager();
        return ((BukkitPlayerManager)playerManager).getPlayer(player);
    }

    public static @NonNull Location adapt(@NonNull org.bukkit.Location location) {
        return Location.at((World)BukkitWorld.of(location.getWorld()), (int)MathMan.roundInt((double)location.getX()), (int)MathMan.roundInt((double)location.getY()), (int)MathMan.roundInt((double)location.getZ()));
    }

    public static @NonNull Location adaptComplete(@NonNull org.bukkit.Location location) {
        return Location.at((World)BukkitWorld.of(location.getWorld()), (int)MathMan.roundInt((double)location.getX()), (int)MathMan.roundInt((double)location.getY()), (int)MathMan.roundInt((double)location.getZ()), (float)location.getYaw(), (float)location.getPitch());
    }

    public static @NonNull org.bukkit.Location adapt(@NonNull Location location) {
        return new org.bukkit.Location((org.bukkit.World)location.getWorld().getPlatformWorld(), (double)location.getX(), (double)location.getY(), (double)location.getZ());
    }

    public static @Nullable org.bukkit.World getWorld(@NonNull String string) {
        return Bukkit.getWorld((String)string);
    }

    private static void ensureLoaded(@NonNull String world, int x, int z, @NonNull Consumer<Chunk> chunkConsumer) {
        PaperLib.getChunkAtAsync((org.bukkit.World)Objects.requireNonNull(BukkitUtil.getWorld(world)), (int)(x >> 4), (int)(z >> 4), (boolean)true).thenAccept(chunk -> BukkitUtil.ensureMainThread(chunkConsumer, chunk));
    }

    private static void ensureLoaded(@NonNull Location location, @NonNull Consumer<Chunk> chunkConsumer) {
        PaperLib.getChunkAtAsync((org.bukkit.Location)BukkitUtil.adapt(location), (boolean)true).thenAccept(chunk -> BukkitUtil.ensureMainThread(chunkConsumer, chunk));
    }

    private static <T> void ensureMainThread(@NonNull Consumer<T> consumer, @NonNull T value) {
        if (Bukkit.isPrimaryThread()) {
            consumer.accept(value);
        } else {
            Bukkit.getScheduler().runTask((Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class), () -> consumer.accept(value));
        }
    }

    public boolean isBlockSame(@NonNull BlockState block1, @NonNull BlockState block2) {
        Material mat2;
        if (block1.equals((Object)block2)) {
            return true;
        }
        Material mat1 = BukkitAdapter.adapt((BlockType)block1.getBlockType());
        return mat1 == (mat2 = BukkitAdapter.adapt((BlockType)block2.getBlockType()));
    }

    public boolean isWorld(@NonNull String worldName) {
        return BukkitUtil.getWorld(worldName) != null;
    }

    public void getBiome(@NonNull String world, int x, int z, @NonNull Consumer<BiomeType> result) {
        BukkitUtil.ensureLoaded(world, x, z, chunk -> result.accept(BukkitAdapter.adapt((Biome)BukkitUtil.getWorld(world).getBiome(x, z))));
    }

    public @NonNull BiomeType getBiomeSynchronous(@NonNull String world, int x, int z) {
        return BukkitAdapter.adapt((Biome)Objects.requireNonNull(BukkitUtil.getWorld(world)).getBiome(x, z));
    }

    public void getHighestBlock(@NonNull String world, int x, int z, @NonNull IntConsumer result) {
        BukkitUtil.ensureLoaded(world, x, z, chunk -> {
            org.bukkit.World bukkitWorld = Objects.requireNonNull(BukkitUtil.getWorld(world));
            int air = 1;
            for (int y = bukkitWorld.getMaxHeight() - 1; y >= 0; --y) {
                Block block = bukkitWorld.getBlockAt(x, y, z);
                Material type = block.getType();
                if (type.isSolid()) {
                    if (air > 1) {
                        result.accept(y);
                        return;
                    }
                    air = 0;
                    continue;
                }
                if (block.isLiquid()) {
                    result.accept(y);
                    return;
                }
                ++air;
            }
            result.accept(bukkitWorld.getMaxHeight() - 1);
        });
    }

    public @NonNegative int getHighestBlockSynchronous(@NonNull String world, int x, int z) {
        org.bukkit.World bukkitWorld = Objects.requireNonNull(BukkitUtil.getWorld(world));
        int air = 1;
        for (int y = bukkitWorld.getMaxHeight() - 1; y >= 0; --y) {
            Block block = bukkitWorld.getBlockAt(x, y, z);
            Material type = block.getType();
            if (type.isSolid()) {
                if (air > 1) {
                    return y;
                }
                air = 0;
                continue;
            }
            if (block.isLiquid()) {
                return y;
            }
            ++air;
        }
        return bukkitWorld.getMaxHeight() - 1;
    }

    public @NonNull String[] getSignSynchronous(@NonNull Location location) {
        Block block = Objects.requireNonNull(BukkitUtil.getWorld(location.getWorldName())).getBlockAt(location.getX(), location.getY(), location.getZ());
        try {
            return (String[])TaskManager.getPlatformImplementation().sync(() -> {
                org.bukkit.block.BlockState patt12271$temp = block.getState();
                if (patt12271$temp instanceof Sign) {
                    Sign sign = (Sign)patt12271$temp;
                    return sign.getLines();
                }
                return new String[0];
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public @NonNull Location getSpawn(@NonNull String world) {
        org.bukkit.Location temp = BukkitUtil.getWorld(world).getSpawnLocation();
        return Location.at((String)world, (int)temp.getBlockX(), (int)temp.getBlockY(), (int)temp.getBlockZ(), (float)temp.getYaw(), (float)temp.getPitch());
    }

    public void setSpawn(@NonNull Location location) {
        org.bukkit.World world = BukkitUtil.getWorld(location.getWorldName());
        if (world != null) {
            world.setSpawnLocation(location.getX(), location.getY(), location.getZ());
        }
    }

    public void saveWorld(@NonNull String worldName) {
        org.bukkit.World world = BukkitUtil.getWorld(worldName);
        if (world != null) {
            world.save();
        }
    }

    public void setSign(@NonNull Location location, @NonNull Caption[] lines, Template ... replacements) {
        BukkitUtil.ensureLoaded(location.getWorldName(), location.getX(), location.getZ(), chunk -> {
            org.bukkit.block.BlockState blockstate;
            Sign sign;
            PlotArea area = location.getPlotArea();
            org.bukkit.World world = BukkitUtil.getWorld(location.getWorldName());
            Block block = world.getBlockAt(location.getX(), location.getY(), location.getZ());
            Material type = block.getType();
            if (type != Material.LEGACY_SIGN && type != Material.LEGACY_WALL_SIGN) {
                BlockFace facing = BlockFace.EAST;
                if (world.getBlockAt(location.getX(), location.getY(), location.getZ() + 1).getType().isSolid()) {
                    facing = BlockFace.NORTH;
                } else if (world.getBlockAt(location.getX() + 1, location.getY(), location.getZ()).getType().isSolid()) {
                    facing = BlockFace.WEST;
                } else if (world.getBlockAt(location.getX(), location.getY(), location.getZ() - 1).getType().isSolid()) {
                    facing = BlockFace.SOUTH;
                }
                if (PlotSquared.platform().serverVersion()[1] == 13) {
                    block.setType(Material.valueOf((String)area.legacySignMaterial()), false);
                } else {
                    block.setType(Material.valueOf((String)area.signMaterial()), false);
                }
                if (!(block.getBlockData() instanceof WallSign)) {
                    throw new RuntimeException("Something went wrong generating a sign");
                }
                sign = (Directional)block.getBlockData();
                sign.setFacing(facing);
                block.setBlockData((BlockData)sign, false);
            }
            if ((blockstate = block.getState()) instanceof Sign) {
                sign = (Sign)blockstate;
                for (int i = 0; i < lines.length; ++i) {
                    sign.setLine(i, LEGACY_COMPONENT_SERIALIZER.serialize(MINI_MESSAGE.parse(lines[i].getComponent(LocaleHolder.console()), replacements)));
                }
                sign.update(true);
            }
        });
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StringComparison.ComparisonResult getClosestBlock(@NonNull String name) {
        BlockState state = BlockUtil.get((String)name);
        return new StringComparison.ComparisonResult(new StringComparison(), 1.0, (Object)state);
    }

    public void setBiomes(@NonNull String worldName, @NonNull CuboidRegion region, @NonNull BiomeType biomeType) {
        org.bukkit.World world = BukkitUtil.getWorld(worldName);
        if (world == null) {
            LOGGER.warn("An error occurred while setting the biome because the world was null", (Throwable)new RuntimeException());
            return;
        }
        Biome biome = BukkitAdapter.adapt((BiomeType)biomeType);
        for (int x = region.getMinimumPoint().getX(); x <= region.getMaximumPoint().getX(); ++x) {
            for (int z = region.getMinimumPoint().getZ(); z <= region.getMaximumPoint().getZ(); ++z) {
                if (world.getBiome(x, z) == biome) continue;
                world.setBiome(x, z, biome);
            }
        }
    }

    public @NonNull com.sk89q.worldedit.world.World getWeWorld(@NonNull String world) {
        return new com.sk89q.worldedit.bukkit.BukkitWorld(Bukkit.getWorld((String)world));
    }

    public void refreshChunk(int x, int z, String world) {
        Bukkit.getWorld((String)world).refreshChunk(x, z);
    }

    public void getBlock(@NonNull Location location, @NonNull Consumer<BlockState> result) {
        BukkitUtil.ensureLoaded(location, chunk -> {
            org.bukkit.World world = BukkitUtil.getWorld(location.getWorldName());
            Block block = Objects.requireNonNull(world).getBlockAt(location.getX(), location.getY(), location.getZ());
            result.accept(Objects.requireNonNull(BukkitAdapter.asBlockType((Material)block.getType())).getDefaultState());
        });
    }

    public @NonNull BlockState getBlockSynchronous(@NonNull Location location) {
        org.bukkit.World world = BukkitUtil.getWorld(location.getWorldName());
        Block block = Objects.requireNonNull(world).getBlockAt(location.getX(), location.getY(), location.getZ());
        return Objects.requireNonNull(BukkitAdapter.asBlockType((Material)block.getType())).getDefaultState();
    }

    public @NonNegative double getHealth(@NonNull PlotPlayer<?> player) {
        return Objects.requireNonNull(Bukkit.getPlayer((UUID)player.getUUID())).getHealth();
    }

    public @NonNegative int getFoodLevel(@NonNull PlotPlayer<?> player) {
        return Objects.requireNonNull(Bukkit.getPlayer((UUID)player.getUUID())).getFoodLevel();
    }

    public void setHealth(@NonNull PlotPlayer<?> player, @NonNegative double health) {
        Objects.requireNonNull(Bukkit.getPlayer((UUID)player.getUUID())).setHealth(health);
    }

    public void setFoodLevel(@NonNull PlotPlayer<?> player, @NonNegative int foodLevel) {
        Bukkit.getPlayer((UUID)player.getUUID()).setFoodLevel(foodLevel);
    }

    public @NonNull Set<com.sk89q.worldedit.world.entity.EntityType> getTypesInCategory(@NonNull String category) {
        HashSet<Class> allowedInterfaces = new HashSet<Class>();
        switch (category) {
            case "animal": {
                allowedInterfaces.add(IronGolem.class);
                allowedInterfaces.add(Snowman.class);
                allowedInterfaces.add(Animals.class);
                allowedInterfaces.add(WaterMob.class);
                allowedInterfaces.add(Ambient.class);
                break;
            }
            case "tameable": {
                allowedInterfaces.add(Tameable.class);
                break;
            }
            case "vehicle": {
                allowedInterfaces.add(Vehicle.class);
                break;
            }
            case "hostile": {
                allowedInterfaces.add(Shulker.class);
                allowedInterfaces.add(Monster.class);
                allowedInterfaces.add(Boss.class);
                allowedInterfaces.add(Slime.class);
                allowedInterfaces.add(Ghast.class);
                allowedInterfaces.add(Phantom.class);
                allowedInterfaces.add(EnderCrystal.class);
                break;
            }
            case "hanging": {
                allowedInterfaces.add(Hanging.class);
                break;
            }
            case "villager": {
                allowedInterfaces.add(NPC.class);
                break;
            }
            case "projectile": {
                allowedInterfaces.add(Projectile.class);
                break;
            }
            case "other": {
                allowedInterfaces.add(ArmorStand.class);
                allowedInterfaces.add(FallingBlock.class);
                allowedInterfaces.add(Item.class);
                allowedInterfaces.add(Explosive.class);
                allowedInterfaces.add(AreaEffectCloud.class);
                allowedInterfaces.add(EvokerFangs.class);
                allowedInterfaces.add(LightningStrike.class);
                allowedInterfaces.add(ExperienceOrb.class);
                allowedInterfaces.add(EnderSignal.class);
                allowedInterfaces.add(Firework.class);
                break;
            }
            case "player": {
                allowedInterfaces.add(Player.class);
                break;
            }
            default: {
                LOGGER.error("Unknown entity category requested: {}", (Object)category);
            }
        }
        HashSet<com.sk89q.worldedit.world.entity.EntityType> types = new HashSet<com.sk89q.worldedit.world.entity.EntityType>();
        block22: for (EntityType bukkitType : EntityType.values()) {
            Class entityClass = bukkitType.getEntityClass();
            if (entityClass == null) continue;
            for (Class allowedInterface : allowedInterfaces) {
                if (!allowedInterface.isAssignableFrom(entityClass)) continue;
                types.add(BukkitAdapter.adapt((EntityType)bukkitType));
                continue block22;
            }
        }
        return types;
    }

    public @NonNull Collection<BlockType> getTileEntityTypes() {
        if (this.tileEntityTypes.isEmpty()) {
            this.tileEntityTypes.addAll(BlockCategories.BANNERS.getAll());
            this.tileEntityTypes.addAll(BlockCategories.SIGNS.getAll());
            this.tileEntityTypes.addAll(BlockCategories.BEDS.getAll());
            this.tileEntityTypes.addAll(BlockCategories.FLOWER_POTS.getAll());
            Stream.of("barrel", "beacon", "beehive", "bee_nest", "bell", "blast_furnace", "brewing_stand", "campfire", "chest", "ender_chest", "trapped_chest", "command_block", "end_gateway", "hopper", "jigsaw", "jubekox", "lectern", "note_block", "black_shulker_box", "blue_shulker_box", "brown_shulker_box", "cyan_shulker_box", "gray_shulker_box", "green_shulker_box", "light_blue_shulker_box", "light_gray_shulker_box", "lime_shulker_box", "magenta_shulker_box", "orange_shulker_box", "pink_shulker_box", "purple_shulker_box", "red_shulker_box", "shulker_box", "white_shulker_box", "yellow_shulker_box", "smoker", "structure_block", "structure_void").map(BlockTypes::get).filter(Objects::nonNull).forEach(this.tileEntityTypes::add);
        }
        return this.tileEntityTypes;
    }

    public @NonNegative int getTileEntityCount(@NonNull String world, @NonNull BlockVector2 chunk) {
        return Objects.requireNonNull(BukkitUtil.getWorld(world)).getChunkAt(chunk.getBlockX(), chunk.getBlockZ()).getTileEntities().length;
    }

    public Set<BlockVector2> getChunkChunks(String world) {
        Set chunks = super.getChunkChunks(world);
        if (Bukkit.isPrimaryThread()) {
            for (Chunk chunk : Objects.requireNonNull(Bukkit.getWorld((String)world)).getLoadedChunks()) {
                BlockVector2 loc = BlockVector2.at((int)(chunk.getX() >> 5), (int)(chunk.getZ() >> 5));
                chunks.add(loc);
            }
        } else {
            Semaphore semaphore = new Semaphore(1);
            try {
                semaphore.acquire();
                Bukkit.getScheduler().runTask((Plugin)BukkitPlatform.getPlugin(BukkitPlatform.class), () -> {
                    for (Chunk chunk : Objects.requireNonNull(Bukkit.getWorld((String)world)).getLoadedChunks()) {
                        BlockVector2 loc = BlockVector2.at((int)(chunk.getX() >> 5), (int)(chunk.getZ() >> 5));
                        chunks.add(loc);
                    }
                    semaphore.release();
                });
                semaphore.acquireUninterruptibly();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return chunks;
    }
}

