/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.google.inject.Inject;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.BlockBurnFlag;
import com.plotsquared.core.plot.flag.implementations.BlockIgnitionFlag;
import com.plotsquared.core.plot.flag.implementations.BreakFlag;
import com.plotsquared.core.plot.flag.implementations.CoralDryFlag;
import com.plotsquared.core.plot.flag.implementations.CropGrowFlag;
import com.plotsquared.core.plot.flag.implementations.DisablePhysicsFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.ExplosionFlag;
import com.plotsquared.core.plot.flag.implementations.GrassGrowFlag;
import com.plotsquared.core.plot.flag.implementations.IceFormFlag;
import com.plotsquared.core.plot.flag.implementations.IceMeltFlag;
import com.plotsquared.core.plot.flag.implementations.InstabreakFlag;
import com.plotsquared.core.plot.flag.implementations.KelpGrowFlag;
import com.plotsquared.core.plot.flag.implementations.LeafDecayFlag;
import com.plotsquared.core.plot.flag.implementations.LiquidFlowFlag;
import com.plotsquared.core.plot.flag.implementations.MycelGrowFlag;
import com.plotsquared.core.plot.flag.implementations.PlaceFlag;
import com.plotsquared.core.plot.flag.implementations.RedstoneFlag;
import com.plotsquared.core.plot.flag.implementations.SnowFormFlag;
import com.plotsquared.core.plot.flag.implementations.SnowMeltFlag;
import com.plotsquared.core.plot.flag.implementations.SoilDryFlag;
import com.plotsquared.core.plot.flag.implementations.VineGrowFlag;
import com.plotsquared.core.plot.flag.types.BlockTypeWrapper;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.Template;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.material.Directional;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BlockEventListener
implements Listener {
    private final PlotAreaManager plotAreaManager;
    private final WorldEdit worldEdit;

    @Inject
    public BlockEventListener(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldEdit worldEdit) {
        this.plotAreaManager = plotAreaManager;
        this.worldEdit = worldEdit;
    }

    public static void sendBlockChange(org.bukkit.Location bloc, BlockData data) {
        TaskManager.runTaskLater(() -> {
            String world = bloc.getWorld().getName();
            int x = bloc.getBlockX();
            int z = bloc.getBlockZ();
            int distance = Bukkit.getViewDistance() * 16;
            for (PlotPlayer player : PlotSquared.platform().playerManager().getPlayers()) {
                Location location = player.getLocation();
                if (!location.getWorldName().equals(world) || 16 * Math.abs(location.getX() - x) / 16 > distance || 16 * Math.abs(location.getZ() - z) / 16 > distance) continue;
                ((BukkitPlayer)player).player.sendBlockChange(bloc, data);
            }
        }, (TaskTime)TaskTime.ticks((long)3L));
    }

    @EventHandler
    public void onRedstoneEvent(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (area.isRoadFlags() && !((Boolean)area.getRoadFlag(RedstoneFlag.class)).booleanValue()) {
                event.setNewCurrent(0);
            }
            return;
        }
        if (!((Boolean)plot.getFlag(RedstoneFlag.class)).booleanValue()) {
            event.setNewCurrent(0);
            plot.debug("Redstone event was cancelled because redstone = false");
            return;
        }
        if (Settings.Redstone.DISABLE_OFFLINE) {
            boolean disable = false;
            if (!DBFunc.SERVER.equals(plot.getOwner())) {
                if (plot.isMerged()) {
                    disable = true;
                    for (UUID owner : plot.getOwners()) {
                        if (PlotSquared.platform().playerManager().getPlayerIfExists(owner) == null) continue;
                        disable = false;
                        break;
                    }
                } else {
                    boolean bl = disable = PlotSquared.platform().playerManager().getPlayerIfExists(plot.getOwnerAbs()) == null;
                }
            }
            if (disable) {
                for (UUID trusted : plot.getTrusted()) {
                    if (PlotSquared.platform().playerManager().getPlayerIfExists(trusted) == null) continue;
                    disable = false;
                    break;
                }
                if (disable) {
                    event.setNewCurrent(0);
                    plot.debug("Redstone event was cancelled because no trusted player was in the plot");
                    return;
                }
            }
        }
        if (Settings.Redstone.DISABLE_UNOCCUPIED) {
            for (PlotPlayer player : PlotSquared.platform().playerManager().getPlayers()) {
                if (!plot.equals((Object)player.getCurrentPlot())) continue;
                return;
            }
            event.setNewCurrent(0);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPhysicsEvent(BlockPhysicsEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlotAbs(location);
        if (plot == null) {
            return;
        }
        if (event.getChangedType().hasGravity() && ((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
            event.setCancelled(true);
            BlockEventListener.sendBlockChange(event.getBlock().getLocation(), event.getBlock().getBlockData());
            plot.debug("Prevented block physics and resent block change because disable-physics = true");
            return;
        }
        switch (event.getChangedType()) {
            case COMPARATOR: {
                if (!((Boolean)plot.getFlag(RedstoneFlag.class)).booleanValue()) {
                    event.setCancelled(true);
                    plot.debug("Prevented comparator update because redstone = false");
                }
                return;
            }
            case ANVIL: 
            case DRAGON_EGG: 
            case GRAVEL: 
            case SAND: 
            case TURTLE_EGG: 
            case TURTLE_HELMET: 
            case TURTLE_SPAWN_EGG: {
                if (((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
                    event.setCancelled(true);
                    plot.debug("Prevented block physics because disable-physics = true");
                }
                return;
            }
        }
        if (Settings.Redstone.DETECT_INVALID_EDGE_PISTONS) {
            switch (block.getType()) {
                case PISTON: 
                case STICKY_PISTON: {
                    org.bukkit.block.data.Directional piston = (org.bukkit.block.data.Directional)block.getBlockData();
                    switch (piston.getFacing()) {
                        case EAST: {
                            location = location.add(1, 0, 0);
                            break;
                        }
                        case SOUTH: {
                            location = location.add(-1, 0, 0);
                            break;
                        }
                        case WEST: {
                            location = location.add(0, 0, 1);
                            break;
                        }
                        case NORTH: {
                            location = location.add(0, 0, -1);
                        }
                    }
                    Plot newPlot = area.getOwnedPlotAbs(location);
                    if (plot.equals((Object)newPlot)) break;
                    event.setCancelled(true);
                    plot.debug("Prevented piston update because of invalid edge piston detection");
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void blockCreate(BlockPlaceEvent event) {
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Player player = event.getPlayer();
        BukkitPlayer pp = BukkitUtil.adapt(player);
        Plot plot = area.getPlot(location);
        if (plot != null) {
            Block block;
            if (!(location.getY() <= area.getMaxBuildHeight() && location.getY() >= area.getMinBuildHeight() || Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_HEIGHT_LIMIT))) {
                event.setCancelled(true);
                pp.sendMessage((Caption)TranslatableCaption.of((String)"height.height_limit"), new Template[]{Template.of((String)"minHeight", (String)String.valueOf(area.getMinBuildHeight())), Template.of((String)"maxHeight", (String)String.valueOf(area.getMaxBuildHeight()))});
            }
            if (!plot.hasOwner()) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_UNOWNED))});
                    event.setCancelled(true);
                    return;
                }
            } else if (!plot.isAdded(pp.getUUID())) {
                Block block2;
                List place = (List)plot.getFlag(PlaceFlag.class);
                if (place != null && place.contains(BlockTypeWrapper.get((BlockType)BukkitAdapter.asBlockType((Material)(block2 = event.getBlock()).getType())))) {
                    return;
                }
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_OTHER))});
                    event.setCancelled(true);
                    plot.debug(player.getName() + " could not place " + event.getBlock().getType() + " because of the place = false");
                    return;
                }
            } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"done.building_restricted"), new Template[0]);
                event.setCancelled(true);
                return;
            }
            if (((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue() && (block = event.getBlockPlaced()).getType().hasGravity()) {
                BlockEventListener.sendBlockChange(block.getLocation(), block.getBlockData());
                plot.debug(event.getBlock().getType() + " did not fall because of disable-physics = true");
            }
        } else if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
            pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_ROAD))});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void blockDestroy(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getPlot(location);
        if (plot != null) {
            BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
            if (event.getBlock().getY() == 0) {
                if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_GROUNDLEVEL)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_GROUNDLEVEL))});
                    event.setCancelled(true);
                    return;
                }
            } else if (!(location.getY() <= area.getMaxBuildHeight() && location.getY() >= area.getMinBuildHeight() || Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_BUILD_HEIGHT_LIMIT))) {
                event.setCancelled(true);
                plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"height.height_limit"), new Template[]{Template.of((String)"minHeight", (String)String.valueOf(area.getMinBuildHeight())), Template.of((String)"maxHeight", (String)String.valueOf(area.getMaxBuildHeight()))});
            }
            if (!plot.hasOwner()) {
                if (!Permissions.hasPermission((PlotPlayer)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_UNOWNED, (boolean)true)) {
                    event.setCancelled(true);
                }
                return;
            }
            if (!plot.isAdded(plotPlayer.getUUID())) {
                List destroy = (List)plot.getFlag(BreakFlag.class);
                Block block = event.getBlock();
                BlockType blockType = BukkitAdapter.asBlockType((Material)block.getType());
                for (BlockTypeWrapper blockTypeWrapper : destroy) {
                    if (!blockTypeWrapper.accepts(blockType)) continue;
                    return;
                }
                if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_OTHER)) {
                    return;
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_OTHER))});
                event.setCancelled(true);
            } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot) && !Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"done.building_restricted"), new Template[0]);
                event.setCancelled(true);
                return;
            }
            return;
        }
        BukkitPlayer pp = BukkitUtil.adapt(player);
        if (Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_DESTROY_ROAD)) {
            return;
        }
        if (this.worldEdit != null && pp.getAttribute("worldedit") && player.getInventory().getItemInMainHand().getType() == Material.getMaterial((String)this.worldEdit.getConfiguration().wandItem)) {
            return;
        }
        pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_ROAD))});
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        if (location.isPlotRoad()) {
            event.setCancelled(true);
            return;
        }
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            return;
        }
        switch (event.getSource().getType().toString()) {
            case "GRASS_BLOCK": {
                if (((Boolean)plot.getFlag(GrassGrowFlag.class)).booleanValue()) break;
                plot.debug("Grass could not grow because grass-grow = false");
                event.setCancelled(true);
                break;
            }
            case "MYCELIUM": {
                if (((Boolean)plot.getFlag(MycelGrowFlag.class)).booleanValue()) break;
                plot.debug("Mycelium could not grow because mycel-grow = false");
                event.setCancelled(true);
                break;
            }
            case "WEEPING_VINES": 
            case "TWISTING_VINES": 
            case "CAVE_VINES": 
            case "VINE": {
                if (((Boolean)plot.getFlag(VineGrowFlag.class)).booleanValue()) break;
                plot.debug("Vine could not grow because vine-grow = false");
                event.setCancelled(true);
                break;
            }
            case "KELP": {
                if (!((Boolean)plot.getFlag(KelpGrowFlag.class)).booleanValue()) {
                    plot.debug("Kelp could not grow because kelp-grow = false");
                    event.setCancelled(true);
                }
            }
            case "BUDDING_AMETHYST": {
                if (((Boolean)plot.getFlag(CropGrowFlag.class)).booleanValue()) break;
                plot.debug("Amethyst clusters could not grow because crop-grow = false");
                event.setCancelled(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCauldronEmpty(CauldronLevelChangeEvent event) {
        Entity entity = event.getEntity();
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getPlot(location);
        switch (event.getReason()) {
            case BANNER_WASH: 
            case ARMOR_WASH: 
            case EXTINGUISH: {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
                    if (plot != null) {
                        if (!plot.hasOwner()) {
                            if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)) {
                                return;
                            }
                        } else {
                            if (plot.isAdded(plotPlayer.getUUID())) return;
                            if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                                return;
                            }
                        }
                    } else {
                        if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_INTERACT_ROAD)) {
                            return;
                        }
                        if (this.worldEdit != null && plotPlayer.getAttribute("worldedit") && player.getInventory().getItemInMainHand().getType() == Material.getMaterial((String)this.worldEdit.getConfiguration().wandItem)) {
                            return;
                        }
                    }
                }
                if (event.getReason() == CauldronLevelChangeEvent.ChangeReason.EXTINGUISH && event.getEntity() != null) {
                    event.getEntity().setFireTicks(0);
                }
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        if (event instanceof EntityBlockFormEvent) {
            return;
        }
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        if (location.isPlotRoad()) {
            event.setCancelled(true);
            return;
        }
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            return;
        }
        switch (event.getNewState().getType()) {
            case SNOW: 
            case SNOW_BLOCK: {
                if (!((Boolean)plot.getFlag(SnowFormFlag.class)).booleanValue()) {
                    plot.debug("Snow could not form because snow-form = false");
                    event.setCancelled(true);
                }
                return;
            }
            case ICE: 
            case FROSTED_ICE: 
            case PACKED_ICE: {
                if (((Boolean)plot.getFlag(IceFormFlag.class)).booleanValue()) break;
                plot.debug("Ice could not form because ice-form = false");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityBlockForm(EntityBlockFormEvent event) {
        Class<SnowFormFlag> flag;
        String world = event.getBlock().getWorld().getName();
        if (!this.plotAreaManager.hasPlotArea(world)) {
            return;
        }
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            event.setCancelled(true);
            return;
        }
        switch (event.getNewState().getType()) {
            case SNOW: 
            case SNOW_BLOCK: {
                flag = SnowFormFlag.class;
                break;
            }
            case ICE: 
            case FROSTED_ICE: 
            case PACKED_ICE: {
                flag = IceFormFlag.class;
                break;
            }
            default: {
                return;
            }
        }
        boolean allowed = (Boolean)plot.getFlag(flag);
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
            if (!plot.isAdded(plotPlayer.getUUID())) {
                if (allowed) {
                    return;
                }
                plot.debug(String.format("%s could not be formed because %s = false (entity is player)", event.getNewState().getType(), flag == SnowFormFlag.class ? "snow-form" : "ice-form"));
                event.setCancelled(true);
            }
            return;
        }
        if (plot.hasOwner()) {
            if (allowed) {
                return;
            }
            plot.debug(String.format("%s could not be formed because %s = false (entity is not player)", event.getNewState().getType(), flag == SnowFormFlag.class ? "snow-form" : "ice-form"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent event) {
        Player player = event.getPlayer();
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        Plot plot = area.getPlot(location);
        if (plot != null) {
            BukkitPlayer plotPlayer;
            if (((Boolean)plot.getFlag(InstabreakFlag.class)).booleanValue()) {
                Block block = event.getBlock();
                BlockBreakEvent call = new BlockBreakEvent(block, player);
                Bukkit.getServer().getPluginManager().callEvent((Event)call);
                if (!call.isCancelled()) {
                    event.getBlock().breakNaturally();
                }
            }
            if (location.getY() == 0) {
                event.setCancelled(true);
                return;
            }
            if (!plot.hasOwner()) {
                plotPlayer = BukkitUtil.adapt(player);
                if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_UNOWNED)) {
                    return;
                }
                event.setCancelled(true);
                return;
            }
            plotPlayer = BukkitUtil.adapt(player);
            if (!plot.isAdded(plotPlayer.getUUID())) {
                Block block;
                List destroy = (List)plot.getFlag(BreakFlag.class);
                if (destroy.contains(BlockTypeWrapper.get((BlockType)BukkitAdapter.asBlockType((Material)(block = event.getBlock()).getType()))) || Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_OTHER)) {
                    return;
                }
                plot.debug(player.getName() + " could not break " + block.getType() + " because it was not in the break flag");
                event.setCancelled(true);
                return;
            }
            return;
        }
        BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
        if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_ROAD)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFade(BlockFadeEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            event.setCancelled(true);
            return;
        }
        switch (block.getType()) {
            case ICE: {
                if (((Boolean)plot.getFlag(IceMeltFlag.class)).booleanValue()) break;
                plot.debug("Ice could not melt because ice-melt = false");
                event.setCancelled(true);
                break;
            }
            case SNOW: {
                if (((Boolean)plot.getFlag(SnowMeltFlag.class)).booleanValue()) break;
                plot.debug("Snow could not melt because snow-melt = false");
                event.setCancelled(true);
                break;
            }
            case FARMLAND: {
                if (((Boolean)plot.getFlag(SoilDryFlag.class)).booleanValue()) break;
                plot.debug("Soil could not dry because soil-dry = false");
                event.setCancelled(true);
                break;
            }
            case TUBE_CORAL_BLOCK: 
            case BRAIN_CORAL_BLOCK: 
            case BUBBLE_CORAL_BLOCK: 
            case FIRE_CORAL_BLOCK: 
            case HORN_CORAL_BLOCK: 
            case TUBE_CORAL: 
            case BRAIN_CORAL: 
            case BUBBLE_CORAL: 
            case FIRE_CORAL: 
            case HORN_CORAL: 
            case TUBE_CORAL_FAN: 
            case BRAIN_CORAL_FAN: 
            case BUBBLE_CORAL_FAN: 
            case FIRE_CORAL_FAN: 
            case HORN_CORAL_FAN: 
            case BRAIN_CORAL_WALL_FAN: 
            case BUBBLE_CORAL_WALL_FAN: 
            case FIRE_CORAL_WALL_FAN: 
            case HORN_CORAL_WALL_FAN: 
            case TUBE_CORAL_WALL_FAN: {
                if (((Boolean)plot.getFlag(CoralDryFlag.class)).booleanValue()) break;
                plot.debug("Coral could not dry because coral-dry = false");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChange(BlockFromToEvent event) {
        org.bukkit.Location location;
        Plot fromPlot;
        Plot plot;
        Block from = event.getBlock();
        Location fLocation = BukkitUtil.adapt(from.getLocation());
        PlotArea fromArea = fLocation.getPlotArea();
        if (fromArea != null && (plot = fromArea.getOwnedPlot(fLocation)) != null && plot.getFlag(LiquidFlowFlag.class) == LiquidFlowFlag.FlowStatus.DISABLED && event.getBlock().isLiquid()) {
            plot.debug("Liquid could not flow because liquid-flow = disabled");
            event.setCancelled(true);
            return;
        }
        Block to = event.getToBlock();
        Location tLocation = BukkitUtil.adapt(to.getLocation());
        PlotArea area = tLocation.getPlotArea();
        if (area == null) {
            if (from.getType() == Material.DRAGON_EGG && fromArea != null) {
                event.setCancelled(true);
            }
            return;
        }
        Plot plot2 = area.getOwnedPlot(tLocation);
        if (!(from.getType() != Material.DRAGON_EGG || fromArea == null || (fromPlot = fromArea.getOwnedPlot(fLocation)) == null && plot2 == null || fromPlot != null && fromPlot.equals((Object)plot2) || plot2 != null && plot2.equals((Object)fromPlot))) {
            event.setCancelled(true);
            return;
        }
        if (plot2 != null) {
            if (!area.contains(fLocation.getX(), fLocation.getZ()) || !Objects.equals(plot2, area.getOwnedPlot(fLocation))) {
                event.setCancelled(true);
                return;
            }
            if (plot2.getFlag(LiquidFlowFlag.class) == LiquidFlowFlag.FlowStatus.ENABLED && event.getBlock().isLiquid()) {
                return;
            }
            if (((Boolean)plot2.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
                plot2.debug(event.getBlock().getType() + " could not update because disable-physics = true");
                event.setCancelled(true);
                return;
            }
            if (plot2.getFlag(LiquidFlowFlag.class) == LiquidFlowFlag.FlowStatus.DISABLED && event.getBlock().isLiquid()) {
                plot2.debug("Liquid could not flow because liquid-flow = disabled");
                event.setCancelled(true);
            }
        } else if (!area.contains(fLocation.getX(), fLocation.getZ()) || !Objects.equals(null, area.getOwnedPlot(fLocation))) {
            event.setCancelled(true);
        } else if (event.getBlock().isLiquid() && (BukkitUtil.adapt((location = event.getBlock().getLocation()).clone().add(-1.0, 0.0, 1.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(1.0, 0.0, 0.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(1.0, 0.0, 1.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(-1.0, 0.0, 0.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(1.0, 0.0, 0.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(-1.0, 0.0, -1.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(0.0, 0.0, -1.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(1.0, 0.0, 1.0)).getPlot() != null)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onGrow(BlockGrowEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(CropGrowFlag.class)).booleanValue()) {
            if (plot != null) {
                plot.debug("Crop grow event was cancelled because crop-grow = false");
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        BlockFace face = event.getDirection();
        Vector relative = new Vector(face.getModX(), face.getModY(), face.getModZ());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
                return;
            }
            for (Block block1 : event.getBlocks()) {
                Location bloc = BukkitUtil.adapt(block1.getLocation());
                if (!bloc.isPlotArea() && !bloc.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ()).isPlotArea()) continue;
                event.setCancelled(true);
                return;
            }
            if (location.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ()).isPlotArea()) {
                event.setCancelled(true);
            }
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            event.setCancelled(true);
            return;
        }
        for (Block block1 : event.getBlocks()) {
            Location bloc = BukkitUtil.adapt(block1.getLocation());
            if (!area.contains(bloc.getX(), bloc.getZ()) || !area.contains(bloc.getX() + relative.getBlockX(), bloc.getZ() + relative.getBlockZ())) {
                event.setCancelled(true);
                return;
            }
            if (plot.equals((Object)area.getOwnedPlot(bloc)) && plot.equals((Object)area.getOwnedPlot(bloc.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ())))) continue;
            event.setCancelled(true);
            return;
        }
        if (!plot.equals((Object)area.getOwnedPlot(location.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ())))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        BlockFace face = event.getDirection();
        Vector relative = new Vector(face.getModX(), face.getModY(), face.getModZ());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
                return;
            }
            for (Block block1 : event.getBlocks()) {
                Location bloc = BukkitUtil.adapt(block1.getLocation());
                if (!bloc.isPlotArea() && !bloc.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ()).isPlotArea()) continue;
                event.setCancelled(true);
                return;
            }
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            event.setCancelled(true);
            return;
        }
        for (Block block1 : event.getBlocks()) {
            Location bloc = BukkitUtil.adapt(block1.getLocation());
            if (!area.contains(bloc.getX(), bloc.getZ()) || !area.contains(bloc.getX() + relative.getBlockX(), bloc.getZ() + relative.getBlockZ())) {
                event.setCancelled(true);
                return;
            }
            if (plot.equals((Object)area.getOwnedPlot(bloc)) && plot.equals((Object)area.getOwnedPlot(bloc.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ())))) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent event) {
        Material type = event.getItem().getType();
        switch (type.toString()) {
            case "SHULKER_BOX": 
            case "WHITE_SHULKER_BOX": 
            case "ORANGE_SHULKER_BOX": 
            case "MAGENTA_SHULKER_BOX": 
            case "LIGHT_BLUE_SHULKER_BOX": 
            case "YELLOW_SHULKER_BOX": 
            case "LIME_SHULKER_BOX": 
            case "PINK_SHULKER_BOX": 
            case "GRAY_SHULKER_BOX": 
            case "LIGHT_GRAY_SHULKER_BOX": 
            case "CYAN_SHULKER_BOX": 
            case "PURPLE_SHULKER_BOX": 
            case "BLUE_SHULKER_BOX": 
            case "BROWN_SHULKER_BOX": 
            case "GREEN_SHULKER_BOX": 
            case "RED_SHULKER_BOX": 
            case "BLACK_SHULKER_BOX": 
            case "CARVED_PUMPKIN": 
            case "WITHER_SKELETON_SKULL": 
            case "FLINT_AND_STEEL": 
            case "BONE_MEAL": 
            case "SHEARS": 
            case "GLASS_BOTTLE": 
            case "GLOWSTONE": 
            case "COD_BUCKET": 
            case "PUFFERFISH_BUCKET": 
            case "SALMON_BUCKET": 
            case "TROPICAL_FISH_BUCKET": 
            case "AXOLOTL_BUCKET": 
            case "BUCKET": 
            case "WATER_BUCKET": 
            case "LAVA_BUCKET": {
                if (event.getBlock().getType() == Material.DROPPER) {
                    return;
                }
                BlockFace targetFace = ((Directional)event.getBlock().getState().getData()).getFacing();
                Location location = BukkitUtil.adapt(event.getBlock().getRelative(targetFace).getLocation());
                if (!location.isPlotRoad()) break;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        Plot plot;
        int i;
        if (!this.plotAreaManager.hasPlotArea(event.getWorld().getName())) {
            return;
        }
        List blocks = event.getBlocks();
        if (blocks.isEmpty()) {
            return;
        }
        Location location = BukkitUtil.adapt(((BlockState)blocks.get(0)).getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            for (int i2 = blocks.size() - 1; i2 >= 0; --i2) {
                location = BukkitUtil.adapt(((BlockState)blocks.get(i2)).getLocation());
                if (!location.isPlotArea()) continue;
                blocks.remove(i2);
            }
            return;
        }
        Plot origin = area.getOwnedPlot(location);
        if (origin == null) {
            event.setCancelled(true);
            return;
        }
        for (i = blocks.size() - 1; i >= 0; --i) {
            location = BukkitUtil.adapt(((BlockState)blocks.get(i)).getLocation());
            if (!area.contains(location.getX(), location.getZ())) {
                blocks.remove(i);
                continue;
            }
            plot = area.getOwnedPlot(location);
            if (Objects.equals(plot, origin)) continue;
            event.getBlocks().remove(i);
        }
        origin = area.getPlot(location);
        if (origin == null) {
            event.setCancelled(true);
            return;
        }
        for (i = blocks.size() - 1; i >= 0; --i) {
            location = BukkitUtil.adapt(((BlockState)blocks.get(i)).getLocation());
            plot = area.getOwnedPlot(location);
            if (Objects.equals(plot, origin) || plot.isMerged() || origin.isMerged()) continue;
            event.getBlocks().remove(i);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBigBoom(BlockExplodeEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        String world = location.getWorldName();
        if (!this.plotAreaManager.hasPlotArea(world)) {
            return;
        }
        PlotArea area = location.getPlotArea();
        if (area == null) {
            Iterator iterator = event.blockList().iterator();
            while (iterator.hasNext()) {
                location = BukkitUtil.adapt(((Block)iterator.next()).getLocation());
                if (!location.isPlotArea()) continue;
                iterator.remove();
            }
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null || !((Boolean)plot.getFlag(ExplosionFlag.class)).booleanValue()) {
            event.setCancelled(true);
            if (plot != null) {
                plot.debug("Explosion was cancelled because explosion = false");
            }
        }
        event.blockList().removeIf(blox -> !plot.equals((Object)area.getOwnedPlot(BukkitUtil.adapt(blox.getLocation()))));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(BlockBurnFlag.class)).booleanValue()) {
            if (plot != null) {
                plot.debug("Block burning was cancelled because block-burn = false");
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        Player player = event.getPlayer();
        Entity ignitingEntity = event.getIgnitingEntity();
        Block block = event.getBlock();
        BlockIgniteEvent.IgniteCause igniteCause = event.getCause();
        Location location1 = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location1.getPlotArea();
        if (area == null) {
            return;
        }
        if (igniteCause == BlockIgniteEvent.IgniteCause.LIGHTNING) {
            event.setCancelled(true);
            return;
        }
        Plot plot = area.getOwnedPlot(location1);
        if (player != null) {
            BukkitPlayer pp = BukkitUtil.adapt(player);
            if (plot == null) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_ROAD))});
                    event.setCancelled(true);
                }
            } else if (!plot.hasOwner()) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_UNOWNED))});
                    event.setCancelled(true);
                }
            } else if (!plot.isAdded(pp.getUUID())) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_OTHER))});
                    event.setCancelled(true);
                }
            } else if (!((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue()) {
                event.setCancelled(true);
                plot.debug("Block ignition was cancelled because block-ignition = false");
            }
        } else {
            if (plot == null) {
                event.setCancelled(true);
                return;
            }
            if (ignitingEntity != null) {
                if (!((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue()) {
                    event.setCancelled(true);
                    plot.debug("Block ignition was cancelled because block-ignition = false");
                    return;
                }
                if (igniteCause == BlockIgniteEvent.IgniteCause.FIREBALL && ignitingEntity instanceof Fireball) {
                    Projectile fireball = (Projectile)ignitingEntity;
                    Location location = null;
                    ProjectileSource projectileSource = fireball.getShooter();
                    if (projectileSource instanceof Entity) {
                        Entity shooter = (Entity)projectileSource;
                        location = BukkitUtil.adapt(shooter.getLocation());
                    } else if (fireball.getShooter() instanceof BlockProjectileSource) {
                        Block shooter = ((BlockProjectileSource)fireball.getShooter()).getBlock();
                        location = BukkitUtil.adapt(shooter.getLocation());
                    }
                    if (location != null && !plot.equals((Object)location.getPlot())) {
                        event.setCancelled(true);
                    }
                }
            } else if (event.getIgnitingBlock() != null) {
                Block ignitingBlock = event.getIgnitingBlock();
                Plot plotIgnited = BukkitUtil.adapt(ignitingBlock.getLocation()).getPlot();
                if (!((igniteCause != BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL || ((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue() && plotIgnited != null && plotIgnited.equals((Object)plot)) && (igniteCause != BlockIgniteEvent.IgniteCause.SPREAD && igniteCause != BlockIgniteEvent.IgniteCause.LAVA || ((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue() && plotIgnited != null && plotIgnited.equals((Object)plot)))) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLeavesDecay(LeavesDecayEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(LeafDecayFlag.class)).booleanValue()) {
            if (plot != null) {
                plot.debug("Leaf decaying was cancelled because leaf-decay = false");
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpongeAbsorb(SpongeAbsorbEvent event) {
        Block sponge = event.getBlock();
        Location location = BukkitUtil.adapt(sponge.getLocation());
        PlotArea area = location.getPlotArea();
        List blocks = event.getBlocks();
        if (area == null) {
            blocks.removeIf(block -> BukkitUtil.adapt(block.getLocation()).isPlotArea());
        } else {
            Plot origin = area.getOwnedPlot(location);
            blocks.removeIf(block -> {
                Location blockLocation = BukkitUtil.adapt(block.getLocation());
                if (!area.contains(blockLocation.getX(), blockLocation.getZ())) {
                    return true;
                }
                Plot plot = area.getOwnedPlot(blockLocation);
                return !Objects.equals(plot, origin);
            });
        }
        if (blocks.isEmpty()) {
            event.setCancelled(true);
        }
    }
}

