/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitWorld
implements com.plotsquared.core.location.World<World> {
    private static final Map<String, BukkitWorld> worldMap = Maps.newHashMap();
    private final World world;

    private BukkitWorld(World world) {
        this.world = world;
    }

    public static @NonNull BukkitWorld of(@NonNull String worldName) {
        World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld == null) {
            throw new IllegalArgumentException(String.format("There is no world with the name '%s'", worldName));
        }
        return BukkitWorld.of(bukkitWorld);
    }

    public static @NonNull BukkitWorld of(World world) {
        BukkitWorld bukkitWorld = worldMap.get(world.getName());
        if (bukkitWorld != null && bukkitWorld.getPlatformWorld().equals(world)) {
            return bukkitWorld;
        }
        bukkitWorld = new BukkitWorld(world);
        worldMap.put(world.getName(), bukkitWorld);
        return bukkitWorld;
    }

    public World getPlatformWorld() {
        return this.world;
    }

    public @NonNull String getName() {
        return this.world.getName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitWorld)) {
            return false;
        }
        BukkitWorld other = (BukkitWorld)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Objects.equals(this.world, other.world);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BukkitWorld;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        World $world = this.world;
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        return result;
    }

    public String toString() {
        return "BukkitWorld(world=" + this.world + ")";
    }
}

