/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.queue;

import com.google.inject.Inject;
import com.plotsquared.bukkit.schematic.StateWrapper;
import com.plotsquared.bukkit.util.BukkitBlockUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.inject.factory.ChunkCoordinatorBuilderFactory;
import com.plotsquared.core.inject.factory.ChunkCoordinatorFactory;
import com.plotsquared.core.queue.BasicQueueCoordinator;
import com.plotsquared.core.queue.ChunkCoordinator;
import com.plotsquared.core.queue.LocalChunk;
import com.plotsquared.core.util.ChunkUtil;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitQueueCoordinator
extends BasicQueueCoordinator {
    private final SideEffectSet noSideEffectSet = SideEffectSet.none().with(SideEffect.LIGHTING, SideEffect.State.OFF).with(SideEffect.NEIGHBORS, SideEffect.State.OFF);
    private final SideEffectSet lightingSideEffectSet = SideEffectSet.none().with(SideEffect.NEIGHBORS, SideEffect.State.OFF);
    private final SideEffectSet edgeSideEffectSet = this.noSideEffectSet.with(SideEffect.UPDATE, SideEffect.State.ON).with(SideEffect.NEIGHBORS, SideEffect.State.ON);
    private final SideEffectSet edgeLightingSideEffectSet = this.noSideEffectSet.with(SideEffect.UPDATE, SideEffect.State.ON).with(SideEffect.NEIGHBORS, SideEffect.State.ON);
    private org.bukkit.World bukkitWorld;
    @Inject
    private ChunkCoordinatorBuilderFactory chunkCoordinatorBuilderFactory;
    @Inject
    private ChunkCoordinatorFactory chunkCoordinatorFactory;
    private ChunkCoordinator chunkCoordinator;

    @Inject
    public BukkitQueueCoordinator(@NonNull World world) {
        super(world);
    }

    public BlockState getBlock(int x, int y, int z) {
        Block block = this.getBukkitWorld().getBlockAt(x, y, z);
        return BukkitBlockUtil.get(block);
    }

    public void start() {
        this.chunkCoordinator.start();
    }

    public void cancel() {
        this.chunkCoordinator.cancel();
    }

    public boolean enqueue() {
        BlockArrayClipboard regenClipboard;
        if (this.isRegen()) {
            BlockVector3 start = BlockVector3.at((int)(this.getRegenStart()[0] << 4), (int)0, (int)(this.getRegenStart()[1] << 4));
            BlockVector3 end = BlockVector3.at((int)((this.getRegenEnd()[0] << 4) + 15), (int)255, (int)((this.getRegenEnd()[1] << 4) + 15));
            CuboidRegion region = new CuboidRegion(start, end);
            regenClipboard = new BlockArrayClipboard((Region)region);
            regenClipboard.setOrigin(start);
            this.getWorld().regenerate((Region)region, (Extent)regenClipboard);
        } else if (this.getRegenRegion() != null) {
            regenClipboard = new BlockArrayClipboard((Region)this.getRegenRegion());
            regenClipboard.setOrigin(this.getRegenRegion().getMinimumPoint());
            this.getWorld().regenerate((Region)this.getRegenRegion(), (Extent)regenClipboard);
        } else {
            regenClipboard = null;
        }
        Consumer<BlockVector2> consumer = this.getChunkConsumer();
        if (consumer == null) {
            consumer = arg_0 -> this.lambda$enqueue$2((Clipboard)regenClipboard, arg_0);
        }
        ArrayList read = new ArrayList();
        if (this.getReadChunks().size() > 0) {
            read.addAll(this.getReadChunks());
        }
        this.chunkCoordinator = this.chunkCoordinatorBuilderFactory.create(this.chunkCoordinatorFactory).inWorld(this.getWorld()).withChunks((Collection)this.getBlockChunks().keySet()).withChunks(read).withInitialBatchSize(3).withMaxIterationTime(40L).withThrowableConsumer(Throwable::printStackTrace).withFinalAction(this.getCompleteTask()).withConsumer(consumer).unloadAfter(this.isUnloadAfter()).withProgressSubscribers((Collection)this.getProgressSubscribers()).build();
        return super.enqueue();
    }

    private void setWorldBlock(int x, int y, int z, @NonNull BaseBlock block, @NonNull BlockVector2 blockVector2, boolean edge) {
        block9: {
            try {
                BlockVector3 loc = BlockVector3.at((int)x, (int)y, (int)z);
                boolean lighting = false;
                switch (this.getLightingMode()) {
                    case NONE: {
                        break;
                    }
                    case PLACEMENT: {
                        lighting = block.getBlockType().getMaterial().getLightValue() > 0;
                        break;
                    }
                    case REPLACEMENT: {
                        lighting = block.getBlockType().getMaterial().getLightValue() > 0 || this.getWorld().getBlock(loc).getBlockType().getMaterial().getLightValue() > 0;
                        break;
                    }
                    default: {
                        lighting = true;
                    }
                }
                SideEffectSet sideEffectSet = lighting ? (edge ? this.edgeLightingSideEffectSet : this.lightingSideEffectSet) : (edge ? this.edgeSideEffectSet : this.noSideEffectSet);
                this.getWorld().setBlock(loc, (BlockStateHolder)block, sideEffectSet);
            }
            catch (WorldEditException ignored) {
                BlockData blockData = BukkitAdapter.adapt((BlockStateHolder)block);
                Chunk chunk = this.getBukkitWorld().getChunkAt(blockVector2.getX(), blockVector2.getZ());
                Block existing = chunk.getBlock(x, y, z);
                BlockState existingBaseBlock = BukkitAdapter.adapt((BlockData)existing.getBlockData());
                if (BukkitBlockUtil.get(existing).equals((Object)existingBaseBlock) && existing.getBlockData().matches(blockData)) {
                    return;
                }
                if (existing.getState() instanceof Container) {
                    ((Container)existing.getState()).getInventory().clear();
                }
                existing.setType(BukkitAdapter.adapt((BlockType)block.getBlockType()), false);
                existing.setBlockData(blockData, false);
                if (!block.hasNbtData()) break block9;
                CompoundTag tag = block.getNbtData();
                StateWrapper sw = new StateWrapper(tag);
                sw.restoreTag(this.getWorld().getName(), existing.getX(), existing.getY(), existing.getZ());
            }
        }
    }

    private org.bukkit.World getBukkitWorld() {
        if (this.bukkitWorld == null) {
            this.bukkitWorld = Bukkit.getWorld((String)this.getWorld().getName());
        }
        return this.bukkitWorld;
    }

    private boolean isEdge(int layer, int x, int y, int z, BlockVector2 blockVector2, LocalChunk localChunk) {
        LocalChunk localChunkZ;
        LocalChunk localChunkX;
        if (layer == 0 || layer == localChunk.getBaseblocks().length - 1) {
            return false;
        }
        if (x == 0 ? (localChunkX = (LocalChunk)this.getBlockChunks().get(blockVector2.withX(blockVector2.getX() - 1))) == null || localChunkX.getBaseblocks()[layer] == null || localChunkX.getBaseblocks()[layer][ChunkUtil.getJ((int)15, (int)y, (int)z)] != null : x == 15 && ((localChunkX = (LocalChunk)this.getBlockChunks().get(blockVector2.withX(blockVector2.getX() + 1))) == null || localChunkX.getBaseblocks()[layer] == null || localChunkX.getBaseblocks()[layer][ChunkUtil.getJ((int)0, (int)y, (int)z)] != null)) {
            return true;
        }
        if (z == 0 ? (localChunkZ = (LocalChunk)this.getBlockChunks().get(blockVector2.withZ(blockVector2.getZ() - 1))) == null || localChunkZ.getBaseblocks()[layer] == null || localChunkZ.getBaseblocks()[layer][ChunkUtil.getJ((int)x, (int)y, (int)15)] != null : z == 15 && ((localChunkZ = (LocalChunk)this.getBlockChunks().get(blockVector2.withZ(blockVector2.getZ() + 1))) == null || localChunkZ.getBaseblocks()[layer] == null || localChunkZ.getBaseblocks()[layer][ChunkUtil.getJ((int)x, (int)y, (int)0)] != null)) {
            return true;
        }
        if (y == 0 ? localChunk.getBaseblocks()[layer - 1] == null || localChunk.getBaseblocks()[layer][ChunkUtil.getJ((int)x, (int)15, (int)z)] != null : y == 15 && (localChunk.getBaseblocks()[layer + 1] == null || localChunk.getBaseblocks()[layer][ChunkUtil.getJ((int)x, (int)0, (int)z)] != null)) {
            return true;
        }
        BaseBlock[] baseBlocks = localChunk.getBaseblocks()[layer];
        if (x > 0 && baseBlocks[ChunkUtil.getJ((int)(x - 1), (int)y, (int)z)] == null) {
            return true;
        }
        if (x < 15 && baseBlocks[ChunkUtil.getJ((int)(x + 1), (int)y, (int)z)] == null) {
            return true;
        }
        if (y > 0 && baseBlocks[ChunkUtil.getJ((int)x, (int)(y - 1), (int)z)] == null) {
            return true;
        }
        if (y < 15 && baseBlocks[ChunkUtil.getJ((int)x, (int)(y + 1), (int)z)] == null) {
            return true;
        }
        if (z > 0 && baseBlocks[ChunkUtil.getJ((int)x, (int)y, (int)(z - 1))] == null) {
            return true;
        }
        return z < 15 && baseBlocks[ChunkUtil.getJ((int)x, (int)y, (int)(z + 1))] == null;
    }

    private boolean isEdgeRegen(int x, int z, BlockVector2 blockVector2) {
        LocalChunk localChunkX;
        if (x == 0 ? (localChunkX = (LocalChunk)this.getBlockChunks().get(blockVector2.withX(blockVector2.getX() - 1))) == null : x == 15 && (localChunkX = (LocalChunk)this.getBlockChunks().get(blockVector2.withX(blockVector2.getX() + 1))) == null) {
            return true;
        }
        if (z == 0) {
            return this.getBlockChunks().get(blockVector2.withZ(blockVector2.getZ() - 1)) == null;
        }
        if (z == 15) {
            return this.getBlockChunks().get(blockVector2.withZ(blockVector2.getZ() + 1)) == null;
        }
        return false;
    }

    private /* synthetic */ void lambda$enqueue$2(Clipboard regenClipboard, BlockVector2 blockVector2) {
        int j;
        int layer;
        LocalChunk localChunk = (LocalChunk)this.getBlockChunks().get(blockVector2);
        boolean isRegenChunk = regenClipboard != null && blockVector2.getBlockX() > this.getRegenStart()[0] && blockVector2.getBlockZ() > this.getRegenStart()[1] && blockVector2.getBlockX() < this.getRegenEnd()[0] && blockVector2.getBlockZ() < this.getRegenEnd()[1];
        int sx = blockVector2.getX() << 4;
        int sz = blockVector2.getZ() << 4;
        if (isRegenChunk) {
            for (layer = 0; layer < 16; ++layer) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            BaseBlock block = regenClipboard.getFullBlock(BlockVector3.at((int)(x += sx), (int)(y += layer << 4), (int)(z += sz)));
                            if (block == null) continue;
                            boolean edge = Settings.QUEUE.UPDATE_EDGES && this.isEdgeRegen(x & 0xF, z & 0xF, blockVector2);
                            this.setWorldBlock(x, y, z, block, blockVector2, edge);
                        }
                    }
                }
            }
        }
        if (localChunk == null) {
            return;
        }
        for (layer = 0; layer < localChunk.getBaseblocks().length; ++layer) {
            BaseBlock[] blocksLayer = localChunk.getBaseblocks()[layer];
            if (blocksLayer == null) continue;
            for (j = 0; j < blocksLayer.length; ++j) {
                BaseBlock block;
                if (blocksLayer[j] == null || (block = blocksLayer[j]) == null) continue;
                int lx = ChunkUtil.getX((int)j);
                int lz = ChunkUtil.getZ((int)j);
                int x = sx + lx;
                int y = ChunkUtil.getY((int)layer, (int)j);
                int z = sz + lz;
                boolean edge = Settings.QUEUE.UPDATE_EDGES && this.isEdge(y >> 4, lx, y & 0xF, lz, blockVector2, localChunk);
                this.setWorldBlock(x, y, z, block, blockVector2, edge);
            }
        }
        for (layer = 0; layer < localChunk.getBaseblocks().length; ++layer) {
            BiomeType[] biomesLayer = localChunk.getBiomes()[layer];
            if (biomesLayer == null) continue;
            for (j = 0; j < biomesLayer.length; ++j) {
                BiomeType biome;
                if (biomesLayer[j] == null || (biome = biomesLayer[j]) == null) continue;
                int x = sx + ChunkUtil.getX((int)j);
                int y = ChunkUtil.getY((int)layer, (int)j);
                int z = sz + ChunkUtil.getZ((int)j);
                this.getWorld().setBiome(BlockVector3.at((int)x, (int)y, (int)z), biome);
            }
        }
        if (localChunk.getTiles().size() > 0) {
            localChunk.getTiles().forEach((blockVector3, tag) -> {
                try {
                    BaseBlock block = this.getWorld().getBlock(blockVector3).toBaseBlock(tag);
                    this.getWorld().setBlock(blockVector3, (BlockStateHolder)block, this.noSideEffectSet);
                }
                catch (WorldEditException ignored) {
                    StateWrapper sw = new StateWrapper((CompoundTag)tag);
                    sw.restoreTag(this.getWorld().getName(), blockVector3.getX(), blockVector3.getY(), blockVector3.getZ());
                }
            });
        }
        if (localChunk.getEntities().size() > 0) {
            localChunk.getEntities().forEach((location, entity) -> this.getWorld().createEntity(location, entity));
        }
    }
}

