/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.permissions;

import com.plotsquared.bukkit.player.BukkitOfflinePlayer;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.core.permissions.ConsolePermissionProfile;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.permissions.PermissionProfile;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VaultPermissionHandler
implements PermissionHandler {
    private Permission permissions;

    public void initialize() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            throw new IllegalStateException("Vault is not present on the server");
        }
        RegisteredServiceProvider permissionProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            this.permissions = (Permission)permissionProvider.getProvider();
        }
    }

    public @NonNull Optional<PermissionProfile> getPermissionProfile(@NonNull PlotPlayer<?> playerPlotPlayer) {
        if (playerPlotPlayer instanceof BukkitPlayer) {
            BukkitPlayer bukkitPlayer = (BukkitPlayer)playerPlotPlayer;
            return Optional.of(new VaultPermissionProfile((OfflinePlayer)bukkitPlayer.getPlatformPlayer()));
        }
        if (playerPlotPlayer instanceof ConsolePlayer) {
            return Optional.of(ConsolePermissionProfile.INSTANCE);
        }
        return Optional.empty();
    }

    public @NonNull Optional<PermissionProfile> getPermissionProfile(@NonNull OfflinePlotPlayer offlinePlotPlayer) {
        if (offlinePlotPlayer instanceof BukkitOfflinePlayer) {
            return Optional.of(new VaultPermissionProfile(((BukkitOfflinePlayer)offlinePlotPlayer).player));
        }
        return Optional.empty();
    }

    public @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    PermissionHandler.PermissionHandlerCapability> getCapabilities() {
        return EnumSet.of(PermissionHandler.PermissionHandlerCapability.PER_WORLD_PERMISSIONS, PermissionHandler.PermissionHandlerCapability.ONLINE_PERMISSIONS, PermissionHandler.PermissionHandlerCapability.OFFLINE_PERMISSIONS);
    }

    private final class VaultPermissionProfile
    implements PermissionProfile {
        private final OfflinePlayer offlinePlayer;

        private VaultPermissionProfile(OfflinePlayer offlinePlayer) {
            this.offlinePlayer = offlinePlayer;
        }

        public boolean hasPermission(@Nullable String world, @NonNull String permission) {
            if (VaultPermissionHandler.this.permissions == null) {
                return false;
            }
            if (world == null && this.offlinePlayer instanceof BukkitPlayer) {
                return VaultPermissionHandler.this.permissions.playerHas(((BukkitPlayer)this.offlinePlayer).getPlatformPlayer(), permission);
            }
            return VaultPermissionHandler.this.permissions.playerHas(world, this.offlinePlayer, permission);
        }

        public boolean hasKeyedPermission(@Nullable String world, @NonNull String stub, @NonNull String key) {
            if (VaultPermissionHandler.this.permissions == null) {
                return false;
            }
            if (world == null && this.offlinePlayer instanceof BukkitPlayer) {
                return VaultPermissionHandler.this.permissions.playerHas(((BukkitPlayer)this.offlinePlayer).getPlatformPlayer(), stub + ".*") || VaultPermissionHandler.this.permissions.playerHas(((BukkitPlayer)this.offlinePlayer).getPlatformPlayer(), stub + "." + key);
            }
            return VaultPermissionHandler.this.permissions.playerHas(world, this.offlinePlayer, stub + ".*") || VaultPermissionHandler.this.permissions.playerHas(world, this.offlinePlayer, stub + "." + key);
        }
    }
}

