/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.managers;

import com.google.inject.Singleton;
import com.plotsquared.bukkit.managers.BukkitWorldManager;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import se.hyperver.hyperverse.Hyperverse;
import se.hyperver.hyperverse.world.WorldConfiguration;
import se.hyperver.hyperverse.world.WorldConfigurationBuilder;
import se.hyperver.hyperverse.world.WorldFeatures;
import se.hyperver.hyperverse.world.WorldType;

@Singleton
public class HyperverseWorldManager
extends BukkitWorldManager {
    @Override
    public @Nullable World handleWorldCreation(@NonNull String worldName, @Nullable String generator) {
        this.setGenerator(worldName, generator);
        WorldConfigurationBuilder worldConfigurationBuilder = WorldConfiguration.builder().setName(worldName).setType(WorldType.OVER_WORLD);
        if (generator != null) {
            worldConfigurationBuilder.setGenerator(generator).setWorldFeatures(WorldFeatures.FLATLAND);
        }
        try {
            return Hyperverse.getApi().createWorld(worldConfigurationBuilder.createWorldConfiguration()).getBukkitWorld();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getName() {
        return "bukkit-hyperverse";
    }
}

