/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkEvent;
import org.bukkit.event.world.ChunkLoadEvent;

public class SingleWorldListener
implements Listener {
    private final Method methodGetHandleChunk;
    private Field shouldSave;

    public SingleWorldListener() throws Exception {
        ReflectionUtils.RefClass classCraftChunk = ReflectionUtils.getRefClass((String)"{cb}.CraftChunk");
        this.methodGetHandleChunk = classCraftChunk.getMethod("getHandle", new Object[0]).getRealMethod();
        try {
            if (PlotSquared.platform().serverVersion()[1] < 17) {
                ReflectionUtils.RefClass classChunk = ReflectionUtils.getRefClass((String)"{nms}.Chunk");
                this.shouldSave = PlotSquared.platform().serverVersion()[1] == 13 ? classChunk.getField("mustSave").getRealField() : classChunk.getField("s").getRealField();
            } else {
                ReflectionUtils.RefClass classChunk = ReflectionUtils.getRefClass((String)"net.minecraft.world.level.chunk.Chunk");
                this.shouldSave = classChunk.getField("r").getRealField();
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void markChunkAsClean(Chunk chunk) {
        try {
            Object nmsChunk = this.methodGetHandleChunk.invoke((Object)chunk, new Object[0]);
            if (this.shouldSave != null) {
                this.shouldSave.set(nmsChunk, false);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void handle(ChunkEvent event) {
        World world = event.getWorld();
        String name = world.getName();
        PlotAreaManager man = PlotSquared.get().getPlotAreaManager();
        if (!(man instanceof SinglePlotAreaManager)) {
            return;
        }
        if (!SinglePlotArea.isSinglePlotWorld((String)name)) {
            return;
        }
        this.markChunkAsClean(event.getChunk());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChunkLoad(ChunkLoadEvent event) {
        this.handle((ChunkEvent)event);
    }
}

