/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.google.inject.Inject;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitEntityUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotHandler;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.Permissions;
import net.kyori.adventure.text.minimessage.Template;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ProjectileEventListener
implements Listener {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public ProjectileEventListener(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        this.onProjectileHit((ProjectileHitEvent)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        ThrownPotion damager = event.getPotion();
        Location location = BukkitUtil.adapt(damager.getLocation());
        if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
            return;
        }
        int count = 0;
        for (LivingEntity victim : event.getAffectedEntities()) {
            if (BukkitEntityUtil.entityDamage((Entity)damager, (Entity)victim)) continue;
            event.setIntensity(victim, 0.0);
            ++count;
        }
        if (count > 0 && count == event.getAffectedEntities().size()) {
            event.setCancelled(true);
        } else {
            this.onProjectileHit((ProjectileHitEvent)event);
        }
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Projectile entity = event.getEntity();
        ProjectileSource shooter = entity.getShooter();
        if (!(shooter instanceof Player)) {
            return;
        }
        Location location = BukkitUtil.adapt(entity.getLocation());
        if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
            return;
        }
        BukkitPlayer pp = BukkitUtil.adapt((Player)shooter);
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_ROAD)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_PROJECTILE_ROAD))});
                entity.remove();
                event.setCancelled(true);
            }
        } else if (!plot.hasOwner()) {
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED))});
                entity.remove();
                event.setCancelled(true);
            }
        } else if (!plot.isAdded(pp.getUUID()) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_OTHER)) {
            pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_PROJECTILE_OTHER))});
            entity.remove();
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile entity = event.getEntity();
        Location location = BukkitUtil.adapt(entity.getLocation());
        if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
            return;
        }
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getPlot(location);
        ProjectileSource shooter = entity.getShooter();
        if (shooter instanceof Player) {
            BukkitPlayer pp = BukkitUtil.adapt((Player)shooter);
            if (plot == null) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)) {
                    entity.remove();
                    event.setCancelled(true);
                }
                return;
            }
            if (plot.isAdded(pp.getUUID()) || Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_OTHER)) {
                return;
            }
            entity.remove();
            event.setCancelled(true);
            return;
        }
        if (!(shooter instanceof Entity) && shooter != null) {
            if (plot == null) {
                entity.remove();
                event.setCancelled(true);
                return;
            }
            Location sLoc = BukkitUtil.adapt(((BlockProjectileSource)shooter).getBlock().getLocation());
            if (!area.contains(sLoc.getX(), sLoc.getZ())) {
                entity.remove();
                event.setCancelled(true);
                return;
            }
            Plot sPlot = area.getOwnedPlotAbs(sLoc);
            if (sPlot == null || !PlotHandler.sameOwners((Plot)plot, (Plot)sPlot)) {
                entity.remove();
                event.setCancelled(true);
                return;
            }
        }
    }
}

