/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.google.common.collect.Iterables;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.ForcefieldFlag;
import com.plotsquared.core.util.Permissions;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ForceFieldListener {
    private static Set<PlotPlayer<?>> getNearbyPlayers(Player player, Plot plot) {
        HashSet players = new HashSet();
        for (Player nearPlayer : Iterables.filter((Iterable)player.getNearbyEntities(5.0, 5.0, 5.0), Player.class)) {
            BukkitPlayer plotPlayer = BukkitUtil.adapt(nearPlayer);
            if (plotPlayer == null || !plot.equals((Object)plotPlayer.getCurrentPlot()) || plot.isAdded(plotPlayer.getUUID())) continue;
            players.add(plotPlayer);
        }
        return players;
    }

    private static PlotPlayer<?> hasNearbyPermitted(Player player, Plot plot) {
        for (Player nearPlayer : Iterables.filter((Iterable)player.getNearbyEntities(5.0, 5.0, 5.0), Player.class)) {
            BukkitPlayer plotPlayer = BukkitUtil.adapt(nearPlayer);
            if (plotPlayer == null || !plot.equals((Object)plotPlayer.getCurrentPlot()) || !plot.isAdded(plotPlayer.getUUID())) continue;
            return plotPlayer;
        }
        return null;
    }

    private static Vector calculateVelocity(PlotPlayer<?> player, PlotPlayer<?> e) {
        Location playerLocation = player.getLocationFull();
        Location oPlayerLocation = e.getLocation();
        double playerX = playerLocation.getX();
        double playerY = playerLocation.getY();
        double playerZ = playerLocation.getZ();
        double oPlayerX = oPlayerLocation.getX();
        double oPlayerY = oPlayerLocation.getY();
        double oPlayerZ = oPlayerLocation.getZ();
        double x = 0.0;
        if (playerX < oPlayerX) {
            x = 1.0;
        } else if (playerX > oPlayerX) {
            x = -1.0;
        }
        double y = 0.0;
        if (playerY < oPlayerY) {
            y = 0.5;
        } else if (playerY > oPlayerY) {
            y = -0.5;
        }
        double z = 0.0;
        if (playerZ < oPlayerZ) {
            z = 1.0;
        } else if (playerZ > oPlayerZ) {
            z = -1.0;
        }
        return new Vector(x, y, z);
    }

    public static void handleForcefield(Player player, PlotPlayer<?> plotPlayer, Plot plot) {
        if (((Boolean)plot.getFlag(ForcefieldFlag.class)).booleanValue()) {
            UUID uuid = plotPlayer.getUUID();
            if (plot.isAdded(uuid)) {
                Set<PlotPlayer<?>> players = ForceFieldListener.getNearbyPlayers(player, plot);
                for (PlotPlayer<?> oPlayer : players) {
                    if (Permissions.hasPermission(oPlayer, (Permission)Permission.PERMISSION_ADMIN_ENTRY_FORCEFIELD)) continue;
                    ((BukkitPlayer)oPlayer).player.setVelocity(ForceFieldListener.calculateVelocity(plotPlayer, oPlayer));
                }
            } else {
                PlotPlayer<?> oPlayer = ForceFieldListener.hasNearbyPermitted(player, plot);
                if (oPlayer == null) {
                    return;
                }
                if (!Permissions.hasPermission(plotPlayer, (Permission)Permission.PERMISSION_ADMIN_ENTRY_FORCEFIELD)) {
                    player.setVelocity(ForceFieldListener.calculateVelocity(oPlayer, plotPlayer));
                }
            }
        }
    }
}

