/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.google.inject.Inject;
import com.plotsquared.bukkit.listener.BlockEventListener;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitEntityUtil;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.listener.PlayerBlockEventType;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotHandler;
import com.plotsquared.core.plot.flag.implementations.DisablePhysicsFlag;
import com.plotsquared.core.plot.flag.implementations.EntityChangeBlockFlag;
import com.plotsquared.core.plot.flag.implementations.ExplosionFlag;
import com.plotsquared.core.plot.flag.implementations.InvincibleFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.Permissions;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.checkerframework.checker.nullness.qual.NonNull;

public class EntityEventListener
implements Listener {
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private float lastRadius;

    @Inject
    public EntityEventListener(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityCombustByEntity(EntityCombustByEntityEvent event) {
        EntityDamageByEntityEvent eventChange = new EntityDamageByEntityEvent(event.getCombuster(), event.getEntity(), EntityDamageEvent.DamageCause.FIRE_TICK, (double)event.getDuration());
        this.onEntityDamageByEntityEvent(eventChange);
        if (eventChange.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        Location location = BukkitUtil.adapt(damager.getLocation());
        if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
            return;
        }
        Entity victim = event.getEntity();
        if (!BukkitEntityUtil.entityDamage(damager, victim, event.getCause())) {
            Ageable ageable;
            if (event.isCancelled() && victim instanceof Ageable && (ageable = (Ageable)victim).getAge() == -24000) {
                ageable.setAge(0);
                ageable.setAdult();
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void creatureSpawnEvent(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        Location location = BukkitUtil.adapt(entity.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        switch (reason.toString()) {
            case "DISPENSE_EGG": 
            case "EGG": 
            case "OCELOT_BABY": 
            case "SPAWNER_EGG": {
                if (area.isSpawnEggs()) break;
                event.setCancelled(true);
                return;
            }
            case "REINFORCEMENTS": 
            case "NATURAL": 
            case "MOUNT": 
            case "PATROL": 
            case "RAID": 
            case "SHEARED": 
            case "SILVERFISH_BLOCK": 
            case "TRAP": 
            case "VILLAGE_DEFENSE": 
            case "VILLAGE_INVASION": 
            case "BEEHIVE": 
            case "CHUNK_GEN": {
                if (area.isMobSpawning()) break;
                event.setCancelled(true);
                return;
            }
            case "BREEDING": {
                if (area.isSpawnBreeding()) break;
                event.setCancelled(true);
                return;
            }
            case "BUILD_IRONGOLEM": 
            case "BUILD_SNOWMAN": 
            case "BUILD_WITHER": 
            case "CUSTOM": {
                if (area.isSpawnCustom() || entity.getType() == EntityType.ARMOR_STAND) break;
                event.setCancelled(true);
                return;
            }
            case "SPAWNER": {
                if (area.isMobSpawnerSpawning()) break;
                event.setCancelled(true);
                return;
            }
        }
        Plot plot = area.getOwnedPlotAbs(location);
        if (plot == null) {
            if (!area.isMobSpawning()) {
                event.setCancelled(true);
            }
            return;
        }
        if (BukkitEntityUtil.checkEntity((Entity)entity, plot)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityFall(EntityChangeBlockEvent event) {
        if (event.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        Block block = event.getBlock();
        World world = block.getWorld();
        String worldName = world.getName();
        if (!this.plotAreaManager.hasPlotArea(worldName)) {
            return;
        }
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlotAbs(location);
        if (plot == null || ((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
            event.setCancelled(true);
            if (plot != null) {
                if (block.getType().hasGravity()) {
                    BlockEventListener.sendBlockChange(block.getLocation(), block.getBlockData());
                }
                plot.debug("Falling block event was cancelled because disable-physics = true");
            }
            return;
        }
        if (event.getTo().hasGravity()) {
            Entity entity = event.getEntity();
            List meta = entity.getMetadata("plot");
            if (meta.isEmpty()) {
                return;
            }
            Plot origin = (Plot)((MetadataValue)meta.get(0)).value();
            if (origin != null && !origin.equals((Object)plot)) {
                event.setCancelled(true);
                entity.remove();
            }
        } else if (event.getTo() == Material.AIR) {
            event.getEntity().setMetadata("plot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)plot));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Location location = BukkitUtil.adapt(event.getEntity().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (area.isRoadFlags() && ((Boolean)area.getRoadFlag(InvincibleFlag.class)).booleanValue()) {
                event.setCancelled(true);
            }
            return;
        }
        if (((Boolean)plot.getFlag(InvincibleFlag.class)).booleanValue()) {
            plot.debug(event.getEntity().getName() + " could not take damage because invincible = true");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBigBoom(EntityExplodeEvent event) {
        Location location = BukkitUtil.adapt(event.getLocation());
        PlotArea area = location.getPlotArea();
        boolean plotArea = location.isPlotArea();
        if (!plotArea) {
            if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
                return;
            }
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot != null) {
            if (((Boolean)plot.getFlag(ExplosionFlag.class)).booleanValue()) {
                List meta = event.getEntity().getMetadata("plot");
                Plot origin = meta.isEmpty() ? plot : (Plot)((MetadataValue)meta.get(0)).value();
                if (this.lastRadius != 0.0f) {
                    List nearby = event.getEntity().getNearbyEntities((double)this.lastRadius, (double)this.lastRadius, (double)this.lastRadius);
                    for (Entity near : nearby) {
                        if (!(near instanceof TNTPrimed) && !near.getType().equals((Object)EntityType.MINECART_TNT) || near.hasMetadata("plot")) continue;
                        near.setMetadata("plot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)plot));
                    }
                    this.lastRadius = 0.0f;
                }
                Iterator iterator = event.blockList().iterator();
                while (iterator.hasNext()) {
                    Block block = (Block)iterator.next();
                    location = BukkitUtil.adapt(block.getLocation());
                    if (area.contains(location.getX(), location.getZ()) && origin.equals((Object)area.getOwnedPlot(location))) continue;
                    iterator.remove();
                }
                return;
            }
            plot.debug("Explosion was cancelled because explosion = false");
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPeskyMobsChangeTheWorldLikeWTFEvent(EntityChangeBlockEvent event) {
        Plot plot;
        Entity e = event.getEntity();
        Material type = event.getBlock().getType();
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        if (e instanceof FallingBlock) {
            return;
        }
        if (e instanceof Boat) {
            if (type == Material.LILY_PAD) {
                return;
            }
        } else {
            if (e instanceof Player) {
                Player player = (Player)e;
                BukkitPlayer pp = BukkitUtil.adapt(player);
                if (type.toString().equals("POWDER_SNOW")) {
                    BlockType blockType = BukkitAdapter.asBlockType((Material)type);
                    if (!this.eventDispatcher.checkPlayerBlockEvent((PlotPlayer)pp, PlayerBlockEventType.TRIGGER_PHYSICAL, location, blockType, true)) {
                        event.setCancelled(true);
                    }
                    return;
                }
                return;
            }
            if (e instanceof Projectile) {
                Projectile entity = (Projectile)e;
                Plot plot2 = area.getPlot(location);
                ProjectileSource shooter = entity.getShooter();
                if (shooter instanceof Player) {
                    BukkitPlayer pp = BukkitUtil.adapt((Player)shooter);
                    if (plot2 == null) {
                        if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)) {
                            entity.remove();
                            event.setCancelled(true);
                        }
                        return;
                    }
                    if (plot2.isAdded(pp.getUUID()) || Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_OTHER)) {
                        return;
                    }
                    entity.remove();
                    event.setCancelled(true);
                    return;
                }
                if (!(shooter instanceof Entity) && shooter != null) {
                    if (plot2 == null) {
                        entity.remove();
                        event.setCancelled(true);
                        return;
                    }
                    Location sLoc = BukkitUtil.adapt(((BlockProjectileSource)shooter).getBlock().getLocation());
                    if (!area.contains(sLoc.getX(), sLoc.getZ())) {
                        entity.remove();
                        event.setCancelled(true);
                        return;
                    }
                    Plot sPlot = area.getOwnedPlotAbs(sLoc);
                    if (sPlot == null || !PlotHandler.sameOwners((Plot)plot2, (Plot)sPlot)) {
                        entity.remove();
                        event.setCancelled(true);
                    }
                    return;
                }
            }
        }
        if ((plot = area.getOwnedPlot(location)) != null && !((Boolean)plot.getFlag(EntityChangeBlockFlag.class)).booleanValue()) {
            plot.debug(e.getType() + " could not change block because entity-change-block = false");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPrime(ExplosionPrimeEvent event) {
        this.lastRadius = event.getRadius() + 1.0f;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onVehicleCreate(VehicleCreateEvent event) {
        Vehicle entity = event.getVehicle();
        Location location = BukkitUtil.adapt(entity.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlotAbs(location);
        if (plot == null || BukkitEntityUtil.checkEntity((Entity)entity, plot)) {
            entity.remove();
            return;
        }
        if (Settings.Enabled_Components.KILL_ROAD_VEHICLES) {
            entity.setMetadata("plot", (MetadataValue)new FixedMetadataValue((Plugin)PlotSquared.platform(), (Object)plot));
        }
    }
}

