/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.google.inject.Inject;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.CopperOxideFlag;
import com.plotsquared.core.plot.flag.implementations.MiscInteractFlag;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockReceiveGameEvent;

public class BlockEventListener117
implements Listener {
    @Inject
    public BlockEventListener117() {
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockReceiveGame(BlockReceiveGameEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        Entity entity = event.getEntity();
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(MiscInteractFlag.class)).booleanValue()) {
            Object plotPlayer;
            Entity entity2 = entity;
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                plotPlayer = BukkitUtil.adapt(player);
                if (plot != null && !plot.isAdded(((BukkitPlayer)((Object)plotPlayer)).getUUID())) {
                    plot.debug(((BukkitPlayer)((Object)plotPlayer)).getName() + " couldn't trigger sculk sensors because misc-interact = false");
                    event.setCancelled(true);
                }
                return;
            }
            plotPlayer = entity;
            if (plotPlayer instanceof Item) {
                Item item = (Item)plotPlayer;
                UUID itemThrower = item.getThrower();
                if (plot != null && !plot.isAdded(itemThrower) && !plot.isAdded(itemThrower)) {
                    plot.debug("A thrown item couldn't trigger sculk sensors because misc-interact = false");
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockFertilize(BlockFertilizeEvent event) {
        Plot plot;
        int i;
        Block block = event.getBlock();
        List blocks = event.getBlocks();
        Location location = BukkitUtil.adapt(((BlockState)blocks.get(0)).getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            for (int i2 = blocks.size() - 1; i2 >= 0; --i2) {
                location = BukkitUtil.adapt(((BlockState)blocks.get(i2)).getLocation());
                if (!location.isPlotArea()) continue;
                blocks.remove(i2);
            }
            return;
        }
        Plot origin = area.getOwnedPlot(location);
        if (origin == null) {
            event.setCancelled(true);
            return;
        }
        for (i = blocks.size() - 1; i >= 0; --i) {
            location = BukkitUtil.adapt(((BlockState)blocks.get(i)).getLocation());
            if (!area.contains(location.getX(), location.getZ())) {
                blocks.remove(i);
                continue;
            }
            plot = area.getOwnedPlot(location);
            if (Objects.equals(plot, origin)) continue;
            event.getBlocks().remove(i);
        }
        origin = area.getPlot(location);
        if (origin == null) {
            event.setCancelled(true);
            return;
        }
        for (i = blocks.size() - 1; i >= 0; --i) {
            location = BukkitUtil.adapt(((BlockState)blocks.get(i)).getLocation());
            plot = area.getOwnedPlot(location);
            if (Objects.equals(plot, origin) || plot.isMerged() || origin.isMerged()) continue;
            event.getBlocks().remove(i);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        if (location.isPlotRoad()) {
            event.setCancelled(true);
            return;
        }
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            return;
        }
        switch (event.getNewState().getType()) {
            case COPPER_BLOCK: 
            case EXPOSED_COPPER: 
            case WEATHERED_COPPER: 
            case OXIDIZED_COPPER: 
            case CUT_COPPER: 
            case EXPOSED_CUT_COPPER: 
            case WEATHERED_CUT_COPPER: 
            case OXIDIZED_CUT_COPPER: 
            case CUT_COPPER_STAIRS: 
            case EXPOSED_CUT_COPPER_STAIRS: 
            case WEATHERED_CUT_COPPER_STAIRS: 
            case OXIDIZED_CUT_COPPER_STAIRS: 
            case CUT_COPPER_SLAB: 
            case EXPOSED_CUT_COPPER_SLAB: 
            case WEATHERED_CUT_COPPER_SLAB: 
            case OXIDIZED_CUT_COPPER_SLAB: {
                if (((Boolean)plot.getFlag(CopperOxideFlag.class)).booleanValue()) break;
                plot.debug("Copper could not oxide because copper-oxide = false");
                event.setCancelled(true);
            }
        }
    }
}

