/*
 *       _____  _       _    _____                                _
 *      |  __ \| |     | |  / ____|                              | |
 *      | |__) | | ___ | |_| (___   __ _ _   _  __ _ _ __ ___  __| |
 *      |  ___/| |/ _ \| __|\___ \ / _` | | | |/ _` | '__/ _ \/ _` |
 *      | |    | | (_) | |_ ____) | (_| | |_| | (_| | | |  __/ (_| |
 *      |_|    |_|\___/ \__|_____/ \__, |\__,_|\__,_|_|  \___|\__,_|
 *                                    | |
 *                                    |_|
 *            PlotSquared plot management system for Minecraft
 *                  Copyright (C) 2021 IntellectualSites
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.plotsquared.bukkit.util.task;

import com.plotsquared.core.util.task.TaskTime;
import org.checkerframework.checker.index.qual.NonNegative;

/**
 * Naive time converter that assumes that all ticks are 50 milliseconds
 */
public final class SpigotTimeConverter implements TaskTime.TimeConverter {

    private static final long MS_PER_TICKS = 50L;

    @Override
    public long msToTicks(@NonNegative final long ms) {
        return Math.max(1L, ms / MS_PER_TICKS);
    }

    @Override
    public long ticksToMs(@NonNegative final long ticks) {
        return Math.max(1L, ticks * MS_PER_TICKS);
    }

}
