/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.bukkit.util.ContentMap;
import com.plotsquared.core.generator.AugmentedUtils;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.PlotLoc;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.ScopedQueueCoordinator;
import com.plotsquared.core.util.ChunkManager;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.entity.EntityCategories;
import com.plotsquared.core.util.task.RunnableVal;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.papermc.lib.PaperLib;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitRegionManager
extends RegionManager {
    private final GlobalBlockQueue blockQueue;

    @Inject
    public BukkitRegionManager(@NonNull WorldUtil worldUtil, @NonNull GlobalBlockQueue blockQueue, @NonNull ProgressSubscriberFactory subscriberFactory) {
        super(worldUtil, blockQueue, subscriberFactory);
        this.blockQueue = blockQueue;
    }

    public boolean handleClear(@NonNull Plot plot, @Nullable Runnable whenDone, @NonNull PlotManager manager, @Nullable PlotPlayer<?> player) {
        return false;
    }

    public int[] countEntities(@NonNull Plot plot) {
        int[] existing = (int[])plot.getMeta("EntityCount");
        if (existing != null && System.currentTimeMillis() - (Long)plot.getMeta("EntityCountTime") < 1000L) {
            return existing;
        }
        PlotArea area = plot.getArea();
        org.bukkit.World world = BukkitUtil.getWorld(area.getWorldName());
        Location bot = plot.getBottomAbs();
        Location top = plot.getTopAbs();
        int bx = bot.getX() >> 4;
        int bz = bot.getZ() >> 4;
        int tx = top.getX() >> 4;
        int tz = top.getZ() >> 4;
        int size = tx - bx << 4;
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        for (int X = bx; X <= tx; ++X) {
            for (int Z = bz; Z <= tz; ++Z) {
                if (!world.isChunkLoaded(X, Z)) continue;
                chunks.add(world.getChunkAt(X, Z));
            }
        }
        boolean doWhole = false;
        List entities = null;
        if (size > 200 && chunks.size() > 200 && (entities = world.getEntities()).size() < 16 + size / 8) {
            doWhole = true;
        }
        int[] count = new int[6];
        if (doWhole) {
            for (Entity entity : entities) {
                org.bukkit.Location location = entity.getLocation();
                PaperLib.getChunkAtAsync((org.bukkit.Location)location).thenAccept(chunk -> {
                    if (chunks.contains(chunk)) {
                        int X = chunk.getX();
                        int Z = chunk.getZ();
                        if (X > bx && X < tx && Z > bz && Z < tz) {
                            this.count(count, entity);
                        } else {
                            Plot other = area.getPlot(BukkitUtil.adapt(location));
                            if (plot.equals((Object)other)) {
                                this.count(count, entity);
                            }
                        }
                    }
                });
            }
        } else {
            for (Chunk chunk2 : chunks) {
                Entity[] entities1;
                int X = chunk2.getX();
                int Z = chunk2.getZ();
                for (Entity entity : entities1 = chunk2.getEntities()) {
                    if (X == bx || X == tx || Z == bz || Z == tz) {
                        Plot other = area.getPlot(BukkitUtil.adapt(entity.getLocation()));
                        if (!plot.equals((Object)other)) continue;
                        this.count(count, entity);
                        continue;
                    }
                    this.count(count, entity);
                }
            }
        }
        return count;
    }

    public boolean regenerateRegion(@NonNull Location pos1, @NonNull Location pos2, boolean ignoreAugment, @Nullable Runnable whenDone) {
        BukkitWorld world = (BukkitWorld)this.worldUtil.getWeWorld(pos1.getWorldName());
        int p1x = pos1.getX();
        int p1z = pos1.getZ();
        int p2x = pos2.getX();
        int p2z = pos2.getZ();
        int bcx = p1x >> 4;
        int bcz = p1z >> 4;
        int tcx = p2x >> 4;
        int tcz = p2z >> 4;
        QueueCoordinator queue = this.blockQueue.getNewQueue((World)world);
        QueueCoordinator regenQueue = this.blockQueue.getNewQueue((World)world);
        queue.addReadChunks(new CuboidRegion(pos1.getBlockVector3(), pos2.getBlockVector3()).getChunks());
        queue.setChunkConsumer(chunk -> {
            int zzt2;
            int zzb2;
            int xxt2;
            int xxb2;
            int x = chunk.getX();
            int z = chunk.getZ();
            int xxb = x << 4;
            int zzb = z << 4;
            int xxt = xxb + 15;
            int zzt = zzb + 15;
            if (xxb >= p1x && xxt <= p2x && zzb >= p1z && zzt <= p2z) {
                AugmentedUtils.bypass((boolean)ignoreAugment, () -> regenQueue.regenChunk(chunk.getX(), chunk.getZ()));
                return;
            }
            boolean checkX1 = false;
            if (x == bcx) {
                xxb2 = p1x - 1;
                checkX1 = true;
            } else {
                xxb2 = xxb;
            }
            boolean checkX2 = false;
            if (x == tcx) {
                xxt2 = p2x + 1;
                checkX2 = true;
            } else {
                xxt2 = xxt;
            }
            boolean checkZ1 = false;
            if (z == bcz) {
                zzb2 = p1z - 1;
                checkZ1 = true;
            } else {
                zzb2 = zzb;
            }
            boolean checkZ2 = false;
            if (z == tcz) {
                zzt2 = p2z + 1;
                checkZ2 = true;
            } else {
                zzt2 = zzt;
            }
            final ContentMap map = new ContentMap();
            if (checkX1) {
                map.saveRegion(world, xxb, xxb2, zzb2, zzt2);
            }
            if (checkX2) {
                map.saveRegion(world, xxt2, xxt, zzb2, zzt2);
            }
            if (checkZ1) {
                map.saveRegion(world, xxb2, xxt2, zzb, zzb2);
            }
            if (checkZ2) {
                map.saveRegion(world, xxb2, xxt2, zzt2, zzt);
            }
            if (checkX1 && checkZ1) {
                map.saveRegion(world, xxb, xxb2, zzb, zzb2);
            }
            if (checkX2 && checkZ1) {
                map.saveRegion(world, xxt2, xxt, zzb, zzb2);
            }
            if (checkX1 && checkZ2) {
                map.saveRegion(world, xxb, xxb2, zzt2, zzt);
            }
            if (checkX2 && checkZ2) {
                map.saveRegion(world, xxt2, xxt, zzt2, zzt);
            }
            CuboidRegion currentPlotClear = new CuboidRegion(pos1.getBlockVector3(), pos2.getBlockVector3());
            map.saveEntitiesOut(Bukkit.getWorld((String)world.getName()).getChunkAt(x, z), currentPlotClear);
            AugmentedUtils.bypass((boolean)ignoreAugment, () -> ChunkManager.setChunkInPlotArea(null, (RunnableVal)new RunnableVal<ScopedQueueCoordinator>(){

                public void run(ScopedQueueCoordinator value) {
                    Location min = value.getMin();
                    int bx = min.getX();
                    int bz = min.getZ();
                    for (int x1 = 0; x1 < 16; ++x1) {
                        for (int z1 = 0; z1 < 16; ++z1) {
                            PlotLoc plotLoc = new PlotLoc(bx + x1, bz + z1);
                            BaseBlock[] ids = map.allBlocks.get(plotLoc);
                            if (ids == null) continue;
                            int minY = value.getMin().getY();
                            for (int yIndex = 0; yIndex < ids.length; ++yIndex) {
                                int y = yIndex + minY;
                                BaseBlock id = ids[yIndex];
                                if (id != null) {
                                    value.setBlock(x1, y, z1, id);
                                    continue;
                                }
                                value.setBlock(x1, y, z1, BlockTypes.AIR.getDefaultState());
                            }
                        }
                    }
                }
            }, (String)world.getName(), (BlockVector2)chunk));
            map.restoreEntities(Bukkit.getWorld((String)world.getName()));
        });
        regenQueue.setCompleteTask(whenDone);
        queue.setCompleteTask(() -> ((QueueCoordinator)regenQueue).enqueue());
        queue.enqueue();
        return true;
    }

    public void clearAllEntities(@NonNull Location pos1, @NonNull Location pos2) {
        String world = pos1.getWorldName();
        org.bukkit.World bukkitWorld = BukkitUtil.getWorld(world);
        ArrayList entities = bukkitWorld != null ? new ArrayList(bukkitWorld.getEntities()) : new ArrayList();
        int bx = pos1.getX();
        int bz = pos1.getZ();
        int tx = pos2.getX();
        int tz = pos2.getZ();
        for (Entity entity : entities) {
            org.bukkit.Location location;
            if (!(!(entity instanceof Player) && (location = entity.getLocation()).getX() >= (double)bx && location.getX() <= (double)tx && location.getZ() >= (double)bz && location.getZ() <= (double)tz && !entity.hasMetadata("ps-tmp-teleport"))) continue;
            entity.remove();
        }
    }

    private void count(int[] count, @NonNull Entity entity) {
        com.sk89q.worldedit.world.entity.EntityType entityType = BukkitAdapter.adapt((EntityType)entity.getType());
        if (EntityCategories.PLAYER.contains((Keyed)entityType)) {
            return;
        }
        if (EntityCategories.PROJECTILE.contains((Keyed)entityType) || EntityCategories.OTHER.contains((Keyed)entityType) || EntityCategories.HANGING.contains((Keyed)entityType)) {
            count[5] = count[5] + 1;
        } else if (EntityCategories.ANIMAL.contains((Keyed)entityType) || EntityCategories.VILLAGER.contains((Keyed)entityType) || EntityCategories.TAMEABLE.contains((Keyed)entityType)) {
            count[3] = count[3] + 1;
            count[1] = count[1] + 1;
        } else if (EntityCategories.VEHICLE.contains((Keyed)entityType)) {
            count[4] = count[4] + 1;
        } else if (EntityCategories.HOSTILE.contains((Keyed)entityType)) {
            count[3] = count[3] + 1;
            count[2] = count[2] + 1;
        }
        count[0] = count[0] + 1;
    }
}

