/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import com.destroystokyo.paper.event.entity.SlimePathfindEvent;
import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.inject.Inject;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.flag.implementations.BeaconEffectsFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.ProjectilesFlag;
import com.plotsquared.core.plot.flag.types.BooleanFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlotFlagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import net.kyori.adventure.text.minimessage.Template;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.TileState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PaperListener
implements Listener {
    private final PlotAreaManager plotAreaManager;
    private Chunk lastChunk;

    @Inject
    public PaperListener(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @EventHandler
    public void onEntityPathfind(EntityPathfindEvent event) {
        Plot fplot;
        if (!Settings.Paper_Components.ENTITY_PATHING) {
            return;
        }
        Location toLoc = BukkitUtil.adapt(event.getLoc());
        Location fromLoc = BukkitUtil.adapt(event.getEntity().getLocation());
        PlotArea tarea = toLoc.getPlotArea();
        if (tarea == null) {
            return;
        }
        PlotArea farea = fromLoc.getPlotArea();
        if (farea == null) {
            return;
        }
        if (tarea != farea) {
            event.setCancelled(true);
            return;
        }
        Plot tplot = toLoc.getPlot();
        if (tplot == null ^ (fplot = fromLoc.getPlot()) == null) {
            event.setCancelled(true);
            return;
        }
        if (tplot == null || tplot.getId().hashCode() == fplot.getId().hashCode()) {
            return;
        }
        if (fplot.isMerged() && fplot.getConnectedPlots().contains(fplot)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onEntityPathfind(SlimePathfindEvent event) {
        Plot fplot;
        if (!Settings.Paper_Components.ENTITY_PATHING) {
            return;
        }
        Slime slime = event.getEntity();
        Block b = slime.getTargetBlock(4);
        if (b == null) {
            return;
        }
        Location toLoc = BukkitUtil.adapt(b.getLocation());
        Location fromLoc = BukkitUtil.adapt(event.getEntity().getLocation());
        PlotArea tarea = toLoc.getPlotArea();
        if (tarea == null) {
            return;
        }
        PlotArea farea = fromLoc.getPlotArea();
        if (farea == null) {
            return;
        }
        if (tarea != farea) {
            event.setCancelled(true);
            return;
        }
        Plot tplot = toLoc.getPlot();
        if (tplot == null ^ (fplot = fromLoc.getPlot()) == null) {
            event.setCancelled(true);
            return;
        }
        if (tplot == null || tplot.getId().hashCode() == fplot.getId().hashCode()) {
            return;
        }
        if (fplot.isMerged() && fplot.getConnectedPlots().contains(fplot)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPreCreatureSpawnEvent(PreCreatureSpawnEvent event) {
        if (!Settings.Paper_Components.CREATURE_SPAWN) {
            return;
        }
        Location location = BukkitUtil.adapt(event.getSpawnLocation());
        PlotArea area = location.getPlotArea();
        if (!location.isPlotArea()) {
            return;
        }
        Entity[] entities = event.getSpawnLocation().getChunk().getEntities();
        if (entities.length > Settings.Chunk_Processor.MAX_ENTITIES) {
            event.setShouldAbortSpawn(true);
            event.setCancelled(true);
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = event.getReason();
        switch (reason.toString()) {
            case "DISPENSE_EGG": 
            case "EGG": 
            case "OCELOT_BABY": 
            case "SPAWNER_EGG": {
                if (area.isSpawnEggs()) break;
                event.setShouldAbortSpawn(true);
                event.setCancelled(true);
                return;
            }
            case "REINFORCEMENTS": 
            case "NATURAL": 
            case "MOUNT": 
            case "PATROL": 
            case "RAID": 
            case "SHEARED": 
            case "SILVERFISH_BLOCK": 
            case "ENDER_PEARL": 
            case "TRAP": 
            case "VILLAGE_DEFENSE": 
            case "VILLAGE_INVASION": 
            case "BEEHIVE": 
            case "CHUNK_GEN": {
                if (area.isMobSpawning()) break;
                event.setShouldAbortSpawn(true);
                event.setCancelled(true);
                return;
            }
            case "BREEDING": {
                if (area.isSpawnBreeding()) break;
                event.setShouldAbortSpawn(true);
                event.setCancelled(true);
                return;
            }
            case "BUILD_IRONGOLEM": 
            case "BUILD_SNOWMAN": 
            case "BUILD_WITHER": 
            case "CUSTOM": {
                if (area.isSpawnCustom() || event.getType() == EntityType.ARMOR_STAND) break;
                event.setShouldAbortSpawn(true);
                event.setCancelled(true);
                return;
            }
            case "SPAWNER": {
                if (area.isMobSpawnerSpawning()) break;
                event.setShouldAbortSpawn(true);
                event.setCancelled(true);
                return;
            }
        }
        Plot plot = location.getOwnedPlotAbs();
        if (plot == null) {
            EntityType type = event.getType();
            if (type == EntityType.DROPPED_ITEM) {
                if (Settings.Enabled_Components.KILL_ROAD_ITEMS) {
                    event.setCancelled(true);
                }
                return;
            }
            if (!area.isMobSpawning()) {
                if (type == EntityType.PLAYER) {
                    return;
                }
                if (type.isAlive()) {
                    event.setShouldAbortSpawn(true);
                    event.setCancelled(true);
                }
            }
            if (!area.isMiscSpawnUnowned() && !type.isAlive()) {
                event.setShouldAbortSpawn(true);
                event.setCancelled(true);
            }
            return;
        }
        if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot)) {
            event.setShouldAbortSpawn(true);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerNaturallySpawnCreaturesEvent(PlayerNaturallySpawnCreaturesEvent event) {
        Location location;
        PlotArea area;
        if (Settings.Paper_Components.CANCEL_CHUNK_SPAWN && (area = (location = BukkitUtil.adapt(event.getPlayer().getLocation())).getPlotArea()) != null && !area.isMobSpawning()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPreSpawnerSpawnEvent(PreSpawnerSpawnEvent event) {
        Location location;
        PlotArea area;
        if (Settings.Paper_Components.SPAWNER_SPAWN && (area = (location = BukkitUtil.adapt(event.getSpawnerLocation())).getPlotArea()) != null && !area.isMobSpawnerSpawning()) {
            event.setCancelled(true);
            event.setShouldAbortSpawn(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!Settings.Paper_Components.TILE_ENTITY_CHECK || !Settings.Enabled_Components.CHUNK_PROCESSOR) {
            return;
        }
        if (!(event.getBlock().getState(false) instanceof TileState)) {
            return;
        }
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea plotArea = location.getPlotArea();
        if (plotArea == null) {
            return;
        }
        int tileEntityCount = event.getBlock().getChunk().getTileEntities(false).length;
        if (tileEntityCount >= Settings.Chunk_Processor.MAX_TILES) {
            BukkitPlayer plotPlayer = BukkitUtil.adapt(event.getPlayer());
            plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"errors.tile_entity_cap_reached"), new Template[]{Template.of((String)"amount", (String)String.valueOf(Settings.Chunk_Processor.MAX_TILES))});
            event.setCancelled(true);
            event.setBuild(false);
        }
    }

    @EventHandler
    public void onProjectileLaunch(PlayerLaunchProjectileEvent event) {
        if (!Settings.Paper_Components.PLAYER_PROJECTILE) {
            return;
        }
        Projectile entity = event.getProjectile();
        ProjectileSource shooter = entity.getShooter();
        if (!(shooter instanceof Player)) {
            return;
        }
        Location location = BukkitUtil.adapt(entity.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        BukkitPlayer pp = BukkitUtil.adapt((Player)shooter);
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals((PlotArea)area, ProjectilesFlag.class, (Object)true) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_ROAD)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_PROJECTILE_ROAD))});
                entity.remove();
                event.setCancelled(true);
            }
        } else if (!plot.hasOwner()) {
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_PROJECTILE_UNOWNED))});
                entity.remove();
                event.setCancelled(true);
            }
        } else if (!(plot.isAdded(pp.getUUID()) || ((Boolean)plot.getFlag(ProjectilesFlag.class)).booleanValue() || Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_PROJECTILE_OTHER))) {
            pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_PROJECTILE_OTHER))});
            entity.remove();
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onAsyncTabCompletion(AsyncTabCompleteEvent event) {
        String[] unprocessedArgs;
        if (!Settings.Paper_Components.ASYNC_TAB_COMPLETION) {
            return;
        }
        String buffer = event.getBuffer();
        if (!(event.getSender() instanceof Player)) {
            return;
        }
        if (!event.isCommand() && !buffer.startsWith("/") || buffer.indexOf(32) == -1) {
            return;
        }
        if (buffer.startsWith("/")) {
            buffer = buffer.substring(1);
        }
        if ((unprocessedArgs = buffer.split(Pattern.quote(" "))).length == 1) {
            return;
        }
        if (!Settings.Enabled_Components.TAB_COMPLETED_ALIASES.contains(unprocessedArgs[0].toLowerCase(Locale.ENGLISH))) {
            return;
        }
        String[] args = new String[unprocessedArgs.length - 1];
        System.arraycopy(unprocessedArgs, 1, args, 0, args.length);
        try {
            BukkitPlayer player = BukkitUtil.adapt((Player)event.getSender());
            Collection objects = MainCommand.getInstance().tab((PlotPlayer)player, args, buffer.endsWith(" "));
            if (objects == null) {
                return;
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Command o : objects) {
                result.add(o.toString());
            }
            event.setCompletions(result);
            event.setHandled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBeaconEffect(BeaconEffectEvent event) {
        Block block = event.getBlock();
        Location beaconLocation = BukkitUtil.adapt(block.getLocation());
        Plot beaconPlot = beaconLocation.getPlot();
        PlotArea area = beaconLocation.getPlotArea();
        if (area == null) {
            return;
        }
        Player player = event.getPlayer();
        Location playerLocation = BukkitUtil.adapt(player.getLocation());
        BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
        Plot playerStandingPlot = playerLocation.getPlot();
        if (playerStandingPlot == null) {
            FlagContainer container = area.getRoadFlagContainer();
            if (!this.getBooleanFlagValue(container, BeaconEffectsFlag.class, true) || beaconPlot != null && Settings.Enabled_Components.DISABLE_BEACON_EFFECT_OVERFLOW) {
                event.setCancelled(true);
            }
            return;
        }
        FlagContainer container = playerStandingPlot.getFlagContainer();
        boolean plotBeaconEffects = this.getBooleanFlagValue(container, BeaconEffectsFlag.class, true);
        if (playerStandingPlot.equals((Object)beaconPlot)) {
            if (!plotBeaconEffects) {
                event.setCancelled(true);
            }
            return;
        }
        if (!plotBeaconEffects || Settings.Enabled_Components.DISABLE_BEACON_EFFECT_OVERFLOW) {
            event.setCancelled(true);
        }
    }

    private boolean getBooleanFlagValue(@NonNull FlagContainer container, @NonNull Class<? extends BooleanFlag<?>> flagClass, boolean defaultValue) {
        BooleanFlag flag = (BooleanFlag)container.getFlag(flagClass);
        return flag == null ? defaultValue : (Boolean)flag.getValue();
    }
}

