/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.google.inject.Inject;
import com.plotsquared.bukkit.player.BukkitPlayer;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.BlockBurnFlag;
import com.plotsquared.core.plot.flag.implementations.BlockIgnitionFlag;
import com.plotsquared.core.plot.flag.implementations.BreakFlag;
import com.plotsquared.core.plot.flag.implementations.CoralDryFlag;
import com.plotsquared.core.plot.flag.implementations.CropGrowFlag;
import com.plotsquared.core.plot.flag.implementations.DisablePhysicsFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.ExplosionFlag;
import com.plotsquared.core.plot.flag.implementations.GrassGrowFlag;
import com.plotsquared.core.plot.flag.implementations.IceFormFlag;
import com.plotsquared.core.plot.flag.implementations.IceMeltFlag;
import com.plotsquared.core.plot.flag.implementations.InstabreakFlag;
import com.plotsquared.core.plot.flag.implementations.KelpGrowFlag;
import com.plotsquared.core.plot.flag.implementations.LeafDecayFlag;
import com.plotsquared.core.plot.flag.implementations.LiquidFlowFlag;
import com.plotsquared.core.plot.flag.implementations.MycelGrowFlag;
import com.plotsquared.core.plot.flag.implementations.PlaceFlag;
import com.plotsquared.core.plot.flag.implementations.RedstoneFlag;
import com.plotsquared.core.plot.flag.implementations.SnowFormFlag;
import com.plotsquared.core.plot.flag.implementations.SnowMeltFlag;
import com.plotsquared.core.plot.flag.implementations.SoilDryFlag;
import com.plotsquared.core.plot.flag.implementations.VineGrowFlag;
import com.plotsquared.core.plot.flag.types.BlockTypeWrapper;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.PlotFlagUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.minimessage.Template;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.material.Directional;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BlockEventListener
implements Listener {
    private static final Set<Material> PISTONS = Set.of(Material.PISTON, Material.STICKY_PISTON);
    private static final Set<Material> PHYSICS_BLOCKS = Set.of(Material.TURTLE_EGG, Material.TURTLE_SPAWN_EGG);
    private static final Set<Material> SNOW = Stream.of(Material.values()).filter(material -> material.name().contains("SNOW")).filter(Material::isBlock).collect(Collectors.toUnmodifiableSet());
    private final PlotAreaManager plotAreaManager;
    private final WorldEdit worldEdit;

    @Inject
    public BlockEventListener(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldEdit worldEdit) {
        this.plotAreaManager = plotAreaManager;
        this.worldEdit = worldEdit;
    }

    public static void sendBlockChange(org.bukkit.Location bloc, BlockData data) {
        TaskManager.runTaskLater(() -> {
            String world = bloc.getWorld().getName();
            int x = bloc.getBlockX();
            int z = bloc.getBlockZ();
            int distance = Bukkit.getViewDistance() * 16;
            for (PlotPlayer player : PlotSquared.platform().playerManager().getPlayers()) {
                Location location = player.getLocation();
                if (!location.getWorldName().equals(world) || 16 * Math.abs(location.getX() - x) / 16 > distance || 16 * Math.abs(location.getZ() - z) / 16 > distance) continue;
                ((BukkitPlayer)player).player.sendBlockChange(bloc, data);
            }
        }, (TaskTime)TaskTime.ticks((long)3L));
    }

    @EventHandler
    public void onRedstoneEvent(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null) {
            if (PlotFlagUtil.isAreaRoadFlagsAndFlagEquals((PlotArea)area, RedstoneFlag.class, (Object)false)) {
                event.setNewCurrent(0);
            }
            return;
        }
        if (!((Boolean)plot.getFlag(RedstoneFlag.class)).booleanValue()) {
            event.setNewCurrent(0);
            plot.debug("Redstone event was cancelled because redstone = false");
            return;
        }
        if (Settings.Redstone.DISABLE_OFFLINE) {
            boolean disable = false;
            if (!DBFunc.SERVER.equals(plot.getOwner())) {
                if (plot.isMerged()) {
                    disable = true;
                    for (UUID owner : plot.getOwners()) {
                        if (PlotSquared.platform().playerManager().getPlayerIfExists(owner) == null) continue;
                        disable = false;
                        break;
                    }
                } else {
                    boolean bl = disable = PlotSquared.platform().playerManager().getPlayerIfExists(plot.getOwnerAbs()) == null;
                }
            }
            if (disable) {
                for (UUID trusted : plot.getTrusted()) {
                    if (PlotSquared.platform().playerManager().getPlayerIfExists(trusted) == null) continue;
                    disable = false;
                    break;
                }
                if (disable) {
                    event.setNewCurrent(0);
                    plot.debug("Redstone event was cancelled because no trusted player was in the plot");
                    return;
                }
            }
        }
        if (Settings.Redstone.DISABLE_UNOCCUPIED) {
            for (PlotPlayer player : PlotSquared.platform().playerManager().getPlayers()) {
                if (!plot.equals((Object)player.getCurrentPlot())) continue;
                return;
            }
            event.setNewCurrent(0);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPhysicsEvent(BlockPhysicsEvent event) {
        org.bukkit.block.data.Directional piston;
        BlockFace facing;
        Plot newPlot;
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlotAbs(location);
        if (plot == null) {
            return;
        }
        if (event.getChangedType().hasGravity() && ((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
            event.setCancelled(true);
            BlockEventListener.sendBlockChange(event.getBlock().getLocation(), event.getBlock().getBlockData());
            plot.debug("Prevented block physics and resent block change because disable-physics = true");
            return;
        }
        if (event.getChangedType() == Material.COMPARATOR) {
            if (!((Boolean)plot.getFlag(RedstoneFlag.class)).booleanValue()) {
                event.setCancelled(true);
                plot.debug("Prevented comparator update because redstone = false");
            }
            return;
        }
        if (PHYSICS_BLOCKS.contains(event.getChangedType())) {
            if (((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
                event.setCancelled(true);
                plot.debug("Prevented block physics because disable-physics = true");
            }
            return;
        }
        if (Settings.Redstone.DETECT_INVALID_EDGE_PISTONS && PISTONS.contains(block.getType()) && !plot.equals((Object)(newPlot = area.getOwnedPlotAbs(location = location.add((facing = (piston = (org.bukkit.block.data.Directional)block.getBlockData()).getFacing()).getModX(), facing.getModY(), facing.getModZ()))))) {
            event.setCancelled(true);
            plot.debug("Prevented piston update because of invalid edge piston detection");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void blockCreate(BlockPlaceEvent event) {
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Player player = event.getPlayer();
        BukkitPlayer pp = BukkitUtil.adapt(player);
        Plot plot = area.getPlot(location);
        if (plot != null) {
            Block block;
            if (area.notifyIfOutsideBuildArea((PlotPlayer)pp, location.getY())) {
                event.setCancelled(true);
                return;
            }
            if (!plot.hasOwner()) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_UNOWNED))});
                    event.setCancelled(true);
                    return;
                }
            } else if (!plot.isAdded(pp.getUUID())) {
                Block block2;
                List place = (List)plot.getFlag(PlaceFlag.class);
                if (place != null && place.contains(BlockTypeWrapper.get((BlockType)BukkitAdapter.asBlockType((Material)(block2 = event.getBlock()).getType())))) {
                    return;
                }
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_OTHER))});
                    event.setCancelled(true);
                    plot.debug(player.getName() + " could not place " + event.getBlock().getType() + " because of the place = false");
                    return;
                }
            } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"done.building_restricted"), new Template[0]);
                event.setCancelled(true);
                return;
            }
            if (((Boolean)plot.getFlag(DisablePhysicsFlag.class)).booleanValue() && (block = event.getBlockPlaced()).getType().hasGravity()) {
                BlockEventListener.sendBlockChange(block.getLocation(), block.getBlockData());
                plot.debug(event.getBlock().getType() + " did not fall because of disable-physics = true");
            }
        } else if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
            pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_ROAD))});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void blockDestroy(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getPlot(location);
        if (plot != null) {
            BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
            if (event.getBlock().getY() == area.getMinGenHeight()) {
                if (!Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_GROUNDLEVEL)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_GROUNDLEVEL))});
                    event.setCancelled(true);
                    return;
                }
            } else if (area.notifyIfOutsideBuildArea((PlotPlayer)plotPlayer, location.getY())) {
                event.setCancelled(true);
                return;
            }
            if (!plot.hasOwner()) {
                if (!Permissions.hasPermission((PlotPlayer)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_UNOWNED, (boolean)true)) {
                    event.setCancelled(true);
                }
                return;
            }
            if (!plot.isAdded(plotPlayer.getUUID())) {
                List destroy = (List)plot.getFlag(BreakFlag.class);
                Block block = event.getBlock();
                BlockType blockType = BukkitAdapter.asBlockType((Material)block.getType());
                for (BlockTypeWrapper blockTypeWrapper : destroy) {
                    if (!blockTypeWrapper.accepts(blockType)) continue;
                    return;
                }
                if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_OTHER)) {
                    return;
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_OTHER))});
                event.setCancelled(true);
            } else if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)plot) && !Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of((String)"done.building_restricted"), new Template[0]);
                event.setCancelled(true);
                return;
            }
            return;
        }
        BukkitPlayer pp = BukkitUtil.adapt(player);
        if (Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_DESTROY_ROAD)) {
            return;
        }
        if (this.worldEdit != null && pp.getAttribute("worldedit") && player.getInventory().getItemInMainHand().getType() == Material.getMaterial((String)this.worldEdit.getConfiguration().wandItem)) {
            return;
        }
        pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_DESTROY_ROAD))});
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        if (location.isPlotRoad()) {
            event.setCancelled(true);
            return;
        }
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            return;
        }
        switch (event.getSource().getType().toString()) {
            case "GRASS_BLOCK": {
                if (((Boolean)plot.getFlag(GrassGrowFlag.class)).booleanValue()) break;
                plot.debug("Grass could not grow because grass-grow = false");
                event.setCancelled(true);
                break;
            }
            case "MYCELIUM": {
                if (((Boolean)plot.getFlag(MycelGrowFlag.class)).booleanValue()) break;
                plot.debug("Mycelium could not grow because mycel-grow = false");
                event.setCancelled(true);
                break;
            }
            case "WEEPING_VINES": 
            case "TWISTING_VINES": 
            case "CAVE_VINES": 
            case "VINE": 
            case "GLOW_BERRIES": {
                if (((Boolean)plot.getFlag(VineGrowFlag.class)).booleanValue()) break;
                plot.debug("Vine could not grow because vine-grow = false");
                event.setCancelled(true);
                break;
            }
            case "KELP": {
                if (!((Boolean)plot.getFlag(KelpGrowFlag.class)).booleanValue()) {
                    plot.debug("Kelp could not grow because kelp-grow = false");
                    event.setCancelled(true);
                }
            }
            case "BUDDING_AMETHYST": {
                if (((Boolean)plot.getFlag(CropGrowFlag.class)).booleanValue()) break;
                plot.debug("Amethyst clusters could not grow because crop-grow = false");
                event.setCancelled(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCauldronEmpty(CauldronLevelChangeEvent event) {
        Entity entity = event.getEntity();
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getPlot(location);
        switch (event.getReason()) {
            case BANNER_WASH: 
            case ARMOR_WASH: 
            case EXTINGUISH: {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
                    if (plot != null) {
                        if (!plot.hasOwner()) {
                            if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_INTERACT_UNOWNED)) {
                                return;
                            }
                        } else {
                            if (plot.isAdded(plotPlayer.getUUID())) return;
                            if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_INTERACT_OTHER)) {
                                return;
                            }
                        }
                    } else {
                        if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_INTERACT_ROAD)) {
                            return;
                        }
                        if (this.worldEdit != null && plotPlayer.getAttribute("worldedit") && player.getInventory().getItemInMainHand().getType() == Material.getMaterial((String)this.worldEdit.getConfiguration().wandItem)) {
                            return;
                        }
                    }
                }
                if (event.getReason() == CauldronLevelChangeEvent.ChangeReason.EXTINGUISH && event.getEntity() != null) {
                    event.getEntity().setFireTicks(0);
                }
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        if (event instanceof EntityBlockFormEvent) {
            return;
        }
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        if (location.isPlotRoad()) {
            event.setCancelled(true);
            return;
        }
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            return;
        }
        if (!area.buildRangeContainsY(location.getY())) {
            event.setCancelled(true);
            return;
        }
        if (SNOW.contains(event.getNewState().getType())) {
            if (!((Boolean)plot.getFlag(SnowFormFlag.class)).booleanValue()) {
                plot.debug("Snow could not form because snow-form = false");
                event.setCancelled(true);
            }
            return;
        }
        if (Tag.ICE.isTagged((Keyed)event.getNewState().getType()) && !((Boolean)plot.getFlag(IceFormFlag.class)).booleanValue()) {
            plot.debug("Ice could not form because ice-form = false");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityBlockForm(EntityBlockFormEvent event) {
        Class<SnowFormFlag> flag;
        String world = event.getBlock().getWorld().getName();
        if (!this.plotAreaManager.hasPlotArea(world)) {
            return;
        }
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            event.setCancelled(true);
            return;
        }
        if (SNOW.contains(event.getNewState().getType())) {
            flag = SnowFormFlag.class;
        } else if (Tag.ICE.isTagged((Keyed)event.getNewState().getType())) {
            flag = IceFormFlag.class;
        } else {
            return;
        }
        boolean allowed = (Boolean)plot.getFlag(flag);
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
            if (!plot.isAdded(plotPlayer.getUUID())) {
                if (allowed) {
                    return;
                }
                plot.debug(String.format("%s could not be formed because %s = false (entity is player)", event.getNewState().getType(), flag == SnowFormFlag.class ? "snow-form" : "ice-form"));
                event.setCancelled(true);
            }
            return;
        }
        if (plot.hasOwner()) {
            if (allowed) {
                return;
            }
            plot.debug(String.format("%s could not be formed because %s = false (entity is not player)", event.getNewState().getType(), flag == SnowFormFlag.class ? "snow-form" : "ice-form"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent event) {
        Player player = event.getPlayer();
        Location location = BukkitUtil.adapt(event.getBlock().getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        Plot plot = area.getPlot(location);
        if (plot != null) {
            BukkitPlayer plotPlayer;
            if (((Boolean)plot.getFlag(InstabreakFlag.class)).booleanValue()) {
                Block block = event.getBlock();
                BlockBreakEvent call = new BlockBreakEvent(block, player);
                Bukkit.getServer().getPluginManager().callEvent((Event)call);
                if (!call.isCancelled()) {
                    event.getBlock().breakNaturally();
                }
            }
            if (location.getY() == area.getMinGenHeight()) {
                event.setCancelled(true);
                return;
            }
            if (!plot.hasOwner()) {
                plotPlayer = BukkitUtil.adapt(player);
                if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_UNOWNED)) {
                    return;
                }
                event.setCancelled(true);
                return;
            }
            plotPlayer = BukkitUtil.adapt(player);
            if (!plot.isAdded(plotPlayer.getUUID())) {
                Block block;
                List destroy = (List)plot.getFlag(BreakFlag.class);
                if (destroy.contains(BlockTypeWrapper.get((BlockType)BukkitAdapter.asBlockType((Material)(block = event.getBlock()).getType()))) || Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_OTHER)) {
                    return;
                }
                plot.debug(player.getName() + " could not break " + block.getType() + " because it was not in the break flag");
                event.setCancelled(true);
                return;
            }
            return;
        }
        BukkitPlayer plotPlayer = BukkitUtil.adapt(player);
        if (Permissions.hasPermission((PermissionHolder)plotPlayer, (Permission)Permission.PERMISSION_ADMIN_DESTROY_ROAD)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFade(BlockFadeEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            event.setCancelled(true);
            return;
        }
        Material blockType = block.getType();
        if (Tag.ICE.isTagged((Keyed)blockType)) {
            if (!((Boolean)plot.getFlag(IceMeltFlag.class)).booleanValue()) {
                plot.debug("Ice could not melt because ice-melt = false");
                event.setCancelled(true);
            }
            return;
        }
        if (SNOW.contains(blockType)) {
            if (!((Boolean)plot.getFlag(SnowMeltFlag.class)).booleanValue()) {
                plot.debug("Snow could not melt because snow-melt = false");
                event.setCancelled(true);
            }
            return;
        }
        if (blockType == Material.FARMLAND) {
            if (!((Boolean)plot.getFlag(SoilDryFlag.class)).booleanValue()) {
                plot.debug("Soil could not dry because soil-dry = false");
                event.setCancelled(true);
            }
            return;
        }
        if ((Tag.CORAL_BLOCKS.isTagged((Keyed)blockType) || Tag.CORALS.isTagged((Keyed)blockType) || Tag.WALL_CORALS.isTagged((Keyed)blockType)) && !((Boolean)plot.getFlag(CoralDryFlag.class)).booleanValue()) {
            plot.debug("Coral could not dry because coral-dry = false");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChange(BlockFromToEvent event) {
        org.bukkit.Location location;
        Plot fromPlot;
        Plot fromPlot2;
        Block fromBlock = event.getBlock();
        Location fromLocation = BukkitUtil.adapt(fromBlock.getLocation());
        PlotArea fromArea = fromLocation.getPlotArea();
        if (fromArea != null && (fromPlot2 = fromArea.getOwnedPlot(fromLocation)) != null && fromPlot2.getFlag(LiquidFlowFlag.class) == LiquidFlowFlag.FlowStatus.DISABLED && event.getBlock().isLiquid()) {
            fromPlot2.debug("Liquid could not flow because liquid-flow = disabled");
            event.setCancelled(true);
            return;
        }
        Block toBlock = event.getToBlock();
        Location toLocation = BukkitUtil.adapt(toBlock.getLocation());
        PlotArea toArea = toLocation.getPlotArea();
        if (toArea == null) {
            if (fromBlock.getType() == Material.DRAGON_EGG && fromArea != null) {
                event.setCancelled(true);
            }
            return;
        }
        if (!toArea.buildRangeContainsY(toLocation.getY())) {
            event.setCancelled(true);
            return;
        }
        Plot toPlot = toArea.getOwnedPlot(toLocation);
        if (!(fromBlock.getType() != Material.DRAGON_EGG || fromArea == null || (fromPlot = fromArea.getOwnedPlot(fromLocation)) == null && toPlot == null || fromPlot != null && fromPlot.equals((Object)toPlot) || toPlot != null && toPlot.equals((Object)fromPlot))) {
            event.setCancelled(true);
            return;
        }
        if (toPlot != null) {
            if (!toArea.contains(fromLocation.getX(), fromLocation.getZ()) || !Objects.equals(toPlot, toArea.getOwnedPlot(fromLocation))) {
                event.setCancelled(true);
                return;
            }
            if (toPlot.getFlag(LiquidFlowFlag.class) == LiquidFlowFlag.FlowStatus.ENABLED && event.getBlock().isLiquid()) {
                return;
            }
            if (((Boolean)toPlot.getFlag(DisablePhysicsFlag.class)).booleanValue()) {
                toPlot.debug(event.getBlock().getType() + " could not update because disable-physics = true");
                event.setCancelled(true);
                return;
            }
            if (toPlot.getFlag(LiquidFlowFlag.class) == LiquidFlowFlag.FlowStatus.DISABLED && event.getBlock().isLiquid()) {
                toPlot.debug("Liquid could not flow because liquid-flow = disabled");
                event.setCancelled(true);
            }
        } else if (!toArea.contains(fromLocation.getX(), fromLocation.getZ()) || !Objects.equals(null, toArea.getOwnedPlot(fromLocation))) {
            event.setCancelled(true);
        } else if (event.getBlock().isLiquid() && (BukkitUtil.adapt((location = event.getBlock().getLocation()).clone().add(-1.0, 0.0, 1.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(1.0, 0.0, 0.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(1.0, 0.0, 1.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(-1.0, 0.0, 0.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(1.0, 0.0, 0.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(-1.0, 0.0, -1.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(0.0, 0.0, -1.0)).getPlot() != null || BukkitUtil.adapt(location.clone().add(1.0, 0.0, 1.0)).getPlot() != null)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onGrow(BlockGrowEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        if (!area.buildRangeContainsY(location.getY())) {
            event.setCancelled(true);
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(CropGrowFlag.class)).booleanValue()) {
            if (plot != null) {
                plot.debug("Crop grow event was cancelled because crop-grow = false");
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        BlockFace face = event.getDirection();
        Vector relative = new Vector(face.getModX(), face.getModY(), face.getModZ());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
                return;
            }
            for (Block block1 : event.getBlocks()) {
                Location bloc = BukkitUtil.adapt(block1.getLocation());
                if (!bloc.isPlotArea() && !bloc.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ()).isPlotArea()) continue;
                event.setCancelled(true);
                return;
            }
            if (location.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ()).isPlotArea()) {
                event.setCancelled(true);
            }
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            event.setCancelled(true);
            return;
        }
        for (Block block1 : event.getBlocks()) {
            Location bloc = BukkitUtil.adapt(block1.getLocation());
            Location newLoc = bloc.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ());
            if (!area.contains(bloc.getX(), bloc.getZ()) || !area.contains(newLoc)) {
                event.setCancelled(true);
                return;
            }
            if (!plot.equals((Object)area.getOwnedPlot(bloc)) || !plot.equals((Object)area.getOwnedPlot(newLoc))) {
                event.setCancelled(true);
                return;
            }
            if (area.buildRangeContainsY(bloc.getY()) && area.buildRangeContainsY(newLoc.getY())) continue;
            event.setCancelled(true);
            return;
        }
        if (!plot.equals((Object)area.getOwnedPlot(location.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ())))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        BlockFace face = event.getDirection();
        Vector relative = new Vector(face.getModX(), face.getModY(), face.getModZ());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            if (!this.plotAreaManager.hasPlotArea(location.getWorldName())) {
                return;
            }
            for (Block block1 : event.getBlocks()) {
                Location bloc = BukkitUtil.adapt(block1.getLocation());
                Location newLoc = bloc.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ());
                if (!bloc.isPlotArea() && !newLoc.isPlotArea()) continue;
                event.setCancelled(true);
                return;
            }
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null) {
            event.setCancelled(true);
            return;
        }
        for (Block block1 : event.getBlocks()) {
            Location bloc = BukkitUtil.adapt(block1.getLocation());
            Location newLoc = bloc.add(relative.getBlockX(), relative.getBlockY(), relative.getBlockZ());
            if (!area.contains(bloc.getX(), bloc.getZ()) || !area.contains(newLoc)) {
                event.setCancelled(true);
                return;
            }
            if (!plot.equals((Object)area.getOwnedPlot(bloc)) || !plot.equals((Object)area.getOwnedPlot(newLoc))) {
                event.setCancelled(true);
                return;
            }
            if (area.buildRangeContainsY(bloc.getY()) && area.buildRangeContainsY(newLoc.getY())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent event) {
        Material type = event.getItem().getType();
        switch (type.toString()) {
            case "SHULKER_BOX": 
            case "WHITE_SHULKER_BOX": 
            case "ORANGE_SHULKER_BOX": 
            case "MAGENTA_SHULKER_BOX": 
            case "LIGHT_BLUE_SHULKER_BOX": 
            case "YELLOW_SHULKER_BOX": 
            case "LIME_SHULKER_BOX": 
            case "PINK_SHULKER_BOX": 
            case "GRAY_SHULKER_BOX": 
            case "LIGHT_GRAY_SHULKER_BOX": 
            case "CYAN_SHULKER_BOX": 
            case "PURPLE_SHULKER_BOX": 
            case "BLUE_SHULKER_BOX": 
            case "BROWN_SHULKER_BOX": 
            case "GREEN_SHULKER_BOX": 
            case "RED_SHULKER_BOX": 
            case "BLACK_SHULKER_BOX": 
            case "CARVED_PUMPKIN": 
            case "WITHER_SKELETON_SKULL": 
            case "FLINT_AND_STEEL": 
            case "BONE_MEAL": 
            case "SHEARS": 
            case "GLASS_BOTTLE": 
            case "GLOWSTONE": 
            case "COD_BUCKET": 
            case "PUFFERFISH_BUCKET": 
            case "SALMON_BUCKET": 
            case "TROPICAL_FISH_BUCKET": 
            case "AXOLOTL_BUCKET": 
            case "BUCKET": 
            case "WATER_BUCKET": 
            case "LAVA_BUCKET": 
            case "TADPOLE_BUCKET": {
                if (event.getBlock().getType() == Material.DROPPER) {
                    return;
                }
                BlockFace targetFace = ((Directional)event.getBlock().getState().getData()).getFacing();
                Location location = BukkitUtil.adapt(event.getBlock().getRelative(targetFace).getLocation());
                if (location.isPlotRoad()) {
                    event.setCancelled(true);
                    return;
                }
                PlotArea area = location.getPlotArea();
                if (area == null || area.buildRangeContainsY(location.getY())) break;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        Plot plot;
        int i;
        if (!this.plotAreaManager.hasPlotArea(event.getWorld().getName())) {
            return;
        }
        List blocks = event.getBlocks();
        if (blocks.isEmpty()) {
            return;
        }
        Location location = BukkitUtil.adapt(((BlockState)blocks.get(0)).getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            for (int i2 = blocks.size() - 1; i2 >= 0; --i2) {
                location = BukkitUtil.adapt(((BlockState)blocks.get(i2)).getLocation());
                if (!location.isPlotArea()) continue;
                blocks.remove(i2);
            }
            return;
        }
        Plot origin = area.getOwnedPlot(location);
        if (origin == null) {
            event.setCancelled(true);
            return;
        }
        for (i = blocks.size() - 1; i >= 0; --i) {
            location = BukkitUtil.adapt(((BlockState)blocks.get(i)).getLocation());
            if (!area.contains(location.getX(), location.getZ())) {
                blocks.remove(i);
                continue;
            }
            plot = area.getOwnedPlot(location);
            if (!Objects.equals(plot, origin)) {
                event.getBlocks().remove(i);
                continue;
            }
            if (area.buildRangeContainsY(location.getY())) continue;
            event.getBlocks().remove(i);
        }
        origin = area.getPlot(location);
        if (origin == null) {
            event.setCancelled(true);
            return;
        }
        for (i = blocks.size() - 1; i >= 0; --i) {
            location = BukkitUtil.adapt(((BlockState)blocks.get(i)).getLocation());
            plot = area.getOwnedPlot(location);
            if (Objects.equals(plot, origin) || plot.isMerged() || origin.isMerged()) continue;
            event.getBlocks().remove(i);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBigBoom(BlockExplodeEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        String world = location.getWorldName();
        if (!this.plotAreaManager.hasPlotArea(world)) {
            return;
        }
        PlotArea area = location.getPlotArea();
        if (area == null) {
            Iterator iterator = event.blockList().iterator();
            while (iterator.hasNext()) {
                location = BukkitUtil.adapt(((Block)iterator.next()).getLocation());
                if (!location.isPlotArea()) continue;
                iterator.remove();
            }
            return;
        }
        Plot plot = area.getOwnedPlot(location);
        if (plot == null || !((Boolean)plot.getFlag(ExplosionFlag.class)).booleanValue()) {
            event.setCancelled(true);
            if (plot != null) {
                plot.debug("Explosion was cancelled because explosion = false");
            }
        }
        event.blockList().removeIf(blox -> !plot.equals((Object)area.getOwnedPlot(BukkitUtil.adapt(blox.getLocation()))));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(BlockBurnFlag.class)).booleanValue()) {
            if (plot != null) {
                plot.debug("Block burning was cancelled because block-burn = false");
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        Player player = event.getPlayer();
        Entity ignitingEntity = event.getIgnitingEntity();
        Block block = event.getBlock();
        BlockIgniteEvent.IgniteCause igniteCause = event.getCause();
        Location location1 = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location1.getPlotArea();
        if (area == null) {
            return;
        }
        if (igniteCause == BlockIgniteEvent.IgniteCause.LIGHTNING) {
            event.setCancelled(true);
            return;
        }
        Plot plot = area.getOwnedPlot(location1);
        if (player != null) {
            BukkitPlayer pp = BukkitUtil.adapt(player);
            if (area.notifyIfOutsideBuildArea((PlotPlayer)pp, location1.getY())) {
                event.setCancelled(true);
                return;
            }
            if (plot == null) {
                if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals((PlotArea)area, BlockIgnitionFlag.class, (Object)true) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_ROAD)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_ROAD))});
                    event.setCancelled(true);
                }
            } else if (!plot.hasOwner()) {
                if (!PlotFlagUtil.isAreaRoadFlagsAndFlagEquals((PlotArea)area, BlockIgnitionFlag.class, (Object)true) && !Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_UNOWNED)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_UNOWNED))});
                    event.setCancelled(true);
                }
            } else if (!plot.isAdded(pp.getUUID())) {
                if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_OTHER)) {
                    pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_OTHER))});
                    event.setCancelled(true);
                }
            } else if (!((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue()) {
                event.setCancelled(true);
                plot.debug("Block ignition was cancelled because block-ignition = false");
            }
        } else {
            if (plot == null) {
                event.setCancelled(true);
                return;
            }
            if (ignitingEntity != null) {
                if (!((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue()) {
                    event.setCancelled(true);
                    plot.debug("Block ignition was cancelled because block-ignition = false");
                    return;
                }
                if (igniteCause == BlockIgniteEvent.IgniteCause.FIREBALL && ignitingEntity instanceof Fireball) {
                    Projectile fireball = (Projectile)ignitingEntity;
                    Location location = null;
                    ProjectileSource projectileSource = fireball.getShooter();
                    if (projectileSource instanceof Entity) {
                        Entity shooter = (Entity)projectileSource;
                        location = BukkitUtil.adapt(shooter.getLocation());
                    } else if (fireball.getShooter() instanceof BlockProjectileSource) {
                        Block shooter = ((BlockProjectileSource)fireball.getShooter()).getBlock();
                        location = BukkitUtil.adapt(shooter.getLocation());
                    }
                    if (location != null && !plot.equals((Object)location.getPlot())) {
                        event.setCancelled(true);
                    }
                }
            } else if (event.getIgnitingBlock() != null) {
                Block ignitingBlock = event.getIgnitingBlock();
                Plot plotIgnited = BukkitUtil.adapt(ignitingBlock.getLocation()).getPlot();
                if (!((igniteCause != BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL || ((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue() && plotIgnited != null && plotIgnited.equals((Object)plot)) && (igniteCause != BlockIgniteEvent.IgniteCause.SPREAD && igniteCause != BlockIgniteEvent.IgniteCause.LAVA || ((Boolean)plot.getFlag(BlockIgnitionFlag.class)).booleanValue() && plotIgnited != null && plotIgnited.equals((Object)plot)))) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLeavesDecay(LeavesDecayEvent event) {
        Block block = event.getBlock();
        Location location = BukkitUtil.adapt(block.getLocation());
        PlotArea area = location.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = location.getOwnedPlot();
        if (plot == null || !((Boolean)plot.getFlag(LeafDecayFlag.class)).booleanValue()) {
            if (plot != null) {
                plot.debug("Leaf decaying was cancelled because leaf-decay = false");
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpongeAbsorb(SpongeAbsorbEvent event) {
        Block sponge = event.getBlock();
        Location location = BukkitUtil.adapt(sponge.getLocation());
        PlotArea area = location.getPlotArea();
        List blocks = event.getBlocks();
        if (area == null) {
            blocks.removeIf(block -> BukkitUtil.adapt(block.getLocation()).isPlotArea());
        } else {
            Plot origin = area.getOwnedPlot(location);
            blocks.removeIf(block -> {
                Location blockLocation = BukkitUtil.adapt(block.getLocation());
                if (!area.contains(blockLocation.getX(), blockLocation.getZ())) {
                    return true;
                }
                Plot plot = area.getOwnedPlot(blockLocation);
                if (!Objects.equals(plot, origin)) {
                    return true;
                }
                return !area.buildRangeContainsY(location.getY());
            });
        }
        if (blocks.isEmpty()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
        this.blockCreate((BlockPlaceEvent)event);
        if (event.isCancelled()) {
            return;
        }
        BukkitPlayer pp = BukkitUtil.adapt(event.getPlayer());
        Location placedLocation = BukkitUtil.adapt(event.getBlockReplacedState().getLocation());
        PlotArea area = placedLocation.getPlotArea();
        if (area == null) {
            return;
        }
        Plot plot = placedLocation.getPlot();
        for (BlockState state : event.getReplacedBlockStates()) {
            Location currentLocation = BukkitUtil.adapt(state.getLocation());
            if (!Permissions.hasPermission((PermissionHolder)pp, (Permission)Permission.PERMISSION_ADMIN_BUILD_ROAD) && !Objects.equals(currentLocation.getPlot(), plot)) {
                pp.sendMessage((Caption)TranslatableCaption.of((String)"permission.no_permission_event"), new Template[]{Template.of((String)"node", (String)String.valueOf(Permission.PERMISSION_ADMIN_BUILD_ROAD))});
                event.setCancelled(true);
                break;
            }
            if (!area.notifyIfOutsideBuildArea((PlotPlayer)pp, currentLocation.getY())) continue;
            event.setCancelled(true);
            break;
        }
    }
}

