/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.bukkit.generator.BlockStatePopulator;
import com.plotsquared.bukkit.generator.BukkitAugmentedGenerator;
import com.plotsquared.bukkit.generator.DelegatePlotGenerator;
import com.plotsquared.bukkit.generator.LegacyBlockStatePopulator;
import com.plotsquared.bukkit.queue.GenChunk;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.bukkit.util.BukkitWorld;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.generator.SingleWorldGenerator;
import com.plotsquared.core.location.ChunkWrapper;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.queue.ScopedQueueCoordinator;
import com.plotsquared.core.util.ChunkManager;
import com.sk89q.worldedit.math.BlockVector2;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitPlotGenerator
extends ChunkGenerator
implements GeneratorWrapper<ChunkGenerator> {
    public final boolean PAPER_ASYNC_SAFE = true;
    private final PlotAreaManager plotAreaManager;
    private final IndependentPlotGenerator plotGenerator;
    private final ChunkGenerator platformGenerator;
    private final boolean full;
    private final String levelName;
    private List<BlockPopulator> populators;
    private boolean loaded = false;

    public BukkitPlotGenerator(@NonNull String name, @NonNull IndependentPlotGenerator generator, @NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
        this.levelName = name;
        this.plotGenerator = generator;
        this.platformGenerator = this;
        this.populators = new ArrayList<BlockPopulator>();
        int minecraftMinorVersion = PlotSquared.platform().serverVersion()[1];
        if (minecraftMinorVersion >= 17) {
            this.populators.add(new BlockStatePopulator(this.plotGenerator));
        } else {
            this.populators.add(new LegacyBlockStatePopulator(this.plotGenerator));
        }
        this.full = true;
    }

    public BukkitPlotGenerator(String world, ChunkGenerator cg, @NonNull PlotAreaManager plotAreaManager) {
        if (cg instanceof BukkitPlotGenerator) {
            throw new IllegalArgumentException("ChunkGenerator: " + cg.getClass().getName() + " is already a BukkitPlotGenerator!");
        }
        this.plotAreaManager = plotAreaManager;
        this.levelName = world;
        this.full = false;
        this.platformGenerator = cg;
        this.plotGenerator = new DelegatePlotGenerator(cg, world);
    }

    public void augment(PlotArea area) {
        BukkitAugmentedGenerator.get(BukkitUtil.getWorld(area.getWorldName()));
    }

    public boolean isFull() {
        return this.full;
    }

    public IndependentPlotGenerator getPlotGenerator() {
        return this.plotGenerator;
    }

    public ChunkGenerator getPlatformGenerator() {
        return this.platformGenerator;
    }

    public @NonNull List<BlockPopulator> getDefaultPopulators(@NonNull World world) {
        try {
            this.checkLoaded(world);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<BlockPopulator> toAdd = new ArrayList<BlockPopulator>();
        List existing = world.getPopulators();
        if (this.populators == null && this.platformGenerator != null) {
            this.populators = new ArrayList<BlockPopulator>(this.platformGenerator.getDefaultPopulators(world));
        }
        if (this.populators != null) {
            for (BlockPopulator populator : this.populators) {
                if (existing.contains(populator)) continue;
                toAdd.add(populator);
            }
        }
        return toAdd;
    }

    private synchronized void checkLoaded(@NonNull World world) {
        if (!PlotSquared.get().isWeInitialised()) {
            return;
        }
        if (!this.loaded) {
            String name = world.getName();
            PlotSquared.get().loadWorld(name, (GeneratorWrapper)this);
            Set areas = this.plotAreaManager.getPlotAreasSet(name);
            if (!areas.isEmpty()) {
                PlotArea area = (PlotArea)areas.iterator().next();
                if (!area.isMobSpawning()) {
                    if (!area.isSpawnEggs()) {
                        world.setSpawnFlags(false, false);
                    }
                    this.setSpawnLimits(world, 0);
                } else {
                    world.setSpawnFlags(true, true);
                    this.setSpawnLimits(world, -1);
                }
            }
            this.loaded = true;
        }
    }

    private void setSpawnLimits(@NonNull World world, int limit) {
        world.setAmbientSpawnLimit(limit);
        world.setAnimalSpawnLimit(limit);
        world.setMonsterSpawnLimit(limit);
        world.setWaterAnimalSpawnLimit(limit);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ChunkGenerator.ChunkData generateChunkData(@NonNull World world, @NonNull Random random, int x, int z, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ChunkGenerator.BiomeGrid biome) {
        int minY = BukkitWorld.getMinWorldHeight(world);
        int maxY = BukkitWorld.getMaxWorldHeight(world);
        GenChunk result = new GenChunk(minY, maxY);
        if (this.getPlotGenerator() instanceof SingleWorldGenerator && result.getChunkData() != null) {
            for (int chunkX = 0; chunkX < 16; ++chunkX) {
                for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                    for (int y = minY; y < maxY; ++y) {
                        biome.setBiome(chunkX, y, chunkZ, Biome.PLAINS);
                    }
                }
            }
            return result.getChunkData();
        }
        result.setChunk(new ChunkWrapper(world.getName(), x, z));
        result.setChunkData(this.createChunkData(world));
        result.biomeGrid = biome;
        result.result = null;
        try {
            if (this.platformGenerator != this) {
                return this.platformGenerator.generateChunkData(world, random, x, z, biome);
            }
            this.generate(BlockVector2.at((int)x, (int)z), world, result);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result.getChunkData();
    }

    private void generate(BlockVector2 loc, World world, ScopedQueueCoordinator result) {
        if (!this.loaded) {
            this.checkLoaded(world);
        }
        if (ChunkManager.preProcessChunk((BlockVector2)loc, (ScopedQueueCoordinator)result)) {
            return;
        }
        PlotArea area = this.plotAreaManager.getPlotArea(world.getName(), null);
        if (area == null && (area = this.plotAreaManager.getPlotArea(this.levelName, null)) == null) {
            throw new IllegalStateException("Cannot regenerate chunk that does not belong to a plot area. Location: " + loc + ", world: " + world);
        }
        try {
            this.plotGenerator.generateChunk(result, area);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ChunkManager.postProcessChunk((BlockVector2)loc, (ScopedQueueCoordinator)result);
    }

    public boolean canSpawn(@NonNull World world, int x, int z) {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return false;
    }

    public boolean isParallelCapable() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return false;
    }

    public boolean shouldGenerateStructures() {
        return true;
    }

    public String toString() {
        if (this.platformGenerator == this) {
            return this.plotGenerator.getName();
        }
        if (this.platformGenerator == null) {
            return "null";
        }
        return this.platformGenerator.getClass().getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString()) || this.toString().equals(obj.getClass().getName());
    }

    public String getLevelName() {
        return this.levelName;
    }
}

