/*
 * Decompiled with CFR 0.152.
 */
package com.platymuus.bukkit.permissions;

import com.platymuus.bukkit.permissions.PermissionsPlugin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

class PlayerListener
implements Listener {
    private PermissionsPlugin plugin;

    public PlayerListener(PermissionsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        this.plugin.calculateAttachment(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLogin(PlayerJoinEvent event) {
        this.plugin.debug("Player " + event.getPlayer().getName() + " joined, registering...");
        this.plugin.registerPlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerKick(PlayerKickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.plugin.debug("Player " + event.getPlayer().getName() + " was kicked, unregistering...");
        this.plugin.unregisterPlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.debug("Player " + event.getPlayer().getName() + " quit, unregistering...");
        this.plugin.unregisterPlayer(event.getPlayer());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (!event.getPlayer().hasPermission("permissions.build")) {
            this.bother(event.getPlayer());
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getPlayer().hasPermission("permissions.build")) {
            this.bother(event.getPlayer());
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getPlayer().hasPermission("permissions.build")) {
            this.bother(event.getPlayer());
            event.setCancelled(true);
        }
    }

    private void bother(Player player) {
        if (this.plugin.getConfig().getString("messages.build", "").length() > 0) {
            String message = this.plugin.getConfig().getString("messages.build", "").replace('&', '\u00a7');
            player.sendMessage(message);
        }
    }
}

