/*
 * Decompiled with CFR 0.152.
 */
package com.platymuus.bukkit.permissions;

import com.platymuus.bukkit.permissions.Group;
import com.platymuus.bukkit.permissions.PermissionInfo;
import com.platymuus.bukkit.permissions.PermissionsCommand;
import com.platymuus.bukkit.permissions.PlayerListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsPlugin
extends JavaPlugin {
    private PlayerListener playerListener = new PlayerListener(this);
    private PermissionsCommand commandExecutor = new PermissionsCommand(this);
    private HashMap<String, PermissionAttachment> permissions = new HashMap();
    private File configFile;
    private YamlConfiguration config;

    public void onEnable() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.saveDefaultConfig();
        }
        this.reloadConfig();
        this.getCommand("permissions").setExecutor((CommandExecutor)this.commandExecutor);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        for (Player p : this.getServer().getOnlinePlayers()) {
            this.registerPlayer(p);
        }
        this.getLogger().info("Enabled successfully, " + this.getServer().getOnlinePlayers().length + " players registered");
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void reloadConfig() {
        this.config = new YamlConfiguration();
        this.config.options().pathSeparator('/');
        try {
            this.config.load(this.configFile);
        }
        catch (Exception e) {
            this.getLogger().severe("Unable to load configuration!");
        }
    }

    public void onDisable() {
        for (Player p : this.getServer().getOnlinePlayers()) {
            this.unregisterPlayer(p);
        }
        this.getLogger().info("Disabled successfully, " + this.getServer().getOnlinePlayers().length + " players unregistered");
    }

    public Group getGroup(String groupName) {
        if (this.getNode("groups") != null) {
            for (String key : this.getNode("groups").getKeys(false)) {
                if (!key.equalsIgnoreCase(groupName)) continue;
                return new Group(this, key);
            }
        }
        return null;
    }

    public List<Group> getGroups(String playerName) {
        ArrayList<Group> result = new ArrayList<Group>();
        if (this.getNode("users/" + playerName) != null) {
            for (String key : this.getNode("users/" + playerName).getStringList("groups")) {
                result.add(new Group(this, key));
            }
        } else {
            result.add(new Group(this, "default"));
        }
        return result;
    }

    public PermissionInfo getPlayerInfo(String playerName) {
        if (this.getNode("users/" + playerName) == null) {
            return null;
        }
        return new PermissionInfo(this, this.getNode("users/" + playerName), "groups");
    }

    public List<Group> getAllGroups() {
        ArrayList<Group> result = new ArrayList<Group>();
        if (this.getNode("groups") != null) {
            for (String key : this.getNode("groups").getKeys(false)) {
                result.add(new Group(this, key));
            }
        }
        return result;
    }

    protected void registerPlayer(Player player) {
        if (this.permissions.containsKey(player.getName())) {
            this.debug("Registering " + player.getName() + ": was already registered");
            this.unregisterPlayer(player);
        }
        PermissionAttachment attachment = player.addAttachment((Plugin)this);
        this.permissions.put(player.getName(), attachment);
        this.calculateAttachment(player);
    }

    protected void unregisterPlayer(Player player) {
        if (this.permissions.containsKey(player.getName())) {
            try {
                player.removeAttachment(this.permissions.get(player.getName()));
            }
            catch (IllegalArgumentException ex) {
                this.debug("Unregistering " + player.getName() + ": player did not have attachment");
            }
            this.permissions.remove(player.getName());
        } else {
            this.debug("Unregistering " + player.getName() + ": was not registered");
        }
    }

    protected void refreshPermissions() {
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to write changed config.yml: " + e.getMessage());
        }
        for (String player : this.permissions.keySet()) {
            PermissionAttachment attachment = this.permissions.get(player);
            for (String key : attachment.getPermissions().keySet()) {
                attachment.unsetPermission(key);
            }
            this.calculateAttachment(this.getServer().getPlayer(player));
        }
    }

    protected ConfigurationSection getNode(String node) {
        for (String entry : this.getConfig().getKeys(true)) {
            if (!node.equalsIgnoreCase(entry) || !this.getConfig().isConfigurationSection(entry)) continue;
            return this.getConfig().getConfigurationSection(entry);
        }
        return null;
    }

    protected HashMap<String, Boolean> getAllPerms(String desc, String path) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        ConfigurationSection node = this.getNode(path);
        int failures = 0;
        String firstFailure = "";
        boolean fixed = false;
        boolean fixedNow = true;
        while (fixedNow) {
            fixedNow = false;
            for (String key : node.getKeys(true)) {
                if (node.isBoolean(key) && key.contains("/")) {
                    node.set(key.replace("/", "."), (Object)node.getBoolean(key));
                    node.set(key, null);
                    fixedNow = true;
                    fixed = true;
                    continue;
                }
                if (!node.isConfigurationSection(key) || node.getConfigurationSection(key).getKeys(true).size() != 0) continue;
                node.set(key, null);
                fixedNow = true;
                fixed = true;
            }
        }
        if (fixed) {
            this.getLogger().info("Fixed broken nesting in " + desc + ".");
            try {
                this.getConfig().save(this.configFile);
            }
            catch (IOException e) {
                this.getLogger().warning("Failed to write changed config.yml: " + e.getMessage());
            }
        }
        for (String key : node.getKeys(false)) {
            if (node.isBoolean(key)) {
                result.put(key, node.getBoolean(key));
                continue;
            }
            ++failures;
            if (firstFailure.length() != 0) continue;
            firstFailure = key;
        }
        if (failures == 1) {
            this.getLogger().warning("In " + desc + ": " + firstFailure + " is non-boolean.");
        } else if (failures > 1) {
            this.getLogger().warning("In " + desc + ": " + firstFailure + " is non-boolean (+" + (failures - 1) + " more).");
        }
        return result;
    }

    protected void debug(String message) {
        if (this.getConfig().getBoolean("debug", false)) {
            this.getLogger().info("Debug: " + message);
        }
    }

    protected void calculateAttachment(Player player) {
        if (player == null) {
            return;
        }
        PermissionAttachment attachment = this.permissions.get(player.getName());
        if (attachment == null) {
            this.debug("Calculating permissions on " + player.getName() + ": attachment was null");
            return;
        }
        for (String string : attachment.getPermissions().keySet()) {
            attachment.unsetPermission(string);
        }
        for (Map.Entry entry : this.calculatePlayerPermissions(player.getName().toLowerCase(), player.getWorld().getName()).entrySet()) {
            attachment.setPermission((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        player.recalculatePermissions();
    }

    private Map<String, Boolean> calculatePlayerPermissions(String player, String world) {
        HashMap<String, Boolean> perms;
        if (this.getNode("users/" + player) == null) {
            return this.calculateGroupPermissions("default", world);
        }
        HashMap<String, Boolean> hashMap = perms = this.getNode("users/" + player + "/permissions") == null ? new HashMap<String, Boolean>() : this.getAllPerms("user " + player, "users/" + player + "/permissions");
        if (this.getNode("users/" + player + "/worlds/" + world) != null) {
            for (Map.Entry entry : this.getAllPerms("user " + player + " world " + world, "users/" + player + "/worlds/" + world).entrySet()) {
                perms.put((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        for (String string : this.getNode("users/" + player).getStringList("groups")) {
            for (Map.Entry<String, Boolean> entry : this.calculateGroupPermissions(string, world).entrySet()) {
                if (perms.containsKey(entry.getKey())) continue;
                perms.put(entry.getKey(), entry.getValue());
            }
        }
        return perms;
    }

    private Map<String, Boolean> calculateGroupPermissions(String group, String world) {
        HashMap<String, Boolean> perms;
        if (this.getNode("groups/" + group) == null) {
            return new HashMap<String, Boolean>();
        }
        HashMap<String, Boolean> hashMap = perms = this.getNode("groups/" + group + "/permissions") == null ? new HashMap<String, Boolean>() : this.getAllPerms("group " + group, "groups/" + group + "/permissions");
        if (this.getNode("groups/" + group + "/worlds/" + world) != null) {
            for (Map.Entry entry : this.getAllPerms("group " + group + " world " + world, "groups/" + group + "/worlds/" + world).entrySet()) {
                perms.put((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        for (String string : this.getNode("groups/" + group).getStringList("inheritance")) {
            for (Map.Entry<String, Boolean> entry : this.calculateGroupPermissions(string, world).entrySet()) {
                if (perms.containsKey(entry.getKey())) continue;
                perms.put(entry.getKey(), entry.getValue());
            }
        }
        return perms;
    }
}

