/*
 * Decompiled with CFR 0.152.
 */
package com.platymuus.bukkit.permissions;

import com.platymuus.bukkit.permissions.PermissionsPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;

class PermissionsCommand
implements CommandExecutor {
    private PermissionsPlugin plugin;

    public PermissionsCommand(PermissionsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] split) {
        if (split.length < 1) {
            return !this.checkPerm(sender, "help") || this.usage(sender, command);
        }
        String subcommand = split[0];
        if (subcommand.equals("reload")) {
            if (!this.checkPerm(sender, "reload")) {
                return true;
            }
            this.plugin.reloadConfig();
            this.plugin.refreshPermissions();
            sender.sendMessage(ChatColor.GREEN + "Configuration reloaded.");
            return true;
        }
        if (subcommand.equals("check")) {
            String name;
            if (!this.checkPerm(sender, "check")) {
                return true;
            }
            if (split.length != 2 && split.length != 3) {
                return this.usage(sender, command, subcommand);
            }
            String node = split[1];
            Object permissible = split.length == 2 ? sender : this.plugin.getServer().getPlayer(split[2]);
            String string = permissible instanceof Player ? ((Player)permissible).getName() : (name = permissible instanceof ConsoleCommandSender ? "Console" : "Unknown");
            if (permissible == null) {
                sender.sendMessage(ChatColor.RED + "Player " + ChatColor.WHITE + split[2] + ChatColor.RED + " not found.");
            } else {
                boolean set = permissible.isPermissionSet(node);
                boolean has = permissible.hasPermission(node);
                String sets = set ? " sets " : " defaults ";
                String perm = has ? "true" : "false";
                sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + name + ChatColor.GREEN + sets + ChatColor.WHITE + node + ChatColor.GREEN + " to " + ChatColor.WHITE + perm + ChatColor.GREEN + ".");
            }
            return true;
        }
        if (subcommand.equals("info")) {
            if (!this.checkPerm(sender, "info")) {
                return true;
            }
            if (split.length != 2) {
                return this.usage(sender, command, subcommand);
            }
            String node = split[1];
            Permission perm = this.plugin.getServer().getPluginManager().getPermission(node);
            if (perm == null) {
                sender.sendMessage(ChatColor.RED + "Permission " + ChatColor.WHITE + node + ChatColor.RED + " not found.");
            } else {
                sender.sendMessage(ChatColor.GREEN + "Info on permission " + ChatColor.WHITE + perm.getName() + ChatColor.GREEN + ":");
                sender.sendMessage(ChatColor.GREEN + "Default: " + ChatColor.WHITE + perm.getDefault());
                if (perm.getDescription() != null && perm.getDescription().length() > 0) {
                    sender.sendMessage(ChatColor.GREEN + "Description: " + ChatColor.WHITE + perm.getDescription());
                }
                if (perm.getChildren() != null && perm.getChildren().size() > 0) {
                    sender.sendMessage(ChatColor.GREEN + "Children: " + ChatColor.WHITE + perm.getChildren().size());
                }
            }
            return true;
        }
        if (subcommand.equals("dump")) {
            int page;
            CommandSender permissible;
            if (!this.checkPerm(sender, "dump")) {
                return true;
            }
            if (split.length < 1 || split.length > 3) {
                return this.usage(sender, command, subcommand);
            }
            if (split.length == 1) {
                permissible = sender;
                page = 1;
            } else if (split.length == 2) {
                try {
                    permissible = sender;
                    page = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException ex) {
                    permissible = this.plugin.getServer().getPlayer(split[1]);
                    page = 1;
                }
            } else {
                permissible = this.plugin.getServer().getPlayer(split[1]);
                try {
                    page = Integer.parseInt(split[2]);
                }
                catch (NumberFormatException ex) {
                    page = 1;
                }
            }
            if (permissible == null) {
                sender.sendMessage(ChatColor.RED + "Player " + ChatColor.WHITE + split[1] + ChatColor.RED + " not found.");
            } else {
                ArrayList dump = new ArrayList(permissible.getEffectivePermissions());
                Collections.sort(dump, new Comparator<PermissionAttachmentInfo>(){

                    @Override
                    public int compare(PermissionAttachmentInfo a, PermissionAttachmentInfo b) {
                        return a.getPermission().compareTo(b.getPermission());
                    }
                });
                int numpages = 1 + (dump.size() - 1) / 8;
                if (page > numpages) {
                    page = numpages;
                } else if (page < 1) {
                    page = 1;
                }
                ChatColor g = ChatColor.GREEN;
                ChatColor w = ChatColor.WHITE;
                ChatColor r = ChatColor.RED;
                int start = 8 * (page - 1);
                sender.sendMessage(ChatColor.RED + "[==== " + ChatColor.GREEN + "Page " + page + " of " + numpages + ChatColor.RED + " ====]");
                for (int i = start; i < start + 8 && i < dump.size(); ++i) {
                    PermissionAttachmentInfo info = (PermissionAttachmentInfo)dump.get(i);
                    if (info.getAttachment() == null) {
                        sender.sendMessage(g + "Node " + w + info.getPermission() + g + "=" + w + info.getValue() + g + " (" + r + "default" + g + ")");
                        continue;
                    }
                    sender.sendMessage(g + "Node " + w + info.getPermission() + g + "=" + w + info.getValue() + g + " (" + w + info.getAttachment().getPlugin().getDescription().getName() + g + ")");
                }
            }
            return true;
        }
        if (subcommand.equals("group")) {
            if (split.length < 2) {
                return !this.checkPerm(sender, "group.help") || this.usage(sender, command, subcommand);
            }
            this.groupCommand(sender, command, split);
            return true;
        }
        if (subcommand.equals("player")) {
            if (split.length < 2) {
                return !this.checkPerm(sender, "player.help") || this.usage(sender, command, subcommand);
            }
            this.playerCommand(sender, command, split);
            return true;
        }
        return !this.checkPerm(sender, "help") || this.usage(sender, command);
    }

    private boolean groupCommand(CommandSender sender, Command command, String[] split) {
        String subcommand = split[1];
        if (subcommand.equals("list")) {
            if (!this.checkPerm(sender, "group.list")) {
                return true;
            }
            if (split.length != 2) {
                return this.usage(sender, command, "group list");
            }
            String result = "";
            String sep = "";
            for (String key : this.plugin.getNode("groups").getKeys(false)) {
                result = result + sep + key;
                sep = ", ";
            }
            sender.sendMessage(ChatColor.GREEN + "Groups: " + ChatColor.WHITE + result);
            return true;
        }
        if (subcommand.equals("players")) {
            if (!this.checkPerm(sender, "group.players")) {
                return true;
            }
            if (split.length != 3) {
                return this.usage(sender, command, "group players");
            }
            String group = split[2];
            if (this.plugin.getNode("groups/" + group) == null) {
                sender.sendMessage(ChatColor.RED + "No such group " + ChatColor.WHITE + group + ChatColor.RED + ".");
                return true;
            }
            int count = 0;
            String text = "";
            String sep = "";
            for (String user : this.plugin.getNode("users").getKeys(false)) {
                if (!this.plugin.getNode("users/" + user).getStringList("groups").contains(group)) continue;
                ++count;
                text = text + sep + user;
                sep = ", ";
            }
            sender.sendMessage(ChatColor.GREEN + "Users in " + ChatColor.WHITE + group + ChatColor.GREEN + " (" + ChatColor.WHITE + count + ChatColor.GREEN + "): " + ChatColor.WHITE + text);
            return true;
        }
        if (subcommand.equals("setperm")) {
            if (!this.checkPerm(sender, "group.setperm")) {
                return true;
            }
            if (split.length != 4 && split.length != 5) {
                return this.usage(sender, command, "group setperm");
            }
            String group = split[2];
            String perm = split[3];
            boolean value = split.length != 5 || Boolean.parseBoolean(split[4]);
            String node = "permissions";
            if (this.plugin.getNode("groups/" + group) == null) {
                sender.sendMessage(ChatColor.RED + "No such group " + ChatColor.WHITE + group + ChatColor.RED + ".");
                return true;
            }
            if (perm.contains(":")) {
                String world = perm.substring(0, perm.indexOf(58));
                perm = perm.substring(perm.indexOf(58) + 1);
                node = "worlds/" + world;
            }
            if (this.plugin.getNode("groups/" + group + "/" + node) == null) {
                this.createGroupNode(group, node);
            }
            this.plugin.getNode("groups/" + group + "/" + node).set(perm, (Object)value);
            this.plugin.refreshPermissions();
            sender.sendMessage(ChatColor.GREEN + "Group " + ChatColor.WHITE + group + ChatColor.GREEN + " now has " + ChatColor.WHITE + perm + ChatColor.GREEN + " = " + ChatColor.WHITE + value + ChatColor.GREEN + ".");
            return true;
        }
        if (subcommand.equals("unsetperm")) {
            ConfigurationSection sec;
            if (!this.checkPerm(sender, "group.unsetperm")) {
                return true;
            }
            if (split.length != 4) {
                return this.usage(sender, command, "group unsetperm");
            }
            String group = split[2].toLowerCase();
            String perm = split[3];
            String node = "permissions";
            if (this.plugin.getNode("groups/" + group) == null) {
                sender.sendMessage(ChatColor.RED + "No such group " + ChatColor.WHITE + group + ChatColor.RED + ".");
                return true;
            }
            if (perm.contains(":")) {
                String world = perm.substring(0, perm.indexOf(58));
                perm = perm.substring(perm.indexOf(58) + 1);
                node = "worlds/" + world;
            }
            if (this.plugin.getNode("groups/" + group + "/" + node) == null) {
                this.createGroupNode(group, node);
            }
            if (!(sec = this.plugin.getNode("groups/" + group + "/" + node)).contains(perm)) {
                sender.sendMessage(ChatColor.GREEN + "Group " + ChatColor.WHITE + group + ChatColor.GREEN + " did not have " + ChatColor.WHITE + perm + ChatColor.GREEN + " set.");
                return true;
            }
            sec.set(perm, null);
            this.plugin.refreshPermissions();
            sender.sendMessage(ChatColor.GREEN + "Group " + ChatColor.WHITE + group + ChatColor.GREEN + " no longer has " + ChatColor.WHITE + perm + ChatColor.GREEN + " set.");
            return true;
        }
        return !this.checkPerm(sender, "group.help") || this.usage(sender, command);
    }

    private boolean playerCommand(CommandSender sender, Command command, String[] split) {
        String subcommand = split[1];
        if (subcommand.equals("groups")) {
            if (!this.checkPerm(sender, "player.groups")) {
                return true;
            }
            if (split.length != 3) {
                return this.usage(sender, command, "player groups");
            }
            String player = split[2].toLowerCase();
            if (this.plugin.getNode("users/" + player) == null) {
                sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.RED + " is in the default group.");
                return true;
            }
            int count = 0;
            String text = "";
            String sep = "";
            for (String group : this.plugin.getNode("users/" + player).getStringList("groups")) {
                ++count;
                text = text + sep + group;
                sep = ", ";
            }
            sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.GREEN + " is in groups (" + ChatColor.WHITE + count + ChatColor.GREEN + "): " + ChatColor.WHITE + text);
            return true;
        }
        if (subcommand.equals("setgroup")) {
            if (!this.checkPerm(sender, "player.setgroup")) {
                return true;
            }
            if (split.length != 4) {
                return this.usage(sender, command, "player setgroup");
            }
            String player = split[2].toLowerCase();
            String[] groups = split[3].split(",");
            if (this.plugin.getNode("users/" + player) == null) {
                this.createPlayerNode(player);
            }
            this.plugin.getNode("users/" + player).set("groups", Arrays.asList(groups));
            this.plugin.refreshPermissions();
            sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.GREEN + " is now in " + ChatColor.WHITE + split[3] + ChatColor.GREEN + ".");
            return true;
        }
        if (subcommand.equals("addgroup")) {
            List list;
            if (!this.checkPerm(sender, "player.addgroup")) {
                return true;
            }
            if (split.length != 4) {
                return this.usage(sender, command, "player addgroup");
            }
            String player = split[2].toLowerCase();
            String group = split[3];
            if (this.plugin.getNode("users/" + player) == null) {
                this.createPlayerNode(player);
            }
            if ((list = this.plugin.getNode("users/" + player).getStringList("groups")).contains(group)) {
                sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.GREEN + " was already in " + ChatColor.WHITE + group + ChatColor.GREEN + ".");
                return true;
            }
            list.add(group);
            this.plugin.getNode("users/" + player).set("groups", (Object)list);
            this.plugin.refreshPermissions();
            sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.GREEN + " is now in " + ChatColor.WHITE + group + ChatColor.GREEN + ".");
            return true;
        }
        if (subcommand.equals("removegroup")) {
            List list;
            if (!this.checkPerm(sender, "player.removegroup")) {
                return true;
            }
            if (split.length != 4) {
                return this.usage(sender, command, "player removegroup");
            }
            String player = split[2].toLowerCase();
            String group = split[3];
            if (this.plugin.getNode("users/" + player) == null) {
                this.createPlayerNode(player);
            }
            if (!(list = this.plugin.getNode("users/" + player).getStringList("groups")).contains(group)) {
                sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.GREEN + " was not in " + ChatColor.WHITE + group + ChatColor.GREEN + ".");
                return true;
            }
            list.remove(group);
            this.plugin.getNode("users/" + player).set("groups", (Object)list);
            this.plugin.refreshPermissions();
            sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.GREEN + " is no longer in " + ChatColor.WHITE + group + ChatColor.GREEN + ".");
            return true;
        }
        if (subcommand.equals("setperm")) {
            if (!this.checkPerm(sender, "player.setperm")) {
                return true;
            }
            if (split.length != 4 && split.length != 5) {
                return this.usage(sender, command, "player setperm");
            }
            String player = split[2].toLowerCase();
            String perm = split[3];
            boolean value = split.length != 5 || Boolean.parseBoolean(split[4]);
            String node = "permissions";
            if (this.plugin.getNode("users/" + player) == null) {
                this.createPlayerNode(player);
            }
            if (perm.contains(":")) {
                String world = perm.substring(0, perm.indexOf(58));
                perm = perm.substring(perm.indexOf(58) + 1);
                node = "worlds/" + world;
            }
            if (this.plugin.getNode("users/" + player + "/" + node) == null) {
                this.createPlayerNode(player, node);
            }
            this.plugin.getNode("users/" + player + "/" + node).set(perm, (Object)value);
            this.plugin.refreshPermissions();
            sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.GREEN + " now has " + ChatColor.WHITE + perm + ChatColor.GREEN + " = " + ChatColor.WHITE + value + ChatColor.GREEN + ".");
            return true;
        }
        if (subcommand.equals("unsetperm")) {
            ConfigurationSection sec;
            if (!this.checkPerm(sender, "player.unsetperm")) {
                return true;
            }
            if (split.length != 4) {
                return this.usage(sender, command, "player unsetperm");
            }
            String player = split[2].toLowerCase();
            String perm = split[3];
            String node = "permissions";
            if (this.plugin.getNode("users/" + player) == null) {
                this.createPlayerNode(player);
            }
            if (perm.contains(":")) {
                String world = perm.substring(0, perm.indexOf(58));
                perm = perm.substring(perm.indexOf(58) + 1);
                node = "worlds/" + world;
            }
            if (this.plugin.getNode("users/" + player + "/" + node) == null) {
                this.createPlayerNode(player, node);
            }
            if (!(sec = this.plugin.getNode("users/" + player + "/" + node)).contains(perm)) {
                sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.GREEN + " did not have " + ChatColor.WHITE + perm + ChatColor.GREEN + " set.");
                return true;
            }
            sec.set(perm, null);
            this.plugin.refreshPermissions();
            sender.sendMessage(ChatColor.GREEN + "Player " + ChatColor.WHITE + player + ChatColor.GREEN + " no longer has " + ChatColor.WHITE + perm + ChatColor.GREEN + " set.");
            return true;
        }
        return !this.checkPerm(sender, "player.help") || this.usage(sender, command);
    }

    private void createPlayerNode(String player) {
        this.plugin.getNode("users").createSection(player);
        this.plugin.getNode("users/" + player).set("groups", Arrays.asList("default"));
    }

    private void createPlayerNode(String player, String subnode) {
        this.plugin.getConfig().createSection("users/" + player + "/" + subnode);
    }

    private void createGroupNode(String group, String subnode) {
        this.plugin.getConfig().createSection("groups/" + group + "/" + subnode);
    }

    private boolean checkPerm(CommandSender sender, String subnode) {
        boolean ok = sender.hasPermission("permissions." + subnode);
        if (!ok) {
            sender.sendMessage(ChatColor.RED + "You do not have permissions to do that.");
        }
        return ok;
    }

    private boolean usage(CommandSender sender, Command command) {
        sender.sendMessage(ChatColor.RED + "[====" + ChatColor.GREEN + " /permissons " + ChatColor.RED + "====]");
        for (String line : command.getUsage().split("\\n")) {
            if (line.startsWith("/<command> group") && !line.startsWith("/<command> group -") || line.startsWith("/<command> player") && !line.startsWith("/<command> player -")) continue;
            sender.sendMessage(this.formatLine(line));
        }
        return true;
    }

    private boolean usage(CommandSender sender, Command command, String subcommand) {
        sender.sendMessage(ChatColor.RED + "[====" + ChatColor.GREEN + " /permissons " + subcommand + " " + ChatColor.RED + "====]");
        for (String line : command.getUsage().split("\\n")) {
            if (!line.startsWith("/<command> " + subcommand)) continue;
            sender.sendMessage(this.formatLine(line));
        }
        return true;
    }

    private String formatLine(String line) {
        int i = line.indexOf(" - ");
        String usage = line.substring(0, i);
        String desc = line.substring(i + 3);
        usage = usage.replace("<command>", "permissions");
        usage = usage.replaceAll("\\[[^]:]+\\]", ChatColor.AQUA + "$0" + ChatColor.GREEN);
        usage = usage.replaceAll("\\[[^]]+:\\]", ChatColor.AQUA + "$0" + ChatColor.LIGHT_PURPLE);
        usage = usage.replaceAll("<[^>]+>", ChatColor.LIGHT_PURPLE + "$0" + ChatColor.GREEN);
        return ChatColor.GREEN + usage + " - " + ChatColor.WHITE + desc;
    }
}

