/*
 * Decompiled with CFR 0.152.
 */
package com.platymuus.bukkit.permissions;

import com.platymuus.bukkit.permissions.Group;
import com.platymuus.bukkit.permissions.PermissionsPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionInfo {
    private final PermissionsPlugin plugin;
    private final ConfigurationSection node;
    private final String groupType;

    protected PermissionInfo(PermissionsPlugin plugin, ConfigurationSection node, String groupType) {
        this.plugin = plugin;
        this.node = node;
        this.groupType = groupType;
    }

    public List<Group> getGroups() {
        ArrayList<Group> result = new ArrayList<Group>();
        for (String key : this.node.getStringList(this.groupType)) {
            Group group = this.plugin.getGroup(key);
            if (group == null) continue;
            result.add(group);
        }
        return result;
    }

    public Map<String, Boolean> getPermissions() {
        return this.plugin.getAllPerms(this.node.getName(), this.node.getName());
    }

    public Set<String> getWorlds() {
        if (this.node.getConfigurationSection("worlds") == null) {
            return new HashSet<String>();
        }
        return this.node.getConfigurationSection("worlds").getKeys(false);
    }

    public Map<String, Boolean> getWorldPermissions(String world) {
        return this.plugin.getAllPerms(this.node.getName() + ":" + world, this.node.getName() + "/world/" + world);
    }
}

