/*
 * Decompiled with CFR 0.152.
 */
package com.platymuus.bukkit.permissions;

import com.platymuus.bukkit.permissions.PermissionInfo;
import com.platymuus.bukkit.permissions.PermissionsPlugin;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    private PermissionsPlugin plugin;
    private String name;

    protected Group(PermissionsPlugin plugin, String name) {
        this.plugin = plugin;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPlayers() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.plugin.getNode("users") != null) {
            for (String user : this.plugin.getNode("users").getKeys(false)) {
                for (String group : this.plugin.getNode("users/" + user).getStringList("groups")) {
                    if (!this.name.equalsIgnoreCase(group) || result.contains(user)) continue;
                    result.add(user);
                }
            }
        }
        return result;
    }

    public List<Player> getOnlinePlayers() {
        ArrayList<Player> result = new ArrayList<Player>();
        for (String user : this.getPlayers()) {
            Player player = Bukkit.getServer().getPlayer(user);
            if (player == null || !player.isOnline()) continue;
            result.add(player);
        }
        return result;
    }

    public PermissionInfo getInfo() {
        ConfigurationSection node = this.plugin.getNode("groups/" + this.name);
        if (node == null) {
            return null;
        }
        return new PermissionInfo(this.plugin, node, "inheritance");
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Group && this.name.equalsIgnoreCase(((Group)o).getName());
    }

    public String toString() {
        return "Group{name=" + this.name + "}";
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

