/*
 * Decompiled with CFR 0.152.
 */
package com.pkslow.ai.domain;

import com.pkslow.ai.domain.AnswerStatus;
import com.pkslow.ai.domain.Image;
import java.util.List;

public class Answer {
    private final AnswerStatus status;
    private final String chosenAnswer;
    private final List<Image> images;

    public String markdown() {
        String markdown = this.chosenAnswer;
        if (this.images != null && this.images.size() > 0) {
            for (Image image : this.images) {
                markdown = markdown.replaceFirst(image.labelRegex(), image.markdown());
            }
        }
        return markdown;
    }

    public static AnswerBuilder builder() {
        return new AnswerBuilder();
    }

    public Answer(AnswerStatus status, String chosenAnswer, List<Image> images) {
        this.status = status;
        this.chosenAnswer = chosenAnswer;
        this.images = images;
    }

    public AnswerStatus getStatus() {
        return this.status;
    }

    public String getChosenAnswer() {
        return this.chosenAnswer;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public String toString() {
        return "Answer(status=" + (Object)((Object)this.getStatus()) + ", chosenAnswer=" + this.getChosenAnswer() + ", images=" + this.getImages() + ")";
    }

    public static class AnswerBuilder {
        private AnswerStatus status;
        private String chosenAnswer;
        private List<Image> images;

        AnswerBuilder() {
        }

        public AnswerBuilder status(AnswerStatus status) {
            this.status = status;
            return this;
        }

        public AnswerBuilder chosenAnswer(String chosenAnswer) {
            this.chosenAnswer = chosenAnswer;
            return this;
        }

        public AnswerBuilder images(List<Image> images) {
            this.images = images;
            return this;
        }

        public Answer build() {
            return new Answer(this.status, this.chosenAnswer, this.images);
        }

        public String toString() {
            return "Answer.AnswerBuilder(status=" + (Object)((Object)this.status) + ", chosenAnswer=" + this.chosenAnswer + ", images=" + this.images + ")";
        }
    }
}

