/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.ThrowingFunction;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;
import java.util.function.Predicate;

@FunctionalInterface
public interface ThrowingPredicate<T, E extends Exception> {
    public boolean test(T var1) throws E;

    public static <T> Predicate<T> unchecked(ThrowingPredicate<T, ?> predicate) {
        return Objects.requireNonNull(predicate).uncheck();
    }

    public static <T> Predicate<T> sneaky(ThrowingPredicate<T, ?> predicate) {
        Objects.requireNonNull(predicate);
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception e) {
                return (Boolean)SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }

    default public ThrowingPredicate<T, E> and(ThrowingPredicate<? super T, ? extends E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public ThrowingPredicate<T, E> or(ThrowingPredicate<? super T, ? extends E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    default public ThrowingPredicate<T, E> xor(ThrowingPredicate<? super T, ? extends E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) ^ other.test(t);
    }

    default public ThrowingPredicate<T, E> negate() {
        return t -> !this.test(t);
    }

    default public ThrowingFunction<T, Boolean, E> asFunction() {
        return this::test;
    }

    default public Predicate<T> uncheck() {
        return t -> {
            try {
                return this.test(t);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }
}

