/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.reporter.format;

import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.Reporter;
import com.pinterest.ktlint.reporter.format.internal.Color;
import com.pinterest.ktlint.reporter.format.internal.ColorKt;
import java.io.File;
import java.io.PrintStream;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\f\u0010\u0018\u001a\u00020\f*\u00020\fH\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pinterest/ktlint/reporter/format/FormatReporter;", "Lcom/pinterest/ktlint/core/Reporter;", "out", "Ljava/io/PrintStream;", "format", "", "shouldColorOutput", "outputColor", "Lcom/pinterest/ktlint/reporter/format/internal/Color;", "(Ljava/io/PrintStream;ZZLcom/pinterest/ktlint/reporter/format/internal/Color;)V", "countAutoCorrectPossibleOrDone", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "countCanNotBeAutoCorrected", "after", "", "file", "colorFileName", "fileName", "onLintError", "err", "Lcom/pinterest/ktlint/core/LintError;", "corrected", "colored", "ktlint-reporter-format"})
public final class FormatReporter
implements Reporter {
    @NotNull
    private final PrintStream out;
    private final boolean format;
    private final boolean shouldColorOutput;
    @NotNull
    private final Color outputColor;
    @NotNull
    private final ConcurrentHashMap<String, Integer> countAutoCorrectPossibleOrDone;
    @NotNull
    private final ConcurrentHashMap<String, Integer> countCanNotBeAutoCorrected;

    public FormatReporter(@NotNull PrintStream out, boolean format, boolean shouldColorOutput, @NotNull Color outputColor) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)((Object)outputColor), (String)"outputColor");
        this.out = out;
        this.format = format;
        this.shouldColorOutput = shouldColorOutput;
        this.outputColor = outputColor;
        this.countAutoCorrectPossibleOrDone = new ConcurrentHashMap();
        this.countCanNotBeAutoCorrected = new ConcurrentHashMap();
    }

    public /* synthetic */ FormatReporter(PrintStream printStream, boolean bl, boolean bl2, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            color = Color.DARK_GRAY;
        }
        this(printStream, bl, bl2, color);
    }

    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        if (err.getCanBeAutoCorrected() || corrected) {
            this.countAutoCorrectPossibleOrDone.putIfAbsent(file, 0);
            this.countAutoCorrectPossibleOrDone.replace(file, ((Number)this.countAutoCorrectPossibleOrDone.getOrDefault(file, 0)).intValue() + 1);
        } else {
            this.countCanNotBeAutoCorrected.putIfAbsent(file, 0);
            this.countCanNotBeAutoCorrected.replace(file, ((Number)this.countCanNotBeAutoCorrected.getOrDefault(file, 0)).intValue() + 1);
        }
    }

    public void after(@NotNull String file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = this.countCanNotBeAutoCorrected.getOrDefault(file, 0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"countCanNotBeAutoCorrected.getOrDefault(file, 0)");
        int canNotBeAutocorrected = ((Number)n).intValue();
        if (canNotBeAutocorrected == 1) {
            string = this.format ? "Format not completed (1 violation needs manual fixing)" : "Format required (1 violation needs manual fixing)";
        } else if (canNotBeAutocorrected > 1) {
            string = this.format ? "Format not completed (" + canNotBeAutocorrected + " violations need manual fixing)" : "Format required (" + canNotBeAutocorrected + " violations need manual fixing)";
        } else {
            Integer n2 = this.countAutoCorrectPossibleOrDone.getOrDefault(file, 0);
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"countAutoCorrectPossible\u2026one.getOrDefault(file, 0)");
            string = ((Number)n2).intValue() > 0 ? (this.format ? "Format completed (all violations have been fixed)" : "Format required (all violations can be autocorrected)") : "Format not needed (no violations found)";
        }
        String result = string;
        this.out.println(this.colorFileName(file) + this.colored(":") + ' ' + result);
    }

    private final String colorFileName(String fileName) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String name = StringsKt.substringAfterLast$default((String)fileName, (String)string, null, (int)2, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = fileName.substring(0, fileName.length() - name.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(this.colored(string2)).append(name).toString();
    }

    private final String colored(String $this$colored) {
        return this.shouldColorOutput ? ColorKt.color($this$colored, this.outputColor) : $this$colored;
    }

    public void afterAll() {
        Reporter.DefaultImpls.afterAll((Reporter)this);
    }

    public void before(@NotNull String file) {
        Reporter.DefaultImpls.before((Reporter)this, (String)file);
    }

    public void beforeAll() {
        Reporter.DefaultImpls.beforeAll((Reporter)this);
    }
}

