/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.core.internal;

import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.ParseException;
import com.pinterest.ktlint.core.internal.KotlinPsiFileFactoryProvider;
import com.pinterest.ktlint.core.internal.PositionInTextLocatorKt;
import com.pinterest.ktlint.core.internal.PreparedCode;
import com.pinterest.ktlint.core.internal.SuppressionLocatorBuilder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.ec4j.core.model.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"kotlinPsiFileFactoryProvider", "Lcom/pinterest/ktlint/core/internal/KotlinPsiFileFactoryProvider;", "normalizeText", "", "text", "prepareCodeForLinting", "Lcom/pinterest/ktlint/core/internal/PreparedCode;", "params", "Lcom/pinterest/ktlint/core/KtLint$ExperimentalParams;", "findErrorElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiErrorElement;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "ktlint-core"})
public final class PreparedCodeKt {
    @NotNull
    private static final KotlinPsiFileFactoryProvider kotlinPsiFileFactoryProvider = new KotlinPsiFileFactoryProvider();

    @NotNull
    public static final PreparedCode prepareCodeForLinting(@NotNull KtLint.ExperimentalParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        PsiFileFactory psiFileFactory = kotlinPsiFileFactoryProvider.getKotlinPsiFileFactory(params.isInvokedFromCli());
        String normalizedText = PreparedCodeKt.normalizeText(params.getText());
        Function1<Integer, Pair<Integer, Integer>> positionInTextLocator = PositionInTextLocatorKt.buildPositionInTextLocator(normalizedText);
        String psiFileName = params.getScript() ? "file.kts" : "file.kt";
        PsiFile psiFile = psiFileFactory.createFileFromText(psiFileName, (Language)KotlinLanguage.INSTANCE, (CharSequence)normalizedText);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile psiFile2 = (KtFile)psiFile;
        PsiErrorElement errorElement = PreparedCodeKt.findErrorElement((PsiElement)psiFile2);
        if (errorElement != null) {
            Pair pair = (Pair)positionInTextLocator.invoke((Object)errorElement.getTextOffset());
            int line = ((Number)pair.component1()).intValue();
            int col = ((Number)pair.component2()).intValue();
            String string = errorElement.getErrorDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"errorElement.errorDescription");
            throw new ParseException(line, col, string);
        }
        FileASTNode fileASTNode = psiFile2.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)fileASTNode, (String)"psiFile.node");
        FileASTNode rootNode = fileASTNode;
        Map<String, Property> editorConfigProperties2 = KtLint.INSTANCE.getEditorConfigLoader$ktlint_core().load(params.getNormalizedFilePath$ktlint_core(), params.getRules$ktlint_core(), params.getEditorConfigDefaults(), params.getEditorConfigOverride());
        if (!params.isStdIn$ktlint_core()) {
            rootNode.putUserData(KtLint.INSTANCE.getFILE_PATH_USER_DATA_KEY(), (Object)String.valueOf(params.getNormalizedFilePath$ktlint_core()));
        }
        rootNode.putUserData(KtLint.INSTANCE.getEDITOR_CONFIG_PROPERTIES_USER_DATA_KEY(), editorConfigProperties2);
        Function3<Integer, String, Boolean, Boolean> suppressedRegionLocator = SuppressionLocatorBuilder.INSTANCE.buildSuppressedRegionsLocator((ASTNode)rootNode);
        return new PreparedCode(rootNode, editorConfigProperties2, positionInTextLocator, suppressedRegionLocator);
    }

    private static final String normalizeText(String text) {
        return StringsKt.replaceFirst$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (String)"\r", (String)"\n", (boolean)false, (int)4, null), (String)"\ufeff", (String)"", (boolean)false, (int)4, null);
    }

    private static final PsiErrorElement findErrorElement(PsiElement $this$findErrorElement) {
        if ($this$findErrorElement instanceof PsiErrorElement) {
            return (PsiErrorElement)$this$findErrorElement;
        }
        PsiElement[] psiElementArray = $this$findErrorElement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"this.children");
        Object[] $this$forEach$iv = psiElementArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement child = (PsiElement)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            PsiErrorElement errorElement = PreparedCodeKt.findErrorElement(child);
            if (errorElement == null) continue;
            return errorElement;
        }
        return null;
    }
}

