/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.core.internal;

import com.pinterest.ktlint.core.api.EditorConfigDefaults;
import com.pinterest.ktlint.core.internal.EditorConfigDefaultsLoaderKt;
import com.pinterest.ktlint.core.internal.ThreadSafeEditorConfigCache;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.ec4j.core.EditorConfigLoader;
import org.ec4j.core.Resource;
import org.ec4j.core.model.EditorConfig;
import org.ec4j.core.model.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0014\u0010\t\u001a\n \n*\u0004\u0018\u00010\b0\b*\u00020\bH\u0002J\u0014\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\f*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/pinterest/ktlint/core/internal/EditorConfigDefaultsLoader;", "", "()V", "editorConfigLoader", "Lorg/ec4j/core/EditorConfigLoader;", "load", "Lcom/pinterest/ktlint/core/api/EditorConfigDefaults;", "path", "Ljava/nio/file/Path;", "editorConfigFilePath", "kotlin.jvm.PlatformType", "resource", "Lorg/ec4j/core/Resource;", "ktlint-core"})
public final class EditorConfigDefaultsLoader {
    @NotNull
    private final EditorConfigLoader editorConfigLoader;

    public EditorConfigDefaultsLoader() {
        EditorConfigLoader editorConfigLoader = EditorConfigLoader.of((Version)Version.CURRENT);
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigLoader, (String)"of(Version.CURRENT)");
        this.editorConfigLoader = editorConfigLoader;
    }

    @NotNull
    public final EditorConfigDefaults load(@Nullable Path path) {
        EditorConfig editorConfig;
        if (path == null || StringsKt.isBlank((CharSequence)((Object)path).toString())) {
            return EditorConfigDefaults.Companion.getEmptyEditorConfigDefaults();
        }
        Path editorConfigFilePath = this.editorConfigFilePath(path);
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigFilePath, (String)"editorConfigFilePath");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(editorConfigFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            EditorConfigDefaultsLoaderKt.access$getLogger$p().warn((Function0)new Function0<Object>(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "File or directory '" + this.$path + "' is not found. Can not load '.editorconfig' properties";
                }
            });
            return EditorConfigDefaults.Companion.getEmptyEditorConfigDefaults();
        }
        ThreadSafeEditorConfigCache threadSafeEditorConfigCache = ThreadSafeEditorConfigCache.Companion.getThreadSafeEditorConfigCache();
        Resource resource = this.resource(editorConfigFilePath);
        Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"editorConfigFilePath.resource()");
        EditorConfig it = editorConfig = threadSafeEditorConfigCache.get(resource, this.editorConfigLoader);
        boolean bl = false;
        EditorConfigDefaultsLoaderKt.access$getLogger$p().trace((Function0)new Function0<Object>(it, editorConfigFilePath){
            final /* synthetic */ EditorConfig $it;
            final /* synthetic */ Path $editorConfigFilePath;
            {
                this.$it = $it;
                this.$editorConfigFilePath = $editorConfigFilePath;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String string = this.$it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it\n                        .toString()");
                Object object = new String[]{"\n"};
                List list = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
                object = "Loaded .editorconfig-properties from file '" + this.$editorConfigFilePath + "':\n\t";
                return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n\t", (CharSequence)((CharSequence)object), null, (int)0, null, null, (int)60, null);
            }
        });
        it = editorConfig;
        boolean bl2 = false;
        return new EditorConfigDefaults(it);
    }

    private final Path editorConfigFilePath(Path $this$editorConfigFilePath) {
        Path path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory($this$editorConfigFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            String path2 = ((Object)$this$editorConfigFilePath).toString() + $this$editorConfigFilePath.getFileSystem().getSeparator() + ".editorconfig";
            boolean bl = false;
            path = $this$editorConfigFilePath.getFileSystem().getPath(path2, new String[0]);
        } else {
            path = $this$editorConfigFilePath;
        }
        return path;
    }

    private final Resource resource(Path $this$resource) {
        return Resource.Resources.ofPath((Path)$this$resource, (Charset)StandardCharsets.UTF_8);
    }
}

