/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.core.api;

import com.pinterest.ktlint.core.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.api.Baseline;
import com.pinterest.ktlint.core.api.BaselineKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003\u001a\"\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\r\u001a\u0018\u0010\u0013\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\r\u001a\u0014\u0010\u0014\u001a\u00020\u0011*\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u001a\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"logger", "Lmu/KLogger;", "relativeRoute", "", "Ljava/io/File;", "getRelativeRoute", "(Ljava/io/File;)Ljava/lang/String;", "loadBaseline", "Lcom/pinterest/ktlint/core/api/Baseline;", "path", "parseBaseline", "", "", "Lcom/pinterest/ktlint/core/LintError;", "inputStream", "Ljava/io/InputStream;", "containsLintError", "", "lintError", "doesNotContain", "isSameAs", "parseBaselineErrorsByFile", "Lorg/w3c/dom/Element;", "ktlint-core"})
public final class BaselineKt {
    @NotNull
    private static final KLogger logger = KtLintKLoggerInitializerKt.initKtLintKLogger(KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE));

    @NotNull
    public static final Baseline loadBaseline(@NotNull String path) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File it = file2 = Paths.get(path, new String[0]).toFile();
        boolean bl = false;
        File file3 = file = it.exists() ? file2 : null;
        if (file != null) {
            File baselineFile = file;
            boolean bl2 = false;
            try {
                return new Baseline(BaselineKt.parseBaseline(new FileInputStream(baselineFile)), Baseline.Status.VALID);
            }
            catch (IOException e) {
                logger.error((Function0)new Function0<Object>(path){
                    final /* synthetic */ String $path;
                    {
                        this.$path = $path;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to parse baseline file: " + this.$path;
                    }
                });
            }
            catch (ParserConfigurationException e) {
                logger.error((Function0)new Function0<Object>(path){
                    final /* synthetic */ String $path;
                    {
                        this.$path = $path;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to parse baseline file: " + this.$path;
                    }
                });
            }
            catch (SAXException e) {
                logger.error((Function0)new Function0<Object>(path){
                    final /* synthetic */ String $path;
                    {
                        this.$path = $path;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to parse baseline file: " + this.$path;
                    }
                });
            }
            try {
                baselineFile.delete();
            }
            catch (IOException e) {
                logger.error((Function0)new Function0<Object>(path){
                    final /* synthetic */ String $path;
                    {
                        this.$path = $path;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unable to delete baseline file: " + this.$path;
                    }
                });
            }
            return new Baseline(null, Baseline.Status.INVALID, 1, null);
        }
        return new Baseline(null, Baseline.Status.NOT_FOUND, 1, null);
    }

    @NotNull
    public static final Map<String, List<LintError>> parseBaseline(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        HashMap lintErrorsPerFile = new HashMap();
        NodeList fileNodeList = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream).getElementsByTagName("file");
        int n = fileNodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            Node node = fileNodeList.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element $this$parseBaseline_u24lambda_u2d2 = (Element)node;
            boolean bl = false;
            Map map = lintErrorsPerFile;
            Intrinsics.checkNotNullExpressionValue((Object)$this$parseBaseline_u24lambda_u2d2.getAttribute("name"), (String)"getAttribute(\"name\")");
            List<LintError> list = BaselineKt.parseBaselineErrorsByFile($this$parseBaseline_u24lambda_u2d2);
            map.put(string, list);
        }
        return lintErrorsPerFile;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<LintError> parseBaselineErrorsByFile(Element $this$parseBaselineErrorsByFile) {
        List errors = new ArrayList();
        NodeList errorsList = $this$parseBaselineErrorsByFile.getElementsByTagName("error");
        int n = errorsList.getLength();
        for (int i = 0; i < n; ++i) {
            void $this$parseBaselineErrorsByFile_u24lambda_u2d3;
            Node node = errorsList.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element element = (Element)node;
            List list = errors;
            boolean bl = false;
            String string = $this$parseBaselineErrorsByFile_u24lambda_u2d3.getAttribute("line");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(\"line\")");
            int n2 = Integer.parseInt(string);
            String string2 = $this$parseBaselineErrorsByFile_u24lambda_u2d3.getAttribute("column");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttribute(\"column\")");
            int n3 = Integer.parseInt(string2);
            String string3 = $this$parseBaselineErrorsByFile_u24lambda_u2d3.getAttribute("source");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttribute(\"source\")");
            list.add(new LintError(n2, n3, string3, ""));
        }
        return errors;
    }

    public static final boolean containsLintError(@NotNull List<LintError> $this$containsLintError, @NotNull LintError lintError) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$containsLintError, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)lintError, (String)"lintError");
            Iterable $this$any$iv = $this$containsLintError;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LintError it = (LintError)element$iv;
                    boolean bl2 = false;
                    if (!BaselineKt.isSameAs(it, lintError)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isSameAs(LintError $this$isSameAs, LintError lintError) {
        return $this$isSameAs.getCol() == lintError.getCol() && $this$isSameAs.getLine() == lintError.getLine() && Intrinsics.areEqual((Object)$this$isSameAs.getRuleId(), (Object)lintError.getRuleId());
    }

    public static final boolean doesNotContain(@NotNull List<LintError> $this$doesNotContain, @NotNull LintError lintError) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$doesNotContain, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)lintError, (String)"lintError");
            Iterable $this$none$iv = $this$doesNotContain;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    LintError it = (LintError)element$iv;
                    boolean bl2 = false;
                    if (!BaselineKt.isSameAs(it, lintError)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public static final String getRelativeRoute(@NotNull File $this$relativeRoute) {
        Intrinsics.checkNotNullParameter((Object)$this$relativeRoute, (String)"<this>");
        Path rootPath = Paths.get("", new String[0]).toAbsolutePath();
        Path filePath = $this$relativeRoute.toPath();
        return StringsKt.replace$default((String)((Object)rootPath.relativize(filePath)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }
}

