/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.core;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.RuleProvider;
import com.pinterest.ktlint.core.internal.QualifiedRuleIdKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\r\u0010 \u001a\u00020\nH\u0000\u00a2\u0006\u0002\b!J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\b\u00a8\u0006\""}, d2={"Lcom/pinterest/ktlint/core/RuleRunner;", "", "provider", "Lcom/pinterest/ktlint/core/RuleProvider;", "(Lcom/pinterest/ktlint/core/RuleProvider;)V", "qualifiedRuleId", "", "getQualifiedRuleId$ktlint_core", "()Ljava/lang/String;", "rule", "Lcom/pinterest/ktlint/core/Rule;", "ruleId", "getRuleId$ktlint_core", "ruleSetId", "getRuleSetId$ktlint_core", "runAfterRule", "Lcom/pinterest/ktlint/core/Rule$VisitorModifier$RunAfterRule;", "getRunAfterRule", "()Lcom/pinterest/ktlint/core/Rule$VisitorModifier$RunAfterRule;", "setRunAfterRule", "(Lcom/pinterest/ktlint/core/Rule$VisitorModifier$RunAfterRule;)V", "runAsLateAsPossible", "", "getRunAsLateAsPossible", "()Z", "runOnRootNodeOnly", "getRunOnRootNodeOnly", "shortenedQualifiedRuleId", "getShortenedQualifiedRuleId$ktlint_core", "clearRunAfterRule", "", "clearRunAfterRule$ktlint_core", "getRule", "getRule$ktlint_core", "ktlint-core"})
public final class RuleRunner {
    @NotNull
    private final RuleProvider provider;
    @NotNull
    private Rule rule;
    @NotNull
    private final String qualifiedRuleId;
    @NotNull
    private final String shortenedQualifiedRuleId;
    @NotNull
    private final String ruleId;
    @NotNull
    private final String ruleSetId;
    private final boolean runOnRootNodeOnly;
    private final boolean runAsLateAsPossible;
    @Nullable
    private Rule.VisitorModifier.RunAfterRule runAfterRule;

    public RuleRunner(@NotNull RuleProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
        this.rule = this.provider.createNewRuleInstance();
        this.qualifiedRuleId = QualifiedRuleIdKt.toQualifiedRuleId(this.rule);
        this.shortenedQualifiedRuleId = StringsKt.removePrefix((String)this.qualifiedRuleId, (CharSequence)"standard:");
        this.ruleId = this.rule.getId();
        this.ruleSetId = StringsKt.substringBefore$default((String)this.qualifiedRuleId, (char)':', null, (int)2, null);
        this.runOnRootNodeOnly = this.rule.getVisitorModifiers().contains(Rule.VisitorModifier.RunOnRootNodeOnly.INSTANCE);
        this.runAsLateAsPossible = this.rule.getVisitorModifiers().contains(Rule.VisitorModifier.RunAsLateAsPossible.INSTANCE);
        this.runAfterRule = this.setRunAfterRule();
    }

    @NotNull
    public final String getQualifiedRuleId$ktlint_core() {
        return this.qualifiedRuleId;
    }

    @NotNull
    public final String getShortenedQualifiedRuleId$ktlint_core() {
        return this.shortenedQualifiedRuleId;
    }

    @NotNull
    public final String getRuleId$ktlint_core() {
        return this.ruleId;
    }

    @NotNull
    public final String getRuleSetId$ktlint_core() {
        return this.ruleSetId;
    }

    public final boolean getRunOnRootNodeOnly() {
        return this.runOnRootNodeOnly;
    }

    public final boolean getRunAsLateAsPossible() {
        return this.runAsLateAsPossible;
    }

    @Nullable
    public final Rule.VisitorModifier.RunAfterRule getRunAfterRule() {
        return this.runAfterRule;
    }

    public final void setRunAfterRule(@Nullable Rule.VisitorModifier.RunAfterRule runAfterRule) {
        this.runAfterRule = runAfterRule;
    }

    @NotNull
    public final Rule getRule$ktlint_core() {
        if (this.rule.isUsedForTraversalOfAST$ktlint_core()) {
            this.rule = this.provider.createNewRuleInstance();
        }
        return this.rule;
    }

    private final Rule.VisitorModifier.RunAfterRule setRunAfterRule() {
        Rule.VisitorModifier.RunAfterRule runAfterRule;
        Object v0;
        block4: {
            Iterable iterable = this.rule.getVisitorModifiers();
            for (Object t : iterable) {
                Rule.VisitorModifier it = (Rule.VisitorModifier)t;
                boolean bl = false;
                if (!(it instanceof Rule.VisitorModifier.RunAfterRule)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Rule.VisitorModifier visitorModifier = v0;
        if (visitorModifier != null) {
            Rule.VisitorModifier it = visitorModifier;
            boolean bl = false;
            Rule.VisitorModifier.RunAfterRule runAfterRuleVisitorModifier = (Rule.VisitorModifier.RunAfterRule)it;
            String qualifiedAfterRuleId = QualifiedRuleIdKt.toQualifiedRuleId(runAfterRuleVisitorModifier.getRuleId());
            if (!(!Intrinsics.areEqual((Object)this.qualifiedRuleId, (Object)qualifiedAfterRuleId))) {
                boolean bl2 = false;
                String string = "Rule with id '" + this.rule.getId() + "' has a visitor modifier of type '" + Reflection.getOrCreateKotlinClass(Rule.VisitorModifier.RunAfterRule.class).getSimpleName() + "' but it is not referring to another rule but to the rule itself. A rule can not run after itself. This should be fixed by the maintainer of the rule.";
                throw new IllegalStateException(string.toString());
            }
            runAfterRule = Rule.VisitorModifier.RunAfterRule.copy$default(runAfterRuleVisitorModifier, qualifiedAfterRuleId, false, false, 6, null);
        } else {
            runAfterRule = null;
        }
        return runAfterRule;
    }

    public final void clearRunAfterRule$ktlint_core() {
        if (!(!this.rule.isUsedForTraversalOfAST$ktlint_core())) {
            boolean bl = false;
            String string = "RunAfterRule can not be cleared when rule has already been used for traversal of the AST";
            throw new IllegalArgumentException(string.toString());
        }
        this.runAfterRule = null;
    }
}

