/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.reporter.checkstyle;

import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\f\u0010\u0010\u001a\u00020\b*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/pinterest/ktlint/cli/reporter/checkstyle/CheckStyleReporter;", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "out", "Ljava/io/PrintStream;", "<init>", "(Ljava/io/PrintStream;)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "onLintError", "", "file", "ktlintCliError", "afterAll", "escapeXMLAttrValue", "ktlint-cli-reporter-checkstyle"})
@SourceDebugExtension(value={"SMAP\nCheckStyleReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckStyleReporter.kt\ncom/pinterest/ktlint/cli/reporter/checkstyle/CheckStyleReporter\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n72#2,2:51\n1#3:53\n1053#4:54\n*S KotlinDebug\n*F\n+ 1 CheckStyleReporter.kt\ncom/pinterest/ktlint/cli/reporter/checkstyle/CheckStyleReporter\n*L\n20#1:51,2\n20#1:53\n27#1:54\n*E\n"})
public final class CheckStyleReporter
implements ReporterV2 {
    @NotNull
    private final PrintStream out;
    @NotNull
    private final ConcurrentHashMap<String, List<KtlintCliError>> acc;

    public CheckStyleReporter(@NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.acc = new ConcurrentHashMap();
    }

    public void onLintError(@NotNull String file, @NotNull KtlintCliError ktlintCliError) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktlintCliError, (String)"ktlintCliError");
        if (ktlintCliError.getStatus() != KtlintCliError.Status.FORMAT_IS_AUTOCORRECTED) {
            ConcurrentMap $this$getOrPut$iv = this.acc;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(file);
            if (object == null) {
                boolean bl = false;
                List default$iv = new ArrayList();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(file, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((List)object).add(ktlintCliError);
        }
    }

    public void afterAll() {
        this.out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.out.println("<checkstyle version=\"8.0\">");
        Set<Map.Entry<String, List<KtlintCliError>>> set = this.acc.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        for (Object e : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        })) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Map.Entry entry = (Map.Entry)e;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String file = (String)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            List errList = (List)v;
            this.out.println("    <file name=\"" + this.escapeXMLAttrValue(file) + "\">");
            Iterator iterator = errList.iterator();
            while (iterator.hasNext()) {
                KtlintCliError err;
                KtlintCliError $this$afterAll_u24lambda_u242 = err = (KtlintCliError)iterator.next();
                boolean bl = false;
                String message = this.escapeXMLAttrValue($this$afterAll_u24lambda_u242.getDetail());
                this.out.println("        <error line=\"" + $this$afterAll_u24lambda_u242.getLine() + "\" column=\"" + $this$afterAll_u24lambda_u242.getCol() + "\" severity=\"error\" message=\"" + message + "\" source=\"" + $this$afterAll_u24lambda_u242.getRuleId() + "\" />");
            }
            this.out.println("    </file>");
        }
        this.out.println("</checkstyle>");
    }

    private final String escapeXMLAttrValue(String $this$escapeXMLAttrValue) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeXMLAttrValue, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"\"", (String)"&quot;", (boolean)false, (int)4, null), (String)"'", (String)"&apos;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    public void beforeAll() {
        ReporterV2.DefaultImpls.beforeAll((ReporterV2)this);
    }

    public void before(@NotNull String file) {
        ReporterV2.DefaultImpls.before((ReporterV2)this, (String)file);
    }

    public void after(@NotNull String file) {
        ReporterV2.DefaultImpls.after((ReporterV2)this, (String)file);
    }
}

