/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.pinterest.ktlint.cli.internal.CodeStyleValueConverter;
import com.pinterest.ktlint.cli.internal.FileUtilsKt;
import com.pinterest.ktlint.cli.internal.KtlintCommandLine;
import com.pinterest.ktlint.cli.internal.KtlintCommandLineKt;
import com.pinterest.ktlint.cli.internal.KtlintVersionProvider;
import com.pinterest.ktlint.cli.internal.LoadRuleProvidersKt;
import com.pinterest.ktlint.cli.internal.LogLevelConverter;
import com.pinterest.ktlint.cli.internal.ReporterAggregator;
import com.pinterest.ktlint.cli.reporter.baseline.Baseline;
import com.pinterest.ktlint.cli.reporter.baseline.BaselineKt;
import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import com.pinterest.ktlint.cli.reporter.plain.Color;
import com.pinterest.ktlint.logger.api.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.rule.engine.api.Code;
import com.pinterest.ktlint.rule.engine.api.EditorConfigDefaults;
import com.pinterest.ktlint.rule.engine.api.EditorConfigOverride;
import com.pinterest.ktlint.rule.engine.api.KtLintParseException;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleEngine;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleException;
import com.pinterest.ktlint.rule.engine.api.LintError;
import com.pinterest.ktlint.rule.engine.core.api.RuleId;
import com.pinterest.ktlint.rule.engine.core.api.RuleProvider;
import com.pinterest.ktlint.rule.engine.core.api.RuleProviderKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecution;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecutionEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.rules.FilenameRuleKt;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=KtlintVersionProvider.class, mixinStandardHelpOptions=true, headerHeading="\nAn anti-bikeshedding Kotlin linter with built-in formatter.\n(https://github.com/pinterest/ktlint).\n\nUsage:\n  ktlint <flags> [patterns]\n  java -jar ktlint.jar <flags> [patterns]\n\nExamples:\n  # Check the style of all Kotlin files (ending with '.kt' or '.kts') inside the current dir (recursively).\n  #\n  # Hidden folders will be skipped.\n  ktlint\n\n  # Check only certain locations starting from the current directory.\n  #\n  # Prepend ! to negate the pattern, KtLint uses .gitignore pattern style syntax.\n  # Globs are applied starting from the last one.\n  #\n  # Hidden folders will be skipped.\n  # Check all '.kt' files in 'src/' directory, but ignore files ending with 'Test.kt':\n  ktlint \"src/**/*.kt\" \"!src/**/*Test.kt\"\n  # Check all '.kt' files in 'src/' directory, but ignore 'generated' directory and its subdirectories:\n  ktlint \"src/**/*.kt\" \"!src/**/generated/**\"\n\n  # Auto-correct style violations.\n  ktlint -F \"src/**/*.kt\"\n\n  # Using custom reporter jar and overriding report location\n  ktlint --reporter=csv,artifact=/path/to/reporter/csv.jar,output=my-custom-report.csv\nFlags:\n", synopsisHeading="", customSynopsis={""}, sortOptions=false)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010?\u001a\u00020@H\u0002J\r\u0010A\u001a\u00020@H\u0000\u00a2\u0006\u0002\bBJ%\u0010C\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020G0F\u0012\u0004\u0012\u00020G0E0DH\u0002\u00a2\u0006\u0002\u0010HJ\u0016\u0010I\u001a\u00020J2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LH\u0002J,\u0010)\u001a\b\u0012\u0004\u0012\u00020N012\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020N01H\u0002J,\u0010T\u001a\b\u0012\u0004\u0012\u00020N012\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020N01H\u0002J2\u0010U\u001a\u00020@2\u0006\u0010O\u001a\u00020P2\u0018\u0010V\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020N010W2\u0006\u0010X\u001a\u00020YH\u0002J\u0018\u0010Z\u001a\u00020@2\u0006\u0010O\u001a\u00020P2\u0006\u0010X\u001a\u00020YH\u0002J,\u0010[\u001a\b\u0012\u0004\u0012\u00020N012\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020N01H\u0002J\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u000b0L2\u0006\u0010]\u001a\u00020\u000bH\u0002J&\u0010^\u001a\u00020@2\u0006\u0010_\u001a\u00020\u000b2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020N012\u0006\u0010X\u001a\u00020YH\u0002J\u0013\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LH\u0000\u00a2\u0006\u0002\baJ\u0006\u0010b\u001a\u00020@J<\u0010c\u001a\u00020@\"\u0004\b\u0000\u0010d*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hd0f0e2\u0012\u0010g\u001a\u000e\u0012\u0004\u0012\u0002Hd\u0012\u0004\u0012\u00020@0h2\b\b\u0002\u0010i\u001a\u00020+H\u0002J\u0018\u0010j\u001a\b\u0012\u0004\u0012\u00020\u000b01*\b\u0012\u0004\u0012\u00020\u000b01H\u0002J\u0018\u0010k\u001a\u00020N*\u00060lj\u0002`m2\u0006\u0010Q\u001a\u00020RH\u0002R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\tR\u001e\u0010\u0015\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00048@@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0007R\u001e\u0010\u001f\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\u0019R\u0014\u0010\"\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0007\"\u0004\b'\u0010\tR\u000e\u0010(\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\u00020+8B@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0012\u0010.\u001a\u00020/8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b018\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0007\"\u0004\b4\u0010\tR\u0018\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b018\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R$\u00106\u001a\b\u0012\u0004\u0012\u00020\u000b018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0012\u0010;\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/pinterest/ktlint/cli/internal/KtlintCommandLine;", "", "()V", "android", "", "getAndroid$annotations", "getAndroid", "()Z", "setAndroid", "(Z)V", "baselinePath", "", "codeStyle", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "getCodeStyle", "()Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "setCodeStyle", "(Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;)V", "color", "getColor", "setColor", "colorName", "getColorName", "()Ljava/lang/String;", "setColorName", "(Ljava/lang/String;)V", "commandSpec", "Lpicocli/CommandLine$Model$CommandSpec;", "<set-?>", "debug", "getDebug$ktlint_cli", "disabledRules", "getDisabledRules", "setDisabledRules", "editorConfigPath", "errorNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "experimental", "getExperimental", "setExperimental", "fileNumber", "format", "limit", "", "getLimit", "()I", "minLogLevel", "Lch/qos/logback/classic/Level;", "patterns", "", "relative", "getRelative", "setRelative", "reporterConfigurations", "rulesetJarPaths", "getRulesetJarPaths", "()Ljava/util/List;", "setRulesetJarPaths", "(Ljava/util/List;)V", "stdin", "stdinDelimiter", "tripped", "Ljava/util/concurrent/atomic/AtomicBoolean;", "assertStdinAndPatternsFromStdinOptionsMutuallyExclusive", "", "configureLogger", "configureLogger$ktlint_cli", "disabledRulesEditorConfigOverrides", "", "Lkotlin/Pair;", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/RuleExecution;", "()[Lkotlin/Pair;", "editorConfigDefaults", "Lcom/pinterest/ktlint/rule/engine/api/EditorConfigDefaults;", "ruleProviders", "", "Lcom/pinterest/ktlint/rule/engine/core/api/RuleProvider;", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "ktLintRuleEngine", "Lcom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine;", "code", "Lcom/pinterest/ktlint/rule/engine/api/Code;", "baselineLintErrors", "lint", "lintFiles", "lintErrorsPerFile", "", "reporter", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "lintStdin", "process", "readPatternsFromStdin", "delimiter", "report", "relativeRoute", "ktlintCliErrors", "ruleProviders$ktlint_cli", "run", "parallel", "T", "Lkotlin/sequences/Sequence;", "Ljava/util/concurrent/Callable;", "cb", "Lkotlin/Function1;", "numberOfThreads", "replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty", "toKtlintCliError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "ktlint-cli"})
@SourceDebugExtension(value={"SMAP\nKtlintCommandLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtlintCommandLine.kt\ncom/pinterest/ktlint/cli/internal/KtlintCommandLine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,760:1\n766#2:761\n857#2,2:762\n1549#2:764\n1620#2,3:765\n1549#2:768\n1620#2,3:769\n1855#2,2:779\n857#2,2:781\n37#3,2:772\n259#4:774\n259#4:775\n259#4:776\n259#4:777\n1#5:778\n*S KotlinDebug\n*F\n+ 1 KtlintCommandLine.kt\ncom/pinterest/ktlint/cli/internal/KtlintCommandLine\n*L\n247#1:761\n247#1:762,2\n248#1:764\n248#1:765,3\n251#1:768\n251#1:769,3\n454#1:779,2\n620#1:781,2\n252#1:772,2\n258#1:774\n261#1:775\n264#1:776\n267#1:777\n*E\n"})
public final class KtlintCommandLine {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec commandSpec;
    @CommandLine.Option(names={"--android", "-a"}, description={"Turn on Android Kotlin Style Guide compatibility"}, hidden=true)
    private boolean android;
    @CommandLine.Option(names={"--code-style"}, description={"Defines the code style (ktlint_official, intellij_idea or android_studio) to be used for formatting the code. It is advised to define '.editorconfig' property 'ktlint_code_style'."}, converter={CodeStyleValueConverter.class}, scope=CommandLine.ScopeType.INHERIT)
    @Nullable
    private CodeStyleValue codeStyle;
    @CommandLine.Option(names={"--color"}, description={"Make output colorful"})
    private boolean color;
    @CommandLine.Option(names={"--color-name"}, description={"Customize the output color"})
    @NotNull
    private String colorName = Color.DARK_GRAY.name();
    @CommandLine.Option(names={"--disabled_rules"}, description={"Comma-separated list of rules to globally disable. To disable standard ktlint rule-set use --disabled_rules=standard"})
    @NotNull
    private String disabledRules = "";
    @CommandLine.Option(names={"--format", "-F"}, description={"Fix any deviations from the code style"})
    private boolean format;
    @CommandLine.Option(names={"--limit"}, description={"Maximum number of errors to show (default: show all)"})
    private int limit = -1;
    @CommandLine.Option(names={"--relative"}, description={"Print files relative to the working directory (e.g. dir/file.kt instead of /home/user/project/dir/file.kt)"})
    private boolean relative;
    @CommandLine.Option(names={"--reporter"}, description={"A reporter to use (built-in: plain (default), plain?group_by_file, plain-summary, json, sarif, checkstyle, html). To use a third-party reporter specify a path to a JAR file on the filesystem via ',artifact=' option. To override reporter output, use ',output=' option."})
    @NotNull
    private List<String> reporterConfigurations = new ArrayList();
    @CommandLine.Option(names={"--ruleset", "-R"}, description={"A path to a JAR file containing additional ruleset(s)"})
    @NotNull
    private List<String> rulesetJarPaths = new ArrayList();
    @CommandLine.Option(names={"--stdin"}, description={"Read file from stdin"})
    private boolean stdin;
    @CommandLine.Option(names={"--patterns-from-stdin"}, description={"Read additional patterns to check/format from stdin. Patterns are delimited by the given argument. (default is newline) If the argument is an empty string, the NUL byte is used."}, arity="0..1", fallbackValue="\n")
    @Nullable
    private String stdinDelimiter;
    @CommandLine.Option(names={"--editorconfig"}, description={"Path to the default '.editorconfig'. A property value from this file is used only when no '.editorconfig' file on the path to the source file specifies that property. Note: up until ktlint 0.46 the property value in this file used to override values found in '.editorconfig' files on the path to the source file."})
    @Nullable
    private String editorConfigPath;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental rules"})
    private boolean experimental;
    @CommandLine.Option(names={"--baseline"}, description={"Defines a baseline file to check against"})
    @NotNull
    private String baselinePath = "";
    @CommandLine.Parameters(hidden=true)
    @NotNull
    private List<String> patterns = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--log-level", "-l"}, description={"Defines the minimum log level (trace, debug, info, warn, error) or none to suppress all logging"}, converter={LogLevelConverter.class})
    @NotNull
    private Level minLogLevel;
    @NotNull
    private final AtomicBoolean tripped;
    @NotNull
    private final AtomicInteger fileNumber;
    @NotNull
    private final AtomicInteger errorNumber;
    private boolean debug;

    public KtlintCommandLine() {
        Level level = Level.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
        this.minLogLevel = level;
        this.tripped = new AtomicBoolean();
        this.fileNumber = new AtomicInteger();
        this.errorNumber = new AtomicInteger();
    }

    public final boolean getAndroid() {
        return this.android;
    }

    public final void setAndroid(boolean bl) {
        this.android = bl;
    }

    @Deprecated(message="Marked for removal in KtLint 0.50")
    public static /* synthetic */ void getAndroid$annotations() {
    }

    @Nullable
    public final CodeStyleValue getCodeStyle() {
        return this.codeStyle;
    }

    public final void setCodeStyle(@Nullable CodeStyleValue codeStyleValue) {
        this.codeStyle = codeStyleValue;
    }

    public final boolean getColor() {
        return this.color;
    }

    public final void setColor(boolean bl) {
        this.color = bl;
    }

    @NotNull
    public final String getColorName() {
        return this.colorName;
    }

    public final void setColorName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.colorName = string;
    }

    @NotNull
    public final String getDisabledRules() {
        return this.disabledRules;
    }

    public final void setDisabledRules(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.disabledRules = string;
    }

    private final int getLimit() {
        return this.limit < 0 ? Integer.MAX_VALUE : this.limit;
    }

    public final boolean getRelative() {
        return this.relative;
    }

    public final void setRelative(boolean bl) {
        this.relative = bl;
    }

    @NotNull
    public final List<String> getRulesetJarPaths() {
        return this.rulesetJarPaths;
    }

    public final void setRulesetJarPaths(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.rulesetJarPaths = list;
    }

    public final boolean getExperimental() {
        return this.experimental;
    }

    public final void setExperimental(boolean bl) {
        this.experimental = bl;
    }

    public final boolean getDebug$ktlint_cli() {
        return Level.DEBUG.isGreaterOrEqual(this.minLogLevel);
    }

    private final Pair<EditorConfigProperty<RuleExecution>, RuleExecution>[] disabledRulesEditorConfigOverrides() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)this.disabledRules, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(RuleId.Companion.prefixWithStandardRuleSetIdWhenMissing(it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)RuleExecutionEditorConfigPropertyKt.createRuleExecutionEditorConfigProperty-U7AdEiY$default((String)RuleId.constructor-impl((String)it), null, (int)1, null), (Object)RuleExecution.disabled));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Pair[0]);
    }

    /*
     * WARNING - void declaration
     */
    public final void run() {
        void editorConfigOverride2;
        EditorConfigOverride editorConfigOverride3;
        EditorConfigOverride editorConfigOverride4;
        EditorConfigOverride editorConfigOverride5;
        EditorConfigOverride editorConfigOverride6;
        Pair[] pairArray;
        void $this$applyIf$iv;
        EditorConfigOverride editorConfigOverride7 = EditorConfigOverride.Companion.getEMPTY_EDITOR_CONFIG_OVERRIDE();
        boolean if$iv = this.experimental;
        boolean $i$f$applyIf = false;
        if (if$iv) {
            void $this$run_u24lambda_u243 = $this$applyIf$iv;
            boolean bl = false;
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.debug((Function0)run.editorConfigOverride.1.1.INSTANCE);
            pairArray = new Pair[]{TuplesKt.to((Object)RuleExecutionEditorConfigPropertyKt.getEXPERIMENTAL_RULES_EXECUTION_PROPERTY(), (Object)RuleExecution.enabled)};
            editorConfigOverride6 = EditorConfigOverride.Companion.plus((EditorConfigOverride)$this$run_u24lambda_u243, pairArray);
        } else {
            editorConfigOverride6 = $this$applyIf$iv;
        }
        $this$applyIf$iv = editorConfigOverride6;
        if$iv = !StringsKt.isBlank((CharSequence)this.disabledRules);
        $i$f$applyIf = false;
        if (if$iv) {
            void $this$run_u24lambda_u244 = $this$applyIf$iv;
            boolean bl = false;
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.debug((Function0)new Function0<Object>(this){
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Add editor config override to disable rules: '" + this.this$0.getDisabledRules() + '\'';
                }
            });
            pairArray = this.disabledRulesEditorConfigOverrides();
            editorConfigOverride5 = EditorConfigOverride.Companion.plus((EditorConfigOverride)$this$run_u24lambda_u244, Arrays.copyOf(pairArray, pairArray.length));
        } else {
            editorConfigOverride5 = $this$applyIf$iv;
        }
        $this$applyIf$iv = editorConfigOverride5;
        if$iv = this.android || this.codeStyle == CodeStyleValue.android || this.codeStyle == CodeStyleValue.android_studio;
        $i$f$applyIf = false;
        if (if$iv) {
            void $this$run_u24lambda_u245 = $this$applyIf$iv;
            boolean bl = false;
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.debug((Function0)run.editorConfigOverride.3.1.INSTANCE);
            pairArray = new Pair[]{TuplesKt.to((Object)CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY(), (Object)CodeStyleValue.android_studio)};
            editorConfigOverride4 = EditorConfigOverride.Companion.plus((EditorConfigOverride)$this$run_u24lambda_u245, pairArray);
        } else {
            editorConfigOverride4 = $this$applyIf$iv;
        }
        $this$applyIf$iv = editorConfigOverride4;
        if$iv = this.stdin;
        $i$f$applyIf = false;
        if (if$iv) {
            void $this$run_u24lambda_u246 = $this$applyIf$iv;
            boolean bl = false;
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.debug((Function0)run.editorConfigOverride.4.1.INSTANCE);
            pairArray = new Pair[]{TuplesKt.to((Object)RuleExecutionEditorConfigPropertyKt.createRuleExecutionEditorConfigProperty-U7AdEiY$default((String)FilenameRuleKt.getFILENAME_RULE_ID(), null, (int)1, null), (Object)RuleExecution.disabled)};
            editorConfigOverride3 = EditorConfigOverride.Companion.plus((EditorConfigOverride)$this$run_u24lambda_u246, pairArray);
        } else {
            editorConfigOverride3 = editorConfigOverride2 = $this$applyIf$iv;
        }
        if (this.android) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.error((Function0)run.1.INSTANCE);
        }
        this.assertStdinAndPatternsFromStdinOptionsMutuallyExclusive();
        this.patterns = this.replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty(this.patterns);
        long start = System.currentTimeMillis();
        Set<RuleProvider> ruleProviders = this.ruleProviders$ktlint_cli();
        KtLintRuleEngine ktLintRuleEngine = new KtLintRuleEngine(ruleProviders, this.editorConfigDefaults(ruleProviders), (EditorConfigOverride)editorConfigOverride2, true, null, 16, null);
        Baseline baseline = this.stdin || StringsKt.isBlank((CharSequence)this.baselinePath) ? new Baseline(null, Baseline.Status.DISABLED, null, 5, null) : BaselineKt.loadBaseline((String)this.baselinePath);
        ReporterV2 aggregatedReporter = new ReporterAggregator(baseline, this.reporterConfigurations, this.color, this.colorName, this.stdin, this.format, this.relative).aggregatedReporter();
        aggregatedReporter.beforeAll();
        if (this.stdin) {
            this.lintStdin(ktLintRuleEngine, aggregatedReporter);
        } else {
            this.lintFiles(ktLintRuleEngine, baseline.getLintErrorsPerFile(), aggregatedReporter);
        }
        aggregatedReporter.afterAll();
        KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
        if (kLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            kLogger = null;
        }
        kLogger.debug((Function0)new Function0<Object>(start, this){
            final /* synthetic */ long $start;
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.$start = $start;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Finished processing in " + (System.currentTimeMillis() - this.$start) + "ms / " + KtlintCommandLine.access$getFileNumber$p(this.this$0) + " file(s) scanned / " + KtlintCommandLine.access$getErrorNumber$p(this.this$0) + " error(s) found";
            }
        });
        if (this.fileNumber.get() == 0) {
            KLogger kLogger2 = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger2 = null;
            }
            kLogger2.warn((Function0)new Function0<Object>(this){
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "No files matched " + KtlintCommandLine.access$getPatterns$p(this.this$0);
                }
            });
        }
        if (this.tripped.get()) {
            KtlintCommandLineKt.exitKtLintProcess(1);
            throw new KotlinNothingValueException();
        }
        KtlintCommandLineKt.exitKtLintProcess(0);
        throw new KotlinNothingValueException();
    }

    private final EditorConfigDefaults editorConfigDefaults(Set<RuleProvider> ruleProviders) {
        Path path2;
        String string;
        String string2 = this.editorConfigPath;
        if (string2 != null && (string = FileUtilsKt.expandTildeToFullPath(string2)) != null) {
            String path3 = string;
            boolean bl = false;
            path2 = Paths.get(path3, new String[0]);
        } else {
            path2 = null;
        }
        Path fullyExpandedEditorConfigPath = path2;
        return EditorConfigDefaults.Companion.load(fullyExpandedEditorConfigPath, RuleProviderKt.propertyTypes((Collection)ruleProviders));
    }

    private final List<String> replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty(List<String> $this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty) {
        List list;
        String localStdinDelimiter = this.stdinDelimiter;
        if (localStdinDelimiter != null) {
            CharSequence charSequence;
            KtlintCommandLine ktlintCommandLine = this;
            CharSequence charSequence2 = localStdinDelimiter;
            if (charSequence2.length() == 0) {
                KtlintCommandLine ktlintCommandLine2 = ktlintCommandLine;
                boolean bl = false;
                charSequence = "\u0000";
                ktlintCommandLine = ktlintCommandLine2;
            } else {
                charSequence = charSequence2;
            }
            Set<String> stdinPatterns = ktlintCommandLine.readPatternsFromStdin((String)charSequence);
            if (!((Collection)$this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty).isEmpty() && !((Collection)stdinPatterns).isEmpty()) {
                KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                if (kLogger == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    kLogger = null;
                }
                kLogger.warn((Function0)new Function0<Object>((List<String>)$this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty, stdinPatterns){
                    final /* synthetic */ List<String> $this_replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty;
                    final /* synthetic */ Set<String> $stdinPatterns;
                    {
                        this.$this_replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty = $receiver;
                        this.$stdinPatterns = $stdinPatterns;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Patterns specified at command line (" + this.$this_replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty + ") and patterns from 'stdin' due to flag '--patterns-from-stdin' (" + this.$stdinPatterns + ") are merged";
                    }
                });
            }
            list = CollectionsKt.plus((Collection)$this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty, (Iterable)stdinPatterns);
        } else if ($this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty.isEmpty()) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.info((Function0)replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty.2.INSTANCE);
            list = FileUtilsKt.getDEFAULT_PATTERNS();
        } else {
            list = $this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty;
        }
        return list;
    }

    @NotNull
    public final Set<RuleProvider> ruleProviders$ktlint_cli() {
        return LoadRuleProvidersKt.loadRuleProviders(KtlintCommandLineKt.toFilesURIList(this.rulesetJarPaths));
    }

    public final void configureLogger$ktlint_cli() {
        KtlintCommandLineKt.access$setLogger$p(KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KtLintKLoggerInitializerKt.setDefaultLoggerModifier((KLogger)KotlinLogging.INSTANCE.logger((Function0)configureLogger.1.INSTANCE), (Function1)((Function1)new Function1<KLogger, Unit>(this){
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KLogger logger) {
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                org.slf4j.Logger logger2 = logger.getUnderlyingLogger();
                Intrinsics.checkNotNull((Object)logger2, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
                ((Logger)logger2).setLevel(KtlintCommandLine.access$getMinLogLevel$p(this.this$0));
            }
        }))));
    }

    private final void assertStdinAndPatternsFromStdinOptionsMutuallyExclusive() {
        if (this.stdin && this.stdinDelimiter != null) {
            CommandLine.Model.CommandSpec commandSpec = this.commandSpec;
            if (commandSpec == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commandSpec");
                commandSpec = null;
            }
            throw new CommandLine.ParameterException(commandSpec.commandLine(), "Options --stdin and --patterns-from-stdin are mutually exclusive");
        }
    }

    private final void lintFiles(KtLintRuleEngine ktLintRuleEngine, Map<String, ? extends List<KtlintCliError>> lintErrorsPerFile, ReporterV2 reporter) {
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault()");
        KtlintCommandLine.parallel$default(this, SequencesKt.map((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.map((Sequence)FileUtilsKt.fileSequence$default(fileSystem, this.patterns, null, 2, null), (Function1)lintFiles.1.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(File it) {
                return KtlintCommandLine.access$getErrorNumber$p(this.this$0).get() < KtlintCommandLine.access$getLimit(this.this$0);
            }
        })), (Function1)((Function1)new Function1<File, Callable<Pair<? extends File, ? extends List<? extends KtlintCliError>>>>(this, ktLintRuleEngine, lintErrorsPerFile){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ KtLintRuleEngine $ktLintRuleEngine;
            final /* synthetic */ Map<String, List<KtlintCliError>> $lintErrorsPerFile;
            {
                this.this$0 = $receiver;
                this.$ktLintRuleEngine = $ktLintRuleEngine;
                this.$lintErrorsPerFile = $lintErrorsPerFile;
                super(1);
            }

            @NotNull
            public final Callable<Pair<File, List<KtlintCliError>>> invoke(File file) {
                return () -> lintFiles.3.invoke$lambda$0(file, this.this$0, this.$ktLintRuleEngine, this.$lintErrorsPerFile);
            }

            private static final Pair invoke$lambda$0(File $file, KtlintCommandLine this$0, KtLintRuleEngine $ktLintRuleEngine, Map $lintErrorsPerFile) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ktLintRuleEngine, (String)"$ktLintRuleEngine");
                Intrinsics.checkNotNullParameter((Object)$lintErrorsPerFile, (String)"$lintErrorsPerFile");
                Intrinsics.checkNotNullExpressionValue((Object)$file, (String)"file");
                return TuplesKt.to((Object)$file, (Object)KtlintCommandLine.access$process(this$0, $ktLintRuleEngine, Code.Companion.fromFile($file), $lintErrorsPerFile.getOrDefault(FileUtilsKt.location($file, true), CollectionsKt.emptyList())));
            }
        })), (Function1)new Function1<Pair<? extends File, ? extends List<? extends KtlintCliError>>, Unit>(this, reporter){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ ReporterV2 $reporter;
            {
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(Pair<? extends File, ? extends List<KtlintCliError>> pair) {
                File file = (File)pair.component1();
                List errList = (List)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                KtlintCommandLine.access$report(this.this$0, FileUtilsKt.location(file, this.this$0.getRelative()), errList, this.$reporter);
            }
        }, 0, 2, null);
    }

    private final void lintStdin(KtLintRuleEngine ktLintRuleEngine, ReporterV2 reporter) {
        this.report("<stdin>", this.process(ktLintRuleEngine, Code.Companion.fromStdin(), CollectionsKt.emptyList()), reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void report(String relativeRoute, List<KtlintCliError> ktlintCliErrors, ReporterV2 reporter) {
        void $this$forEach$iv;
        this.fileNumber.incrementAndGet();
        int errListLimit = Math.min(ktlintCliErrors.size(), Math.max(this.getLimit() - this.errorNumber.get(), 0));
        this.errorNumber.addAndGet(errListLimit);
        reporter.before(relativeRoute);
        Iterable iterable = CollectionsKt.take((Iterable)ktlintCliErrors, (int)errListLimit);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtlintCliError it = (KtlintCliError)element$iv;
            boolean bl = false;
            reporter.onLintError(relativeRoute, it);
        }
        reporter.after(relativeRoute);
    }

    private final List<KtlintCliError> process(KtLintRuleEngine ktLintRuleEngine, Code code, List<KtlintCliError> baselineLintErrors) {
        if (code.getFileName() != null) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.trace((Function0)new Function0<Object>(code, this){
                final /* synthetic */ Code $code;
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.$code = $code;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Checking ");
                    String string = this.$code.getFileName();
                    Intrinsics.checkNotNull((Object)string);
                    return stringBuilder.append(FileUtilsKt.location(new File(string), this.this$0.getRelative())).toString();
                }
            });
        }
        return this.format ? this.format(ktLintRuleEngine, code, baselineLintErrors) : this.lint(ktLintRuleEngine, code, baselineLintErrors);
    }

    private final List<KtlintCliError> format(KtLintRuleEngine ktLintRuleEngine, Code code, List<KtlintCliError> baselineLintErrors) {
        List ktlintCliErrors = new ArrayList();
        try {
            File file;
            Path path2;
            String string;
            String formattedFileContent = string = ktLintRuleEngine.format(code, (Function2)new Function2<LintError, Boolean, Unit>(baselineLintErrors, (List<KtlintCliError>)ktlintCliErrors, this){
                final /* synthetic */ List<KtlintCliError> $baselineLintErrors;
                final /* synthetic */ List<KtlintCliError> $ktlintCliErrors;
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.$baselineLintErrors = $baselineLintErrors;
                    this.$ktlintCliErrors = $ktlintCliErrors;
                    this.this$0 = $receiver;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull LintError lintError, boolean corrected) {
                    String string;
                    void $this$applyIf$iv;
                    Intrinsics.checkNotNullParameter((Object)lintError, (String)"lintError");
                    int n = lintError.getLine();
                    int n2 = lintError.getCol();
                    String string2 = lintError.getRuleId-6XN97os();
                    String string3 = lintError.getDetail();
                    boolean $i$f$applyIf = false;
                    if (corrected) {
                        void $this$invoke_u24lambda_u240;
                        void var6_5 = $this$applyIf$iv;
                        String string4 = string2;
                        int n3 = n2;
                        int n4 = n;
                        boolean bl = false;
                        String string5 = (String)$this$invoke_u24lambda_u240 + " (cannot be auto-corrected)";
                        n = n4;
                        n2 = n3;
                        string2 = string4;
                        string = string5;
                    } else {
                        string = $this$applyIf$iv;
                    }
                    KtlintCliError.Status status = corrected ? KtlintCliError.Status.FORMAT_IS_AUTOCORRECTED : KtlintCliError.Status.LINT_CAN_NOT_BE_AUTOCORRECTED;
                    void var13_12 = string;
                    String string6 = string2;
                    int n5 = n2;
                    int n6 = n;
                    KtlintCliError ktlintCliError = new KtlintCliError(n6, n5, string6, (String)var13_12, status);
                    if (BaselineKt.doesNotContain(this.$baselineLintErrors, (KtlintCliError)ktlintCliError)) {
                        this.$ktlintCliErrors.add(ktlintCliError);
                        if (!corrected) {
                            KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                        }
                    }
                }
            });
            boolean bl = false;
            if (code.isStdIn()) {
                System.out.print((Object)formattedFileContent);
            } else if (!Intrinsics.areEqual((Object)code.getContent(), (Object)formattedFileContent) && (path2 = code.getFilePath()) != null && (file = path2.toFile()) != null) {
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
                FilesKt.writeText((File)file, (String)formattedFileContent, (Charset)charset);
            }
        }
        catch (Exception e) {
            if (code.isStdIn() && e instanceof KtLintParseException) {
                KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                if (kLogger == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    kLogger = null;
                }
                kLogger.warn((Function0)new Function0<Object>(this, e, code){
                    final /* synthetic */ KtlintCommandLine this$0;
                    final /* synthetic */ Exception $e;
                    final /* synthetic */ Code $code;
                    {
                        this.this$0 = $receiver;
                        this.$e = $e;
                        this.$code = $code;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return StringsKt.trimIndent((String)("\n                    Can not parse input from <stdin> as Kotlin, due to error below:\n                        " + KtlintCommandLine.access$toKtlintCliError(this.this$0, this.$e, this.$code).getDetail() + "\n                    Now, trying to read the input as Kotlin Script.\n                    "));
                    }
                });
                return this.format(ktLintRuleEngine, Code.Companion.fromSnippet(code.getContent(), true), baselineLintErrors);
            }
            ktlintCliErrors.add(this.toKtlintCliError(e, code));
            this.tripped.set(true);
            code.getContent();
        }
        return CollectionsKt.toList((Iterable)ktlintCliErrors);
    }

    private final List<KtlintCliError> lint(KtLintRuleEngine ktLintRuleEngine, Code code, List<KtlintCliError> baselineLintErrors) {
        List ktlintCliErrors = new ArrayList();
        try {
            ktLintRuleEngine.lint(code, (Function1)new Function1<LintError, Unit>(baselineLintErrors, (List<KtlintCliError>)ktlintCliErrors, this){
                final /* synthetic */ List<KtlintCliError> $baselineLintErrors;
                final /* synthetic */ List<KtlintCliError> $ktlintCliErrors;
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.$baselineLintErrors = $baselineLintErrors;
                    this.$ktlintCliErrors = $ktlintCliErrors;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull LintError lintError) {
                    Intrinsics.checkNotNullParameter((Object)lintError, (String)"lintError");
                    KtlintCliError ktlintCliError = new KtlintCliError(lintError.getLine(), lintError.getCol(), lintError.getRuleId-6XN97os(), lintError.getDetail(), lintError.getCanBeAutoCorrected() ? KtlintCliError.Status.LINT_CAN_BE_AUTOCORRECTED : KtlintCliError.Status.LINT_CAN_NOT_BE_AUTOCORRECTED);
                    if (BaselineKt.doesNotContain(this.$baselineLintErrors, (KtlintCliError)ktlintCliError)) {
                        this.$ktlintCliErrors.add(ktlintCliError);
                        KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                    }
                }
            });
        }
        catch (Exception e) {
            if (code.isStdIn() && e instanceof KtLintParseException) {
                KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                if (kLogger == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    kLogger = null;
                }
                kLogger.warn((Function0)new Function0<Object>(this, e, code){
                    final /* synthetic */ KtlintCommandLine this$0;
                    final /* synthetic */ Exception $e;
                    final /* synthetic */ Code $code;
                    {
                        this.this$0 = $receiver;
                        this.$e = $e;
                        this.$code = $code;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return StringsKt.trimIndent((String)("\n                    Can not parse input from <stdin> as Kotlin, due to error below:\n                        " + KtlintCommandLine.access$toKtlintCliError(this.this$0, this.$e, this.$code).getDetail() + "\n                    Now, trying to read the input as Kotlin Script.\n                    "));
                    }
                });
                return this.lint(ktLintRuleEngine, Code.Companion.fromSnippet(code.getContent(), true), baselineLintErrors);
            }
            ktlintCliErrors.add(this.toKtlintCliError(e, code));
            this.tripped.set(true);
        }
        return CollectionsKt.toList((Iterable)ktlintCliErrors);
    }

    private final KtlintCliError toKtlintCliError(Exception $this$toKtlintCliError, Code code) {
        KtlintCliError ktlintCliError;
        Exception e = $this$toKtlintCliError;
        boolean bl = false;
        Exception exception = e;
        if (exception instanceof KtLintParseException) {
            String string;
            int n = ((KtLintParseException)e).getLine();
            int n2 = ((KtLintParseException)e).getCol();
            StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
            String string2 = e.getMessage();
            if (string2 != null) {
                String string3 = string2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string4 = string3.toLowerCase(locale);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
            } else {
                string = null;
            }
            ktlintCliError = new KtlintCliError(n, n2, "", stringBuilder.append(string).append(')').toString(), KtlintCliError.Status.KOTLIN_PARSE_EXCEPTION);
        } else if (exception instanceof KtLintRuleException) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.debug("Internal Error (" + ((KtLintRuleException)e).getRuleId() + ") in " + code.fileNameOrStdin() + " at position '" + ((KtLintRuleException)e).getLine() + ':' + ((KtLintRuleException)e).getCol(), (Throwable)e);
            ktlintCliError = new KtlintCliError(((KtLintRuleException)e).getLine(), ((KtLintRuleException)e).getCol(), "", "Internal Error (rule '" + ((KtLintRuleException)e).getRuleId() + "') in " + code.fileNameOrStdin() + " at position '" + ((KtLintRuleException)e).getLine() + ':' + ((KtLintRuleException)e).getCol() + ". Please create a ticket at https://github.com/pinterest/ktlint/issues and provide the source code that triggered an error.\n" + ExceptionsKt.stackTraceToString((Throwable)e), KtlintCliError.Status.KTLINT_RULE_ENGINE_EXCEPTION);
        } else {
            throw e;
        }
        return ktlintCliError;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> readPatternsFromStdin(String delimiter) {
        void $this$filterTo$iv;
        if (!(((CharSequence)delimiter).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        InputStream inputStream = System.in;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"`in`");
        Object[] objectArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        String string = new String((byte[])objectArray, Charsets.UTF_8);
        objectArray = new String[1];
        objectArray[0] = (byte)delimiter;
        List patterns = StringsKt.split$default((CharSequence)string, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Iterable iterable = patterns;
        Collection destination$iv = new LinkedHashSet(patterns.size());
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            String p0 = (String)element$iv;
            boolean bl2 = false;
            if (!(((CharSequence)p0).length() > 0)) continue;
            destination$iv.add(element$iv);
        }
        return (LinkedHashSet)destination$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void parallel(Sequence<? extends Callable<T>> $this$parallel, Function1<? super T, Unit> cb, int numberOfThreads) {
        Future pill2 = new Future<T>(){

            public boolean isDone() {
                throw new UnsupportedOperationException();
            }

            public T get(long timeout, @NotNull TimeUnit unit) {
                Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
                throw new UnsupportedOperationException();
            }

            public T get() {
                throw new UnsupportedOperationException();
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new UnsupportedOperationException();
            }

            public boolean isCancelled() {
                throw new UnsupportedOperationException();
            }
        };
        ArrayBlockingQueue q = new ArrayBlockingQueue(numberOfThreads);
        Thread producer2 = ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>($this$parallel, q, pill2){
            final /* synthetic */ Sequence<Callable<T>> $this_parallel;
            final /* synthetic */ ArrayBlockingQueue<Future<T>> $q;
            final /* synthetic */ parallel.pill.1<T> $pill;
            {
                this.$this_parallel = $receiver;
                this.$q = $q;
                this.$pill = $pill;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                ExecutorService executorService = Executors.newCachedThreadPool();
                try {
                    for (Callable task : this.$this_parallel) {
                        this.$q.put(executorService.submit(task));
                    }
                    this.$q.put(this.$pill);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    executorService.shutdown();
                }
            }
        }), (int)30, null);
        try {
            Future result;
            while (!Intrinsics.areEqual(result = q.take(), (Object)pill2)) {
                cb.invoke(result.get());
            }
        }
        finally {
            producer2.interrupt();
            producer2.join();
        }
    }

    static /* synthetic */ void parallel$default(KtlintCommandLine ktlintCommandLine, Sequence sequence, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        ktlintCommandLine.parallel(sequence, function1, n);
    }

    public static final /* synthetic */ AtomicInteger access$getFileNumber$p(KtlintCommandLine $this) {
        return $this.fileNumber;
    }

    public static final /* synthetic */ AtomicInteger access$getErrorNumber$p(KtlintCommandLine $this) {
        return $this.errorNumber;
    }

    public static final /* synthetic */ List access$getPatterns$p(KtlintCommandLine $this) {
        return $this.patterns;
    }

    public static final /* synthetic */ Level access$getMinLogLevel$p(KtlintCommandLine $this) {
        return $this.minLogLevel;
    }

    public static final /* synthetic */ int access$getLimit(KtlintCommandLine $this) {
        return $this.getLimit();
    }

    public static final /* synthetic */ List access$process(KtlintCommandLine $this, KtLintRuleEngine ktLintRuleEngine, Code code, List baselineLintErrors) {
        return $this.process(ktLintRuleEngine, code, baselineLintErrors);
    }

    public static final /* synthetic */ void access$report(KtlintCommandLine $this, String relativeRoute, List ktlintCliErrors, ReporterV2 reporter) {
        $this.report(relativeRoute, ktlintCliErrors, reporter);
    }

    public static final /* synthetic */ AtomicBoolean access$getTripped$p(KtlintCommandLine $this) {
        return $this.tripped;
    }

    public static final /* synthetic */ KtlintCliError access$toKtlintCliError(KtlintCommandLine $this, Exception $receiver, Code code) {
        return $this.toKtlintCliError($receiver, code);
    }
}

